/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.btree.impls;

import java.util.List;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.btree.api.IBTreeLeafFrame;
import org.apache.hyracks.storage.am.btree.impls.BTree;
import org.apache.hyracks.storage.am.btree.impls.BTreeRangeSearchCursor;
import org.apache.hyracks.storage.am.btree.impls.RangePredicate;
import org.apache.hyracks.storage.am.common.api.ICursorInitialState;
import org.apache.hyracks.storage.am.common.api.IModificationOperationCallback;
import org.apache.hyracks.storage.am.common.api.ISearchOperationCallback;
import org.apache.hyracks.storage.am.common.api.ISearchPredicate;
import org.apache.hyracks.storage.am.common.api.ITreeIndexCursor;
import org.apache.hyracks.storage.am.common.api.IndexException;
import org.apache.hyracks.storage.am.common.impls.NoOpOperationCallback;
import org.apache.hyracks.storage.am.common.ophelpers.MultiComparator;
import org.apache.hyracks.storage.am.lsm.btree.impls.LSMBTreeWithBuddyCursorInitialState;
import org.apache.hyracks.storage.am.lsm.btree.impls.LSMBTreeWithBuddyDiskComponent;
import org.apache.hyracks.storage.am.lsm.btree.impls.LSMBTreeWithBuddyMemoryComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMHarness;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexOperationContext;
import org.apache.hyracks.storage.am.lsm.common.impls.BloomFilterAwareBTreePointSearchCursor;
import org.apache.hyracks.storage.common.buffercache.IBufferCache;
import org.apache.hyracks.storage.common.buffercache.ICachedPage;

public abstract class LSMBTreeWithBuddyAbstractCursor
implements ITreeIndexCursor {
    protected boolean open;
    protected BTreeRangeSearchCursor[] btreeCursors;
    protected BTreeRangeSearchCursor[] buddyBtreeCursors;
    protected BTree.BTreeAccessor[] btreeAccessors;
    protected BTree.BTreeAccessor[] buddyBtreeAccessors;
    protected MultiComparator btreeCmp;
    protected MultiComparator buddyBtreeCmp;
    protected int numberOfTrees;
    protected RangePredicate btreeRangePredicate;
    protected RangePredicate buddyBtreeRangePredicate;
    protected ITupleReference frameTuple;
    protected boolean includeMutableComponent;
    protected ILSMHarness lsmHarness;
    protected boolean foundNext;
    protected final ILSMIndexOperationContext opCtx;
    protected List<ILSMComponent> operationalComponents;

    public LSMBTreeWithBuddyAbstractCursor(ILSMIndexOperationContext opCtx) {
        this.opCtx = opCtx;
        this.buddyBtreeRangePredicate = new RangePredicate(null, null, true, true, null, null);
    }

    public ITreeIndexCursor getCursor(int cursorIndex) {
        return this.btreeCursors[cursorIndex];
    }

    public void open(ICursorInitialState initialState, ISearchPredicate searchPred) throws IndexException, HyracksDataException {
        LSMBTreeWithBuddyCursorInitialState lsmInitialState = (LSMBTreeWithBuddyCursorInitialState)initialState;
        this.btreeCmp = lsmInitialState.getBTreeCmp();
        this.buddyBtreeCmp = lsmInitialState.getBuddyBTreeCmp();
        this.operationalComponents = lsmInitialState.getOperationalComponents();
        this.lsmHarness = lsmInitialState.getLSMHarness();
        this.numberOfTrees = this.operationalComponents.size();
        if (this.btreeCursors == null || this.btreeCursors.length != this.numberOfTrees) {
            this.btreeCursors = new BTreeRangeSearchCursor[this.numberOfTrees];
            this.buddyBtreeCursors = new BTreeRangeSearchCursor[this.numberOfTrees];
            this.btreeAccessors = new BTree.BTreeAccessor[this.numberOfTrees];
            this.buddyBtreeAccessors = new BTree.BTreeAccessor[this.numberOfTrees];
        }
        this.includeMutableComponent = false;
        for (int i = 0; i < this.numberOfTrees; ++i) {
            BTree buddyBtree;
            BTree btree;
            ILSMComponent component = this.operationalComponents.get(i);
            if (component.getType() == ILSMComponent.LSMComponentType.MEMORY) {
                this.includeMutableComponent = true;
                if (this.buddyBtreeCursors[i] == null || this.buddyBtreeCursors[i].isBloomFilterAware()) {
                    this.buddyBtreeCursors[i] = new BTreeRangeSearchCursor((IBTreeLeafFrame)lsmInitialState.getBuddyBTreeLeafFrameFactory().createFrame(), false);
                } else {
                    this.buddyBtreeCursors[i].reset();
                }
                btree = ((LSMBTreeWithBuddyMemoryComponent)component).getBTree();
                buddyBtree = ((LSMBTreeWithBuddyMemoryComponent)component).getBuddyBTree();
            } else {
                if (this.buddyBtreeCursors[i] == null || !this.buddyBtreeCursors[i].isBloomFilterAware()) {
                    this.buddyBtreeCursors[i] = new BloomFilterAwareBTreePointSearchCursor((IBTreeLeafFrame)lsmInitialState.getBuddyBTreeLeafFrameFactory().createFrame(), false, ((LSMBTreeWithBuddyDiskComponent)this.operationalComponents.get(i)).getBloomFilter());
                } else {
                    this.buddyBtreeCursors[i].reset();
                }
                btree = ((LSMBTreeWithBuddyDiskComponent)component).getBTree();
                buddyBtree = ((LSMBTreeWithBuddyDiskComponent)component).getBuddyBTree();
            }
            IBTreeLeafFrame leafFrame = (IBTreeLeafFrame)lsmInitialState.getBTreeLeafFrameFactory().createFrame();
            if (this.btreeAccessors[i] == null) {
                this.btreeCursors[i] = new BTreeRangeSearchCursor(leafFrame, false);
                this.btreeAccessors[i] = (BTree.BTreeAccessor)btree.createAccessor((IModificationOperationCallback)NoOpOperationCallback.INSTANCE, (ISearchOperationCallback)NoOpOperationCallback.INSTANCE);
                this.buddyBtreeAccessors[i] = (BTree.BTreeAccessor)buddyBtree.createAccessor((IModificationOperationCallback)NoOpOperationCallback.INSTANCE, (ISearchOperationCallback)NoOpOperationCallback.INSTANCE);
                continue;
            }
            this.btreeCursors[i].reset();
            this.btreeAccessors[i].reset(btree, (IModificationOperationCallback)NoOpOperationCallback.INSTANCE, (ISearchOperationCallback)NoOpOperationCallback.INSTANCE);
            this.buddyBtreeAccessors[i].reset(buddyBtree, (IModificationOperationCallback)NoOpOperationCallback.INSTANCE, (ISearchOperationCallback)NoOpOperationCallback.INSTANCE);
        }
        this.btreeRangePredicate = (RangePredicate)searchPred;
        this.buddyBtreeRangePredicate.reset(null, null, true, true, this.buddyBtreeCmp, this.buddyBtreeCmp);
        this.open = true;
    }

    public void close() throws HyracksDataException {
        if (!this.open) {
            return;
        }
        try {
            if (this.btreeCursors != null && this.buddyBtreeCursors != null) {
                for (int i = 0; i < this.numberOfTrees; ++i) {
                    this.btreeCursors[i].close();
                    this.buddyBtreeCursors[i].close();
                }
            }
            this.btreeCursors = null;
            this.buddyBtreeCursors = null;
        }
        finally {
            this.lsmHarness.endSearch(this.opCtx);
        }
        this.foundNext = false;
        this.open = false;
    }

    public ITupleReference getTuple() {
        return this.frameTuple;
    }

    public ICachedPage getPage() {
        return null;
    }

    public void setBufferCache(IBufferCache bufferCache) {
    }

    public void setFileId(int fileId) {
    }

    public boolean exclusiveLatchNodes() {
        return false;
    }

    public void markCurrentTupleAsUpdated() throws HyracksDataException {
        throw new HyracksDataException("Updating tuples is not supported with this cursor.");
    }
}

