/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.btree.impls;

import java.util.LinkedList;
import java.util.List;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.storage.am.btree.api.IBTreeLeafFrame;
import org.apache.hyracks.storage.am.btree.impls.BTree;
import org.apache.hyracks.storage.am.btree.impls.BTreeOpContext;
import org.apache.hyracks.storage.am.btree.impls.BTreeRangeSearchCursor;
import org.apache.hyracks.storage.am.btree.impls.RangePredicate;
import org.apache.hyracks.storage.am.common.api.IModificationOperationCallback;
import org.apache.hyracks.storage.am.common.api.ISearchOperationCallback;
import org.apache.hyracks.storage.am.common.api.ISearchPredicate;
import org.apache.hyracks.storage.am.common.api.ITreeIndexFrameFactory;
import org.apache.hyracks.storage.am.common.impls.NoOpOperationCallback;
import org.apache.hyracks.storage.am.common.ophelpers.IndexOperation;
import org.apache.hyracks.storage.am.common.ophelpers.MultiComparator;
import org.apache.hyracks.storage.am.common.tuples.PermutingTupleReference;
import org.apache.hyracks.storage.am.lsm.btree.impls.LSMBTreeCursorInitialState;
import org.apache.hyracks.storage.am.lsm.btree.impls.LSMBTreeMemoryComponent;
import org.apache.hyracks.storage.am.lsm.btree.impls.LSMBTreePointSearchCursor;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMDiskComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMHarness;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexOperationContext;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMMemoryComponent;
import org.apache.hyracks.storage.am.lsm.common.impls.AbstractLSMIndexOperationContext;

public final class LSMBTreeOpContext
extends AbstractLSMIndexOperationContext {
    public ITreeIndexFrameFactory insertLeafFrameFactory;
    public ITreeIndexFrameFactory deleteLeafFrameFactory;
    public IBTreeLeafFrame insertLeafFrame;
    public IBTreeLeafFrame deleteLeafFrame;
    public final BTree[] mutableBTrees;
    public BTree.BTreeAccessor[] mutableBTreeAccessors;
    public BTreeOpContext[] mutableBTreeOpCtxs;
    public BTree.BTreeAccessor currentMutableBTreeAccessor;
    public BTreeOpContext currentMutableBTreeOpCtx;
    public IndexOperation op;
    public final MultiComparator cmp;
    public final MultiComparator bloomFilterCmp;
    public IModificationOperationCallback modificationCallback;
    public ISearchOperationCallback searchCallback;
    private final List<ILSMComponent> componentHolder;
    private final List<ILSMDiskComponent> componentsToBeMerged;
    private final List<ILSMDiskComponent> componentsToBeReplicated;
    public final PermutingTupleReference indexTuple;
    public final MultiComparator filterCmp;
    public final PermutingTupleReference filterTuple;
    public ISearchPredicate searchPredicate;
    public BTreeRangeSearchCursor memCursor;
    public LSMBTreeCursorInitialState searchInitialState;
    public LSMBTreePointSearchCursor insertSearchCursor;

    public LSMBTreeOpContext(List<ILSMMemoryComponent> mutableComponents, ITreeIndexFrameFactory insertLeafFrameFactory, ITreeIndexFrameFactory deleteLeafFrameFactory, IModificationOperationCallback modificationCallback, ISearchOperationCallback searchCallback, int numBloomFilterKeyFields, int[] btreeFields, int[] filterFields, ILSMHarness lsmHarness) {
        LSMBTreeMemoryComponent c = (LSMBTreeMemoryComponent)mutableComponents.get(0);
        IBinaryComparatorFactory[] cmpFactories = c.getBTree().getComparatorFactories();
        this.cmp = cmpFactories[0] != null ? MultiComparator.create((IBinaryComparatorFactory[])c.getBTree().getComparatorFactories()) : null;
        this.bloomFilterCmp = numBloomFilterKeyFields == 0 ? null : MultiComparator.create((IBinaryComparatorFactory[])c.getBTree().getComparatorFactories(), (int)0, (int)numBloomFilterKeyFields);
        this.mutableBTrees = new BTree[mutableComponents.size()];
        this.mutableBTreeAccessors = new BTree.BTreeAccessor[mutableComponents.size()];
        this.mutableBTreeOpCtxs = new BTreeOpContext[mutableComponents.size()];
        for (int i = 0; i < mutableComponents.size(); ++i) {
            LSMBTreeMemoryComponent mutableComponent = (LSMBTreeMemoryComponent)mutableComponents.get(i);
            this.mutableBTrees[i] = mutableComponent.getBTree();
            this.mutableBTreeAccessors[i] = (BTree.BTreeAccessor)this.mutableBTrees[i].createAccessor(modificationCallback, (ISearchOperationCallback)NoOpOperationCallback.INSTANCE);
            this.mutableBTreeOpCtxs[i] = this.mutableBTreeAccessors[i].getOpContext();
        }
        this.insertLeafFrameFactory = insertLeafFrameFactory;
        this.deleteLeafFrameFactory = deleteLeafFrameFactory;
        this.insertLeafFrame = (IBTreeLeafFrame)insertLeafFrameFactory.createFrame();
        this.deleteLeafFrame = (IBTreeLeafFrame)deleteLeafFrameFactory.createFrame();
        if (this.insertLeafFrame != null && this.cmp != null) {
            this.insertLeafFrame.setMultiComparator(this.cmp);
        }
        if (this.deleteLeafFrame != null && this.cmp != null) {
            this.deleteLeafFrame.setMultiComparator(this.cmp);
        }
        this.componentHolder = new LinkedList<ILSMComponent>();
        this.componentsToBeMerged = new LinkedList<ILSMDiskComponent>();
        this.componentsToBeReplicated = new LinkedList<ILSMDiskComponent>();
        this.modificationCallback = modificationCallback;
        this.searchCallback = searchCallback;
        if (filterFields != null) {
            this.indexTuple = new PermutingTupleReference(btreeFields);
            this.filterCmp = MultiComparator.create((IBinaryComparatorFactory[])c.getLSMComponentFilter().getFilterCmpFactories());
            this.filterTuple = new PermutingTupleReference(filterFields);
        } else {
            this.indexTuple = null;
            this.filterCmp = null;
            this.filterTuple = null;
        }
        this.searchPredicate = new RangePredicate(null, null, true, true, this.cmp, this.cmp);
        if (this.insertLeafFrame != null) {
            this.memCursor = new BTreeRangeSearchCursor(this.insertLeafFrame, false);
        }
        this.searchInitialState = new LSMBTreeCursorInitialState(insertLeafFrameFactory, this.cmp, this.bloomFilterCmp, lsmHarness, null, searchCallback, null);
        this.insertSearchCursor = new LSMBTreePointSearchCursor((ILSMIndexOperationContext)this);
    }

    public void setOperation(IndexOperation newOp) {
        this.reset();
        this.op = newOp;
    }

    public void setInsertMode() {
        this.currentMutableBTreeOpCtx.leafFrame = this.insertLeafFrame;
        this.currentMutableBTreeOpCtx.leafFrameFactory = this.insertLeafFrameFactory;
    }

    public void setDeleteMode() {
        this.currentMutableBTreeOpCtx.leafFrame = this.deleteLeafFrame;
        this.currentMutableBTreeOpCtx.leafFrameFactory = this.deleteLeafFrameFactory;
    }

    public void reset() {
        super.reset();
        this.componentHolder.clear();
        this.componentsToBeMerged.clear();
        this.componentsToBeReplicated.clear();
    }

    public IndexOperation getOperation() {
        return this.op;
    }

    public List<ILSMComponent> getComponentHolder() {
        return this.componentHolder;
    }

    public ISearchOperationCallback getSearchOperationCallback() {
        return this.searchCallback;
    }

    public IModificationOperationCallback getModificationCallback() {
        return this.modificationCallback;
    }

    public void setCurrentMutableComponentId(int currentMutableComponentId) {
        this.currentMutableBTreeAccessor = this.mutableBTreeAccessors[currentMutableComponentId];
        this.currentMutableBTreeOpCtx = this.mutableBTreeOpCtxs[currentMutableComponentId];
        switch (this.op) {
            case SEARCH: {
                break;
            }
            case DISKORDERSCAN: 
            case UPDATE: {
                break;
            }
            case UPSERT: 
            case INSERT: {
                this.setInsertMode();
                break;
            }
            case PHYSICALDELETE: 
            case DELETE: {
                this.setDeleteMode();
            }
        }
    }

    public List<ILSMDiskComponent> getComponentsToBeMerged() {
        return this.componentsToBeMerged;
    }

    public void setSearchPredicate(ISearchPredicate searchPredicate) {
        this.searchPredicate = searchPredicate;
    }

    public ISearchPredicate getSearchPredicate() {
        return this.searchPredicate;
    }

    public List<ILSMDiskComponent> getComponentsToBeReplicated() {
        return this.componentsToBeReplicated;
    }
}

