/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.btree.impls;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.api.io.IODeviceHandle;
import org.apache.hyracks.storage.am.common.api.IndexException;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperation;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationCallback;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexAccessor;

public class LSMBTreeFlushOperation
implements ILSMIOOperation,
Comparable<LSMBTreeFlushOperation> {
    private final ILSMIndexAccessor accessor;
    private final ILSMComponent flushingComponent;
    private final FileReference btreeFlushTarget;
    private final FileReference bloomFilterFlushTarget;
    private final ILSMIOOperationCallback callback;
    private final String indexIdentifier;

    public LSMBTreeFlushOperation(ILSMIndexAccessor accessor, ILSMComponent flushingComponent, FileReference btreeFlushTarget, FileReference bloomFilterFlushTarget, ILSMIOOperationCallback callback, String indexIdentifier) {
        this.accessor = accessor;
        this.flushingComponent = flushingComponent;
        this.btreeFlushTarget = btreeFlushTarget;
        this.bloomFilterFlushTarget = bloomFilterFlushTarget;
        this.callback = callback;
        this.indexIdentifier = indexIdentifier;
    }

    public Set<IODeviceHandle> getReadDevices() {
        return Collections.emptySet();
    }

    public Set<IODeviceHandle> getWriteDevices() {
        HashSet<IODeviceHandle> devs = new HashSet<IODeviceHandle>();
        devs.add(this.btreeFlushTarget.getDeviceHandle());
        if (this.bloomFilterFlushTarget != null) {
            devs.add(this.bloomFilterFlushTarget.getDeviceHandle());
        }
        return devs;
    }

    public Boolean call() throws HyracksDataException, IndexException {
        this.accessor.flush((ILSMIOOperation)this);
        return true;
    }

    public ILSMIOOperationCallback getCallback() {
        return this.callback;
    }

    public FileReference getBTreeFlushTarget() {
        return this.btreeFlushTarget;
    }

    public FileReference getBloomFilterFlushTarget() {
        return this.bloomFilterFlushTarget;
    }

    public ILSMIndexAccessor getAccessor() {
        return this.accessor;
    }

    public ILSMComponent getFlushingComponent() {
        return this.flushingComponent;
    }

    public String getIndexUniqueIdentifier() {
        return this.indexIdentifier;
    }

    public ILSMIOOperation.LSMIOOpertionType getIOOpertionType() {
        return ILSMIOOperation.LSMIOOpertionType.FLUSH;
    }

    @Override
    public int compareTo(LSMBTreeFlushOperation o) {
        return this.btreeFlushTarget.getFile().getName().compareTo(o.getBTreeFlushTarget().getFile().getName());
    }
}

