/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.btree.impls;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.api.io.IIOManager;
import org.apache.hyracks.data.std.primitive.IntegerPointable;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.bloomfilter.impls.BloomCalculations;
import org.apache.hyracks.storage.am.bloomfilter.impls.BloomFilterFactory;
import org.apache.hyracks.storage.am.bloomfilter.impls.BloomFilterSpecification;
import org.apache.hyracks.storage.am.btree.api.ITupleAcceptor;
import org.apache.hyracks.storage.am.btree.impls.BTree;
import org.apache.hyracks.storage.am.btree.impls.BTreeRangeSearchCursor;
import org.apache.hyracks.storage.am.btree.impls.RangePredicate;
import org.apache.hyracks.storage.am.common.api.ICursorInitialState;
import org.apache.hyracks.storage.am.common.api.IIndexBulkLoader;
import org.apache.hyracks.storage.am.common.api.IIndexCursor;
import org.apache.hyracks.storage.am.common.api.IIndexOperationContext;
import org.apache.hyracks.storage.am.common.api.IModificationOperationCallback;
import org.apache.hyracks.storage.am.common.api.IPageManager;
import org.apache.hyracks.storage.am.common.api.ISearchOperationCallback;
import org.apache.hyracks.storage.am.common.api.ISearchPredicate;
import org.apache.hyracks.storage.am.common.api.ITreeIndex;
import org.apache.hyracks.storage.am.common.api.ITreeIndexAccessor;
import org.apache.hyracks.storage.am.common.api.ITreeIndexCursor;
import org.apache.hyracks.storage.am.common.api.ITreeIndexFrameFactory;
import org.apache.hyracks.storage.am.common.api.IndexException;
import org.apache.hyracks.storage.am.common.api.TreeIndexException;
import org.apache.hyracks.storage.am.common.exceptions.TreeIndexDuplicateKeyException;
import org.apache.hyracks.storage.am.common.impls.AbstractSearchPredicate;
import org.apache.hyracks.storage.am.common.impls.NoOpOperationCallback;
import org.apache.hyracks.storage.am.common.ophelpers.IndexOperation;
import org.apache.hyracks.storage.am.common.ophelpers.MultiComparator;
import org.apache.hyracks.storage.am.common.tuples.PermutingTupleReference;
import org.apache.hyracks.storage.am.lsm.btree.impls.AntimatterAwareTupleAcceptor;
import org.apache.hyracks.storage.am.lsm.btree.impls.LSMBTreeDiskComponent;
import org.apache.hyracks.storage.am.lsm.btree.impls.LSMBTreeDiskComponentFactory;
import org.apache.hyracks.storage.am.lsm.btree.impls.LSMBTreeFlushOperation;
import org.apache.hyracks.storage.am.lsm.btree.impls.LSMBTreeMemoryComponent;
import org.apache.hyracks.storage.am.lsm.btree.impls.LSMBTreeMergeOperation;
import org.apache.hyracks.storage.am.lsm.btree.impls.LSMBTreeOpContext;
import org.apache.hyracks.storage.am.lsm.btree.impls.LSMBTreePointSearchCursor;
import org.apache.hyracks.storage.am.lsm.btree.impls.LSMBTreeRangeSearchCursor;
import org.apache.hyracks.storage.am.lsm.btree.impls.LSMBTreeSearchCursor;
import org.apache.hyracks.storage.am.lsm.btree.tuples.LSMBTreeTupleReference;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponentFilterFactory;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponentFilterFrameFactory;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMDiskComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMHarness;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperation;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationCallback;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationScheduler;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexAccessor;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexFileManager;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexOperationContext;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMMemoryComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMMergePolicy;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMOperationTracker;
import org.apache.hyracks.storage.am.lsm.common.api.IVirtualBufferCache;
import org.apache.hyracks.storage.am.lsm.common.api.LSMOperationType;
import org.apache.hyracks.storage.am.lsm.common.freepage.VirtualFreePageManager;
import org.apache.hyracks.storage.am.lsm.common.impls.AbstractLSMIndex;
import org.apache.hyracks.storage.am.lsm.common.impls.BlockingIOOperationCallbackWrapper;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMComponentFileReferences;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMComponentFilterManager;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMIndexSearchCursor;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMTreeIndexAccessor;
import org.apache.hyracks.storage.am.lsm.common.impls.TreeIndexFactory;
import org.apache.hyracks.storage.common.buffercache.IBufferCache;
import org.apache.hyracks.storage.common.file.IFileMapProvider;

public class LSMBTree
extends AbstractLSMIndex
implements ITreeIndex {
    protected final LSMBTreeDiskComponentFactory componentFactory;
    protected final LSMBTreeDiskComponentFactory bulkLoadComponentFactory;
    protected final ITreeIndexFrameFactory insertLeafFrameFactory;
    protected final ITreeIndexFrameFactory deleteLeafFrameFactory;
    protected final IBinaryComparatorFactory[] cmpFactories;
    private final boolean needKeyDupCheck;
    private final int[] btreeFields;
    private final boolean hasBloomFilter;

    public LSMBTree(IIOManager ioManager, List<IVirtualBufferCache> virtualBufferCaches, ITreeIndexFrameFactory interiorFrameFactory, ITreeIndexFrameFactory insertLeafFrameFactory, ITreeIndexFrameFactory deleteLeafFrameFactory, ILSMIndexFileManager fileManager, TreeIndexFactory<BTree> diskBTreeFactory, TreeIndexFactory<BTree> bulkLoadBTreeFactory, BloomFilterFactory bloomFilterFactory, ILSMComponentFilterFactory filterFactory, ILSMComponentFilterFrameFactory filterFrameFactory, LSMComponentFilterManager filterManager, double bloomFilterFalsePositiveRate, IFileMapProvider diskFileMapProvider, int fieldCount, IBinaryComparatorFactory[] cmpFactories, ILSMMergePolicy mergePolicy, ILSMOperationTracker opTracker, ILSMIOOperationScheduler ioScheduler, ILSMIOOperationCallback ioOpCallback, boolean needKeyDupCheck, int[] btreeFields, int[] filterFields, boolean durable) throws HyracksDataException {
        super(ioManager, virtualBufferCaches, diskBTreeFactory.getBufferCache(), fileManager, diskFileMapProvider, bloomFilterFalsePositiveRate, mergePolicy, opTracker, ioScheduler, ioOpCallback, filterFrameFactory, filterManager, filterFields, durable);
        this.insertLeafFrameFactory = insertLeafFrameFactory;
        this.deleteLeafFrameFactory = deleteLeafFrameFactory;
        this.cmpFactories = cmpFactories;
        int i = 0;
        for (IVirtualBufferCache virtualBufferCache : virtualBufferCaches) {
            LSMBTreeMemoryComponent mutableComponent = new LSMBTreeMemoryComponent(new BTree((IBufferCache)virtualBufferCache, (IFileMapProvider)virtualBufferCache.getFileMapProvider(), (IPageManager)new VirtualFreePageManager((IBufferCache)virtualBufferCache), interiorFrameFactory, insertLeafFrameFactory, cmpFactories, fieldCount, ioManager.resolveAbsolutePath(fileManager.getBaseDir() + "_virtual_" + i)), virtualBufferCache, i == 0, filterFactory == null ? null : filterFactory.createFilter());
            this.memoryComponents.add(mutableComponent);
            ++i;
        }
        this.componentFactory = new LSMBTreeDiskComponentFactory(diskBTreeFactory, bloomFilterFactory, filterFactory);
        this.bulkLoadComponentFactory = new LSMBTreeDiskComponentFactory(bulkLoadBTreeFactory, bloomFilterFactory, filterFactory);
        this.needKeyDupCheck = needKeyDupCheck;
        this.btreeFields = btreeFields;
        this.hasBloomFilter = needKeyDupCheck;
    }

    public LSMBTree(IIOManager ioManager, ITreeIndexFrameFactory insertLeafFrameFactory, ITreeIndexFrameFactory deleteLeafFrameFactory, ILSMIndexFileManager fileManager, TreeIndexFactory<BTree> diskBTreeFactory, TreeIndexFactory<BTree> bulkLoadBTreeFactory, BloomFilterFactory bloomFilterFactory, double bloomFilterFalsePositiveRate, IFileMapProvider diskFileMapProvider, int fieldCount, IBinaryComparatorFactory[] cmpFactories, ILSMMergePolicy mergePolicy, ILSMOperationTracker opTracker, ILSMIOOperationScheduler ioScheduler, ILSMIOOperationCallback ioOpCallback, boolean needKeyDupCheck, boolean durable) {
        super(ioManager, diskBTreeFactory.getBufferCache(), fileManager, diskFileMapProvider, bloomFilterFalsePositiveRate, mergePolicy, opTracker, ioScheduler, ioOpCallback, durable);
        this.insertLeafFrameFactory = insertLeafFrameFactory;
        this.deleteLeafFrameFactory = deleteLeafFrameFactory;
        this.cmpFactories = cmpFactories;
        this.componentFactory = new LSMBTreeDiskComponentFactory(diskBTreeFactory, bloomFilterFactory, null);
        this.bulkLoadComponentFactory = new LSMBTreeDiskComponentFactory(bulkLoadBTreeFactory, bloomFilterFactory, null);
        this.needKeyDupCheck = needKeyDupCheck;
        this.btreeFields = null;
        this.hasBloomFilter = true;
    }

    public synchronized void create() throws HyracksDataException {
        if (this.isActivated) {
            throw new HyracksDataException("Failed to create the index since it is activated.");
        }
        this.fileManager.deleteDirs();
        this.fileManager.createDirs();
        this.diskComponents.clear();
    }

    public synchronized void activate() throws HyracksDataException {
        List validFileReferences;
        if (this.isActivated) {
            throw new HyracksDataException("Failed to activate the index since it is already activated.");
        }
        List immutableComponents = this.diskComponents;
        immutableComponents.clear();
        try {
            validFileReferences = this.fileManager.cleanupAndGetValidFiles();
        }
        catch (IndexException e) {
            throw new HyracksDataException((Throwable)e);
        }
        for (LSMComponentFileReferences lsmComonentFileReference : validFileReferences) {
            LSMBTreeDiskComponent component;
            try {
                component = this.createDiskComponent(this.componentFactory, lsmComonentFileReference.getInsertIndexFileReference(), lsmComonentFileReference.getBloomFilterFileReference(), false);
            }
            catch (IndexException e) {
                throw new HyracksDataException((Throwable)e);
            }
            immutableComponents.add(component);
        }
        this.isActivated = true;
    }

    public synchronized void deactivate(boolean flushOnExit) throws HyracksDataException {
        if (!this.isActivated) {
            throw new HyracksDataException("Failed to deactivate the index since it is already deactivated.");
        }
        if (flushOnExit) {
            BlockingIOOperationCallbackWrapper cb = new BlockingIOOperationCallbackWrapper(this.ioOpCallback);
            ILSMIndexAccessor accessor = this.createAccessor((IModificationOperationCallback)NoOpOperationCallback.INSTANCE, (ISearchOperationCallback)NoOpOperationCallback.INSTANCE);
            accessor.scheduleFlush((ILSMIOOperationCallback)cb);
            try {
                cb.waitForIO();
            }
            catch (InterruptedException e) {
                throw new HyracksDataException((Throwable)e);
            }
        }
        List immutableComponents = this.diskComponents;
        for (ILSMDiskComponent c : immutableComponents) {
            LSMBTreeDiskComponent component = (LSMBTreeDiskComponent)c;
            component.getBTree().deactivateCloseHandle();
            if (!this.hasBloomFilter) continue;
            component.getBloomFilter().deactivate();
        }
        this.deallocateMemoryComponents();
        this.isActivated = false;
    }

    public synchronized void deactivate() throws HyracksDataException {
        this.deactivate(true);
    }

    public void destroy() throws HyracksDataException {
        if (this.isActivated) {
            throw new HyracksDataException("Failed to destroy the index since it is activated.");
        }
        List immutableComponents = this.diskComponents;
        for (ILSMDiskComponent c : immutableComponents) {
            LSMBTreeDiskComponent component = (LSMBTreeDiskComponent)c;
            component.getBTree().destroy();
            if (!this.hasBloomFilter) continue;
            component.getBloomFilter().destroy();
        }
        for (ILSMDiskComponent c : this.memoryComponents) {
            LSMBTreeMemoryComponent mutableComponent = (LSMBTreeMemoryComponent)c;
            mutableComponent.getBTree().destroy();
        }
        this.fileManager.deleteDirs();
    }

    public void clear() throws HyracksDataException {
        if (!this.isActivated) {
            throw new HyracksDataException("Failed to clear the index since it is not activated.");
        }
        this.clearMemoryComponents();
        List immutableComponents = this.diskComponents;
        for (ILSMComponent c : immutableComponents) {
            LSMBTreeDiskComponent component = (LSMBTreeDiskComponent)c;
            if (this.hasBloomFilter) {
                component.getBloomFilter().deactivate();
            }
            component.getBTree().deactivate();
            if (this.hasBloomFilter) {
                component.getBloomFilter().destroy();
            }
            component.getBTree().destroy();
        }
        immutableComponents.clear();
    }

    public void getOperationalComponents(ILSMIndexOperationContext ctx) throws HyracksDataException {
        List immutableComponents = this.diskComponents;
        List operationalComponents = ctx.getComponentHolder();
        int cmc = this.currentMutableComponentId.get();
        ctx.setCurrentMutableComponentId(cmc);
        operationalComponents.clear();
        switch (ctx.getOperation()) {
            case UPDATE: 
            case PHYSICALDELETE: 
            case FLUSH: 
            case DELETE: 
            case UPSERT: {
                operationalComponents.add(this.memoryComponents.get(cmc));
                break;
            }
            case INSERT: {
                this.addOperationalMutableComponents(operationalComponents);
                operationalComponents.addAll(immutableComponents);
                break;
            }
            case SEARCH: {
                if (this.memoryComponentsAllocated) {
                    this.addOperationalMutableComponents(operationalComponents);
                }
                if (this.filterManager != null) {
                    for (ILSMComponent c : immutableComponents) {
                        if (!c.getLSMComponentFilter().satisfy(((AbstractSearchPredicate)ctx.getSearchPredicate()).getMinFilterTuple(), ((AbstractSearchPredicate)ctx.getSearchPredicate()).getMaxFilterTuple(), ((LSMBTreeOpContext)ctx).filterCmp)) continue;
                        operationalComponents.add(c);
                    }
                    break;
                }
                operationalComponents.addAll(immutableComponents);
                break;
            }
            case MERGE: {
                operationalComponents.addAll(ctx.getComponentsToBeMerged());
                break;
            }
            case FULL_MERGE: {
                operationalComponents.addAll(immutableComponents);
                break;
            }
            case REPLICATE: {
                operationalComponents.addAll(ctx.getComponentsToBeReplicated());
                break;
            }
            default: {
                throw new UnsupportedOperationException("Operation " + ctx.getOperation() + " not supported.");
            }
        }
    }

    public void modify(IIndexOperationContext ictx, ITupleReference tuple) throws HyracksDataException, IndexException {
        ITupleReference indexTuple;
        LSMBTreeOpContext ctx = (LSMBTreeOpContext)ictx;
        if (ctx.indexTuple != null) {
            ctx.indexTuple.reset(tuple);
            indexTuple = ctx.indexTuple;
        } else {
            indexTuple = tuple;
        }
        switch (ctx.getOperation()) {
            case PHYSICALDELETE: {
                ctx.currentMutableBTreeAccessor.delete(indexTuple);
                break;
            }
            case INSERT: {
                this.insert(indexTuple, ctx);
                break;
            }
            default: {
                ctx.currentMutableBTreeAccessor.upsert(indexTuple);
            }
        }
        if (ctx.filterTuple != null) {
            ctx.filterTuple.reset(tuple);
            ((ILSMMemoryComponent)this.memoryComponents.get(this.currentMutableComponentId.get())).getLSMComponentFilter().update((ITupleReference)ctx.filterTuple, ctx.filterCmp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean insert(ITupleReference tuple, LSMBTreeOpContext ctx) throws HyracksDataException, IndexException {
        LSMBTreePointSearchCursor searchCursor = ctx.insertSearchCursor;
        BTreeRangeSearchCursor memCursor = ctx.memCursor;
        RangePredicate predicate = (RangePredicate)ctx.getSearchPredicate();
        predicate.setHighKey(tuple);
        predicate.setLowKey(tuple);
        if (this.needKeyDupCheck) {
            ctx.currentMutableBTreeAccessor.search((IIndexCursor)memCursor, (ISearchPredicate)predicate);
            try {
                if (memCursor.hasNext()) {
                    memCursor.next();
                    LSMBTreeTupleReference lsmbtreeTuple = (LSMBTreeTupleReference)memCursor.getTuple();
                    if (!lsmbtreeTuple.isAntimatter()) {
                        throw new TreeIndexDuplicateKeyException("Failed to insert key since key already exists.");
                    }
                    memCursor.close();
                    ctx.currentMutableBTreeAccessor.upsertIfConditionElseInsert(tuple, (ITupleAcceptor)AntimatterAwareTupleAcceptor.INSTANCE);
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                memCursor.close();
            }
            ILSMComponent firstComponent = ctx.getComponentHolder().remove(0);
            this.search((ILSMIndexOperationContext)ctx, (IIndexCursor)searchCursor, (ISearchPredicate)predicate);
            try {
                if (searchCursor.hasNext()) {
                    throw new TreeIndexDuplicateKeyException("Failed to insert key since key already exists.");
                }
            }
            finally {
                searchCursor.close();
                ctx.getComponentHolder().add(0, firstComponent);
            }
        }
        ctx.currentMutableBTreeAccessor.upsertIfConditionElseInsert(tuple, (ITupleAcceptor)AntimatterAwareTupleAcceptor.INSTANCE);
        return true;
    }

    public void search(ILSMIndexOperationContext ictx, IIndexCursor cursor, ISearchPredicate pred) throws HyracksDataException, IndexException {
        LSMBTreeOpContext ctx = (LSMBTreeOpContext)ictx;
        List<ILSMComponent> operationalComponents = ctx.getComponentHolder();
        ctx.searchInitialState.reset(pred, operationalComponents);
        cursor.open((ICursorInitialState)ctx.searchInitialState, pred);
    }

    public void scheduleFlush(ILSMIndexOperationContext ctx, ILSMIOOperationCallback callback) throws HyracksDataException {
        ILSMComponent flushingComponent = (ILSMComponent)ctx.getComponentHolder().get(0);
        LSMComponentFileReferences componentFileRefs = this.fileManager.getRelFlushFileReference();
        LSMBTreeOpContext opCtx = this.createOpContext((IModificationOperationCallback)NoOpOperationCallback.INSTANCE, (ISearchOperationCallback)NoOpOperationCallback.INSTANCE);
        assert (ctx.getComponentHolder().size() == 1);
        opCtx.setOperation(IndexOperation.FLUSH);
        opCtx.getComponentHolder().add(flushingComponent);
        LSMBTreeAccessor flushAccessor = new LSMBTreeAccessor(this.lsmHarness, (ILSMIndexOperationContext)opCtx);
        this.ioScheduler.scheduleOperation((ILSMIOOperation)new LSMBTreeFlushOperation((ILSMIndexAccessor)flushAccessor, flushingComponent, componentFileRefs.getInsertIndexFileReference(), componentFileRefs.getBloomFilterFileReference(), callback, this.fileManager.getBaseDir()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ILSMDiskComponent flush(ILSMIOOperation operation) throws HyracksDataException, IndexException {
        LSMBTreeFlushOperation flushOp = (LSMBTreeFlushOperation)operation;
        LSMBTreeMemoryComponent flushingComponent = (LSMBTreeMemoryComponent)flushOp.getFlushingComponent();
        ITreeIndexAccessor accessor = flushingComponent.getBTree().createAccessor((IModificationOperationCallback)NoOpOperationCallback.INSTANCE, (ISearchOperationCallback)NoOpOperationCallback.INSTANCE);
        RangePredicate nullPred = new RangePredicate(null, null, true, true, null, null);
        long numElements = 0L;
        BloomFilterSpecification bloomFilterSpec = null;
        if (this.hasBloomFilter) {
            accessor.search((IIndexCursor)countingCursor, (ISearchPredicate)nullPred);
            try (ITreeIndexCursor countingCursor = ((BTree.BTreeAccessor)accessor).createCountingSearchCursor();){
                while (countingCursor.hasNext()) {
                    countingCursor.next();
                    ITupleReference countTuple = countingCursor.getTuple();
                    numElements = IntegerPointable.getInteger((byte[])countTuple.getFieldData(0), (int)countTuple.getFieldStart(0));
                }
            }
            int maxBucketsPerElement = BloomCalculations.maxBucketsPerElement((long)numElements);
            bloomFilterSpec = BloomCalculations.computeBloomSpec((int)maxBucketsPerElement, (double)this.bloomFilterFalsePositiveRate);
        }
        LSMBTreeDiskComponent component = this.createDiskComponent(this.componentFactory, flushOp.getBTreeFlushTarget(), flushOp.getBloomFilterFlushTarget(), true);
        IIndexBulkLoader bulkLoader = component.getBTree().createBulkLoader(1.0f, false, numElements, false);
        IIndexBulkLoader builder = null;
        if (this.hasBloomFilter) {
            builder = component.getBloomFilter().createBuilder(numElements, bloomFilterSpec.getNumHashes(), bloomFilterSpec.getNumBucketsPerElements());
        }
        IIndexCursor scanCursor = accessor.createSearchCursor(false);
        accessor.search(scanCursor, (ISearchPredicate)nullPred);
        try {
            while (scanCursor.hasNext()) {
                scanCursor.next();
                if (this.hasBloomFilter) {
                    builder.add(scanCursor.getTuple());
                }
                bulkLoader.add(scanCursor.getTuple());
            }
        }
        finally {
            scanCursor.close();
            if (this.hasBloomFilter) {
                builder.end();
            }
        }
        if (component.getLSMComponentFilter() != null) {
            ArrayList<ITupleReference> filterTuples = new ArrayList<ITupleReference>();
            filterTuples.add(flushingComponent.getLSMComponentFilter().getMinTuple());
            filterTuples.add(flushingComponent.getLSMComponentFilter().getMaxTuple());
            this.filterManager.updateFilter(component.getLSMComponentFilter(), filterTuples);
            this.filterManager.writeFilter(component.getLSMComponentFilter(), (ITreeIndex)component.getBTree());
        }
        flushingComponent.getMetadata().copy(component.getMetadata());
        bulkLoader.end();
        return component;
    }

    public void scheduleMerge(ILSMIndexOperationContext ctx, ILSMIOOperationCallback callback) throws HyracksDataException, IndexException {
        LSMBTreeOpContext opCtx = this.createOpContext((IModificationOperationCallback)NoOpOperationCallback.INSTANCE, (ISearchOperationCallback)NoOpOperationCallback.INSTANCE);
        opCtx.setOperation(IndexOperation.MERGE);
        List mergingComponents = ctx.getComponentHolder();
        boolean returnDeletedTuples = false;
        if (ctx.getComponentHolder().get(ctx.getComponentHolder().size() - 1) != this.diskComponents.get(this.diskComponents.size() - 1)) {
            returnDeletedTuples = true;
        }
        LSMBTreeRangeSearchCursor cursor = new LSMBTreeRangeSearchCursor((ILSMIndexOperationContext)opCtx, returnDeletedTuples);
        BTree firstBTree = ((LSMBTreeDiskComponent)((Object)mergingComponents.get(0))).getBTree();
        BTree lastBTree = ((LSMBTreeDiskComponent)((Object)mergingComponents.get(mergingComponents.size() - 1))).getBTree();
        FileReference firstFile = firstBTree.getFileReference();
        FileReference lastFile = lastBTree.getFileReference();
        LSMComponentFileReferences relMergeFileRefs = this.fileManager.getRelMergeFileReference(firstFile.getFile().getName(), lastFile.getFile().getName());
        LSMBTreeAccessor accessor = new LSMBTreeAccessor(this.lsmHarness, (ILSMIndexOperationContext)opCtx);
        this.ioScheduler.scheduleOperation((ILSMIOOperation)new LSMBTreeMergeOperation((ILSMIndexAccessor)accessor, mergingComponents, (ITreeIndexCursor)cursor, relMergeFileRefs.getInsertIndexFileReference(), relMergeFileRefs.getBloomFilterFileReference(), callback, this.fileManager.getBaseDir()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ILSMDiskComponent merge(ILSMIOOperation operation) throws HyracksDataException, IndexException {
        LSMBTreeMergeOperation mergeOp = (LSMBTreeMergeOperation)operation;
        ITreeIndexCursor cursor = mergeOp.getCursor();
        RangePredicate rangePred = new RangePredicate(null, null, true, true, null, null);
        ILSMIndexOperationContext opCtx = ((LSMIndexSearchCursor)cursor).getOpCtx();
        opCtx.getComponentHolder().addAll(mergeOp.getMergingComponents());
        this.search(opCtx, (IIndexCursor)cursor, (ISearchPredicate)rangePred);
        List<ILSMComponent> mergedComponents = mergeOp.getMergingComponents();
        long numElements = 0L;
        BloomFilterSpecification bloomFilterSpec = null;
        if (this.hasBloomFilter) {
            for (int i = 0; i < mergedComponents.size(); ++i) {
                numElements += ((LSMBTreeDiskComponent)mergedComponents.get(i)).getBloomFilter().getNumElements();
            }
            int maxBucketsPerElement = BloomCalculations.maxBucketsPerElement((long)numElements);
            bloomFilterSpec = BloomCalculations.computeBloomSpec((int)maxBucketsPerElement, (double)this.bloomFilterFalsePositiveRate);
        }
        LSMBTreeDiskComponent mergedComponent = this.createDiskComponent(this.componentFactory, mergeOp.getBTreeMergeTarget(), mergeOp.getBloomFilterMergeTarget(), true);
        IIndexBulkLoader bulkLoader = mergedComponent.getBTree().createBulkLoader(1.0f, false, numElements, false);
        IIndexBulkLoader builder = null;
        if (this.hasBloomFilter) {
            builder = mergedComponent.getBloomFilter().createBuilder(numElements, bloomFilterSpec.getNumHashes(), bloomFilterSpec.getNumBucketsPerElements());
        }
        try {
            while (cursor.hasNext()) {
                cursor.next();
                ITupleReference frameTuple = cursor.getTuple();
                if (this.hasBloomFilter) {
                    builder.add(frameTuple);
                }
                bulkLoader.add(frameTuple);
            }
        }
        finally {
            cursor.close();
            if (this.hasBloomFilter) {
                builder.end();
            }
        }
        if (mergedComponent.getLSMComponentFilter() != null) {
            ArrayList<ITupleReference> filterTuples = new ArrayList<ITupleReference>();
            for (int i = 0; i < mergeOp.getMergingComponents().size(); ++i) {
                filterTuples.add(mergeOp.getMergingComponents().get(i).getLSMComponentFilter().getMinTuple());
                filterTuples.add(mergeOp.getMergingComponents().get(i).getLSMComponentFilter().getMaxTuple());
            }
            this.filterManager.updateFilter(mergedComponent.getLSMComponentFilter(), filterTuples);
            this.filterManager.writeFilter(mergedComponent.getLSMComponentFilter(), (ITreeIndex)mergedComponent.getBTree());
        }
        bulkLoader.end();
        return mergedComponent;
    }

    protected LSMBTreeDiskComponent createDiskComponent(LSMBTreeDiskComponentFactory factory, FileReference btreeFileRef, FileReference bloomFilterFileRef, boolean createComponent) throws HyracksDataException, IndexException {
        LSMBTreeDiskComponent component = factory.createComponent(new LSMComponentFileReferences(btreeFileRef, null, bloomFilterFileRef));
        if (createComponent) {
            component.getBTree().create();
        }
        component.getBTree().activate();
        if (this.hasBloomFilter) {
            if (createComponent) {
                component.getBloomFilter().create();
            }
            component.getBloomFilter().activate();
        }
        if (component.getLSMComponentFilter() != null && !createComponent) {
            this.filterManager.readFilter(component.getLSMComponentFilter(), (ITreeIndex)component.getBTree());
        }
        return component;
    }

    public IIndexBulkLoader createBulkLoader(float fillLevel, boolean verifyInput, long numElementsHint, boolean checkIfEmptyIndex) throws TreeIndexException {
        try {
            return new LSMBTreeBulkLoader(fillLevel, verifyInput, numElementsHint, checkIfEmptyIndex);
        }
        catch (HyracksDataException e) {
            throw new TreeIndexException((Exception)((Object)e));
        }
    }

    protected ILSMDiskComponent createBulkLoadTarget() throws HyracksDataException, IndexException {
        LSMComponentFileReferences componentFileRefs = this.fileManager.getRelFlushFileReference();
        return this.createDiskComponent(this.bulkLoadComponentFactory, componentFileRefs.getInsertIndexFileReference(), componentFileRefs.getBloomFilterFileReference(), true);
    }

    public void markAsValid(ILSMDiskComponent lsmComponent) throws HyracksDataException {
        LSMBTreeDiskComponent component = (LSMBTreeDiskComponent)lsmComponent;
        if (this.hasBloomFilter) {
            this.markAsValidInternal(component.getBTree().getBufferCache(), component.getBloomFilter());
        }
        this.markAsValidInternal((ITreeIndex)component.getBTree());
    }

    public LSMBTreeOpContext createOpContext(IModificationOperationCallback modificationCallback, ISearchOperationCallback searchCallback) {
        int numBloomFilterKeyFields = this.hasBloomFilter ? this.componentFactory.getBloomFilterKeyFields().length : 0;
        return new LSMBTreeOpContext(this.memoryComponents, this.insertLeafFrameFactory, this.deleteLeafFrameFactory, modificationCallback, searchCallback, numBloomFilterKeyFields, this.btreeFields, this.filterFields, this.lsmHarness);
    }

    public ILSMIndexAccessor createAccessor(IModificationOperationCallback modificationCallback, ISearchOperationCallback searchCallback) {
        return new LSMBTreeAccessor(this.lsmHarness, (ILSMIndexOperationContext)this.createOpContext(modificationCallback, searchCallback));
    }

    public IBufferCache getBufferCache() {
        return this.diskBufferCache;
    }

    public IBinaryComparatorFactory[] getComparatorFactories() {
        return this.cmpFactories;
    }

    public ITreeIndexFrameFactory getInteriorFrameFactory() {
        LSMBTreeMemoryComponent mutableComponent = (LSMBTreeMemoryComponent)((Object)this.memoryComponents.get(this.currentMutableComponentId.get()));
        return mutableComponent.getBTree().getInteriorFrameFactory();
    }

    public int getFieldCount() {
        LSMBTreeMemoryComponent mutableComponent = (LSMBTreeMemoryComponent)((Object)this.memoryComponents.get(this.currentMutableComponentId.get()));
        return mutableComponent.getBTree().getFieldCount();
    }

    public int getFileId() {
        LSMBTreeMemoryComponent mutableComponent = (LSMBTreeMemoryComponent)((Object)this.memoryComponents.get(this.currentMutableComponentId.get()));
        return mutableComponent.getBTree().getFileId();
    }

    public IPageManager getPageManager() {
        LSMBTreeMemoryComponent mutableComponent = (LSMBTreeMemoryComponent)((Object)this.memoryComponents.get(this.currentMutableComponentId.get()));
        return mutableComponent.getBTree().getPageManager();
    }

    public ITreeIndexFrameFactory getLeafFrameFactory() {
        LSMBTreeMemoryComponent mutableComponent = (LSMBTreeMemoryComponent)((Object)this.memoryComponents.get(this.currentMutableComponentId.get()));
        return mutableComponent.getBTree().getLeafFrameFactory();
    }

    public long getMemoryAllocationSize() {
        long size = 0L;
        for (ILSMComponent c : this.memoryComponents) {
            LSMBTreeMemoryComponent mutableComponent = (LSMBTreeMemoryComponent)c;
            IBufferCache virtualBufferCache = mutableComponent.getBTree().getBufferCache();
            size += (long)(virtualBufferCache.getNumPages() * virtualBufferCache.getPageSize());
        }
        return size;
    }

    public int getRootPageId() {
        LSMBTreeMemoryComponent mutableComponent = (LSMBTreeMemoryComponent)((Object)this.memoryComponents.get(this.currentMutableComponentId.get()));
        return mutableComponent.getBTree().getRootPageId();
    }

    public void validate() throws HyracksDataException {
        this.validateMemoryComponents();
        List immutableComponents = this.diskComponents;
        for (ILSMDiskComponent c : immutableComponents) {
            BTree btree = ((LSMBTreeDiskComponent)c).getBTree();
            btree.validate();
        }
    }

    public String toString() {
        return "LSMBTree [" + this.fileManager.getBaseDir() + "]";
    }

    public boolean isPrimaryIndex() {
        return this.needKeyDupCheck;
    }

    public Set<String> getLSMComponentPhysicalFiles(ILSMComponent lsmComponent) {
        HashSet<String> files = new HashSet<String>();
        LSMBTreeDiskComponent component = (LSMBTreeDiskComponent)lsmComponent;
        files.add(component.getBTree().getFileReference().getFile().getAbsolutePath());
        if (this.hasBloomFilter) {
            files.add(component.getBloomFilter().getFileReference().getFile().getAbsolutePath());
        }
        return files;
    }

    public synchronized void allocateMemoryComponents() throws HyracksDataException {
        if (!this.isActivated) {
            throw new HyracksDataException("Failed to allocate memory components since the index is not active");
        }
        if (this.memoryComponentsAllocated) {
            return;
        }
        for (ILSMComponent c : this.memoryComponents) {
            LSMBTreeMemoryComponent mutableComponent = (LSMBTreeMemoryComponent)c;
            ((IVirtualBufferCache)mutableComponent.getBTree().getBufferCache()).open();
            mutableComponent.getBTree().create();
            mutableComponent.getBTree().activate();
        }
        this.memoryComponentsAllocated = true;
    }

    private void addOperationalMutableComponents(List<ILSMComponent> operationalComponents) {
        int cmc = this.currentMutableComponentId.get();
        int numMutableComponents = this.memoryComponents.size();
        for (int i = 0; i < numMutableComponents - 1; ++i) {
            ILSMComponent c = (ILSMComponent)this.memoryComponents.get((cmc + i + 1) % numMutableComponents);
            LSMBTreeMemoryComponent mutableComponent = (LSMBTreeMemoryComponent)c;
            if (!mutableComponent.isReadable()) continue;
            operationalComponents.add(0, (ILSMComponent)mutableComponent);
        }
        operationalComponents.add(0, (ILSMComponent)this.memoryComponents.get(cmc));
    }

    private synchronized void clearMemoryComponents() throws HyracksDataException {
        if (this.memoryComponentsAllocated) {
            for (ILSMComponent c : this.memoryComponents) {
                LSMBTreeMemoryComponent mutableComponent = (LSMBTreeMemoryComponent)c;
                mutableComponent.getBTree().clear();
                mutableComponent.reset();
            }
        }
    }

    private synchronized void validateMemoryComponents() throws HyracksDataException {
        if (this.memoryComponentsAllocated) {
            for (ILSMComponent c : this.memoryComponents) {
                LSMBTreeMemoryComponent mutableComponent = (LSMBTreeMemoryComponent)c;
                mutableComponent.getBTree().validate();
            }
        }
    }

    private synchronized void deallocateMemoryComponents() throws HyracksDataException {
        if (this.memoryComponentsAllocated) {
            for (ILSMComponent c : this.memoryComponents) {
                LSMBTreeMemoryComponent mutableComponent = (LSMBTreeMemoryComponent)c;
                mutableComponent.getBTree().deactivate();
                mutableComponent.getBTree().destroy();
                ((IVirtualBufferCache)mutableComponent.getBTree().getBufferCache()).close();
            }
            this.memoryComponentsAllocated = false;
        }
    }

    public class LSMBTreeAccessor
    extends LSMTreeIndexAccessor {
        public LSMBTreeAccessor(ILSMHarness lsmHarness, ILSMIndexOperationContext ctx) {
            super(lsmHarness, ctx);
        }

        public IIndexCursor createSearchCursor(boolean exclusive) {
            return new LSMBTreeSearchCursor(this.ctx);
        }

        public MultiComparator getMultiComparator() {
            LSMBTreeOpContext concreteCtx = (LSMBTreeOpContext)this.ctx;
            return concreteCtx.cmp;
        }
    }

    public class LSMBTreeBulkLoader
    implements IIndexBulkLoader {
        private final ILSMDiskComponent component;
        private final BTree.BTreeBulkLoader bulkLoader;
        private final IIndexBulkLoader builder;
        private boolean cleanedUpArtifacts = false;
        private boolean isEmptyComponent = true;
        private boolean endedBloomFilterLoad = false;
        public final PermutingTupleReference indexTuple;
        public final PermutingTupleReference filterTuple;
        public final MultiComparator filterCmp;

        public LSMBTreeBulkLoader(float fillFactor, boolean verifyInput, long numElementsHint, boolean checkIfEmptyIndex) throws TreeIndexException, HyracksDataException {
            if (checkIfEmptyIndex && !LSMBTree.this.isEmptyIndex()) {
                throw new TreeIndexException("Cannot load an index that is not empty");
            }
            try {
                this.component = LSMBTree.this.createBulkLoadTarget();
            }
            catch (HyracksDataException | IndexException e) {
                throw new TreeIndexException((Exception)e);
            }
            this.bulkLoader = (BTree.BTreeBulkLoader)((LSMBTreeDiskComponent)this.component).getBTree().createBulkLoader(fillFactor, verifyInput, numElementsHint, false);
            if (LSMBTree.this.hasBloomFilter) {
                int maxBucketsPerElement = BloomCalculations.maxBucketsPerElement((long)numElementsHint);
                BloomFilterSpecification bloomFilterSpec = BloomCalculations.computeBloomSpec((int)maxBucketsPerElement, (double)LSMBTree.this.bloomFilterFalsePositiveRate);
                this.builder = ((LSMBTreeDiskComponent)this.component).getBloomFilter().createBuilder(numElementsHint, bloomFilterSpec.getNumHashes(), bloomFilterSpec.getNumBucketsPerElements());
            } else {
                this.builder = null;
            }
            if (LSMBTree.this.filterFields != null) {
                this.indexTuple = new PermutingTupleReference(LSMBTree.this.btreeFields);
                this.filterCmp = MultiComparator.create((IBinaryComparatorFactory[])this.component.getLSMComponentFilter().getFilterCmpFactories());
                this.filterTuple = new PermutingTupleReference(LSMBTree.this.filterFields);
            } else {
                this.indexTuple = null;
                this.filterCmp = null;
                this.filterTuple = null;
            }
        }

        public void add(ITupleReference tuple) throws IndexException, HyracksDataException {
            try {
                ITupleReference t;
                if (this.indexTuple != null) {
                    this.indexTuple.reset(tuple);
                    t = this.indexTuple;
                } else {
                    t = tuple;
                }
                this.bulkLoader.add(t);
                if (LSMBTree.this.hasBloomFilter) {
                    this.builder.add(t);
                }
                if (this.filterTuple != null) {
                    this.filterTuple.reset(tuple);
                    this.component.getLSMComponentFilter().update((ITupleReference)this.filterTuple, this.filterCmp);
                }
            }
            catch (RuntimeException | HyracksDataException | IndexException e) {
                this.cleanupArtifacts();
                throw e;
            }
            if (this.isEmptyComponent) {
                this.isEmptyComponent = false;
            }
        }

        protected void cleanupArtifacts() throws HyracksDataException {
            if (!this.cleanedUpArtifacts) {
                this.cleanedUpArtifacts = true;
                if (LSMBTree.this.hasBloomFilter && !this.endedBloomFilterLoad) {
                    this.builder.abort();
                    this.endedBloomFilterLoad = true;
                }
                ((LSMBTreeDiskComponent)this.component).getBTree().deactivate();
                ((LSMBTreeDiskComponent)this.component).getBTree().destroy();
                if (LSMBTree.this.hasBloomFilter) {
                    ((LSMBTreeDiskComponent)this.component).getBloomFilter().deactivate();
                    ((LSMBTreeDiskComponent)this.component).getBloomFilter().destroy();
                }
            }
        }

        public void end() throws HyracksDataException, IndexException {
            if (!this.cleanedUpArtifacts) {
                if (LSMBTree.this.hasBloomFilter && !this.endedBloomFilterLoad) {
                    this.builder.end();
                    this.endedBloomFilterLoad = true;
                }
                if (this.component.getLSMComponentFilter() != null) {
                    LSMBTree.this.filterManager.writeFilter(this.component.getLSMComponentFilter(), (ITreeIndex)((LSMBTreeDiskComponent)this.component).getBTree());
                }
                this.bulkLoader.end();
                if (this.isEmptyComponent) {
                    this.cleanupArtifacts();
                } else {
                    LSMBTree.this.ioOpCallback.afterOperation(LSMOperationType.FLUSH, null, this.component);
                    LSMBTree.this.lsmHarness.addBulkLoadedComponent(this.component);
                }
            }
        }

        public void abort() throws HyracksDataException {
            if (this.bulkLoader != null) {
                this.bulkLoader.abort();
            }
            if (this.builder != null) {
                this.builder.abort();
            }
        }
    }
}

