/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.btree.impls;

import java.util.LinkedList;
import java.util.List;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.storage.am.common.api.IModificationOperationCallback;
import org.apache.hyracks.storage.am.common.api.ISearchOperationCallback;
import org.apache.hyracks.storage.am.common.api.ISearchPredicate;
import org.apache.hyracks.storage.am.common.api.ITreeIndexFrameFactory;
import org.apache.hyracks.storage.am.common.impls.NoOpOperationCallback;
import org.apache.hyracks.storage.am.common.ophelpers.IndexOperation;
import org.apache.hyracks.storage.am.common.ophelpers.MultiComparator;
import org.apache.hyracks.storage.am.lsm.btree.impls.LSMBTreeWithBuddyCursorInitialState;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMDiskComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMHarness;
import org.apache.hyracks.storage.am.lsm.common.impls.AbstractLSMIndexOperationContext;

public class ExternalBTreeWithBuddyOpContext
extends AbstractLSMIndexOperationContext {
    private IndexOperation op;
    private MultiComparator bTreeCmp;
    private MultiComparator buddyBTreeCmp;
    public final List<ILSMComponent> componentHolder = new LinkedList<ILSMComponent>();
    private final List<ILSMDiskComponent> componentsToBeMerged = new LinkedList<ILSMDiskComponent>();
    private final List<ILSMDiskComponent> componentsToBeReplicated = new LinkedList<ILSMDiskComponent>();
    public final ISearchOperationCallback searchCallback;
    private final int targetIndexVersion;
    public ISearchPredicate searchPredicate;
    public LSMBTreeWithBuddyCursorInitialState searchInitialState;

    public ExternalBTreeWithBuddyOpContext(IBinaryComparatorFactory[] btreeCmpFactories, IBinaryComparatorFactory[] buddyBtreeCmpFactories, ISearchOperationCallback searchCallback, int targetIndexVersion, ILSMHarness lsmHarness, ITreeIndexFrameFactory btreeInteriorFrameFactory, ITreeIndexFrameFactory btreeLeafFrameFactory, ITreeIndexFrameFactory buddyBtreeLeafFrameFactory) {
        this.searchCallback = searchCallback;
        this.targetIndexVersion = targetIndexVersion;
        this.bTreeCmp = MultiComparator.create((IBinaryComparatorFactory[])btreeCmpFactories);
        this.buddyBTreeCmp = MultiComparator.create((IBinaryComparatorFactory[])buddyBtreeCmpFactories);
        this.searchInitialState = new LSMBTreeWithBuddyCursorInitialState(btreeInteriorFrameFactory, btreeLeafFrameFactory, buddyBtreeLeafFrameFactory, lsmHarness, MultiComparator.create((IBinaryComparatorFactory[])btreeCmpFactories), MultiComparator.create((IBinaryComparatorFactory[])buddyBtreeCmpFactories), (ISearchOperationCallback)NoOpOperationCallback.INSTANCE, null);
    }

    public void setOperation(IndexOperation newOp) {
        this.reset();
        this.op = newOp;
    }

    public void setCurrentMutableComponentId(int currentMutableComponentId) {
    }

    public void reset() {
        super.reset();
        this.componentHolder.clear();
        this.componentsToBeMerged.clear();
        this.componentsToBeReplicated.clear();
    }

    public IndexOperation getOperation() {
        return this.op;
    }

    public MultiComparator getBTreeMultiComparator() {
        return this.bTreeCmp;
    }

    public MultiComparator getBuddyBTreeMultiComparator() {
        return this.buddyBTreeCmp;
    }

    public List<ILSMComponent> getComponentHolder() {
        return this.componentHolder;
    }

    public ISearchOperationCallback getSearchOperationCallback() {
        return this.searchCallback;
    }

    public IModificationOperationCallback getModificationCallback() {
        return null;
    }

    public List<ILSMDiskComponent> getComponentsToBeMerged() {
        return this.componentsToBeMerged;
    }

    public int getTargetIndexVersion() {
        return this.targetIndexVersion;
    }

    public void setSearchPredicate(ISearchPredicate searchPredicate) {
        this.searchPredicate = searchPredicate;
    }

    public ISearchPredicate getSearchPredicate() {
        return this.searchPredicate;
    }

    public List<ILSMDiskComponent> getComponentsToBeReplicated() {
        return this.componentsToBeReplicated;
    }
}

