/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.btree.impls;

import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.api.io.IIOManager;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.bloomfilter.impls.BloomCalculations;
import org.apache.hyracks.storage.am.bloomfilter.impls.BloomFilter;
import org.apache.hyracks.storage.am.bloomfilter.impls.BloomFilterFactory;
import org.apache.hyracks.storage.am.bloomfilter.impls.BloomFilterSpecification;
import org.apache.hyracks.storage.am.btree.impls.BTree;
import org.apache.hyracks.storage.am.btree.impls.RangePredicate;
import org.apache.hyracks.storage.am.common.api.ICursorInitialState;
import org.apache.hyracks.storage.am.common.api.IIndexBulkLoader;
import org.apache.hyracks.storage.am.common.api.IIndexCursor;
import org.apache.hyracks.storage.am.common.api.IIndexOperationContext;
import org.apache.hyracks.storage.am.common.api.IMetadataPageManager;
import org.apache.hyracks.storage.am.common.api.IModificationOperationCallback;
import org.apache.hyracks.storage.am.common.api.ISearchOperationCallback;
import org.apache.hyracks.storage.am.common.api.ISearchPredicate;
import org.apache.hyracks.storage.am.common.api.ITreeIndex;
import org.apache.hyracks.storage.am.common.api.ITreeIndexCursor;
import org.apache.hyracks.storage.am.common.api.ITreeIndexFrameFactory;
import org.apache.hyracks.storage.am.common.api.ITwoPCIndexBulkLoader;
import org.apache.hyracks.storage.am.common.api.IndexException;
import org.apache.hyracks.storage.am.common.api.TreeIndexException;
import org.apache.hyracks.storage.am.common.impls.NoOpOperationCallback;
import org.apache.hyracks.storage.am.common.ophelpers.IndexOperation;
import org.apache.hyracks.storage.am.common.ophelpers.MultiComparator;
import org.apache.hyracks.storage.am.lsm.btree.impls.ExternalBTreeWithBuddyOpContext;
import org.apache.hyracks.storage.am.lsm.btree.impls.LSMBTreeWithBuddyDiskComponent;
import org.apache.hyracks.storage.am.lsm.btree.impls.LSMBTreeWithBuddyDiskComponentFactory;
import org.apache.hyracks.storage.am.lsm.btree.impls.LSMBTreeWithBuddyMergeOperation;
import org.apache.hyracks.storage.am.lsm.btree.impls.LSMBTreeWithBuddySearchCursor;
import org.apache.hyracks.storage.am.lsm.btree.impls.LSMBTreeWithBuddySortedCursor;
import org.apache.hyracks.storage.am.lsm.btree.impls.LSMBuddyBTreeMergeCursor;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMDiskComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMDiskComponentFactory;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMHarness;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperation;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationCallback;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationScheduler;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexAccessor;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexFileManager;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexOperationContext;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMMergePolicy;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMOperationTracker;
import org.apache.hyracks.storage.am.lsm.common.api.ITwoPCIndex;
import org.apache.hyracks.storage.am.lsm.common.api.LSMOperationType;
import org.apache.hyracks.storage.am.lsm.common.impls.AbstractLSMIndex;
import org.apache.hyracks.storage.am.lsm.common.impls.BlockingIOOperationCallbackWrapper;
import org.apache.hyracks.storage.am.lsm.common.impls.ExternalIndexHarness;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMComponentFileReferences;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMTreeIndexAccessor;
import org.apache.hyracks.storage.am.lsm.common.impls.TreeIndexFactory;
import org.apache.hyracks.storage.common.buffercache.IBufferCache;
import org.apache.hyracks.storage.common.file.IFileMapProvider;

public class ExternalBTreeWithBuddy
extends AbstractLSMIndex
implements ITreeIndex,
ITwoPCIndex {
    private final LSMBTreeWithBuddyDiskComponentFactory componentFactory;
    private final LSMBTreeWithBuddyDiskComponentFactory bulkComponentFactory;
    private final IBinaryComparatorFactory[] btreeCmpFactories;
    private final IBinaryComparatorFactory[] buddyBtreeCmpFactories;
    private final int[] buddyBTreeFields;
    private final ITreeIndexFrameFactory btreeInteriorFrameFactory;
    private final ITreeIndexFrameFactory btreeLeafFrameFactory;
    private final ITreeIndexFrameFactory buddyBtreeLeafFrameFactory;
    private final List<ILSMDiskComponent> secondDiskComponents;
    private int version = -1;

    public ExternalBTreeWithBuddy(IIOManager ioManager, ITreeIndexFrameFactory btreeInteriorFrameFactory, ITreeIndexFrameFactory btreeLeafFrameFactory, ITreeIndexFrameFactory buddyBtreeLeafFrameFactory, IBufferCache diskBufferCache, ILSMIndexFileManager fileManager, TreeIndexFactory<BTree> bulkLoadBTreeFactory, TreeIndexFactory<BTree> copyBtreeFactory, TreeIndexFactory<BTree> buddyBtreeFactory, BloomFilterFactory bloomFilterFactory, IFileMapProvider diskFileMapProvider, double bloomFilterFalsePositiveRate, ILSMMergePolicy mergePolicy, ILSMOperationTracker opTracker, ILSMIOOperationScheduler ioScheduler, ILSMIOOperationCallback ioOpCallback, IBinaryComparatorFactory[] btreeCmpFactories, IBinaryComparatorFactory[] buddyBtreeCmpFactories, int[] buddyBTreeFields, int version, boolean durable) {
        super(ioManager, diskBufferCache, fileManager, diskFileMapProvider, bloomFilterFalsePositiveRate, mergePolicy, opTracker, ioScheduler, ioOpCallback, durable);
        this.btreeCmpFactories = btreeCmpFactories;
        this.buddyBtreeCmpFactories = buddyBtreeCmpFactories;
        this.buddyBTreeFields = buddyBTreeFields;
        this.btreeInteriorFrameFactory = btreeInteriorFrameFactory;
        this.btreeLeafFrameFactory = btreeLeafFrameFactory;
        this.buddyBtreeLeafFrameFactory = buddyBtreeLeafFrameFactory;
        this.componentFactory = new LSMBTreeWithBuddyDiskComponentFactory(copyBtreeFactory, buddyBtreeFactory, bloomFilterFactory);
        this.bulkComponentFactory = new LSMBTreeWithBuddyDiskComponentFactory(bulkLoadBTreeFactory, buddyBtreeFactory, bloomFilterFactory);
        this.secondDiskComponents = new LinkedList<ILSMDiskComponent>();
        this.version = version;
    }

    public void create() throws HyracksDataException {
        if (this.isActivated) {
            throw new HyracksDataException("Failed to create the index since it is activated.");
        }
        this.fileManager.deleteDirs();
        this.fileManager.createDirs();
        this.diskComponents.clear();
        this.secondDiskComponents.clear();
    }

    public void activate() throws HyracksDataException {
        if (this.isActivated) {
            throw new HyracksDataException("Failed to activate the index since it is already activated.");
        }
        if (this.diskComponents.size() == 0 && this.secondDiskComponents.size() == 0) {
            List validFileReferences;
            try {
                validFileReferences = this.fileManager.cleanupAndGetValidFiles();
            }
            catch (IndexException indexException) {
                throw new HyracksDataException((Throwable)indexException);
            }
            for (LSMComponentFileReferences lsmComonentFileReference : validFileReferences) {
                LSMBTreeWithBuddyDiskComponent component;
                try {
                    component = this.createDiskComponent(this.componentFactory, lsmComonentFileReference.getInsertIndexFileReference(), lsmComonentFileReference.getDeleteIndexFileReference(), lsmComonentFileReference.getBloomFilterFileReference(), false);
                }
                catch (IndexException e) {
                    throw new HyracksDataException((Throwable)e);
                }
                this.diskComponents.add(component);
                this.secondDiskComponents.add((ILSMDiskComponent)component);
            }
            ((ExternalIndexHarness)this.lsmHarness).indexFirstTimeActivated();
        } else {
            BloomFilter bloomFilter;
            BTree buddyBtree;
            BTree btree;
            LSMBTreeWithBuddyDiskComponent component;
            for (ILSMComponent iLSMComponent : this.diskComponents) {
                component = (LSMBTreeWithBuddyDiskComponent)iLSMComponent;
                btree = component.getBTree();
                buddyBtree = component.getBuddyBTree();
                bloomFilter = component.getBloomFilter();
                btree.activate();
                buddyBtree.activate();
                bloomFilter.activate();
            }
            for (ILSMComponent iLSMComponent : this.secondDiskComponents) {
                if (this.diskComponents.contains(iLSMComponent)) continue;
                component = (LSMBTreeWithBuddyDiskComponent)iLSMComponent;
                btree = component.getBTree();
                buddyBtree = component.getBuddyBTree();
                bloomFilter = component.getBloomFilter();
                btree.activate();
                buddyBtree.activate();
                bloomFilter.activate();
            }
        }
        this.isActivated = true;
    }

    public void clear() throws HyracksDataException {
        LSMBTreeWithBuddyDiskComponent component;
        if (!this.isActivated) {
            throw new HyracksDataException("Failed to clear the index since it is not activated.");
        }
        ((ExternalIndexHarness)this.lsmHarness).indexClear();
        for (ILSMComponent iLSMComponent : this.diskComponents) {
            component = (LSMBTreeWithBuddyDiskComponent)iLSMComponent;
            component.getBTree().deactivate();
            component.getBuddyBTree().deactivate();
            component.getBloomFilter().deactivate();
            component.getBTree().destroy();
            component.getBloomFilter().destroy();
            component.getBuddyBTree().destroy();
            this.secondDiskComponents.remove(iLSMComponent);
        }
        for (ILSMComponent iLSMComponent : this.secondDiskComponents) {
            component = (LSMBTreeWithBuddyDiskComponent)iLSMComponent;
            component.getBTree().deactivate();
            component.getBloomFilter().deactivate();
            component.getBuddyBTree().deactivate();
            component.getBTree().destroy();
            component.getBloomFilter().destroy();
            component.getBuddyBTree().destroy();
        }
        this.diskComponents.clear();
        this.secondDiskComponents.clear();
        this.version = -1;
    }

    public void deactivate() throws HyracksDataException {
        this.deactivate(true);
    }

    public void destroy() throws HyracksDataException {
        LSMBTreeWithBuddyDiskComponent component;
        if (this.isActivated) {
            throw new HyracksDataException("Failed to destroy the index since it is activated.");
        }
        for (ILSMComponent iLSMComponent : this.diskComponents) {
            component = (LSMBTreeWithBuddyDiskComponent)iLSMComponent;
            component.getBTree().destroy();
            component.getBuddyBTree().destroy();
            component.getBloomFilter().destroy();
            this.secondDiskComponents.remove(iLSMComponent);
        }
        for (ILSMComponent iLSMComponent : this.secondDiskComponents) {
            component = (LSMBTreeWithBuddyDiskComponent)iLSMComponent;
            component.getBTree().destroy();
            component.getBuddyBTree().destroy();
            component.getBloomFilter().destroy();
        }
        this.diskComponents.clear();
        this.secondDiskComponents.clear();
        this.fileManager.deleteDirs();
        this.version = -1;
    }

    public ILSMIndexAccessor createAccessor(IModificationOperationCallback modificationCallback, ISearchOperationCallback searchCallback) throws HyracksDataException {
        return new LSMBTreeWithBuddyAccessor(this.lsmHarness, (ILSMIndexOperationContext)this.createOpContext(searchCallback, this.version));
    }

    public void validate() throws HyracksDataException {
        throw new UnsupportedOperationException("Validation not implemented for LSM B-Trees with Buddy B-Tree.");
    }

    public long getMemoryAllocationSize() {
        return 0L;
    }

    public void subsumeMergedComponents(ILSMDiskComponent newComponent, List<ILSMComponent> mergedComponents) throws HyracksDataException {
        int swapIndex;
        List olderList;
        List<ILSMDiskComponent> newerList;
        if (this.version == 0) {
            newerList = this.diskComponents;
            olderList = this.secondDiskComponents;
        } else {
            newerList = this.secondDiskComponents;
            olderList = this.diskComponents;
        }
        if (olderList.containsAll(mergedComponents)) {
            swapIndex = olderList.indexOf(mergedComponents.get(0));
            olderList.removeAll(mergedComponents);
            olderList.add(swapIndex, newComponent);
        }
        swapIndex = newerList.indexOf(mergedComponents.get(0));
        newerList.removeAll(mergedComponents);
        newerList.add(swapIndex, newComponent);
    }

    public IIndexBulkLoader createBulkLoader(float fillLevel, boolean verifyInput, long numElementsHint, boolean checkIfEmptyIndex) throws TreeIndexException {
        try {
            return new LSMTwoPCBTreeWithBuddyBulkLoader(fillLevel, verifyInput, 0L, checkIfEmptyIndex, false);
        }
        catch (HyracksDataException e) {
            throw new TreeIndexException((Exception)((Object)e));
        }
    }

    public IIndexBulkLoader createTransactionBulkLoader(float fillLevel, boolean verifyInput, long numElementsHint, boolean checkIfEmptyIndex) throws TreeIndexException {
        try {
            return new LSMTwoPCBTreeWithBuddyBulkLoader(fillLevel, verifyInput, numElementsHint, checkIfEmptyIndex, true);
        }
        catch (HyracksDataException e) {
            throw new TreeIndexException((Exception)((Object)e));
        }
    }

    public void modify(IIndexOperationContext ictx, ITupleReference tuple) throws HyracksDataException, IndexException {
        throw new UnsupportedOperationException("tuple modify not supported in LSM-Disk-Only-BTree");
    }

    public void search(ILSMIndexOperationContext ictx, IIndexCursor cursor, ISearchPredicate pred) throws HyracksDataException, IndexException {
        ExternalBTreeWithBuddyOpContext ctx = (ExternalBTreeWithBuddyOpContext)ictx;
        List operationalComponents = ictx.getComponentHolder();
        ctx.searchInitialState.setOperationalComponents(operationalComponents);
        cursor.open((ICursorInitialState)ctx.searchInitialState, pred);
    }

    public void scheduleFlush(ILSMIndexOperationContext ctx, ILSMIOOperationCallback callback) throws HyracksDataException {
        throw new UnsupportedOperationException("flush not supported in LSM-Disk-Only-BTree");
    }

    public ILSMDiskComponent flush(ILSMIOOperation operation) throws HyracksDataException, IndexException {
        throw new UnsupportedOperationException("flush not supported in LSM-Disk-Only-BTree");
    }

    protected LSMComponentFileReferences getMergeTargetFileName(List<ILSMComponent> mergingDiskComponents) throws HyracksDataException {
        BTree firstTree = ((LSMBTreeWithBuddyDiskComponent)mergingDiskComponents.get(0)).getBTree();
        BTree lastTree = ((LSMBTreeWithBuddyDiskComponent)mergingDiskComponents.get(mergingDiskComponents.size() - 1)).getBTree();
        FileReference firstFile = firstTree.getFileReference();
        FileReference lastFile = lastTree.getFileReference();
        LSMComponentFileReferences fileRefs = this.fileManager.getRelMergeFileReference(firstFile.getFile().getName(), lastFile.getFile().getName());
        return fileRefs;
    }

    public void scheduleMerge(ILSMIndexOperationContext ctx, ILSMIOOperationCallback callback) throws HyracksDataException, IndexException {
        ExternalBTreeWithBuddyOpContext bctx = this.createOpContext((ISearchOperationCallback)NoOpOperationCallback.INSTANCE, 0);
        bctx.setOperation(IndexOperation.MERGE);
        List mergingComponents = ctx.getComponentHolder();
        LSMBTreeWithBuddySortedCursor cursor = new LSMBTreeWithBuddySortedCursor((ILSMIndexOperationContext)bctx, this.buddyBTreeFields);
        LSMComponentFileReferences relMergeFileRefs = this.getMergeTargetFileName(mergingComponents);
        LSMBTreeWithBuddyAccessor accessor = new LSMBTreeWithBuddyAccessor(this.lsmHarness, (ILSMIndexOperationContext)bctx);
        boolean keepDeleteTuples = false;
        keepDeleteTuples = this.version == 0 ? mergingComponents.get(mergingComponents.size() - 1) != this.diskComponents.get(this.diskComponents.size() - 1) : mergingComponents.get(mergingComponents.size() - 1) != this.secondDiskComponents.get(this.secondDiskComponents.size() - 1);
        this.ioScheduler.scheduleOperation((ILSMIOOperation)new LSMBTreeWithBuddyMergeOperation((ILSMIndexAccessor)accessor, mergingComponents, cursor, relMergeFileRefs.getInsertIndexFileReference(), relMergeFileRefs.getDeleteIndexFileReference(), relMergeFileRefs.getBloomFilterFileReference(), callback, this.fileManager.getBaseDir(), keepDeleteTuples));
    }

    public ExternalBTreeWithBuddyOpContext createOpContext(ISearchOperationCallback searchCallback, int targetVersion) {
        return new ExternalBTreeWithBuddyOpContext(this.btreeCmpFactories, this.buddyBtreeCmpFactories, searchCallback, targetVersion, this.lsmHarness, this.btreeInteriorFrameFactory, this.btreeLeafFrameFactory, this.buddyBtreeLeafFrameFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ILSMDiskComponent merge(ILSMIOOperation operation) throws HyracksDataException, IndexException {
        LSMBTreeWithBuddyMergeOperation mergeOp = (LSMBTreeWithBuddyMergeOperation)operation;
        ITreeIndexCursor cursor = mergeOp.getCursor();
        RangePredicate btreeSearchPred = new RangePredicate(null, null, true, true, null, null);
        ILSMIndexOperationContext opCtx = ((LSMBTreeWithBuddySortedCursor)cursor).getOpCtx();
        opCtx.getComponentHolder().addAll(mergeOp.getMergingComponents());
        this.search(opCtx, (IIndexCursor)cursor, (ISearchPredicate)btreeSearchPred);
        LSMBTreeWithBuddyDiskComponent mergedComponent = this.createDiskComponent(this.componentFactory, mergeOp.getBTreeMergeTarget(), mergeOp.getBuddyBTreeMergeTarget(), mergeOp.getBloomFilterMergeTarget(), true);
        if (mergeOp.isKeepDeletedTuples()) {
            LSMBuddyBTreeMergeCursor buddyBtreeCursor = new LSMBuddyBTreeMergeCursor(opCtx);
            this.search(opCtx, (IIndexCursor)buddyBtreeCursor, (ISearchPredicate)btreeSearchPred);
            BTree buddyBtree = mergedComponent.getBuddyBTree();
            IIndexBulkLoader buddyBtreeBulkLoader = buddyBtree.createBulkLoader(1.0f, true, 0L, false);
            long numElements = 0L;
            for (int i = 0; i < mergeOp.getMergingComponents().size(); ++i) {
                numElements += ((LSMBTreeWithBuddyDiskComponent)mergeOp.getMergingComponents().get(i)).getBloomFilter().getNumElements();
            }
            int maxBucketsPerElement = BloomCalculations.maxBucketsPerElement((long)numElements);
            BloomFilterSpecification bloomFilterSpec = BloomCalculations.computeBloomSpec((int)maxBucketsPerElement, (double)this.bloomFilterFalsePositiveRate);
            IIndexBulkLoader builder = mergedComponent.getBloomFilter().createBuilder(numElements, bloomFilterSpec.getNumHashes(), bloomFilterSpec.getNumBucketsPerElements());
            try {
                while (buddyBtreeCursor.hasNext()) {
                    buddyBtreeCursor.next();
                    ITupleReference tuple = buddyBtreeCursor.getTuple();
                    buddyBtreeBulkLoader.add(tuple);
                    builder.add(tuple);
                }
            }
            finally {
                buddyBtreeCursor.close();
                builder.end();
            }
            buddyBtreeBulkLoader.end();
        }
        IIndexBulkLoader bulkLoader = mergedComponent.getBTree().createBulkLoader(1.0f, false, 0L, false);
        try {
            while (cursor.hasNext()) {
                cursor.next();
                ITupleReference frameTuple = cursor.getTuple();
                bulkLoader.add(frameTuple);
            }
        }
        finally {
            cursor.close();
        }
        bulkLoader.end();
        return mergedComponent;
    }

    public void getOperationalComponents(ILSMIndexOperationContext ctx) {
        List operationalComponents = ctx.getComponentHolder();
        List<ILSMDiskComponent> immutableComponents = this.version == 0 ? this.diskComponents : this.secondDiskComponents;
        ExternalBTreeWithBuddyOpContext opCtx = (ExternalBTreeWithBuddyOpContext)ctx;
        operationalComponents.clear();
        switch (ctx.getOperation()) {
            case SEARCH: {
                if (opCtx.getTargetIndexVersion() == 0) {
                    operationalComponents.addAll(this.diskComponents);
                    break;
                }
                operationalComponents.addAll(this.secondDiskComponents);
                break;
            }
            case MERGE: {
                operationalComponents.addAll(ctx.getComponentsToBeMerged());
                break;
            }
            case FULL_MERGE: {
                operationalComponents.addAll(immutableComponents);
            }
            case REPLICATE: {
                operationalComponents.addAll(ctx.getComponentsToBeReplicated());
                break;
            }
            case FLUSH: {
                break;
            }
            default: {
                throw new UnsupportedOperationException("Operation " + ctx.getOperation() + " not supported.");
            }
        }
    }

    public void markAsValid(ILSMDiskComponent lsmComponent) throws HyracksDataException {
        LSMBTreeWithBuddyDiskComponent component = (LSMBTreeWithBuddyDiskComponent)lsmComponent;
        this.markAsValidInternal(component.getBTree().getBufferCache(), component.getBloomFilter());
        this.markAsValidInternal((ITreeIndex)component.getBTree());
        this.markAsValidInternal((ITreeIndex)component.getBuddyBTree());
    }

    public void commitTransactionDiskComponent(ILSMDiskComponent newComponent) throws HyracksDataException {
        List olderList;
        List<ILSMDiskComponent> newerList;
        if (this.version == 0) {
            newerList = this.diskComponents;
            olderList = this.secondDiskComponents;
            this.version = 1;
        } else {
            newerList = this.secondDiskComponents;
            olderList = this.diskComponents;
            this.version = 0;
        }
        olderList.clear();
        olderList.addAll(newerList);
        if (newComponent != null) {
            olderList.add(0, newComponent);
        }
    }

    public void deactivate(boolean flushOnExit) throws HyracksDataException {
        BloomFilter bloomFilter;
        BTree buddyBtree;
        BTree btree;
        LSMBTreeWithBuddyDiskComponent component;
        if (!this.isActivated) {
            throw new HyracksDataException("Failed to deactivate the index since it is already deactivated.");
        }
        if (flushOnExit) {
            BlockingIOOperationCallbackWrapper cb = new BlockingIOOperationCallbackWrapper(this.ioOpCallback);
            cb.afterFinalize(LSMOperationType.FLUSH, null);
        }
        for (ILSMComponent iLSMComponent : this.diskComponents) {
            component = (LSMBTreeWithBuddyDiskComponent)iLSMComponent;
            btree = component.getBTree();
            buddyBtree = component.getBuddyBTree();
            bloomFilter = component.getBloomFilter();
            btree.deactivateCloseHandle();
            buddyBtree.deactivateCloseHandle();
            bloomFilter.deactivate();
        }
        for (ILSMComponent iLSMComponent : this.secondDiskComponents) {
            if (this.diskComponents.contains(iLSMComponent)) continue;
            component = (LSMBTreeWithBuddyDiskComponent)iLSMComponent;
            btree = component.getBTree();
            buddyBtree = component.getBuddyBTree();
            bloomFilter = component.getBloomFilter();
            btree.deactivateCloseHandle();
            buddyBtree.deactivateCloseHandle();
            bloomFilter.deactivate();
        }
        this.isActivated = false;
    }

    public ITreeIndexFrameFactory getLeafFrameFactory() {
        return this.btreeLeafFrameFactory;
    }

    public ITreeIndexFrameFactory getInteriorFrameFactory() {
        return this.btreeInteriorFrameFactory;
    }

    public IMetadataPageManager getPageManager() {
        return null;
    }

    public int getFieldCount() {
        return this.btreeCmpFactories.length;
    }

    public int getRootPageId() {
        return 0;
    }

    public int getFileId() {
        return 0;
    }

    public IBinaryComparatorFactory[] getComparatorFactories() {
        return this.btreeCmpFactories;
    }

    private LSMBTreeWithBuddyDiskComponent createDiskComponent(ILSMDiskComponentFactory factory, FileReference insertFileRef, FileReference deleteFileRef, FileReference bloomFilterFileRef, boolean createComponent) throws HyracksDataException, IndexException {
        LSMBTreeWithBuddyDiskComponent component = (LSMBTreeWithBuddyDiskComponent)factory.createComponent(new LSMComponentFileReferences(insertFileRef, deleteFileRef, bloomFilterFileRef));
        if (createComponent) {
            component.getBTree().create();
            component.getBuddyBTree().create();
            component.getBloomFilter().create();
        }
        component.getBTree().activate();
        component.getBuddyBTree().activate();
        component.getBloomFilter().activate();
        return component;
    }

    protected ILSMDiskComponent createBulkLoadTarget() throws HyracksDataException, IndexException {
        LSMComponentFileReferences componentFileRefs = this.fileManager.getRelFlushFileReference();
        return this.createDiskComponent(this.bulkComponentFactory, componentFileRefs.getInsertIndexFileReference(), componentFileRefs.getDeleteIndexFileReference(), componentFileRefs.getBloomFilterFileReference(), true);
    }

    public ILSMIndexAccessor createAccessor(ISearchOperationCallback searchCallback, int targetIndexVersion) throws HyracksDataException {
        return new LSMBTreeWithBuddyAccessor(this.lsmHarness, (ILSMIndexOperationContext)this.createOpContext(searchCallback, targetIndexVersion));
    }

    public void addDiskComponent(ILSMDiskComponent c) throws HyracksDataException {
        if (this.version == 0) {
            this.diskComponents.add(0, c);
        } else if (this.version == 1) {
            this.secondDiskComponents.add(0, c);
        }
    }

    public int getCurrentVersion() {
        return this.version;
    }

    public List<ILSMDiskComponent> getFirstComponentList() {
        return this.diskComponents;
    }

    public List<ILSMDiskComponent> getSecondComponentList() {
        return this.secondDiskComponents;
    }

    public void commitTransaction() throws HyracksDataException, IndexException {
        LSMComponentFileReferences componentFileRefrences = this.fileManager.getTransactionFileReferenceForCommit();
        LSMBTreeWithBuddyDiskComponent component = null;
        if (componentFileRefrences != null) {
            component = this.createDiskComponent(this.componentFactory, componentFileRefrences.getInsertIndexFileReference(), componentFileRefrences.getDeleteIndexFileReference(), componentFileRefrences.getBloomFilterFileReference(), false);
        }
        ((ExternalIndexHarness)this.lsmHarness).addTransactionComponents(component);
    }

    public void abortTransaction() throws TreeIndexException {
        try {
            this.fileManager.deleteTransactionFiles();
        }
        catch (HyracksDataException e) {
            throw new TreeIndexException((Exception)((Object)e));
        }
    }

    public void recoverTransaction() throws TreeIndexException {
        try {
            this.fileManager.recoverTransaction();
        }
        catch (HyracksDataException e) {
            throw new TreeIndexException((Exception)((Object)e));
        }
    }

    public boolean hasMemoryComponents() {
        return false;
    }

    public boolean isPrimaryIndex() {
        return false;
    }

    public Set<String> getLSMComponentPhysicalFiles(ILSMComponent lsmComponent) {
        HashSet<String> files = new HashSet<String>();
        LSMBTreeWithBuddyDiskComponent component = (LSMBTreeWithBuddyDiskComponent)lsmComponent;
        files.add(component.getBTree().getFileReference().getFile().getAbsolutePath());
        files.add(component.getBuddyBTree().getFileReference().getFile().getAbsolutePath());
        files.add(component.getBloomFilter().getFileReference().getFile().getAbsolutePath());
        return files;
    }

    public void allocateMemoryComponents() throws HyracksDataException {
    }

    public class LSMTwoPCBTreeWithBuddyBulkLoader
    implements IIndexBulkLoader,
    ITwoPCIndexBulkLoader {
        private final ILSMDiskComponent component;
        private final BTree.BTreeBulkLoader btreeBulkLoader;
        private final BTree.BTreeBulkLoader buddyBtreeBulkLoader;
        private final IIndexBulkLoader builder;
        private boolean cleanedUpArtifacts = false;
        private boolean isEmptyComponent = true;
        private boolean endedBloomFilterLoad = false;
        private final boolean isTransaction;

        public LSMTwoPCBTreeWithBuddyBulkLoader(float fillFactor, boolean verifyInput, long numElementsHint, boolean checkIfEmptyIndex, boolean isTransaction) throws TreeIndexException, HyracksDataException {
            this.isTransaction = isTransaction;
            if (isTransaction) {
                try {
                    this.component = this.createTransactionTarget();
                }
                catch (HyracksDataException | IndexException e) {
                    throw new TreeIndexException((Exception)e);
                }
            }
            if (checkIfEmptyIndex && !ExternalBTreeWithBuddy.this.isEmptyIndex()) {
                throw new TreeIndexException("Cannot load an index that is not empty");
            }
            try {
                this.component = ExternalBTreeWithBuddy.this.createBulkLoadTarget();
            }
            catch (HyracksDataException | IndexException e) {
                throw new TreeIndexException((Exception)e);
            }
            this.btreeBulkLoader = (BTree.BTreeBulkLoader)((LSMBTreeWithBuddyDiskComponent)this.component).getBTree().createBulkLoader(fillFactor, verifyInput, numElementsHint, false);
            this.buddyBtreeBulkLoader = (BTree.BTreeBulkLoader)((LSMBTreeWithBuddyDiskComponent)this.component).getBuddyBTree().createBulkLoader(fillFactor, verifyInput, numElementsHint, false);
            int maxBucketsPerElement = BloomCalculations.maxBucketsPerElement((long)numElementsHint);
            BloomFilterSpecification bloomFilterSpec = BloomCalculations.computeBloomSpec((int)maxBucketsPerElement, (double)ExternalBTreeWithBuddy.this.bloomFilterFalsePositiveRate);
            this.builder = ((LSMBTreeWithBuddyDiskComponent)this.component).getBloomFilter().createBuilder(numElementsHint, bloomFilterSpec.getNumHashes(), bloomFilterSpec.getNumBucketsPerElements());
        }

        public void add(ITupleReference tuple) throws IndexException, HyracksDataException {
            try {
                this.btreeBulkLoader.add(tuple);
            }
            catch (RuntimeException | HyracksDataException | IndexException e) {
                this.cleanupArtifacts();
                throw e;
            }
            if (this.isEmptyComponent) {
                this.isEmptyComponent = false;
            }
        }

        public void cleanupArtifacts() throws HyracksDataException {
            if (!this.cleanedUpArtifacts) {
                this.cleanedUpArtifacts = true;
                try {
                    ((LSMBTreeWithBuddyDiskComponent)this.component).getBTree().deactivate();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ((LSMBTreeWithBuddyDiskComponent)this.component).getBTree().destroy();
                try {
                    ((LSMBTreeWithBuddyDiskComponent)this.component).getBuddyBTree().deactivate();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ((LSMBTreeWithBuddyDiskComponent)this.component).getBuddyBTree().destroy();
                try {
                    ((LSMBTreeWithBuddyDiskComponent)this.component).getBloomFilter().deactivate();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ((LSMBTreeWithBuddyDiskComponent)this.component).getBloomFilter().destroy();
            }
        }

        public void end() throws HyracksDataException, IndexException {
            if (!this.cleanedUpArtifacts) {
                if (!this.endedBloomFilterLoad) {
                    this.builder.end();
                    this.endedBloomFilterLoad = true;
                }
                this.btreeBulkLoader.end();
                this.buddyBtreeBulkLoader.end();
                if (this.isEmptyComponent) {
                    this.cleanupArtifacts();
                } else if (this.isTransaction) {
                    ExternalBTreeWithBuddy.this.markAsValid(this.component);
                    BTree btree = ((LSMBTreeWithBuddyDiskComponent)this.component).getBTree();
                    BTree buddyBtree = ((LSMBTreeWithBuddyDiskComponent)this.component).getBuddyBTree();
                    BloomFilter bloomFilter = ((LSMBTreeWithBuddyDiskComponent)this.component).getBloomFilter();
                    btree.deactivate();
                    buddyBtree.deactivate();
                    bloomFilter.deactivate();
                } else {
                    ExternalBTreeWithBuddy.this.lsmHarness.addBulkLoadedComponent(this.component);
                }
            }
        }

        public void delete(ITupleReference tuple) throws IndexException, HyracksDataException {
            try {
                this.buddyBtreeBulkLoader.add(tuple);
                this.builder.add(tuple);
            }
            catch (RuntimeException | HyracksDataException | IndexException e) {
                this.cleanupArtifacts();
                throw e;
            }
            if (this.isEmptyComponent) {
                this.isEmptyComponent = false;
            }
        }

        public void abort() {
            try {
                this.cleanupArtifacts();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private ILSMDiskComponent createTransactionTarget() throws HyracksDataException, IndexException {
            LSMComponentFileReferences componentFileRefs;
            try {
                componentFileRefs = ExternalBTreeWithBuddy.this.fileManager.getNewTransactionFileReference();
            }
            catch (IOException e) {
                throw new HyracksDataException("Failed to create transaction components", (Throwable)e);
            }
            return ExternalBTreeWithBuddy.this.createDiskComponent(ExternalBTreeWithBuddy.this.bulkComponentFactory, componentFileRefs.getInsertIndexFileReference(), componentFileRefs.getDeleteIndexFileReference(), componentFileRefs.getBloomFilterFileReference(), true);
        }
    }

    public class LSMBTreeWithBuddyAccessor
    extends LSMTreeIndexAccessor {
        public LSMBTreeWithBuddyAccessor(ILSMHarness lsmHarness, ILSMIndexOperationContext ctx) {
            super(lsmHarness, ctx);
        }

        public ITreeIndexCursor createSearchCursor(boolean exclusive) {
            return new LSMBTreeWithBuddySearchCursor(this.ctx, ExternalBTreeWithBuddy.this.buddyBTreeFields);
        }

        public MultiComparator getBTreeMultiComparator() {
            ExternalBTreeWithBuddyOpContext concreteCtx = (ExternalBTreeWithBuddyOpContext)this.ctx;
            return concreteCtx.getBTreeMultiComparator();
        }

        public MultiComparator getBodyBTreeMultiComparator() {
            ExternalBTreeWithBuddyOpContext concreteCtx = (ExternalBTreeWithBuddyOpContext)this.ctx;
            return concreteCtx.getBuddyBTreeMultiComparator();
        }
    }
}

