/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.btree.impls;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.api.io.IIOManager;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.bloomfilter.impls.BloomCalculations;
import org.apache.hyracks.storage.am.bloomfilter.impls.BloomFilter;
import org.apache.hyracks.storage.am.bloomfilter.impls.BloomFilterFactory;
import org.apache.hyracks.storage.am.bloomfilter.impls.BloomFilterSpecification;
import org.apache.hyracks.storage.am.btree.impls.BTree;
import org.apache.hyracks.storage.am.common.api.ICursorInitialState;
import org.apache.hyracks.storage.am.common.api.IIndexBulkLoader;
import org.apache.hyracks.storage.am.common.api.IIndexCursor;
import org.apache.hyracks.storage.am.common.api.IIndexOperationContext;
import org.apache.hyracks.storage.am.common.api.IMetadataPageManager;
import org.apache.hyracks.storage.am.common.api.IModificationOperationCallback;
import org.apache.hyracks.storage.am.common.api.ISearchOperationCallback;
import org.apache.hyracks.storage.am.common.api.ISearchPredicate;
import org.apache.hyracks.storage.am.common.api.ITreeIndexCursor;
import org.apache.hyracks.storage.am.common.api.ITreeIndexFrameFactory;
import org.apache.hyracks.storage.am.common.api.ITreeIndexTupleWriterFactory;
import org.apache.hyracks.storage.am.common.api.ITwoPCIndexBulkLoader;
import org.apache.hyracks.storage.am.common.api.IndexException;
import org.apache.hyracks.storage.am.common.api.TreeIndexException;
import org.apache.hyracks.storage.am.common.impls.NoOpOperationCallback;
import org.apache.hyracks.storage.am.common.ophelpers.IndexOperation;
import org.apache.hyracks.storage.am.lsm.btree.impls.ExternalBTreeOpContext;
import org.apache.hyracks.storage.am.lsm.btree.impls.LSMBTree;
import org.apache.hyracks.storage.am.lsm.btree.impls.LSMBTreeDiskComponent;
import org.apache.hyracks.storage.am.lsm.btree.impls.LSMBTreeDiskComponentFactory;
import org.apache.hyracks.storage.am.lsm.btree.impls.LSMBTreeMergeOperation;
import org.apache.hyracks.storage.am.lsm.btree.impls.LSMBTreeRangeSearchCursor;
import org.apache.hyracks.storage.am.lsm.btree.tuples.LSMBTreeRefrencingTupleWriterFactory;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMDiskComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperation;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationCallback;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationScheduler;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexAccessor;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexFileManager;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexOperationContext;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMMergePolicy;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMOperationTracker;
import org.apache.hyracks.storage.am.lsm.common.api.ITwoPCIndex;
import org.apache.hyracks.storage.am.lsm.common.api.LSMOperationType;
import org.apache.hyracks.storage.am.lsm.common.impls.BlockingIOOperationCallbackWrapper;
import org.apache.hyracks.storage.am.lsm.common.impls.ExternalIndexHarness;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMComponentFileReferences;
import org.apache.hyracks.storage.am.lsm.common.impls.TreeIndexFactory;
import org.apache.hyracks.storage.common.file.IFileMapProvider;

public class ExternalBTree
extends LSMBTree
implements ITwoPCIndex {
    private final LSMBTreeDiskComponentFactory transactionComponentFactory;
    private final List<ILSMDiskComponent> secondDiskComponents;
    private int version = -1;
    private final ITreeIndexFrameFactory interiorFrameFactory;

    public ExternalBTree(IIOManager ioManager, ITreeIndexFrameFactory interiorFrameFactory, ITreeIndexFrameFactory insertLeafFrameFactory, ITreeIndexFrameFactory deleteLeafFrameFactory, ILSMIndexFileManager fileManager, TreeIndexFactory<BTree> diskBTreeFactory, TreeIndexFactory<BTree> bulkLoadBTreeFactory, BloomFilterFactory bloomFilterFactory, double bloomFilterFalsePositiveRate, IFileMapProvider diskFileMapProvider, int fieldCount, IBinaryComparatorFactory[] cmpFactories, ILSMMergePolicy mergePolicy, ILSMOperationTracker opTracker, ILSMIOOperationScheduler ioScheduler, ILSMIOOperationCallback ioOpCallback, TreeIndexFactory<BTree> transactionBTreeFactory, int version, boolean durable) {
        super(ioManager, insertLeafFrameFactory, deleteLeafFrameFactory, fileManager, diskBTreeFactory, bulkLoadBTreeFactory, bloomFilterFactory, bloomFilterFalsePositiveRate, diskFileMapProvider, fieldCount, cmpFactories, mergePolicy, opTracker, ioScheduler, ioOpCallback, false, durable);
        this.transactionComponentFactory = new LSMBTreeDiskComponentFactory(transactionBTreeFactory, bloomFilterFactory, null);
        this.secondDiskComponents = new LinkedList<ILSMDiskComponent>();
        this.interiorFrameFactory = interiorFrameFactory;
        this.version = version;
    }

    public void subsumeMergedComponents(ILSMDiskComponent newComponent, List<ILSMComponent> mergedComponents) throws HyracksDataException {
        int swapIndex;
        List olderList;
        List<ILSMDiskComponent> newerList;
        if (this.version == 0) {
            newerList = this.diskComponents;
            olderList = this.secondDiskComponents;
        } else {
            newerList = this.secondDiskComponents;
            olderList = this.diskComponents;
        }
        if (olderList.containsAll(mergedComponents)) {
            swapIndex = olderList.indexOf(mergedComponents.get(0));
            olderList.removeAll(mergedComponents);
            olderList.add(swapIndex, newComponent);
        }
        swapIndex = newerList.indexOf(mergedComponents.get(0));
        newerList.removeAll(mergedComponents);
        newerList.add(swapIndex, newComponent);
    }

    public List<ILSMDiskComponent> getImmutableComponents() {
        if (this.version == 0) {
            return this.diskComponents;
        }
        return this.secondDiskComponents;
    }

    @Override
    public void search(ILSMIndexOperationContext ictx, IIndexCursor cursor, ISearchPredicate pred) throws HyracksDataException, IndexException {
        ExternalBTreeOpContext ctx = (ExternalBTreeOpContext)ictx;
        List<ILSMComponent> operationalComponents = ctx.getComponentHolder();
        ctx.searchInitialState.reset(pred, operationalComponents);
        cursor.open((ICursorInitialState)ctx.searchInitialState, pred);
    }

    public ExternalBTreeOpContext createOpContext(ISearchOperationCallback searchCallback, int targetVersion) {
        return new ExternalBTreeOpContext(this.insertLeafFrameFactory, this.deleteLeafFrameFactory, searchCallback, this.componentFactory.getBloomFilterKeyFields().length, this.cmpFactories, targetVersion, this.lsmHarness);
    }

    @Override
    public void scheduleMerge(ILSMIndexOperationContext ctx, ILSMIOOperationCallback callback) throws HyracksDataException, IndexException {
        ExternalBTreeOpContext opCtx = this.createOpContext((ISearchOperationCallback)NoOpOperationCallback.INSTANCE, -1);
        opCtx.setOperation(IndexOperation.MERGE);
        List mergingComponents = ctx.getComponentHolder();
        boolean returnDeletedTuples = false;
        if (this.version == 0) {
            if (ctx.getComponentHolder().get(ctx.getComponentHolder().size() - 1) != this.diskComponents.get(this.diskComponents.size() - 1)) {
                returnDeletedTuples = true;
            }
        } else if (ctx.getComponentHolder().get(ctx.getComponentHolder().size() - 1) != this.secondDiskComponents.get(this.secondDiskComponents.size() - 1)) {
            returnDeletedTuples = true;
        }
        LSMBTreeRangeSearchCursor cursor = new LSMBTreeRangeSearchCursor((ILSMIndexOperationContext)opCtx, returnDeletedTuples);
        BTree firstBTree = ((LSMBTreeDiskComponent)((Object)mergingComponents.get(0))).getBTree();
        BTree lastBTree = ((LSMBTreeDiskComponent)((Object)mergingComponents.get(mergingComponents.size() - 1))).getBTree();
        FileReference firstFile = firstBTree.getFileReference();
        FileReference lastFile = lastBTree.getFileReference();
        LSMComponentFileReferences relMergeFileRefs = this.fileManager.getRelMergeFileReference(firstFile.getFile().getName(), lastFile.getFile().getName());
        LSMBTree.LSMBTreeAccessor accessor = new LSMBTree.LSMBTreeAccessor(this, this.lsmHarness, (ILSMIndexOperationContext)opCtx);
        this.ioScheduler.scheduleOperation((ILSMIOOperation)new LSMBTreeMergeOperation((ILSMIndexAccessor)accessor, mergingComponents, (ITreeIndexCursor)cursor, relMergeFileRefs.getInsertIndexFileReference(), relMergeFileRefs.getBloomFilterFileReference(), callback, this.fileManager.getBaseDir()));
    }

    public void deleteTransactionComponent() throws HyracksDataException {
        this.fileManager.deleteTransactionFiles();
    }

    public void addDiskComponent(ILSMDiskComponent c) throws HyracksDataException {
        if (this.version == 0) {
            this.diskComponents.add(0, c);
        } else if (this.version == 1) {
            this.secondDiskComponents.add(0, c);
        }
    }

    public void commitTransactionDiskComponent(ILSMDiskComponent newComponent) throws HyracksDataException {
        List olderList;
        List<ILSMDiskComponent> newerList;
        if (this.version == 0) {
            newerList = this.diskComponents;
            olderList = this.secondDiskComponents;
            this.version = 1;
        } else {
            newerList = this.secondDiskComponents;
            olderList = this.diskComponents;
            this.version = 0;
        }
        olderList.clear();
        olderList.addAll(newerList);
        if (newComponent != null) {
            olderList.add(0, newComponent);
        }
    }

    @Override
    public synchronized void activate() throws HyracksDataException {
        if (this.isActivated) {
            throw new HyracksDataException("Failed to activate the index since it is already activated.");
        }
        if (this.diskComponents.size() == 0 && this.secondDiskComponents.size() == 0) {
            List validFileReferences;
            try {
                validFileReferences = this.fileManager.cleanupAndGetValidFiles();
            }
            catch (IndexException indexException) {
                throw new HyracksDataException((Throwable)indexException);
            }
            for (LSMComponentFileReferences lsmComonentFileReference : validFileReferences) {
                LSMBTreeDiskComponent component;
                try {
                    component = this.createDiskComponent(this.componentFactory, lsmComonentFileReference.getInsertIndexFileReference(), lsmComonentFileReference.getBloomFilterFileReference(), false);
                }
                catch (IndexException e) {
                    throw new HyracksDataException((Throwable)e);
                }
                this.diskComponents.add(component);
                this.secondDiskComponents.add((ILSMDiskComponent)component);
            }
            ((ExternalIndexHarness)this.lsmHarness).indexFirstTimeActivated();
        } else {
            BloomFilter bloomFilter;
            BTree btree;
            LSMBTreeDiskComponent component;
            for (ILSMComponent iLSMComponent : this.diskComponents) {
                component = (LSMBTreeDiskComponent)iLSMComponent;
                btree = component.getBTree();
                bloomFilter = component.getBloomFilter();
                btree.activate();
                bloomFilter.activate();
            }
            for (ILSMComponent iLSMComponent : this.secondDiskComponents) {
                if (this.diskComponents.contains(iLSMComponent)) continue;
                component = (LSMBTreeDiskComponent)iLSMComponent;
                btree = component.getBTree();
                bloomFilter = component.getBloomFilter();
                btree.activate();
                bloomFilter.activate();
            }
        }
        this.isActivated = true;
    }

    @Override
    public synchronized void create() throws HyracksDataException {
        super.create();
        this.secondDiskComponents.clear();
    }

    @Override
    public void deactivate(boolean flushOnExit) throws HyracksDataException {
        BloomFilter bloomFilter;
        BTree btree;
        LSMBTreeDiskComponent component;
        if (!this.isActivated) {
            throw new HyracksDataException("Failed to deactivate the index since it is already deactivated.");
        }
        if (flushOnExit) {
            BlockingIOOperationCallbackWrapper cb = new BlockingIOOperationCallbackWrapper(this.ioOpCallback);
            cb.afterFinalize(LSMOperationType.FLUSH, null);
        }
        for (ILSMComponent iLSMComponent : this.diskComponents) {
            component = (LSMBTreeDiskComponent)iLSMComponent;
            btree = component.getBTree();
            bloomFilter = component.getBloomFilter();
            btree.deactivateCloseHandle();
            bloomFilter.deactivate();
        }
        for (ILSMComponent iLSMComponent : this.secondDiskComponents) {
            if (this.diskComponents.contains(iLSMComponent)) continue;
            component = (LSMBTreeDiskComponent)iLSMComponent;
            btree = component.getBTree();
            bloomFilter = component.getBloomFilter();
            btree.deactivateCloseHandle();
            bloomFilter.deactivate();
        }
        this.isActivated = false;
    }

    @Override
    public void clear() throws HyracksDataException {
        LSMBTreeDiskComponent component;
        if (!this.isActivated) {
            throw new HyracksDataException("Failed to clear the index since it is not activated.");
        }
        ((ExternalIndexHarness)this.lsmHarness).indexClear();
        for (ILSMComponent iLSMComponent : this.diskComponents) {
            component = (LSMBTreeDiskComponent)iLSMComponent;
            component.getBloomFilter().deactivate();
            component.getBTree().deactivate();
            component.getBloomFilter().destroy();
            component.getBTree().destroy();
            this.secondDiskComponents.remove(iLSMComponent);
        }
        for (ILSMComponent iLSMComponent : this.secondDiskComponents) {
            component = (LSMBTreeDiskComponent)iLSMComponent;
            component.getBloomFilter().deactivate();
            component.getBTree().deactivate();
            component.getBloomFilter().destroy();
            component.getBTree().destroy();
        }
        this.diskComponents.clear();
        this.secondDiskComponents.clear();
        this.version = -1;
    }

    @Override
    public void destroy() throws HyracksDataException {
        LSMBTreeDiskComponent component;
        if (this.isActivated) {
            throw new HyracksDataException("Failed to destroy the index since it is activated.");
        }
        for (ILSMComponent iLSMComponent : this.diskComponents) {
            component = (LSMBTreeDiskComponent)iLSMComponent;
            component.getBTree().destroy();
            component.getBloomFilter().destroy();
            this.secondDiskComponents.remove(iLSMComponent);
        }
        for (ILSMComponent iLSMComponent : this.secondDiskComponents) {
            component = (LSMBTreeDiskComponent)iLSMComponent;
            component.getBTree().destroy();
            component.getBloomFilter().destroy();
        }
        this.diskComponents.clear();
        this.secondDiskComponents.clear();
        this.fileManager.deleteDirs();
        this.version = -1;
    }

    @Override
    public void validate() throws HyracksDataException {
        BTree btree;
        for (ILSMComponent iLSMComponent : this.diskComponents) {
            btree = ((LSMBTreeDiskComponent)iLSMComponent).getBTree();
            btree.validate();
        }
        for (ILSMComponent iLSMComponent : this.secondDiskComponents) {
            if (this.diskComponents.contains(iLSMComponent)) continue;
            btree = ((LSMBTreeDiskComponent)iLSMComponent).getBTree();
            btree.validate();
        }
    }

    @Override
    public void modify(IIndexOperationContext ictx, ITupleReference tuple) throws HyracksDataException, IndexException {
        throw new UnsupportedOperationException("tuple modify not supported in LSM-Disk-Only-BTree");
    }

    @Override
    public void scheduleFlush(ILSMIndexOperationContext ctx, ILSMIOOperationCallback callback) throws HyracksDataException {
        throw new UnsupportedOperationException("flush not supported in LSM-Disk-Only-BTree");
    }

    @Override
    public ILSMDiskComponent flush(ILSMIOOperation operation) throws HyracksDataException, IndexException {
        throw new UnsupportedOperationException("flush not supported in LSM-Disk-Only-BTree");
    }

    @Override
    public void getOperationalComponents(ILSMIndexOperationContext ctx) {
        List operationalComponents = ctx.getComponentHolder();
        List<ILSMDiskComponent> immutableComponents = this.version == 0 ? this.diskComponents : this.secondDiskComponents;
        ExternalBTreeOpContext opCtx = (ExternalBTreeOpContext)ctx;
        operationalComponents.clear();
        switch (ctx.getOperation()) {
            case SEARCH: {
                if (opCtx.getTargetIndexVersion() == 0) {
                    operationalComponents.addAll(this.diskComponents);
                    break;
                }
                operationalComponents.addAll(this.secondDiskComponents);
                break;
            }
            case MERGE: {
                operationalComponents.addAll(ctx.getComponentsToBeMerged());
                break;
            }
            case FULL_MERGE: {
                operationalComponents.addAll(immutableComponents);
                break;
            }
            case REPLICATE: {
                operationalComponents.addAll(ctx.getComponentsToBeReplicated());
                break;
            }
            default: {
                throw new UnsupportedOperationException("Operation " + ctx.getOperation() + " not supported.");
            }
        }
    }

    @Override
    public IIndexBulkLoader createBulkLoader(float fillLevel, boolean verifyInput, long numElementsHint, boolean checkIfEmptyIndex) throws TreeIndexException {
        try {
            return new LSMTwoPCBTreeBulkLoader(fillLevel, verifyInput, numElementsHint, checkIfEmptyIndex, false);
        }
        catch (HyracksDataException e) {
            throw new TreeIndexException((Exception)((Object)e));
        }
    }

    public IIndexBulkLoader createTransactionBulkLoader(float fillLevel, boolean verifyInput, long numElementsHint, boolean checkIfEmptyIndex) throws TreeIndexException {
        try {
            return new LSMTwoPCBTreeBulkLoader(fillLevel, verifyInput, numElementsHint, checkIfEmptyIndex, true);
        }
        catch (HyracksDataException e) {
            throw new TreeIndexException((Exception)((Object)e));
        }
    }

    @Override
    public String toString() {
        return "LSMTwoPCBTree [" + this.fileManager.getBaseDir() + "]";
    }

    @Override
    public ILSMIndexAccessor createAccessor(IModificationOperationCallback modificationCallback, ISearchOperationCallback searchCallback) {
        return new LSMBTree.LSMBTreeAccessor(this, this.lsmHarness, (ILSMIndexOperationContext)this.createOpContext(searchCallback, this.version));
    }

    public ILSMIndexAccessor createAccessor(ISearchOperationCallback searchCallback, int targetIndexVersion) throws HyracksDataException {
        return new LSMBTree.LSMBTreeAccessor(this, this.lsmHarness, (ILSMIndexOperationContext)this.createOpContext(searchCallback, targetIndexVersion));
    }

    @Override
    public ITreeIndexFrameFactory getInteriorFrameFactory() {
        return this.interiorFrameFactory;
    }

    @Override
    public int getFieldCount() {
        return this.cmpFactories.length;
    }

    @Override
    public int getFileId() {
        return -1;
    }

    public IMetadataPageManager getPageManager() {
        return null;
    }

    @Override
    public ITreeIndexFrameFactory getLeafFrameFactory() {
        return this.insertLeafFrameFactory;
    }

    public int getCurrentVersion() {
        return this.version;
    }

    public List<ILSMDiskComponent> getFirstComponentList() {
        return this.diskComponents;
    }

    public List<ILSMDiskComponent> getSecondComponentList() {
        return this.secondDiskComponents;
    }

    public void commitTransaction() throws TreeIndexException, HyracksDataException, IndexException {
        LSMComponentFileReferences componentFileRefrences = this.fileManager.getTransactionFileReferenceForCommit();
        LSMBTreeDiskComponent component = null;
        if (componentFileRefrences != null) {
            component = this.createDiskComponent(this.componentFactory, componentFileRefrences.getInsertIndexFileReference(), componentFileRefrences.getBloomFilterFileReference(), false);
        }
        ((ExternalIndexHarness)this.lsmHarness).addTransactionComponents(component);
    }

    public void abortTransaction() throws TreeIndexException {
        try {
            this.fileManager.deleteTransactionFiles();
        }
        catch (HyracksDataException e) {
            throw new TreeIndexException((Exception)((Object)e));
        }
    }

    public void recoverTransaction() throws TreeIndexException {
        try {
            this.fileManager.recoverTransaction();
        }
        catch (HyracksDataException e) {
            throw new TreeIndexException((Exception)((Object)e));
        }
    }

    public boolean hasMemoryComponents() {
        return false;
    }

    public class LSMTwoPCBTreeBulkLoader
    implements IIndexBulkLoader,
    ITwoPCIndexBulkLoader {
        private final ILSMDiskComponent component;
        private final BTree.BTreeBulkLoader bulkLoader;
        private final IIndexBulkLoader builder;
        private boolean cleanedUpArtifacts = false;
        private boolean isEmptyComponent = true;
        private boolean endedBloomFilterLoad = false;
        private final boolean isTransaction;
        private final ITreeIndexTupleWriterFactory frameTupleWriterFactory;

        public LSMTwoPCBTreeBulkLoader(float fillFactor, boolean verifyInput, long numElementsHint, boolean checkIfEmptyIndex, boolean isTransaction) throws TreeIndexException, HyracksDataException {
            this.isTransaction = isTransaction;
            if (isTransaction) {
                try {
                    this.component = this.createTransactionTarget();
                }
                catch (HyracksDataException | IndexException e) {
                    throw new TreeIndexException((Exception)e);
                }
            }
            if (checkIfEmptyIndex && !ExternalBTree.this.isEmptyIndex()) {
                throw new TreeIndexException("Cannot load an index that is not empty");
            }
            try {
                this.component = ExternalBTree.this.createBulkLoadTarget();
            }
            catch (HyracksDataException | IndexException e) {
                throw new TreeIndexException((Exception)e);
            }
            this.frameTupleWriterFactory = ((LSMBTreeDiskComponent)this.component).getBTree().getLeafFrameFactory().getTupleWriterFactory();
            this.bulkLoader = (BTree.BTreeBulkLoader)((LSMBTreeDiskComponent)this.component).getBTree().createBulkLoader(fillFactor, verifyInput, numElementsHint, false);
            int maxBucketsPerElement = BloomCalculations.maxBucketsPerElement((long)numElementsHint);
            BloomFilterSpecification bloomFilterSpec = BloomCalculations.computeBloomSpec((int)maxBucketsPerElement, (double)ExternalBTree.this.bloomFilterFalsePositiveRate);
            this.builder = ((LSMBTreeDiskComponent)this.component).getBloomFilter().createBuilder(numElementsHint, bloomFilterSpec.getNumHashes(), bloomFilterSpec.getNumBucketsPerElements());
        }

        public void add(ITupleReference tuple) throws IndexException, HyracksDataException {
            try {
                this.bulkLoader.add(tuple);
                this.builder.add(tuple);
            }
            catch (RuntimeException | HyracksDataException | IndexException e) {
                this.cleanupArtifacts();
                throw e;
            }
            if (this.isEmptyComponent) {
                this.isEmptyComponent = false;
            }
        }

        public void cleanupArtifacts() throws HyracksDataException, IndexException {
            if (!this.cleanedUpArtifacts) {
                this.cleanedUpArtifacts = true;
                if (!this.endedBloomFilterLoad) {
                    this.builder.end();
                    this.endedBloomFilterLoad = true;
                }
                try {
                    ((LSMBTreeDiskComponent)this.component).getBTree().deactivate();
                }
                catch (HyracksDataException hyracksDataException) {
                    // empty catch block
                }
                ((LSMBTreeDiskComponent)this.component).getBTree().destroy();
                try {
                    ((LSMBTreeDiskComponent)this.component).getBloomFilter().deactivate();
                }
                catch (HyracksDataException hyracksDataException) {
                    // empty catch block
                }
                ((LSMBTreeDiskComponent)this.component).getBloomFilter().destroy();
            }
        }

        public void end() throws HyracksDataException, IndexException {
            if (!this.cleanedUpArtifacts) {
                if (!this.endedBloomFilterLoad) {
                    this.builder.end();
                    this.endedBloomFilterLoad = true;
                }
                this.bulkLoader.end();
                if (this.isEmptyComponent) {
                    this.cleanupArtifacts();
                } else if (this.isTransaction) {
                    ExternalBTree.this.markAsValid(this.component);
                    BTree btree = ((LSMBTreeDiskComponent)this.component).getBTree();
                    BloomFilter bloomFilter = ((LSMBTreeDiskComponent)this.component).getBloomFilter();
                    btree.deactivate();
                    bloomFilter.deactivate();
                } else {
                    ExternalBTree.this.lsmHarness.addBulkLoadedComponent(this.component);
                }
            }
        }

        public void delete(ITupleReference tuple) throws IndexException, HyracksDataException {
            ((LSMBTreeRefrencingTupleWriterFactory)this.frameTupleWriterFactory).setMode(IndexOperation.DELETE);
            try {
                this.bulkLoader.add(tuple);
                this.builder.add(tuple);
            }
            catch (RuntimeException | HyracksDataException | IndexException e) {
                this.cleanupArtifacts();
                throw e;
            }
            if (this.isEmptyComponent) {
                this.isEmptyComponent = false;
            }
            ((LSMBTreeRefrencingTupleWriterFactory)this.frameTupleWriterFactory).setMode(IndexOperation.INSERT);
        }

        public void abort() {
            try {
                this.cleanupArtifacts();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private ILSMDiskComponent createTransactionTarget() throws HyracksDataException, IndexException {
            LSMComponentFileReferences componentFileRefs;
            try {
                componentFileRefs = ExternalBTree.this.fileManager.getNewTransactionFileReference();
            }
            catch (IOException e) {
                throw new HyracksDataException("Failed to create transaction components", (Throwable)e);
            }
            return ExternalBTree.this.createDiskComponent(ExternalBTree.this.transactionComponentFactory, componentFileRefs.getInsertIndexFileReference(), componentFileRefs.getBloomFilterFileReference(), true);
        }
    }
}

