/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.std.structures;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hyracks.api.context.IHyracksFrameMgrContext;
import org.apache.hyracks.api.dataflow.value.ITuplePartitionComputer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.std.buffermanager.ITuplePointerAccessor;
import org.apache.hyracks.dataflow.std.structures.ISerializableTable;
import org.apache.hyracks.dataflow.std.structures.TuplePointer;

public class SimpleSerializableHashTable
implements ISerializableTable {
    protected static final int INT_SIZE = 4;
    protected static final int INIT_ENTRY_SIZE = 4;
    protected static final int INVALID_VALUE = -1;
    protected static final byte INVALID_BYTE_VALUE = -1;
    protected IntSerDeBuffer[] headers;
    protected List<IntSerDeBuffer> contents = new ArrayList<IntSerDeBuffer>();
    protected List<Integer> currentOffsetInEachFrameList = new ArrayList<Integer>();
    protected int frameCapacity;
    protected int currentLargestFrameNumber = 0;
    protected int currentByteSize = 0;
    protected int tupleCount = 0;
    protected TuplePointer tempTuplePointer = new TuplePointer();
    protected int tableSize;
    protected int frameSize;
    protected IHyracksFrameMgrContext ctx;

    public SimpleSerializableHashTable(int tableSize, IHyracksFrameMgrContext ctx) throws HyracksDataException {
        this(tableSize, ctx, true);
    }

    public SimpleSerializableHashTable(int tableSize, IHyracksFrameMgrContext ctx, boolean frameInitRequired) throws HyracksDataException {
        this.ctx = ctx;
        this.frameSize = ctx.getInitialFrameSize();
        int residual = tableSize * 4 * 2 % this.frameSize == 0 ? 0 : 1;
        int headerSize = tableSize * 4 * 2 / this.frameSize + residual;
        this.headers = new IntSerDeBuffer[headerSize];
        this.tableSize = tableSize;
        if (frameInitRequired) {
            ByteBuffer newFrame = this.getFrame(this.frameSize);
            if (newFrame == null) {
                throw new HyracksDataException("Can't initialize the Hash Table. Please assign more memory.");
            }
            IntSerDeBuffer frame = new IntSerDeBuffer(newFrame);
            this.frameCapacity = frame.capacity();
            this.contents.add(frame);
            this.currentOffsetInEachFrameList.add(0);
        }
    }

    ByteBuffer getFrame(int size) throws HyracksDataException {
        this.currentByteSize += size;
        return this.ctx.allocateFrame(size);
    }

    void increaseWastedSpaceCount(int size) {
    }

    @Override
    public boolean insert(int entry, TuplePointer pointer) throws HyracksDataException {
        boolean result;
        int contentFrameIndex;
        int headerFrameIndex = this.getHeaderFrameIndex(entry);
        int offsetInHeaderFrame = this.getHeaderFrameOffset(entry);
        IntSerDeBuffer headerFrame = this.headers[headerFrameIndex];
        if (headerFrame == null) {
            ByteBuffer newFrame = this.getFrame(this.frameSize);
            if (newFrame == null) {
                return false;
            }
            this.headers[headerFrameIndex] = headerFrame = new IntSerDeBuffer(newFrame);
        }
        if ((contentFrameIndex = headerFrame.getInt(offsetInHeaderFrame)) < 0) {
            result = this.insertNewEntry(headerFrame, offsetInHeaderFrame, 4, pointer);
        } else {
            int offsetInContentFrame = headerFrame.getInt(offsetInHeaderFrame + 1);
            result = this.insertNonFirstTuple(headerFrame, offsetInHeaderFrame, contentFrameIndex, offsetInContentFrame, pointer);
        }
        if (result) {
            ++this.tupleCount;
        }
        return result;
    }

    @Override
    public void delete(int entry) {
        int headerFrameIndex = this.getHeaderFrameIndex(entry);
        int offsetInHeaderFrame = this.getHeaderFrameOffset(entry);
        IntSerDeBuffer header = this.headers[headerFrameIndex];
        if (header != null) {
            int contentFrameIndex = header.getInt(offsetInHeaderFrame);
            int offsetInContentFrame = header.getInt(offsetInHeaderFrame + 1);
            if (contentFrameIndex >= 0) {
                IntSerDeBuffer frame = this.contents.get(contentFrameIndex);
                int entrySlotCapacity = frame.getInt(offsetInContentFrame);
                int entryUsedItems = frame.getInt(offsetInContentFrame + 1);
                frame.writeInvalidVal(offsetInContentFrame + 1, 1);
                header.writeInvalidVal(offsetInHeaderFrame, 2);
                this.tupleCount -= entryUsedItems;
                this.increaseWastedSpaceCount((entrySlotCapacity + 1) * 2);
            }
        }
    }

    @Override
    public boolean getTuplePointer(int entry, int offsetInSlot, TuplePointer dataPointer) {
        int startOffsetInContentFrame;
        int headerFrameIndex = this.getHeaderFrameIndex(entry);
        int offsetInHeaderFrame = this.getHeaderFrameOffset(entry);
        IntSerDeBuffer header = this.headers[headerFrameIndex];
        if (header == null) {
            dataPointer.reset(-1, -1);
            return false;
        }
        int contentFrameIndex = header.getInt(offsetInHeaderFrame);
        int offsetInContentFrame = header.getInt(offsetInHeaderFrame + 1);
        if (contentFrameIndex < 0) {
            dataPointer.reset(-1, -1);
            return false;
        }
        IntSerDeBuffer frame = this.contents.get(contentFrameIndex);
        int entryUsedCountInSlot = frame.getInt(offsetInContentFrame + 1);
        if (offsetInSlot > entryUsedCountInSlot - 1) {
            dataPointer.reset(-1, -1);
            return false;
        }
        for (startOffsetInContentFrame = offsetInContentFrame + 2 + offsetInSlot * 2; startOffsetInContentFrame >= this.frameCapacity; startOffsetInContentFrame -= this.frameCapacity) {
            ++contentFrameIndex;
        }
        frame = this.contents.get(contentFrameIndex);
        dataPointer.reset(frame.getInt(startOffsetInContentFrame), frame.getInt(startOffsetInContentFrame + 1));
        return true;
    }

    @Override
    public void reset() {
        for (IntSerDeBuffer frame : this.headers) {
            if (frame == null) continue;
            frame.resetFrame();
        }
        this.currentOffsetInEachFrameList.clear();
        for (int i = 0; i < this.contents.size(); ++i) {
            this.currentOffsetInEachFrameList.add(0);
        }
        this.currentLargestFrameNumber = 0;
        this.tupleCount = 0;
        this.currentByteSize = 0;
    }

    @Override
    public int getCurrentByteSize() {
        return this.currentByteSize;
    }

    @Override
    public int getTupleCount() {
        return this.tupleCount;
    }

    @Override
    public int getTupleCount(int entry) {
        int headerFrameIndex = this.getHeaderFrameIndex(entry);
        int offsetInHeaderFrame = this.getHeaderFrameOffset(entry);
        IntSerDeBuffer headerFrame = this.headers[headerFrameIndex];
        if (headerFrame != null) {
            int contentFrameIndex = headerFrame.getInt(offsetInHeaderFrame);
            int offsetInContentFrame = headerFrame.getInt(offsetInHeaderFrame + 1);
            if (contentFrameIndex >= 0) {
                IntSerDeBuffer frame = this.contents.get(contentFrameIndex);
                int entryUsedCountInSlot = frame.getInt(offsetInContentFrame + 1);
                return entryUsedCountInSlot;
            }
        }
        return 0;
    }

    @Override
    public void close() {
        int nFrames = this.contents.size();
        for (int i = 0; i < this.headers.length; ++i) {
            this.headers[i] = null;
        }
        this.contents.clear();
        this.currentOffsetInEachFrameList.clear();
        this.tupleCount = 0;
        this.currentByteSize = 0;
        this.currentLargestFrameNumber = 0;
        this.ctx.deallocateFrames(nFrames);
    }

    protected boolean insertNewEntry(IntSerDeBuffer header, int offsetInHeaderFrame, int entryCapacity, TuplePointer pointer) throws HyracksDataException {
        IntSerDeBuffer lastContentFrame = this.contents.get(this.currentLargestFrameNumber);
        int lastOffsetInCurrentFrame = this.currentOffsetInEachFrameList.get(this.currentLargestFrameNumber);
        int requiredIntCapacity = entryCapacity * 2;
        int currentFrameNumber = this.currentLargestFrameNumber;
        boolean currentFrameNumberChanged = false;
        if (lastOffsetInCurrentFrame + requiredIntCapacity >= this.frameCapacity) {
            if (lastOffsetInCurrentFrame + 4 > this.frameCapacity) {
                lastContentFrame.writeInvalidVal(lastOffsetInCurrentFrame, this.frameCapacity - lastOffsetInCurrentFrame);
                ++currentFrameNumber;
                lastOffsetInCurrentFrame = 0;
                currentFrameNumberChanged = true;
            }
            do {
                if (this.currentLargestFrameNumber >= this.contents.size() - 1) {
                    ByteBuffer newFrame = this.getFrame(this.frameSize);
                    if (newFrame == null) {
                        return false;
                    }
                    IntSerDeBuffer newContentFrame = new IntSerDeBuffer(newFrame);
                    ++this.currentLargestFrameNumber;
                    this.contents.add(newContentFrame);
                    this.currentOffsetInEachFrameList.add(0);
                    continue;
                }
                ++this.currentLargestFrameNumber;
                this.currentOffsetInEachFrameList.set(this.currentLargestFrameNumber, 0);
            } while ((requiredIntCapacity -= this.frameCapacity) > 0);
        }
        if (currentFrameNumberChanged) {
            lastContentFrame = this.contents.get(currentFrameNumber);
        }
        header.writeInt(offsetInHeaderFrame, currentFrameNumber);
        header.writeInt(offsetInHeaderFrame + 1, lastOffsetInCurrentFrame);
        lastContentFrame.writeInt(lastOffsetInCurrentFrame, entryCapacity - 1);
        lastContentFrame.writeInt(lastOffsetInCurrentFrame + 1, 1);
        lastContentFrame.writeInt(lastOffsetInCurrentFrame + 2, pointer.getFrameIndex());
        lastContentFrame.writeInt(lastOffsetInCurrentFrame + 3, pointer.getTupleIndex());
        int newLastOffsetInContentFrame = lastOffsetInCurrentFrame + entryCapacity * 2;
        newLastOffsetInContentFrame = newLastOffsetInContentFrame < this.frameCapacity ? newLastOffsetInContentFrame : this.frameCapacity - 1;
        this.currentOffsetInEachFrameList.set(currentFrameNumber, newLastOffsetInContentFrame);
        requiredIntCapacity = entryCapacity * 2 - (this.frameCapacity - lastOffsetInCurrentFrame);
        while (requiredIntCapacity > 0) {
            newLastOffsetInContentFrame = (requiredIntCapacity -= this.frameCapacity) < 0 ? requiredIntCapacity + this.frameCapacity : this.frameCapacity - 1;
            this.currentOffsetInEachFrameList.set(++currentFrameNumber, newLastOffsetInContentFrame);
        }
        return true;
    }

    protected boolean insertNonFirstTuple(IntSerDeBuffer header, int offsetInHeaderFrame, int contentFrameIndex, int offsetInContentFrame, TuplePointer pointer) throws HyracksDataException {
        int frameIndex = contentFrameIndex;
        IntSerDeBuffer contentFrame = this.contents.get(frameIndex);
        int entrySlotCapacity = contentFrame.getInt(offsetInContentFrame);
        int entryUsedCountInSlot = contentFrame.getInt(offsetInContentFrame + 1);
        boolean frameIndexChanged = false;
        if (entryUsedCountInSlot < entrySlotCapacity) {
            int startOffsetInContentFrame;
            contentFrame.writeInt(offsetInContentFrame + 1, entryUsedCountInSlot + 1);
            for (startOffsetInContentFrame = offsetInContentFrame + 2 + entryUsedCountInSlot * 2; startOffsetInContentFrame >= this.frameCapacity; startOffsetInContentFrame -= this.frameCapacity) {
                ++frameIndex;
                frameIndexChanged = true;
            }
            if (frameIndexChanged) {
                contentFrame = this.contents.get(frameIndex);
            }
            contentFrame.writeInt(startOffsetInContentFrame, pointer.getFrameIndex());
            contentFrame.writeInt(startOffsetInContentFrame + 1, pointer.getTupleIndex());
        } else {
            int capacity = (entrySlotCapacity + 1) * 2;
            header.writeInvalidVal(offsetInHeaderFrame, 2);
            contentFrame.writeInvalidVal(offsetInContentFrame + 1, 1);
            int fIndex = contentFrame.getInt(offsetInContentFrame + 2);
            int tIndex = contentFrame.getInt(offsetInContentFrame + 3);
            this.tempTuplePointer.reset(fIndex, tIndex);
            if (!this.insertNewEntry(header, offsetInHeaderFrame, capacity, this.tempTuplePointer)) {
                header.writeInt(offsetInHeaderFrame, contentFrameIndex);
                header.writeInt(offsetInHeaderFrame + 1, offsetInContentFrame);
                contentFrame.writeInt(offsetInContentFrame + 1, entryUsedCountInSlot);
                return false;
            }
            int newFrameIndex = header.getInt(offsetInHeaderFrame);
            int newTupleIndex = header.getInt(offsetInHeaderFrame + 1);
            for (int i = 1; i < entryUsedCountInSlot; ++i) {
                int startOffsetInContentFrame;
                int startFrameIndex = frameIndex;
                for (startOffsetInContentFrame = offsetInContentFrame + 2 + i * 2; startOffsetInContentFrame >= this.frameCapacity; startOffsetInContentFrame -= this.frameCapacity) {
                    ++startFrameIndex;
                }
                contentFrame = this.contents.get(startFrameIndex);
                fIndex = contentFrame.getInt(startOffsetInContentFrame);
                tIndex = contentFrame.getInt(startOffsetInContentFrame + 1);
                this.tempTuplePointer.reset(fIndex, tIndex);
                if (this.insertNonFirstTuple(header, offsetInHeaderFrame, newFrameIndex, newTupleIndex, this.tempTuplePointer)) continue;
                return false;
            }
            if (!this.insertNonFirstTuple(header, offsetInHeaderFrame, newFrameIndex, newTupleIndex, pointer)) {
                return false;
            }
            this.increaseWastedSpaceCount(capacity);
        }
        return true;
    }

    protected int getHeaderFrameIndex(int entry) {
        int frameIndex = entry * 2 / this.frameCapacity;
        return frameIndex;
    }

    protected int getHeaderFrameOffset(int entry) {
        int offset = entry * 2 % this.frameCapacity;
        return offset;
    }

    public static int getUnitSize() {
        return 4;
    }

    public static int getNumberOfEntryInSlot() {
        return 4;
    }

    public static int getExpectedByteSizePerHashValue() {
        return SimpleSerializableHashTable.getUnitSize() * (2 + SimpleSerializableHashTable.getNumberOfEntryInSlot() * 2);
    }

    public static long getExpectedTableFrameCount(long tableSize, int frameSize) {
        long numberOfHeaderFrame = (long)Math.ceil((double)tableSize * 2.0 / (double)frameSize);
        long numberOfContentFrame = (long)Math.ceil((double)SimpleSerializableHashTable.getNumberOfEntryInSlot() * 2.0 * (double)SimpleSerializableHashTable.getUnitSize() * (double)tableSize / (double)frameSize);
        return numberOfHeaderFrame + numberOfContentFrame;
    }

    public static long getExpectedTableByteSize(long tableSize, int frameSize) {
        return SimpleSerializableHashTable.getExpectedTableFrameCount(tableSize, frameSize) * (long)frameSize;
    }

    public static long calculateFrameCountDeltaForTableSizeChange(long origTableSize, long delta, int frameSize) {
        long originalFrameCount = SimpleSerializableHashTable.getExpectedTableFrameCount(origTableSize, frameSize);
        long newFrameCount = SimpleSerializableHashTable.getExpectedTableFrameCount(origTableSize + delta, frameSize);
        return newFrameCount - originalFrameCount;
    }

    public static long calculateByteSizeDeltaForTableSizeChange(long origTableSize, long delta, int frameSize) {
        return SimpleSerializableHashTable.calculateFrameCountDeltaForTableSizeChange(origTableSize, delta, frameSize) * (long)frameSize;
    }

    @Override
    public boolean isGarbageCollectionNeeded() {
        return false;
    }

    @Override
    public int collectGarbage(ITuplePointerAccessor bufferAccessor, ITuplePartitionComputer tpc) throws HyracksDataException {
        return -1;
    }

    @Override
    public String printInfo() {
        return null;
    }

    static class IntSerDeBuffer {
        ByteBuffer byteBuffer;
        byte[] bytes;

        public IntSerDeBuffer(ByteBuffer byteBuffer) {
            this.byteBuffer = byteBuffer;
            this.bytes = byteBuffer.array();
            this.resetFrame();
        }

        public int getInt(int pos) {
            int offset = pos * 4;
            return ((this.bytes[offset] & 0xFF) << 24) + ((this.bytes[offset + 1] & 0xFF) << 16) + ((this.bytes[offset + 2] & 0xFF) << 8) + (this.bytes[offset + 3] & 0xFF);
        }

        public void writeInt(int pos, int value) {
            int offset = pos * 4;
            this.bytes[offset++] = (byte)(value >> 24);
            this.bytes[offset++] = (byte)(value >> 16);
            this.bytes[offset++] = (byte)(value >> 8);
            this.bytes[offset] = (byte)value;
        }

        public void writeInvalidVal(int intPos, int intRange) {
            int offset = intPos * 4;
            Arrays.fill(this.bytes, offset, offset + 4 * intRange, (byte)-1);
        }

        public int capacity() {
            return this.bytes.length / 4;
        }

        public int getByteCapacity() {
            return this.bytes.length;
        }

        public ByteBuffer getByteBuffer() {
            return this.byteBuffer;
        }

        public void resetFrame() {
            Arrays.fill(this.bytes, (byte)-1);
        }
    }
}

