/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.std.sort;

import java.util.Arrays;
import java.util.Comparator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.hyracks.api.comm.IFrame;
import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.comm.IFrameTupleAppender;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.comm.VSizeFrame;
import org.apache.hyracks.api.context.IHyracksFrameMgrContext;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.IBinaryComparator;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.dataflow.value.INormalizedKeyComputer;
import org.apache.hyracks.api.dataflow.value.INormalizedKeyComputerFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAppender;
import org.apache.hyracks.dataflow.common.comm.util.FrameUtils;
import org.apache.hyracks.dataflow.std.buffermanager.IDeletableTupleBufferManager;
import org.apache.hyracks.dataflow.std.buffermanager.ITuplePointerAccessor;
import org.apache.hyracks.dataflow.std.sort.ITupleSorter;
import org.apache.hyracks.dataflow.std.structures.IResetableComparable;
import org.apache.hyracks.dataflow.std.structures.IResetableComparableFactory;
import org.apache.hyracks.dataflow.std.structures.MaxHeap;
import org.apache.hyracks.dataflow.std.structures.TuplePointer;

public class TupleSorterHeapSort
implements ITupleSorter {
    private static final Logger LOGGER = Logger.getLogger(TupleSorterHeapSort.class.getName());
    private final IDeletableTupleBufferManager bufferManager;
    private final ITuplePointerAccessor bufferAccessor1;
    private final ITuplePointerAccessor bufferAccessor2;
    private final int topK;
    private final FrameTupleAppender outputAppender;
    private final IFrame outputFrame;
    private final int[] sortFields;
    private final INormalizedKeyComputer nkc;
    private final IBinaryComparator[] comparators;
    private HeapEntry maxEntry;
    private HeapEntry newEntry;
    private MaxHeap heap;
    private boolean isSorted;
    private static final Comparator<IResetableComparable> entryComparator = new Comparator<IResetableComparable>(){

        @Override
        public int compare(IResetableComparable o1, IResetableComparable o2) {
            return o1.compareTo(o2);
        }
    };

    public TupleSorterHeapSort(IHyracksTaskContext ctx, IDeletableTupleBufferManager bufferManager, int topK, int[] sortFields, INormalizedKeyComputerFactory firstKeyNormalizerFactory, IBinaryComparatorFactory[] comparatorFactories) throws HyracksDataException {
        this.bufferManager = bufferManager;
        this.bufferAccessor1 = bufferManager.createTuplePointerAccessor();
        this.bufferAccessor2 = bufferManager.createTuplePointerAccessor();
        this.topK = topK;
        this.outputFrame = new VSizeFrame((IHyracksFrameMgrContext)ctx);
        this.outputAppender = new FrameTupleAppender();
        this.sortFields = sortFields;
        this.nkc = firstKeyNormalizerFactory == null ? null : firstKeyNormalizerFactory.createNormalizedKeyComputer();
        this.comparators = new IBinaryComparator[comparatorFactories.length];
        for (int i = 0; i < comparatorFactories.length; ++i) {
            this.comparators[i] = comparatorFactories[i].createBinaryComparator();
        }
        this.heap = new MaxHeap(new HeapEntryFactory(), topK);
        this.maxEntry = new HeapEntry();
        this.newEntry = new HeapEntry();
        this.isSorted = false;
    }

    @Override
    public int getTupleCount() {
        return this.heap.getNumEntries();
    }

    @Override
    public boolean insertTuple(IFrameTupleAccessor frameTupleAccessor, int index) throws HyracksDataException {
        if (this.isSorted) {
            throw new HyracksDataException("The Heap haven't be reset after sorting, the order of using this class is not correct.");
        }
        int nmkey = this.getPNK(frameTupleAccessor, index);
        if (this.heap.getNumEntries() >= this.topK) {
            this.heap.peekMax(this.maxEntry);
            if (this.compareTuple(frameTupleAccessor, index, nmkey, this.maxEntry) >= 0) {
                return true;
            }
        }
        this.newEntry.reset(nmkey);
        if (!this.bufferManager.insertTuple(frameTupleAccessor, index, this.newEntry.tuplePointer)) {
            return false;
        }
        if (this.heap.getNumEntries() < this.topK) {
            this.heap.insert(this.newEntry);
        } else {
            this.bufferManager.deleteTuple(this.maxEntry.tuplePointer);
            this.heap.replaceMax(this.newEntry);
        }
        return true;
    }

    private int getPNK(IFrameTupleAccessor fta, int tIx) {
        if (this.nkc == null) {
            return 0;
        }
        int sfIdx = this.sortFields[0];
        return this.nkc.normalize(fta.getBuffer().array(), fta.getAbsoluteFieldStartOffset(tIx, sfIdx), fta.getFieldLength(tIx, sfIdx));
    }

    private int compareTuple(IFrameTupleAccessor frameTupleAccessor, int tid, int nmkey, HeapEntry maxEntry) throws HyracksDataException {
        if (nmkey != maxEntry.nmk) {
            return ((long)nmkey & 0xFFFFFFFFL) < ((long)maxEntry.nmk & 0xFFFFFFFFL) ? -1 : 1;
        }
        this.bufferAccessor2.reset(maxEntry.tuplePointer);
        byte[] b1 = frameTupleAccessor.getBuffer().array();
        byte[] b2 = this.bufferAccessor2.getBuffer().array();
        for (int f = 0; f < this.comparators.length; ++f) {
            int l2;
            int s2;
            int l1;
            int fIdx = this.sortFields[f];
            int s1 = frameTupleAccessor.getAbsoluteFieldStartOffset(tid, fIdx);
            int c = this.comparators[f].compare(b1, s1, l1 = frameTupleAccessor.getFieldLength(tid, fIdx), b2, s2 = this.bufferAccessor2.getAbsFieldStartOffset(fIdx), l2 = this.bufferAccessor2.getFieldLength(fIdx));
            if (c == 0) continue;
            return c;
        }
        return 0;
    }

    @Override
    public boolean hasRemaining() {
        return this.getTupleCount() > 0;
    }

    @Override
    public void reset() throws HyracksDataException {
        this.bufferManager.reset();
        this.heap.reset();
        this.isSorted = false;
    }

    @Override
    public void sort() throws HyracksDataException {
        IResetableComparable[] entries = this.heap.getEntries();
        int count = this.heap.getNumEntries();
        Arrays.sort(entries, 0, count, entryComparator);
        this.isSorted = true;
    }

    @Override
    public void close() throws HyracksDataException {
        this.heap = null;
        this.bufferManager.close();
        this.isSorted = false;
    }

    @Override
    public int flush(IFrameWriter writer) throws HyracksDataException {
        this.outputAppender.reset(this.outputFrame, true);
        int maxFrameSize = this.outputFrame.getFrameSize();
        int numEntries = this.heap.getNumEntries();
        IResetableComparable[] entries = this.heap.getEntries();
        int io = 0;
        for (int i = 0; i < numEntries; ++i) {
            HeapEntry minEntry = (HeapEntry)entries[i];
            this.bufferAccessor1.reset(minEntry.tuplePointer);
            int flushed = FrameUtils.appendToWriter((IFrameWriter)writer, (IFrameTupleAppender)this.outputAppender, (byte[])this.bufferAccessor1.getBuffer().array(), (int)this.bufferAccessor1.getTupleStartOffset(), (int)this.bufferAccessor1.getTupleLength());
            if (flushed <= 0) continue;
            maxFrameSize = Math.max(maxFrameSize, flushed);
            ++io;
        }
        maxFrameSize = Math.max(maxFrameSize, this.outputFrame.getFrameSize());
        this.outputAppender.write(writer, true);
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("Flushed records:" + numEntries + "; Flushed through " + (io + 1) + " frames");
        }
        return maxFrameSize;
    }

    class HeapEntry
    implements IResetableComparable<HeapEntry> {
        int nmk = 0;
        TuplePointer tuplePointer = new TuplePointer();

        @Override
        public int compareTo(HeapEntry o) {
            if (this.nmk != o.nmk) {
                return ((long)this.nmk & 0xFFFFFFFFL) < ((long)o.nmk & 0xFFFFFFFFL) ? -1 : 1;
            }
            TupleSorterHeapSort.this.bufferAccessor1.reset(this.tuplePointer);
            TupleSorterHeapSort.this.bufferAccessor2.reset(o.tuplePointer);
            byte[] b1 = TupleSorterHeapSort.this.bufferAccessor1.getBuffer().array();
            byte[] b2 = TupleSorterHeapSort.this.bufferAccessor2.getBuffer().array();
            for (int f = 0; f < TupleSorterHeapSort.this.comparators.length; ++f) {
                int c;
                int fIdx = TupleSorterHeapSort.this.sortFields[f];
                int s1 = TupleSorterHeapSort.this.bufferAccessor1.getAbsFieldStartOffset(fIdx);
                int l1 = TupleSorterHeapSort.this.bufferAccessor1.getFieldLength(fIdx);
                int s2 = TupleSorterHeapSort.this.bufferAccessor2.getAbsFieldStartOffset(fIdx);
                int l2 = TupleSorterHeapSort.this.bufferAccessor2.getFieldLength(fIdx);
                try {
                    c = TupleSorterHeapSort.this.comparators[f].compare(b1, s1, l1, b2, s2, l2);
                }
                catch (HyracksDataException e) {
                    throw new IllegalStateException(e);
                }
                if (c == 0) continue;
                return c;
            }
            return 0;
        }

        @Override
        public void reset(int nmkey) {
            this.nmk = nmkey;
        }

        @Override
        public void reset(HeapEntry other) {
            this.nmk = other.nmk;
            this.tuplePointer.reset(other.tuplePointer);
        }
    }

    class HeapEntryFactory
    implements IResetableComparableFactory<HeapEntry> {
        HeapEntryFactory() {
        }

        @Override
        public IResetableComparable<HeapEntry> createResetableComparable() {
            return new HeapEntry();
        }
    }
}

