/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.std.sort;

import java.nio.ByteBuffer;
import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.context.IHyracksFrameMgrContext;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.dataflow.value.INormalizedKeyComputerFactory;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAccessor;
import org.apache.hyracks.dataflow.common.io.RunFileWriter;
import org.apache.hyracks.dataflow.std.buffermanager.VariableDeletableTupleMemoryManager;
import org.apache.hyracks.dataflow.std.buffermanager.VariableFramePool;
import org.apache.hyracks.dataflow.std.sort.AbstractSortRunGenerator;
import org.apache.hyracks.dataflow.std.sort.ISorter;
import org.apache.hyracks.dataflow.std.sort.ITupleSorter;
import org.apache.hyracks.dataflow.std.sort.TupleSorterHeapSort;

public class HeapSortRunGenerator
extends AbstractSortRunGenerator {
    protected final IHyracksTaskContext ctx;
    protected final int frameLimit;
    protected final int topK;
    protected final int[] sortFields;
    protected final INormalizedKeyComputerFactory nmkFactory;
    protected final IBinaryComparatorFactory[] comparatorFactories;
    protected final RecordDescriptor recordDescriptor;
    protected ITupleSorter tupleSorter;
    protected IFrameTupleAccessor inAccessor;

    public HeapSortRunGenerator(IHyracksTaskContext ctx, int frameLimit, int topK, int[] sortFields, INormalizedKeyComputerFactory firstKeyNormalizerFactory, IBinaryComparatorFactory[] comparatorFactories, RecordDescriptor recordDescriptor) {
        this.ctx = ctx;
        this.frameLimit = frameLimit;
        this.topK = topK;
        this.sortFields = sortFields;
        this.nmkFactory = firstKeyNormalizerFactory;
        this.comparatorFactories = comparatorFactories;
        this.inAccessor = new FrameTupleAccessor(recordDescriptor);
        this.recordDescriptor = recordDescriptor;
    }

    @Override
    public void open() throws HyracksDataException {
        VariableFramePool framePool = new VariableFramePool((IHyracksFrameMgrContext)this.ctx, (this.frameLimit - 1) * this.ctx.getInitialFrameSize());
        VariableDeletableTupleMemoryManager bufferManager = new VariableDeletableTupleMemoryManager(framePool, this.recordDescriptor);
        this.tupleSorter = new TupleSorterHeapSort(this.ctx, bufferManager, this.topK, this.sortFields, this.nmkFactory, this.comparatorFactories);
        super.open();
    }

    @Override
    public ISorter getSorter() throws HyracksDataException {
        return this.tupleSorter;
    }

    @Override
    protected RunFileWriter getRunFileWriter() throws HyracksDataException {
        FileReference file = this.ctx.getJobletContext().createManagedWorkspaceFile(HeapSortRunGenerator.class.getSimpleName());
        return new RunFileWriter(file, this.ctx.getIOManager());
    }

    @Override
    protected IFrameWriter getFlushableFrameWriter(RunFileWriter writer) throws HyracksDataException {
        return writer;
    }

    public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
        this.inAccessor.reset(buffer);
        for (int i = 0; i < this.inAccessor.getTupleCount(); ++i) {
            if (this.tupleSorter.insertTuple(this.inAccessor, i)) continue;
            this.flushFramesToRun();
            if (this.tupleSorter.insertTuple(this.inAccessor, i)) continue;
            throw new HyracksDataException("The given tuple is too big to insert into the sorting memory.");
        }
    }
}

