/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.std.sort;

import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.dataflow.value.INormalizedKeyComputerFactory;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.std.buffermanager.IFrameBufferManager;
import org.apache.hyracks.dataflow.std.sort.AbstractFrameSorter;

public class FrameSorterQuickSort
extends AbstractFrameSorter {
    public FrameSorterQuickSort(IHyracksTaskContext ctx, IFrameBufferManager bufferManager, int[] sortFields, INormalizedKeyComputerFactory firstKeyNormalizerFactory, IBinaryComparatorFactory[] comparatorFactories, RecordDescriptor recordDescriptor) throws HyracksDataException {
        this(ctx, bufferManager, sortFields, firstKeyNormalizerFactory, comparatorFactories, recordDescriptor, Integer.MAX_VALUE);
    }

    public FrameSorterQuickSort(IHyracksTaskContext ctx, IFrameBufferManager bufferManager, int[] sortFields, INormalizedKeyComputerFactory firstKeyNormalizerFactory, IBinaryComparatorFactory[] comparatorFactories, RecordDescriptor recordDescriptor, int outputLimit) throws HyracksDataException {
        super(ctx, bufferManager, sortFields, firstKeyNormalizerFactory, comparatorFactories, recordDescriptor, outputLimit);
    }

    @Override
    void sortTupleReferences() throws HyracksDataException {
        this.sort(0, this.tupleCount);
    }

    void sort(int offset, int length) throws HyracksDataException {
        int c;
        int a;
        int m = offset + (length >> 1);
        int b = a = offset;
        int d = c = offset + length - 1;
        while (true) {
            int cmp;
            if (b <= c && (cmp = this.compare(b, m)) <= 0) {
                if (cmp == 0) {
                    this.swap(this.tPointers, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && (cmp = this.compare(c, m)) >= 0) {
                if (cmp == 0) {
                    this.swap(this.tPointers, c, d--);
                }
                --c;
            }
            if (b > c) break;
            this.swap(this.tPointers, b++, c--);
        }
        int n = offset + length;
        int s = Math.min(a - offset, b - a);
        this.vecswap(this.tPointers, offset, b - s, s);
        s = Math.min(d - c, n - d - 1);
        this.vecswap(this.tPointers, b, n - s, s);
        s = b - a;
        if (s > 1) {
            this.sort(offset, s);
        }
        if ((s = d - c) > 1) {
            this.sort(n - s, s);
        }
    }

    private void swap(int[] x, int a, int b) {
        for (int i = 0; i < 4; ++i) {
            int t = x[a * 4 + i];
            x[a * 4 + i] = x[b * 4 + i];
            x[b * 4 + i] = t;
        }
    }

    private void vecswap(int[] x, int a, int b, int n) {
        int i = 0;
        while (i < n) {
            this.swap(x, a, b);
            ++i;
            ++a;
            ++b;
        }
    }
}

