/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.std.sort;

import java.util.LinkedList;
import java.util.List;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.io.GeneratedRunFileReader;
import org.apache.hyracks.dataflow.common.io.RunFileWriter;
import org.apache.hyracks.dataflow.std.sort.IRunGenerator;
import org.apache.hyracks.dataflow.std.sort.ISorter;

public abstract class AbstractSortRunGenerator
implements IRunGenerator {
    protected final List<GeneratedRunFileReader> generatedRunFileReaders = new LinkedList<GeneratedRunFileReader>();

    public abstract ISorter getSorter() throws HyracksDataException;

    public void open() throws HyracksDataException {
        this.generatedRunFileReaders.clear();
    }

    public void close() throws HyracksDataException {
        if (this.getSorter().hasRemaining()) {
            if (this.generatedRunFileReaders.size() <= 0) {
                this.getSorter().sort();
            } else {
                this.flushFramesToRun();
            }
        }
    }

    protected abstract RunFileWriter getRunFileWriter() throws HyracksDataException;

    protected abstract IFrameWriter getFlushableFrameWriter(RunFileWriter var1) throws HyracksDataException;

    protected void flushFramesToRun() throws HyracksDataException {
        this.getSorter().sort();
        RunFileWriter runWriter = this.getRunFileWriter();
        flushWriter.open();
        try (IFrameWriter flushWriter = this.getFlushableFrameWriter(runWriter);){
            this.getSorter().flush(flushWriter);
        }
        this.generatedRunFileReaders.add(runWriter.createDeleteOnCloseReader());
        this.getSorter().reset();
    }

    public void fail() throws HyracksDataException {
    }

    @Override
    public List<GeneratedRunFileReader> getRuns() {
        return this.generatedRunFileReaders;
    }
}

