/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.std.misc;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hyracks.api.comm.IFrame;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.TaskId;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.api.job.JobId;
import org.apache.hyracks.dataflow.common.io.GeneratedRunFileReader;
import org.apache.hyracks.dataflow.common.io.RunFileWriter;
import org.apache.hyracks.dataflow.std.base.AbstractStateObject;

public class MaterializerTaskState
extends AbstractStateObject {
    private RunFileWriter out;
    private final AtomicInteger numConsumers = new AtomicInteger(1);

    public MaterializerTaskState(JobId jobId, TaskId taskId) {
        super(jobId, taskId);
    }

    public MaterializerTaskState(JobId jobId, TaskId taskId, int numConsumers) {
        super(jobId, taskId);
        this.numConsumers.set(numConsumers);
    }

    @Override
    public void toBytes(DataOutput out) throws IOException {
    }

    @Override
    public void fromBytes(DataInput in) throws IOException {
    }

    public void open(IHyracksTaskContext ctx) throws HyracksDataException {
        FileReference file = ctx.getJobletContext().createManagedWorkspaceFile(MaterializerTaskState.class.getSimpleName());
        this.out = new RunFileWriter(file, ctx.getIOManager());
        this.out.open();
    }

    public void close() throws HyracksDataException {
        this.out.close();
    }

    public void appendFrame(ByteBuffer buffer) throws HyracksDataException {
        this.out.nextFrame(buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeOut(IFrameWriter writer, IFrame frame, boolean failed) throws HyracksDataException {
        GeneratedRunFileReader in = this.out.createReader();
        writer.open();
        try {
            if (failed) {
                writer.fail();
                return;
            }
            in.open();
            try {
                while (in.nextFrame(frame)) {
                    writer.nextFrame(frame.getBuffer());
                }
            }
            finally {
                in.close();
            }
        }
        catch (Exception e) {
            writer.fail();
            throw e;
        }
        finally {
            try {
                writer.close();
            }
            finally {
                if (this.numConsumers.decrementAndGet() == 0) {
                    this.out.getFileReference().delete();
                }
            }
        }
    }
}

