/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.std.file;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileSplit;
import org.apache.hyracks.api.io.IIOManager;
import org.apache.hyracks.api.job.IOperatorDescriptorRegistry;
import org.apache.hyracks.dataflow.std.file.AbstractFileWriteOperatorDescriptor;
import org.apache.hyracks.dataflow.std.file.IRecordWriter;
import org.apache.hyracks.dataflow.std.file.RecordWriter;

public class LineFileWriteOperatorDescriptor
extends AbstractFileWriteOperatorDescriptor {
    private static final long serialVersionUID = 1L;
    private int[] columns;
    private char separator;

    public LineFileWriteOperatorDescriptor(IOperatorDescriptorRegistry spec, FileSplit[] splits) {
        this(spec, splits, null, ',');
    }

    public LineFileWriteOperatorDescriptor(IOperatorDescriptorRegistry spec, FileSplit[] splits, int[] columns) {
        this(spec, splits, columns, ',');
    }

    public LineFileWriteOperatorDescriptor(IOperatorDescriptorRegistry spec, FileSplit[] splits, int[] columns, char separator) {
        super(spec, splits);
        this.columns = columns;
        this.separator = separator;
    }

    @Override
    protected IRecordWriter createRecordWriter(IIOManager ioManager, FileSplit fileSplit, int index) throws HyracksDataException {
        return new LineWriterImpl(fileSplit.getFile(ioManager), this.columns, this.separator);
    }

    private static class LineWriterImpl
    extends RecordWriter {
        LineWriterImpl(File file, int[] columns, char separator) throws HyracksDataException {
            super(columns, separator, new Object[]{file});
        }

        @Override
        public OutputStream createOutputStream(Object[] args) throws HyracksDataException {
            try {
                return new FileOutputStream((File)args[0]);
            }
            catch (FileNotFoundException e) {
                throw new HyracksDataException((Throwable)e);
            }
        }
    }
}

