/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.std.file;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.IOperatorNodePushable;
import org.apache.hyracks.api.dataflow.value.IRecordDescriptorProvider;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileSplit;
import org.apache.hyracks.api.io.IIOManager;
import org.apache.hyracks.api.job.IOperatorDescriptorRegistry;
import org.apache.hyracks.dataflow.std.base.AbstractOperatorNodePushable;
import org.apache.hyracks.dataflow.std.base.AbstractSingleActivityOperatorDescriptor;
import org.apache.hyracks.dataflow.std.file.IFileSplitProvider;

public class FileRemoveOperatorDescriptor
extends AbstractSingleActivityOperatorDescriptor {
    private final IFileSplitProvider fileSplitProvider;
    private final boolean quietly;
    private static final long serialVersionUID = 1L;

    public FileRemoveOperatorDescriptor(IOperatorDescriptorRegistry spec, IFileSplitProvider fileSplitProvder, boolean quietly) {
        super(spec, 0, 0);
        this.fileSplitProvider = fileSplitProvder;
        this.quietly = quietly;
    }

    @Deprecated
    public FileRemoveOperatorDescriptor(IOperatorDescriptorRegistry spec, IFileSplitProvider fileSplitProvder) {
        this(spec, fileSplitProvder, false);
    }

    public IOperatorNodePushable createPushRuntime(IHyracksTaskContext ctx, IRecordDescriptorProvider recordDescProvider, int partition, int nPartitions) throws HyracksDataException {
        final FileSplit split = this.fileSplitProvider.getFileSplits()[partition];
        final IIOManager ioManager = ctx.getIOManager();
        return new AbstractOperatorNodePushable(){

            public void setOutputFrameWriter(int index, IFrameWriter writer, RecordDescriptor recordDesc) {
                throw new IllegalStateException();
            }

            public void initialize() throws HyracksDataException {
                File f = split.getFile(ioManager);
                if (FileRemoveOperatorDescriptor.this.quietly) {
                    FileUtils.deleteQuietly((File)f);
                } else {
                    try {
                        FileUtils.deleteDirectory((File)f);
                    }
                    catch (IOException e) {
                        throw new HyracksDataException((Throwable)e);
                    }
                }
            }

            public IFrameWriter getInputFrameWriter(int index) {
                throw new IllegalStateException();
            }

            public int getInputArity() {
                return 0;
            }

            public void deinitialize() throws HyracksDataException {
            }
        };
    }
}

