/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.sqlpp.rewrites.visitor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.base.ILangExpression;
import org.apache.asterix.lang.common.clause.GroupbyClause;
import org.apache.asterix.lang.common.clause.LetClause;
import org.apache.asterix.lang.common.clause.LimitClause;
import org.apache.asterix.lang.common.clause.OrderbyClause;
import org.apache.asterix.lang.common.expression.GbyVariableExpressionPair;
import org.apache.asterix.lang.common.expression.VariableExpr;
import org.apache.asterix.lang.common.rewrites.LangRewritingContext;
import org.apache.asterix.lang.common.struct.Identifier;
import org.apache.asterix.lang.common.struct.VarIdentifier;
import org.apache.asterix.lang.common.visitor.base.ILangVisitor;
import org.apache.asterix.lang.sqlpp.clause.FromClause;
import org.apache.asterix.lang.sqlpp.clause.HavingClause;
import org.apache.asterix.lang.sqlpp.clause.SelectBlock;
import org.apache.asterix.lang.sqlpp.clause.SelectClause;
import org.apache.asterix.lang.sqlpp.expression.SelectExpression;
import org.apache.asterix.lang.sqlpp.util.SqlppRewriteUtil;
import org.apache.asterix.lang.sqlpp.util.SqlppVariableUtil;
import org.apache.asterix.lang.sqlpp.visitor.base.AbstractSqlppExpressionScopingVisitor;
import org.apache.hyracks.algebricks.common.utils.Pair;

public class SqlppGroupByVisitor
extends AbstractSqlppExpressionScopingVisitor {
    public SqlppGroupByVisitor(LangRewritingContext context) {
        super(context);
    }

    @Override
    public Expression visit(SelectBlock selectBlock, ILangExpression arg) throws CompilationException {
        FromClause fromClause = selectBlock.getFromClause();
        if (selectBlock.hasFromClause()) {
            fromClause.accept(this, arg);
        }
        if (selectBlock.hasLetClauses()) {
            List<LetClause> letList = selectBlock.getLetList();
            for (LetClause letClause : letList) {
                letClause.accept((ILangVisitor)this, (Object)arg);
            }
        }
        if (selectBlock.hasWhereClause()) {
            selectBlock.getWhereClause().accept((ILangVisitor)this, (Object)arg);
        }
        if (selectBlock.hasGroupbyClause()) {
            Set<VariableExpr> visibleOuterScopeNonWithVars;
            boolean needResolution;
            SelectExpression parentSelectExpression;
            GroupbyClause groupbyClause = selectBlock.getGroupbyClause();
            groupbyClause.accept((ILangVisitor)this, (Object)fromClause);
            Collection<VariableExpr> visibleVarsInCurrentScope = SqlppVariableUtil.getBindingVariables(groupbyClause);
            VariableExpr groupVar = groupbyClause.getGroupVar();
            Set<VariableExpr> groupFieldVars = this.getGroupFieldVariables(groupbyClause);
            HashSet<VariableExpr> freeVariablesInGbyLets = new HashSet<VariableExpr>();
            if (selectBlock.hasLetClausesAfterGroupby()) {
                List<LetClause> letListAfterGby = selectBlock.getLetListAfterGroupby();
                for (LetClause letClauseAfterGby : letListAfterGby) {
                    letClauseAfterGby.accept((ILangVisitor)this, (Object)arg);
                    SqlppRewriteUtil.rewriteExpressionUsingGroupVariable(groupVar, groupFieldVars, (ILangExpression)letClauseAfterGby, this.context);
                    Collection<VariableExpr> freeVariablesInLet = SqlppVariableUtil.getFreeVariables((ILangExpression)letClauseAfterGby.getBindingExpr());
                    freeVariablesInLet.removeAll(visibleVarsInCurrentScope);
                    freeVariablesInGbyLets.addAll(freeVariablesInLet);
                    visibleVarsInCurrentScope.add(letClauseAfterGby.getVarExpr());
                }
            }
            HashSet<VariableExpr> freeVariables = new HashSet<VariableExpr>();
            if (selectBlock.hasHavingClause()) {
                HavingClause havingClause = selectBlock.getHavingClause();
                havingClause.accept(this, arg);
                SqlppRewriteUtil.rewriteExpressionUsingGroupVariable(groupVar, groupFieldVars, (ILangExpression)havingClause, this.context);
                freeVariables.addAll(SqlppVariableUtil.getFreeVariables((ILangExpression)havingClause));
            }
            if (!(parentSelectExpression = (SelectExpression)arg).getSelectSetOperation().hasRightInputs()) {
                if (parentSelectExpression.hasOrderby()) {
                    OrderbyClause orderbyClause = parentSelectExpression.getOrderbyClause();
                    orderbyClause.accept((ILangVisitor)this, (Object)arg);
                    SqlppRewriteUtil.rewriteExpressionUsingGroupVariable(groupVar, groupFieldVars, (ILangExpression)orderbyClause, this.context);
                    freeVariables.addAll(SqlppVariableUtil.getFreeVariables((ILangExpression)orderbyClause));
                }
                if (parentSelectExpression.hasLimit()) {
                    LimitClause limitClause = parentSelectExpression.getLimitClause();
                    limitClause.accept((ILangVisitor)this, (Object)arg);
                    SqlppRewriteUtil.rewriteExpressionUsingGroupVariable(groupVar, groupFieldVars, (ILangExpression)limitClause, this.context);
                    freeVariables.addAll(SqlppVariableUtil.getFreeVariables((ILangExpression)limitClause));
                }
            }
            SelectClause selectClause = selectBlock.getSelectClause();
            selectClause.accept(this, arg);
            SqlppRewriteUtil.rewriteExpressionUsingGroupVariable(groupVar, groupFieldVars, (ILangExpression)selectClause, this.context);
            freeVariables.addAll(SqlppVariableUtil.getFreeVariables((ILangExpression)selectClause));
            freeVariables.removeAll(visibleVarsInCurrentScope);
            freeVariables.addAll(freeVariablesInGbyLets);
            Set<VariableExpr> decorVars = SqlppVariableUtil.getLiveVariables(this.scopeChecker.getCurrentScope(), true);
            decorVars.removeAll(visibleVarsInCurrentScope);
            boolean bl = needResolution = !decorVars.containsAll(freeVariables);
            if (needResolution) {
                decorVars.retainAll(freeVariables);
                visibleOuterScopeNonWithVars = SqlppVariableUtil.getLiveVariables(this.scopeChecker.getCurrentScope(), false);
                visibleOuterScopeNonWithVars.removeAll(visibleVarsInCurrentScope);
                decorVars.addAll(visibleOuterScopeNonWithVars);
            } else {
                decorVars.retainAll(freeVariables);
            }
            if (!decorVars.isEmpty()) {
                visibleOuterScopeNonWithVars = SqlppVariableUtil.getLiveVariables(this.scopeChecker.getCurrentScope(), false);
                visibleOuterScopeNonWithVars.retainAll(freeVariables);
                decorVars.addAll(visibleOuterScopeNonWithVars);
                ArrayList<GbyVariableExpressionPair> decorList = new ArrayList<GbyVariableExpressionPair>();
                for (VariableExpr var : decorVars) {
                    decorList.add(new GbyVariableExpressionPair((VariableExpr)SqlppRewriteUtil.deepCopy((ILangExpression)var), (Expression)SqlppRewriteUtil.deepCopy((ILangExpression)var)));
                }
                groupbyClause.getDecorPairList().addAll(decorList);
            }
        } else {
            selectBlock.getSelectClause().accept(this, arg);
        }
        return null;
    }

    @Override
    public Expression visit(GroupbyClause gc, ILangExpression arg) throws CompilationException {
        FromClause fromClause = (FromClause)arg;
        Collection<Object> fromBindingVars = fromClause == null ? new ArrayList() : SqlppVariableUtil.getBindingVariables(fromClause);
        HashMap<Object, VariableExpr> withVarMap = new HashMap<Object, VariableExpr>();
        for (Object fromBindingVar : fromBindingVars) {
            VariableExpr variableExpr = new VariableExpr();
            variableExpr.setIsNewVar(false);
            variableExpr.setVar(fromBindingVar.getVar());
            VariableExpr newVarExpr = (VariableExpr)SqlppRewriteUtil.deepCopy((ILangExpression)variableExpr);
            withVarMap.put(variableExpr, newVarExpr);
        }
        ArrayList<Pair> groupFieldList = new ArrayList<Pair>();
        if (!gc.hasGroupFieldList()) {
            for (VariableExpr variableExpr : fromBindingVars) {
                Pair varIdPair = new Pair((Object)new VariableExpr(variableExpr.getVar()), (Object)SqlppVariableUtil.toUserDefinedVariableName(variableExpr.getVar()));
                groupFieldList.add(varIdPair);
            }
            gc.setGroupFieldList(groupFieldList);
        } else {
            for (Pair pair : gc.getGroupFieldList()) {
                Expression newFieldExpr = (Expression)((Expression)pair.first).accept((ILangVisitor)this, (Object)arg);
                groupFieldList.add(new Pair((Object)newFieldExpr, pair.second));
                VariableExpr bindingVar = new VariableExpr(new VarIdentifier(SqlppVariableUtil.toInternalVariableName(((Identifier)pair.second).getValue())));
                withVarMap.put(newFieldExpr, bindingVar);
            }
        }
        gc.setGroupFieldList(groupFieldList);
        if (!gc.hasGroupVar()) {
            VariableExpr groupVar = new VariableExpr(this.context.newVariable());
            gc.setGroupVar(groupVar);
        }
        VariableExpr gbyVarRef = new VariableExpr(gc.getGroupVar().getVar());
        gbyVarRef.setIsNewVar(false);
        withVarMap.put(gbyVarRef, (VariableExpr)SqlppRewriteUtil.deepCopy((ILangExpression)gbyVarRef));
        gc.setWithVarMap(withVarMap);
        return super.visit(gc, arg);
    }

    private Set<VariableExpr> getGroupFieldVariables(GroupbyClause groupbyClause) {
        HashSet<VariableExpr> fieldVars = new HashSet<VariableExpr>();
        if (groupbyClause.hasGroupFieldList()) {
            for (Pair groupField : groupbyClause.getGroupFieldList()) {
                fieldVars.add(new VariableExpr(new VarIdentifier(SqlppVariableUtil.toInternalVariableName(((Identifier)groupField.second).getValue()))));
            }
        }
        return fieldVars;
    }
}

