/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.sqlpp.clause;

import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.lang.common.base.Clause;
import org.apache.asterix.lang.common.visitor.base.ILangVisitor;
import org.apache.asterix.lang.sqlpp.clause.SelectElement;
import org.apache.asterix.lang.sqlpp.clause.SelectRegular;
import org.apache.asterix.lang.sqlpp.visitor.base.ISqlppVisitor;
import org.apache.commons.lang3.ObjectUtils;

public class SelectClause
implements Clause {
    private SelectElement selectElement;
    private SelectRegular selectRegular;
    private boolean distinct;

    public SelectClause(SelectElement selectElement, SelectRegular selectRegular, boolean distinct) {
        this.selectElement = selectElement;
        this.selectRegular = selectRegular;
        this.distinct = distinct;
    }

    public <R, T> R accept(ILangVisitor<R, T> visitor, T arg) throws CompilationException {
        return ((ISqlppVisitor)visitor).visit(this, arg);
    }

    public Clause.ClauseType getClauseType() {
        return Clause.ClauseType.SELECT_CLAUSE;
    }

    public SelectElement getSelectElement() {
        return this.selectElement;
    }

    public SelectRegular getSelectRegular() {
        return this.selectRegular;
    }

    public boolean selectElement() {
        return this.selectElement != null;
    }

    public boolean selectRegular() {
        return this.selectRegular != null;
    }

    public boolean distinct() {
        return this.distinct;
    }

    public String toString() {
        return "select " + (this.distinct ? "distinct " : "") + (this.selectElement() ? "element " + this.selectElement : String.valueOf(this.selectRegular));
    }

    public int hashCode() {
        return ObjectUtils.hashCodeMulti((Object[])new Object[]{this.distinct, this.selectElement, this.selectRegular});
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof SelectClause)) {
            return false;
        }
        SelectClause target = (SelectClause)object;
        return this.distinct == target.distinct && ObjectUtils.equals((Object)this.selectElement, (Object)target.selectElement) && ObjectUtils.equals((Object)this.selectRegular, (Object)target.selectRegular);
    }
}

