/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.event.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.asterix.common.configuration.AsterixConfiguration;
import org.apache.asterix.common.configuration.Property;
import org.apache.asterix.event.model.AsterixRuntimeState;
import org.apache.asterix.event.model.BackupInfo;
import org.apache.asterix.event.model.ProcessInfo;
import org.apache.asterix.event.schema.cluster.Cluster;
import org.apache.asterix.event.schema.cluster.Node;

public class AsterixInstance
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int WEB_INTERFACE_PORT_DEFAULT = 19001;
    private final Cluster cluster;
    private final String name;
    private final Date createdTimestamp;
    private Date stateChangeTimestamp;
    private Date modifiedTimestamp;
    private AsterixConfiguration asterixConfiguration;
    private State state;
    private final String metadataNodeId;
    private final String asterixVersion;
    private final List<BackupInfo> backupInfo;
    private AsterixRuntimeState runtimeState;
    private State previousState;

    public AsterixInstance(String name, Cluster cluster, AsterixConfiguration asterixConfiguration, String metadataNodeId, String asterixVersion) {
        this.name = name;
        this.cluster = cluster;
        this.asterixConfiguration = asterixConfiguration;
        this.metadataNodeId = metadataNodeId;
        this.state = State.ACTIVE;
        this.previousState = State.UNUSABLE;
        this.asterixVersion = asterixVersion;
        this.createdTimestamp = new Date();
        this.backupInfo = new ArrayList<BackupInfo>();
    }

    public State getState() {
        return this.state;
    }

    public void setState(State state) {
        this.previousState = this.state;
        this.state = state;
    }

    public Cluster getCluster() {
        return this.cluster;
    }

    public String getName() {
        return this.name;
    }

    public void setStateChangeTimestamp(Date stateChangeTimestamp) {
        this.stateChangeTimestamp = stateChangeTimestamp;
    }

    public void setModifiedTimestamp(Date modifiedTimestamp) {
        this.modifiedTimestamp = modifiedTimestamp;
    }

    public String getMetadataNodeId() {
        return this.metadataNodeId;
    }

    public String getAsterixVersion() {
        return this.asterixVersion;
    }

    public String getDescription(boolean detailed) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Name:" + this.name + "\n");
        buffer.append("Created:" + this.createdTimestamp + "\n");
        buffer.append("Web-Url:" + this.getWebInterfaceUrl() + "\n");
        buffer.append("State:" + (Object)((Object)this.state));
        if (!this.state.equals((Object)State.UNUSABLE) && this.stateChangeTimestamp != null) {
            buffer.append(" (" + this.stateChangeTimestamp + ")\n");
        } else {
            buffer.append("\n");
        }
        if (this.modifiedTimestamp != null) {
            buffer.append("Last modified timestamp:" + this.modifiedTimestamp + "\n");
        }
        if (this.runtimeState.getSummary() != null && this.runtimeState.getSummary().length() > 0) {
            buffer.append("\nWARNING!:" + this.runtimeState.getSummary() + "\n");
        }
        if (detailed) {
            this.addDetailedInformation(buffer);
        }
        return buffer.toString();
    }

    public List<BackupInfo> getBackupInfo() {
        return this.backupInfo;
    }

    public String getWebInterfaceUrl() {
        int webPort = 19001;
        for (Property p : this.asterixConfiguration.getProperty()) {
            if (!p.getName().equalsIgnoreCase("web.port")) continue;
            webPort = Integer.parseInt(p.getValue());
        }
        return "http://" + this.cluster.getMasterNode().getClientIp() + ":" + webPort;
    }

    public void setAsterixRuntimeStates(AsterixRuntimeState runtimeState) {
        this.runtimeState = runtimeState;
    }

    private void addDetailedInformation(StringBuilder buffer) {
        buffer.append("Master node:" + this.cluster.getMasterNode().getId() + ":" + this.cluster.getMasterNode().getClusterIp() + "\n");
        for (Node node : this.cluster.getNode()) {
            buffer.append(node.getId() + ":" + node.getClusterIp() + "\n");
        }
        if (this.backupInfo != null && this.backupInfo.size() > 0) {
            for (BackupInfo info : this.backupInfo) {
                buffer.append(info + "\n");
            }
        }
        buffer.append("\n");
        buffer.append("Asterix version:" + this.asterixVersion + "\n");
        buffer.append("Metadata Node:" + this.metadataNodeId + "\n");
        buffer.append("Processes\n");
        for (ProcessInfo pInfo : this.runtimeState.getProcesses()) {
            buffer.append(pInfo + "\n");
        }
        buffer.append("\n");
        buffer.append("Asterix Configuration\n");
        int lenMax = 0;
        for (Property property : this.asterixConfiguration.getProperty()) {
            int nextLen = property.getName().length();
            if (nextLen <= lenMax) continue;
            lenMax = nextLen;
        }
        for (Property property : this.asterixConfiguration.getProperty()) {
            buffer.append(property.getName() + this.getIndentation(property.getName(), lenMax) + ":" + property.getValue() + "\n");
        }
    }

    private String getIndentation(String name, int lenMax) {
        int len = name.length();
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < lenMax - len; ++i) {
            buf.append(" ");
        }
        return buf.toString();
    }

    public State getPreviousState() {
        return this.previousState;
    }

    public AsterixConfiguration getAsterixConfiguration() {
        return this.asterixConfiguration;
    }

    public void setAsterixConfiguration(AsterixConfiguration asterixConfiguration) {
        this.asterixConfiguration = asterixConfiguration;
    }

    public static enum State {
        ACTIVE,
        INACTIVE,
        UNUSABLE;

    }
}

