/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.event.management;

import java.util.Random;
import java.util.logging.Logger;

public class Randomizer {
    private static final Logger LOGGER = Logger.getLogger(Randomizer.class.getName());
    private static Randomizer INSTANCE;
    private final Random random;
    private final int seed;

    public static Randomizer getInstance(int seed) {
        if (INSTANCE == null) {
            INSTANCE = new Randomizer(seed);
        }
        return INSTANCE;
    }

    public static Randomizer getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new Randomizer();
        }
        return INSTANCE;
    }

    private Randomizer() {
        Random rm = new Random();
        this.seed = rm.nextInt(10000);
        this.random = new Random(this.seed);
        LOGGER.info("SEED:" + this.seed);
    }

    private Randomizer(int seed) {
        this.seed = seed;
        this.random = new Random(seed);
        LOGGER.info("SEED:" + seed);
    }

    public Random getRandom() {
        return this.random;
    }

    public int getSeed() {
        return this.seed;
    }

    public int getRandomInt(int min, int max) {
        return min + this.random.nextInt(max - min + 1);
    }
}

