/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.event.driver;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBException;
import org.apache.asterix.event.driver.EventConfig;
import org.apache.asterix.event.management.EventUtil;
import org.apache.asterix.event.management.Randomizer;
import org.apache.asterix.event.schema.cluster.Cluster;
import org.apache.asterix.event.schema.cluster.Node;
import org.apache.asterix.event.schema.cluster.Property;
import org.kohsuke.args4j.CmdLineParser;

public class EventDriver {
    public static final String CLIENT_NODE_ID = "client_node";
    public static final String CLUSTER_IP = "127.0.0.1";
    public static final Node CLIENT_NODE = new Node("client_node", "127.0.0.1", null, null, null, null, null, null);
    private static String eventsDir;
    private static Map<String, String> env;
    private static String scriptDirSuffix;

    public static Map<String, String> getEnvironment() {
        return env;
    }

    public static Cluster initializeCluster(String path) throws JAXBException, IOException {
        Cluster cluster = EventUtil.getCluster(path);
        for (Property p : cluster.getEnv().getProperty()) {
            env.put(p.getKey(), p.getValue());
        }
        return cluster;
    }

    public static void main(String[] args) throws Exception {
        String eventsHome = System.getenv("EVENT_HOME");
        if (eventsHome == null) {
            throw new IllegalStateException("EVENT_HOME is not set");
        }
        eventsDir = eventsHome + File.separator + "events";
        EventConfig eventConfig = new EventConfig();
        CmdLineParser parser = new CmdLineParser((Object)eventConfig);
        try {
            parser.parseArgument(args);
            if (eventConfig.help) {
                parser.printUsage((OutputStream)System.out);
            }
            if (eventConfig.seed > 0) {
                Randomizer.getInstance(eventConfig.seed);
            }
            Cluster cluster = EventDriver.initializeCluster(eventConfig.clusterPath);
            if (!eventConfig.dryRun) {
                EventDriver.prepare(cluster);
            }
            if (!eventConfig.dryRun) {
                EventDriver.cleanup(cluster);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            parser.printUsage((OutputStream)System.err);
        }
    }

    private static void prepare(Cluster cluster) throws IOException, InterruptedException {
        scriptDirSuffix = Long.toString(System.nanoTime());
        ArrayList<String> args = new ArrayList<String>();
        args.add(scriptDirSuffix);
        Node clientNode = new Node();
        clientNode.setId("client");
        clientNode.setClusterIp(CLUSTER_IP);
        for (Node node : cluster.getNode()) {
            args.add(node.getClusterIp());
        }
        EventUtil.executeLocalScript(clientNode, eventsDir + "/events/prepare.sh", args);
    }

    private static void cleanup(Cluster cluster) throws IOException, InterruptedException {
        ArrayList<String> args = new ArrayList<String>();
        args.add(scriptDirSuffix);
        Node clientNode = new Node();
        clientNode.setId("client");
        clientNode.setClusterIp(CLUSTER_IP);
        for (Node node : cluster.getNode()) {
            args.add(node.getClusterIp());
        }
        EventUtil.executeLocalScript(clientNode, eventsDir + "/events/cleanup.sh", args);
    }

    static {
        env = new HashMap<String, String>();
    }
}

