/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.rtree.impls;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.dataflow.value.ILinearizeComparatorFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.IIOManager;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.btree.impls.BTreeRangeSearchCursor;
import org.apache.hyracks.storage.am.btree.impls.RangePredicate;
import org.apache.hyracks.storage.am.common.api.IIndexBulkLoader;
import org.apache.hyracks.storage.am.common.api.IIndexCursor;
import org.apache.hyracks.storage.am.common.api.IModificationOperationCallback;
import org.apache.hyracks.storage.am.common.api.ISearchOperationCallback;
import org.apache.hyracks.storage.am.common.api.ISearchPredicate;
import org.apache.hyracks.storage.am.common.api.ITreeIndex;
import org.apache.hyracks.storage.am.common.api.ITreeIndexAccessor;
import org.apache.hyracks.storage.am.common.api.ITreeIndexCursor;
import org.apache.hyracks.storage.am.common.api.ITreeIndexFrameFactory;
import org.apache.hyracks.storage.am.common.api.IndexException;
import org.apache.hyracks.storage.am.common.api.TreeIndexException;
import org.apache.hyracks.storage.am.common.impls.NoOpOperationCallback;
import org.apache.hyracks.storage.am.common.ophelpers.IndexOperation;
import org.apache.hyracks.storage.am.common.ophelpers.MultiComparator;
import org.apache.hyracks.storage.am.common.tuples.PermutingTupleReference;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponentFilterFactory;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponentFilterFrameFactory;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMDiskComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMDiskComponentFactory;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMHarness;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperation;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationCallback;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationScheduler;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexAccessor;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexFileManager;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexOperationContext;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMMergePolicy;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMOperationTracker;
import org.apache.hyracks.storage.am.lsm.common.api.IVirtualBufferCache;
import org.apache.hyracks.storage.am.lsm.common.api.LSMOperationType;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMComponentFileReferences;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMComponentFilterManager;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMIndexSearchCursor;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMTreeIndexAccessor;
import org.apache.hyracks.storage.am.lsm.common.impls.TreeIndexFactory;
import org.apache.hyracks.storage.am.lsm.rtree.impls.AbstractLSMRTree;
import org.apache.hyracks.storage.am.lsm.rtree.impls.LSMRTreeDiskComponent;
import org.apache.hyracks.storage.am.lsm.rtree.impls.LSMRTreeFlushOperation;
import org.apache.hyracks.storage.am.lsm.rtree.impls.LSMRTreeMemoryComponent;
import org.apache.hyracks.storage.am.lsm.rtree.impls.LSMRTreeMergeOperation;
import org.apache.hyracks.storage.am.lsm.rtree.impls.LSMRTreeOpContext;
import org.apache.hyracks.storage.am.lsm.rtree.impls.LSMRTreeWithAntiMatterTuplesDiskComponentFactory;
import org.apache.hyracks.storage.am.lsm.rtree.impls.LSMRTreeWithAntiMatterTuplesFlushCursor;
import org.apache.hyracks.storage.am.lsm.rtree.impls.LSMRTreeWithAntiMatterTuplesSearchCursor;
import org.apache.hyracks.storage.am.lsm.rtree.impls.TreeTupleSorter;
import org.apache.hyracks.storage.am.rtree.impls.RTree;
import org.apache.hyracks.storage.am.rtree.impls.RTreeSearchCursor;
import org.apache.hyracks.storage.am.rtree.impls.SearchPredicate;
import org.apache.hyracks.storage.common.file.IFileMapProvider;

public class LSMRTreeWithAntiMatterTuples
extends AbstractLSMRTree {
    private final ILSMDiskComponentFactory bulkLoaComponentFactory;

    public LSMRTreeWithAntiMatterTuples(IIOManager ioManager, List<IVirtualBufferCache> virtualBufferCaches, ITreeIndexFrameFactory rtreeInteriorFrameFactory, ITreeIndexFrameFactory rtreeLeafFrameFactory, ITreeIndexFrameFactory btreeInteriorFrameFactory, ITreeIndexFrameFactory btreeLeafFrameFactory, ILSMIndexFileManager fileManager, TreeIndexFactory<RTree> diskRTreeFactory, TreeIndexFactory<RTree> bulkLoadRTreeFactory, ILSMComponentFilterFactory filterFactory, ILSMComponentFilterFrameFactory filterFrameFactory, LSMComponentFilterManager filterManager, IFileMapProvider diskFileMapProvider, int fieldCount, IBinaryComparatorFactory[] rtreeCmpFactories, IBinaryComparatorFactory[] btreeCmpFactories, ILinearizeComparatorFactory linearizer, int[] comparatorFields, IBinaryComparatorFactory[] linearizerArray, ILSMMergePolicy mergePolicy, ILSMOperationTracker opTracker, ILSMIOOperationScheduler ioScheduler, ILSMIOOperationCallback ioOpCallback, int[] rtreeFields, int[] filterFields, boolean durable, boolean isPointMBR) throws HyracksDataException {
        super(ioManager, virtualBufferCaches, rtreeInteriorFrameFactory, rtreeLeafFrameFactory, btreeInteriorFrameFactory, btreeLeafFrameFactory, fileManager, new LSMRTreeWithAntiMatterTuplesDiskComponentFactory(diskRTreeFactory, filterFactory), diskFileMapProvider, fieldCount, rtreeCmpFactories, btreeCmpFactories, linearizer, comparatorFields, linearizerArray, 0.0, mergePolicy, opTracker, ioScheduler, ioOpCallback, filterFactory, filterFrameFactory, filterManager, rtreeFields, filterFields, durable, isPointMBR, diskRTreeFactory.getBufferCache());
        this.bulkLoaComponentFactory = new LSMRTreeWithAntiMatterTuplesDiskComponentFactory(bulkLoadRTreeFactory, filterFactory);
    }

    @Override
    public synchronized void activate() throws HyracksDataException {
        List validFileReferences;
        super.activate();
        List immutableComponents = this.diskComponents;
        immutableComponents.clear();
        try {
            validFileReferences = this.fileManager.cleanupAndGetValidFiles();
        }
        catch (IndexException e) {
            throw new HyracksDataException((Throwable)e);
        }
        for (LSMComponentFileReferences lsmComonentFileReference : validFileReferences) {
            LSMRTreeDiskComponent component;
            try {
                component = this.createDiskComponent(this.componentFactory, lsmComonentFileReference.getInsertIndexFileReference(), null, null, false);
            }
            catch (IndexException e) {
                throw new HyracksDataException((Throwable)e);
            }
            immutableComponents.add(component);
        }
        this.isActivated = true;
    }

    @Override
    public synchronized void deactivate(boolean flushOnExit) throws HyracksDataException {
        super.deactivate(flushOnExit);
        List immutableComponents = this.diskComponents;
        for (ILSMDiskComponent c : immutableComponents) {
            RTree rtree = ((LSMRTreeDiskComponent)c).getRTree();
            rtree.deactivateCloseHandle();
        }
        this.isActivated = false;
    }

    public synchronized void deactivate() throws HyracksDataException {
        this.deactivate(true);
    }

    @Override
    public synchronized void destroy() throws HyracksDataException {
        super.destroy();
        List immutableComponents = this.diskComponents;
        for (ILSMDiskComponent c : immutableComponents) {
            RTree rtree = ((LSMRTreeDiskComponent)c).getRTree();
            rtree.destroy();
        }
        this.fileManager.deleteDirs();
    }

    @Override
    public synchronized void clear() throws HyracksDataException {
        super.clear();
        List immutableComponents = this.diskComponents;
        for (ILSMDiskComponent c : immutableComponents) {
            RTree rtree = ((LSMRTreeDiskComponent)c).getRTree();
            rtree.deactivate();
            rtree.destroy();
        }
        immutableComponents.clear();
    }

    public void scheduleFlush(ILSMIndexOperationContext ctx, ILSMIOOperationCallback callback) throws HyracksDataException {
        ILSMComponent flushingComponent = (ILSMComponent)ctx.getComponentHolder().get(0);
        LSMRTreeOpContext opCtx = this.createOpContext((IModificationOperationCallback)NoOpOperationCallback.INSTANCE, (ISearchOperationCallback)NoOpOperationCallback.INSTANCE);
        LSMComponentFileReferences relFlushFileRefs = this.fileManager.getRelFlushFileReference();
        opCtx.setOperation(IndexOperation.FLUSH);
        opCtx.getComponentHolder().add(flushingComponent);
        LSMRTreeWithAntiMatterTuplesAccessor accessor = new LSMRTreeWithAntiMatterTuplesAccessor(this.lsmHarness, (ILSMIndexOperationContext)opCtx);
        this.ioScheduler.scheduleOperation((ILSMIOOperation)new LSMRTreeFlushOperation((ILSMIndexAccessor)accessor, flushingComponent, relFlushFileRefs.getInsertIndexFileReference(), null, null, callback, this.fileManager.getBaseDir()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ILSMDiskComponent flush(ILSMIOOperation operation) throws HyracksDataException, IndexException {
        LSMRTreeFlushOperation flushOp = (LSMRTreeFlushOperation)operation;
        LSMRTreeMemoryComponent flushingComponent = (LSMRTreeMemoryComponent)flushOp.getFlushingComponent();
        ITreeIndexAccessor memRTreeAccessor = flushingComponent.getRTree().createAccessor((IModificationOperationCallback)NoOpOperationCallback.INSTANCE, (ISearchOperationCallback)NoOpOperationCallback.INSTANCE);
        RTreeSearchCursor rtreeScanCursor = (RTreeSearchCursor)memRTreeAccessor.createSearchCursor(false);
        SearchPredicate rtreeNullPredicate = new SearchPredicate(null, null);
        memRTreeAccessor.search((IIndexCursor)rtreeScanCursor, (ISearchPredicate)rtreeNullPredicate);
        LSMRTreeDiskComponent component = this.createDiskComponent(this.componentFactory, flushOp.getRTreeFlushTarget(), null, null, true);
        RTree diskRTree = component.getRTree();
        ITreeIndexAccessor memBTreeAccessor = flushingComponent.getBTree().createAccessor((IModificationOperationCallback)NoOpOperationCallback.INSTANCE, (ISearchOperationCallback)NoOpOperationCallback.INSTANCE);
        BTreeRangeSearchCursor btreeScanCursor = (BTreeRangeSearchCursor)memBTreeAccessor.createSearchCursor(false);
        RangePredicate btreeNullPredicate = new RangePredicate(null, null, true, true, null, null);
        memBTreeAccessor.search((IIndexCursor)btreeScanCursor, (ISearchPredicate)btreeNullPredicate);
        TreeTupleSorter rTreeTupleSorter = new TreeTupleSorter(flushingComponent.getRTree().getFileId(), this.linearizerArray, this.rtreeLeafFrameFactory.createFrame(), this.rtreeLeafFrameFactory.createFrame(), flushingComponent.getRTree().getBufferCache(), this.comparatorFields);
        TreeTupleSorter bTreeTupleSorter = new TreeTupleSorter(flushingComponent.getBTree().getFileId(), this.linearizerArray, this.btreeLeafFrameFactory.createFrame(), this.btreeLeafFrameFactory.createFrame(), flushingComponent.getBTree().getBufferCache(), this.comparatorFields);
        boolean isEmpty = true;
        try {
            while (rtreeScanCursor.hasNext()) {
                isEmpty = false;
                rtreeScanCursor.next();
                rTreeTupleSorter.insertTupleEntry(rtreeScanCursor.getPageId(), rtreeScanCursor.getTupleOffset());
            }
        }
        finally {
            rtreeScanCursor.close();
        }
        if (!isEmpty) {
            rTreeTupleSorter.sort();
        }
        isEmpty = true;
        try {
            while (btreeScanCursor.hasNext()) {
                isEmpty = false;
                btreeScanCursor.next();
                bTreeTupleSorter.insertTupleEntry(btreeScanCursor.getPageId(), btreeScanCursor.getTupleOffset());
            }
        }
        finally {
            btreeScanCursor.close();
        }
        if (!isEmpty) {
            bTreeTupleSorter.sort();
        }
        IIndexBulkLoader rTreeBulkloader = diskRTree.createBulkLoader(1.0f, false, 0L, false);
        cursor.open(null, null);
        try (LSMRTreeWithAntiMatterTuplesFlushCursor cursor = new LSMRTreeWithAntiMatterTuplesFlushCursor(rTreeTupleSorter, bTreeTupleSorter, this.comparatorFields, this.linearizerArray);){
            while (cursor.hasNext()) {
                cursor.next();
                ITupleReference frameTuple = cursor.getTuple();
                rTreeBulkloader.add(frameTuple);
            }
        }
        if (component.getLSMComponentFilter() != null) {
            ArrayList<ITupleReference> filterTuples = new ArrayList<ITupleReference>();
            filterTuples.add(flushingComponent.getLSMComponentFilter().getMinTuple());
            filterTuples.add(flushingComponent.getLSMComponentFilter().getMaxTuple());
            this.filterManager.updateFilter(component.getLSMComponentFilter(), filterTuples);
            this.filterManager.writeFilter(component.getLSMComponentFilter(), (ITreeIndex)component.getRTree());
        }
        flushingComponent.getMetadata().copy(component.getMetadata());
        rTreeBulkloader.end();
        return component;
    }

    public void scheduleMerge(ILSMIndexOperationContext ctx, ILSMIOOperationCallback callback) throws HyracksDataException, IndexException {
        LSMRTreeOpContext rctx = this.createOpContext((IModificationOperationCallback)NoOpOperationCallback.INSTANCE, (ISearchOperationCallback)NoOpOperationCallback.INSTANCE);
        rctx.setOperation(IndexOperation.MERGE);
        List mergingComponents = ctx.getComponentHolder();
        boolean returnDeletedTuples = false;
        if (ctx.getComponentHolder().get(ctx.getComponentHolder().size() - 1) != this.diskComponents.get(this.diskComponents.size() - 1)) {
            returnDeletedTuples = true;
        }
        LSMRTreeWithAntiMatterTuplesSearchCursor cursor = new LSMRTreeWithAntiMatterTuplesSearchCursor((ILSMIndexOperationContext)rctx, returnDeletedTuples);
        LSMComponentFileReferences relMergeFileRefs = this.getMergeTargetFileName(mergingComponents);
        LSMRTreeWithAntiMatterTuplesAccessor accessor = new LSMRTreeWithAntiMatterTuplesAccessor(this.lsmHarness, (ILSMIndexOperationContext)rctx);
        this.ioScheduler.scheduleOperation((ILSMIOOperation)new LSMRTreeMergeOperation((ILSMIndexAccessor)accessor, mergingComponents, (ITreeIndexCursor)cursor, relMergeFileRefs.getInsertIndexFileReference(), null, null, callback, this.fileManager.getBaseDir()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ILSMDiskComponent merge(ILSMIOOperation operation) throws HyracksDataException, IndexException {
        LSMRTreeMergeOperation mergeOp = (LSMRTreeMergeOperation)operation;
        ITreeIndexCursor cursor = mergeOp.getCursor();
        SearchPredicate rtreeSearchPred = new SearchPredicate(null, null);
        ILSMIndexOperationContext opCtx = ((LSMIndexSearchCursor)cursor).getOpCtx();
        opCtx.getComponentHolder().addAll(mergeOp.getMergingComponents());
        this.search(opCtx, (IIndexCursor)cursor, (ISearchPredicate)rtreeSearchPred);
        LSMRTreeDiskComponent component = this.createDiskComponent(this.componentFactory, mergeOp.getRTreeMergeTarget(), null, null, true);
        RTree mergedRTree = component.getRTree();
        IIndexBulkLoader bulkloader = mergedRTree.createBulkLoader(1.0f, false, 0L, false);
        try {
            while (cursor.hasNext()) {
                cursor.next();
                ITupleReference frameTuple = cursor.getTuple();
                bulkloader.add(frameTuple);
            }
        }
        finally {
            cursor.close();
        }
        if (component.getLSMComponentFilter() != null) {
            ArrayList<ITupleReference> filterTuples = new ArrayList<ITupleReference>();
            for (int i = 0; i < mergeOp.getMergingComponents().size(); ++i) {
                filterTuples.add(mergeOp.getMergingComponents().get(i).getLSMComponentFilter().getMinTuple());
                filterTuples.add(mergeOp.getMergingComponents().get(i).getLSMComponentFilter().getMaxTuple());
            }
            this.filterManager.updateFilter(component.getLSMComponentFilter(), filterTuples);
            this.filterManager.writeFilter(component.getLSMComponentFilter(), (ITreeIndex)component.getRTree());
        }
        bulkloader.end();
        return component;
    }

    public ILSMIndexAccessor createAccessor(IModificationOperationCallback modificationCallback, ISearchOperationCallback searchCallback) {
        return new LSMRTreeWithAntiMatterTuplesAccessor(this.lsmHarness, (ILSMIndexOperationContext)this.createOpContext(modificationCallback, searchCallback));
    }

    public IIndexBulkLoader createBulkLoader(float fillLevel, boolean verifyInput, long numElementsHint, boolean checkIfEmptyIndex) throws TreeIndexException {
        try {
            return new LSMRTreeWithAntiMatterTuplesBulkLoader(fillLevel, verifyInput, numElementsHint, checkIfEmptyIndex);
        }
        catch (HyracksDataException e) {
            throw new TreeIndexException((Exception)((Object)e));
        }
    }

    public void markAsValid(ILSMDiskComponent lsmComponent) throws HyracksDataException {
        RTree rtree = ((LSMRTreeDiskComponent)lsmComponent).getRTree();
        this.markAsValidInternal((ITreeIndex)rtree);
    }

    public Set<String> getLSMComponentPhysicalFiles(ILSMComponent lsmComponent) {
        HashSet<String> files = new HashSet<String>();
        RTree rtree = ((LSMRTreeDiskComponent)lsmComponent).getRTree();
        files.add(rtree.getFileReference().getFile().getAbsolutePath());
        return files;
    }

    public class LSMRTreeWithAntiMatterTuplesBulkLoader
    implements IIndexBulkLoader {
        private final ILSMDiskComponent component;
        private final IIndexBulkLoader bulkLoader;
        private boolean cleanedUpArtifacts = false;
        private boolean isEmptyComponent = true;
        public final PermutingTupleReference indexTuple;
        public final PermutingTupleReference filterTuple;
        public final MultiComparator filterCmp;

        public LSMRTreeWithAntiMatterTuplesBulkLoader(float fillFactor, boolean verifyInput, long numElementsHint, boolean checkIfEmptyIndex) throws TreeIndexException, HyracksDataException {
            if (checkIfEmptyIndex && !LSMRTreeWithAntiMatterTuples.this.isEmptyIndex()) {
                throw new TreeIndexException("Cannot load an index that is not empty");
            }
            try {
                this.component = this.createBulkLoadTarget();
            }
            catch (HyracksDataException | IndexException e) {
                throw new TreeIndexException((Exception)e);
            }
            this.bulkLoader = ((LSMRTreeDiskComponent)this.component).getRTree().createBulkLoader(fillFactor, verifyInput, numElementsHint, false);
            if (LSMRTreeWithAntiMatterTuples.this.filterFields != null) {
                this.indexTuple = new PermutingTupleReference(LSMRTreeWithAntiMatterTuples.this.rtreeFields);
                this.filterCmp = MultiComparator.create((IBinaryComparatorFactory[])this.component.getLSMComponentFilter().getFilterCmpFactories());
                this.filterTuple = new PermutingTupleReference(LSMRTreeWithAntiMatterTuples.this.filterFields);
            } else {
                this.indexTuple = null;
                this.filterCmp = null;
                this.filterTuple = null;
            }
        }

        public void add(ITupleReference tuple) throws HyracksDataException, IndexException {
            try {
                ITupleReference t;
                if (this.indexTuple != null) {
                    this.indexTuple.reset(tuple);
                    t = this.indexTuple;
                } else {
                    t = tuple;
                }
                this.bulkLoader.add(t);
                if (this.filterTuple != null) {
                    this.filterTuple.reset(tuple);
                    this.component.getLSMComponentFilter().update((ITupleReference)this.filterTuple, this.filterCmp);
                }
            }
            catch (RuntimeException | HyracksDataException | IndexException e) {
                this.cleanupArtifacts();
                throw e;
            }
            if (this.isEmptyComponent) {
                this.isEmptyComponent = false;
            }
        }

        public void end() throws HyracksDataException, IndexException {
            if (!this.cleanedUpArtifacts) {
                if (this.component.getLSMComponentFilter() != null) {
                    LSMRTreeWithAntiMatterTuples.this.filterManager.writeFilter(this.component.getLSMComponentFilter(), (ITreeIndex)((LSMRTreeDiskComponent)this.component).getRTree());
                }
                this.bulkLoader.end();
                if (this.isEmptyComponent) {
                    this.cleanupArtifacts();
                } else {
                    LSMRTreeWithAntiMatterTuples.this.ioOpCallback.afterOperation(LSMOperationType.FLUSH, null, this.component);
                    LSMRTreeWithAntiMatterTuples.this.lsmHarness.addBulkLoadedComponent(this.component);
                }
            }
        }

        public void abort() throws HyracksDataException {
            if (this.bulkLoader != null) {
                this.bulkLoader.abort();
            }
        }

        protected void cleanupArtifacts() throws HyracksDataException {
            if (!this.cleanedUpArtifacts) {
                this.cleanedUpArtifacts = true;
                ((LSMRTreeDiskComponent)this.component).getRTree().deactivate();
                ((LSMRTreeDiskComponent)this.component).getRTree().destroy();
            }
        }

        private ILSMDiskComponent createBulkLoadTarget() throws HyracksDataException, IndexException {
            LSMComponentFileReferences relFlushFileRefs = LSMRTreeWithAntiMatterTuples.this.fileManager.getRelFlushFileReference();
            return LSMRTreeWithAntiMatterTuples.this.createDiskComponent(LSMRTreeWithAntiMatterTuples.this.bulkLoaComponentFactory, relFlushFileRefs.getInsertIndexFileReference(), null, null, true);
        }
    }

    public class LSMRTreeWithAntiMatterTuplesAccessor
    extends LSMTreeIndexAccessor {
        public LSMRTreeWithAntiMatterTuplesAccessor(ILSMHarness lsmHarness, ILSMIndexOperationContext ctx) {
            super(lsmHarness, ctx);
        }

        public ITreeIndexCursor createSearchCursor(boolean exclusive) {
            return new LSMRTreeWithAntiMatterTuplesSearchCursor(this.ctx);
        }

        public MultiComparator getMultiComparator() {
            LSMRTreeOpContext concreteCtx = (LSMRTreeOpContext)this.ctx;
            return concreteCtx.currentRTreeOpContext.cmp;
        }
    }
}

