/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.rtree.impls;

import org.apache.hyracks.api.dataflow.value.ILinearizeComparator;
import org.apache.hyracks.api.dataflow.value.ILinearizeComparatorFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.common.api.ICursorInitialState;
import org.apache.hyracks.storage.am.common.api.IIndexCursor;
import org.apache.hyracks.storage.am.common.api.ISearchPredicate;
import org.apache.hyracks.storage.am.common.api.IndexException;
import org.apache.hyracks.storage.am.common.tuples.PermutingTupleReference;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexOperationContext;
import org.apache.hyracks.storage.am.lsm.rtree.impls.LSMRTreeAbstractCursor;

public class LSMRTreeSortedCursor
extends LSMRTreeAbstractCursor {
    private ILinearizeComparator linearizeCmp;
    private boolean[] depletedRtreeCursors;
    private int foundIn = -1;
    private PermutingTupleReference btreeTuple;

    public LSMRTreeSortedCursor(ILSMIndexOperationContext opCtx, ILinearizeComparatorFactory linearizer, int[] buddyBTreeFields) throws HyracksDataException {
        super(opCtx);
        this.linearizeCmp = linearizer.createBinaryComparator();
        this.btreeTuple = new PermutingTupleReference(buddyBTreeFields);
        this.reset();
    }

    public ILSMIndexOperationContext getOpCtx() {
        return this.opCtx;
    }

    public void reset() throws HyracksDataException {
        this.depletedRtreeCursors = new boolean[this.numberOfTrees];
        this.foundNext = false;
        try {
            for (int i = 0; i < this.numberOfTrees; ++i) {
                this.rtreeCursors[i].reset();
                try {
                    this.rtreeAccessors[i].search((IIndexCursor)this.rtreeCursors[i], (ISearchPredicate)this.rtreeSearchPredicate);
                }
                catch (IndexException e) {
                    throw new HyracksDataException((Throwable)e);
                }
                if (this.rtreeCursors[i].hasNext()) {
                    this.rtreeCursors[i].next();
                    continue;
                }
                this.depletedRtreeCursors[i] = true;
            }
        }
        finally {
            if (this.open) {
                this.lsmHarness.endSearch(this.opCtx);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasNext() throws HyracksDataException, IndexException {
        while (!this.foundNext) {
            this.frameTuple = null;
            if (this.foundIn != -1) {
                if (this.rtreeCursors[this.foundIn].hasNext()) {
                    this.rtreeCursors[this.foundIn].next();
                } else {
                    this.depletedRtreeCursors[this.foundIn] = true;
                }
            }
            this.foundIn = -1;
            for (int i = 0; i < this.numberOfTrees; ++i) {
                if (this.depletedRtreeCursors[i]) continue;
                if (this.frameTuple == null) {
                    this.frameTuple = this.rtreeCursors[i].getTuple();
                    this.foundIn = i;
                    continue;
                }
                if (this.linearizeCmp.compare(this.frameTuple.getFieldData(0), this.frameTuple.getFieldStart(0), this.frameTuple.getFieldLength(0) * this.linearizeCmp.getDimensions(), this.rtreeCursors[i].getTuple().getFieldData(0), this.rtreeCursors[i].getTuple().getFieldStart(0), this.rtreeCursors[i].getTuple().getFieldLength(0) * this.linearizeCmp.getDimensions()) <= 0) continue;
                this.frameTuple = this.rtreeCursors[i].getTuple();
                this.foundIn = i;
            }
            if (this.foundIn == -1) {
                return false;
            }
            boolean killed = false;
            this.btreeTuple.reset(this.frameTuple);
            for (int i = 0; i < this.foundIn; ++i) {
                try {
                    this.btreeCursors[i].reset();
                    this.btreeRangePredicate.setHighKey((ITupleReference)this.btreeTuple, true);
                    this.btreeRangePredicate.setLowKey((ITupleReference)this.btreeTuple, true);
                    this.btreeAccessors[i].search((IIndexCursor)this.btreeCursors[i], (ISearchPredicate)this.btreeRangePredicate);
                }
                catch (IndexException e) {
                    throw new HyracksDataException((Throwable)e);
                }
                try {
                    if (!this.btreeCursors[i].hasNext()) continue;
                    killed = true;
                    break;
                }
                finally {
                    this.btreeCursors[i].close();
                }
            }
            if (killed) continue;
            this.foundNext = true;
        }
        return true;
    }

    public void next() throws HyracksDataException {
        this.foundNext = false;
    }

    @Override
    public void open(ICursorInitialState initialState, ISearchPredicate searchPred) throws HyracksDataException {
        super.open(initialState, searchPred);
        this.depletedRtreeCursors = new boolean[this.numberOfTrees];
        this.foundNext = false;
        for (int i = 0; i < this.numberOfTrees; ++i) {
            this.rtreeCursors[i].reset();
            try {
                this.rtreeAccessors[i].search((IIndexCursor)this.rtreeCursors[i], (ISearchPredicate)this.rtreeSearchPredicate);
            }
            catch (IndexException e) {
                throw new HyracksDataException((Throwable)e);
            }
            if (this.rtreeCursors[i].hasNext()) {
                this.rtreeCursors[i].next();
                continue;
            }
            this.depletedRtreeCursors[i] = true;
        }
    }
}

