/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.rtree.impls;

import java.util.LinkedList;
import java.util.List;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.storage.am.btree.impls.BTree;
import org.apache.hyracks.storage.am.btree.impls.BTreeOpContext;
import org.apache.hyracks.storage.am.common.api.IModificationOperationCallback;
import org.apache.hyracks.storage.am.common.api.ISearchOperationCallback;
import org.apache.hyracks.storage.am.common.api.ISearchPredicate;
import org.apache.hyracks.storage.am.common.api.ITreeIndexFrameFactory;
import org.apache.hyracks.storage.am.common.impls.NoOpOperationCallback;
import org.apache.hyracks.storage.am.common.ophelpers.IndexOperation;
import org.apache.hyracks.storage.am.common.ophelpers.MultiComparator;
import org.apache.hyracks.storage.am.common.tuples.PermutingTupleReference;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMDiskComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMHarness;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMMemoryComponent;
import org.apache.hyracks.storage.am.lsm.common.impls.AbstractLSMIndexOperationContext;
import org.apache.hyracks.storage.am.lsm.rtree.impls.LSMRTreeCursorInitialState;
import org.apache.hyracks.storage.am.lsm.rtree.impls.LSMRTreeMemoryComponent;
import org.apache.hyracks.storage.am.rtree.impls.RTree;
import org.apache.hyracks.storage.am.rtree.impls.RTreeOpContext;

public final class LSMRTreeOpContext
extends AbstractLSMIndexOperationContext {
    public RTree.RTreeAccessor[] mutableRTreeAccessors;
    public RTree.RTreeAccessor currentMutableRTreeAccessor;
    public BTree.BTreeAccessor[] mutableBTreeAccessors;
    public BTree.BTreeAccessor currentMutableBTreeAccessor;
    public RTreeOpContext[] rtreeOpContexts;
    public BTreeOpContext[] btreeOpContexts;
    public RTreeOpContext currentRTreeOpContext;
    public BTreeOpContext currentBTreeOpContext;
    private IndexOperation op;
    public final List<ILSMComponent> componentHolder;
    private final List<ILSMDiskComponent> componentsToBeMerged;
    private final List<ILSMDiskComponent> componentsToBeReplicated;
    private IModificationOperationCallback modificationCallback;
    private ISearchOperationCallback searchCallback;
    public final PermutingTupleReference indexTuple;
    public final MultiComparator filterCmp;
    public final PermutingTupleReference filterTuple;
    public ISearchPredicate searchPredicate;
    public LSMRTreeCursorInitialState searchInitialState;

    public LSMRTreeOpContext(List<ILSMMemoryComponent> mutableComponents, ITreeIndexFrameFactory rtreeLeafFrameFactory, ITreeIndexFrameFactory rtreeInteriorFrameFactory, ITreeIndexFrameFactory btreeLeafFrameFactory, IModificationOperationCallback modificationCallback, ISearchOperationCallback searchCallback, int[] rtreeFields, int[] filterFields, ILSMHarness lsmHarness, int[] comparatorFields, IBinaryComparatorFactory[] linearizerArray) {
        this.mutableRTreeAccessors = new RTree.RTreeAccessor[mutableComponents.size()];
        this.mutableBTreeAccessors = new BTree.BTreeAccessor[mutableComponents.size()];
        this.rtreeOpContexts = new RTreeOpContext[mutableComponents.size()];
        this.btreeOpContexts = new BTreeOpContext[mutableComponents.size()];
        LSMRTreeMemoryComponent c = (LSMRTreeMemoryComponent)mutableComponents.get(0);
        for (int i = 0; i < mutableComponents.size(); ++i) {
            LSMRTreeMemoryComponent mutableComponent = (LSMRTreeMemoryComponent)mutableComponents.get(i);
            this.mutableRTreeAccessors[i] = (RTree.RTreeAccessor)mutableComponent.getRTree().createAccessor((IModificationOperationCallback)NoOpOperationCallback.INSTANCE, (ISearchOperationCallback)NoOpOperationCallback.INSTANCE);
            this.mutableBTreeAccessors[i] = (BTree.BTreeAccessor)mutableComponent.getBTree().createAccessor((IModificationOperationCallback)NoOpOperationCallback.INSTANCE, (ISearchOperationCallback)NoOpOperationCallback.INSTANCE);
            this.rtreeOpContexts[i] = this.mutableRTreeAccessors[i].getOpContext();
            this.btreeOpContexts[i] = this.mutableBTreeAccessors[i].getOpContext();
        }
        assert (mutableComponents.size() > 0);
        this.currentRTreeOpContext = this.rtreeOpContexts[0];
        this.currentBTreeOpContext = this.btreeOpContexts[0];
        this.componentHolder = new LinkedList<ILSMComponent>();
        this.componentsToBeMerged = new LinkedList<ILSMDiskComponent>();
        this.componentsToBeReplicated = new LinkedList<ILSMDiskComponent>();
        this.modificationCallback = modificationCallback;
        this.searchCallback = searchCallback;
        if (filterFields != null) {
            this.indexTuple = new PermutingTupleReference(rtreeFields);
            this.filterCmp = MultiComparator.create((IBinaryComparatorFactory[])c.getLSMComponentFilter().getFilterCmpFactories());
            this.filterTuple = new PermutingTupleReference(filterFields);
        } else {
            this.indexTuple = null;
            this.filterCmp = null;
            this.filterTuple = null;
        }
        this.searchInitialState = new LSMRTreeCursorInitialState(rtreeLeafFrameFactory, rtreeInteriorFrameFactory, btreeLeafFrameFactory, this.getBTreeMultiComparator(), lsmHarness, comparatorFields, linearizerArray, searchCallback, this.componentHolder);
    }

    public void setOperation(IndexOperation newOp) {
        this.reset();
        this.op = newOp;
    }

    public void setCurrentMutableComponentId(int currentMutableComponentId) {
        this.currentMutableRTreeAccessor = this.mutableRTreeAccessors[currentMutableComponentId];
        this.currentMutableBTreeAccessor = this.mutableBTreeAccessors[currentMutableComponentId];
        this.currentRTreeOpContext = this.rtreeOpContexts[currentMutableComponentId];
        this.currentBTreeOpContext = this.btreeOpContexts[currentMutableComponentId];
        if (this.op == IndexOperation.INSERT) {
            this.currentRTreeOpContext.setOperation(this.op);
        } else if (this.op == IndexOperation.DELETE) {
            this.currentBTreeOpContext.setOperation(IndexOperation.INSERT);
        }
    }

    public void reset() {
        super.reset();
        this.componentHolder.clear();
        this.componentsToBeMerged.clear();
    }

    public IndexOperation getOperation() {
        return this.op;
    }

    public MultiComparator getBTreeMultiComparator() {
        return this.currentBTreeOpContext.cmp;
    }

    public List<ILSMComponent> getComponentHolder() {
        return this.componentHolder;
    }

    public ISearchOperationCallback getSearchOperationCallback() {
        return this.searchCallback;
    }

    public IModificationOperationCallback getModificationCallback() {
        return this.modificationCallback;
    }

    public List<ILSMDiskComponent> getComponentsToBeMerged() {
        return this.componentsToBeMerged;
    }

    public void setSearchPredicate(ISearchPredicate searchPredicate) {
        this.searchPredicate = searchPredicate;
    }

    public ISearchPredicate getSearchPredicate() {
        return this.searchPredicate;
    }

    public List<ILSMDiskComponent> getComponentsToBeReplicated() {
        return this.componentsToBeReplicated;
    }
}

