/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.rtree.impls;

import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.storage.am.bloomfilter.impls.BloomFilterFactory;
import org.apache.hyracks.storage.am.btree.impls.BTree;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponentFilterFactory;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMDiskComponentFactory;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMComponentFileReferences;
import org.apache.hyracks.storage.am.lsm.common.impls.TreeIndexFactory;
import org.apache.hyracks.storage.am.lsm.rtree.impls.LSMRTreeDiskComponent;
import org.apache.hyracks.storage.am.rtree.impls.RTree;

public class LSMRTreeDiskComponentFactory
implements ILSMDiskComponentFactory {
    private final TreeIndexFactory<RTree> rtreeFactory;
    private final TreeIndexFactory<BTree> btreeFactory;
    private final BloomFilterFactory bloomFilterFactory;
    private final ILSMComponentFilterFactory filterFactory;

    public LSMRTreeDiskComponentFactory(TreeIndexFactory<RTree> rtreeFactory, TreeIndexFactory<BTree> btreeFactory, BloomFilterFactory bloomFilterFactory, ILSMComponentFilterFactory filterFactory) {
        this.rtreeFactory = rtreeFactory;
        this.btreeFactory = btreeFactory;
        this.bloomFilterFactory = bloomFilterFactory;
        this.filterFactory = filterFactory;
    }

    public LSMRTreeDiskComponent createComponent(LSMComponentFileReferences cfr) throws HyracksDataException {
        return new LSMRTreeDiskComponent((RTree)this.rtreeFactory.createIndexInstance(cfr.getInsertIndexFileReference()), (BTree)this.btreeFactory.createIndexInstance(cfr.getDeleteIndexFileReference()), this.bloomFilterFactory.createBloomFiltertInstance(cfr.getBloomFilterFileReference()), this.filterFactory == null ? null : this.filterFactory.createFilter());
    }
}

