/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.rtree.impls;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.dataflow.value.ILinearizeComparatorFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.IIOManager;
import org.apache.hyracks.data.std.primitive.IntegerPointable;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.bloomfilter.impls.BloomCalculations;
import org.apache.hyracks.storage.am.bloomfilter.impls.BloomFilter;
import org.apache.hyracks.storage.am.bloomfilter.impls.BloomFilterFactory;
import org.apache.hyracks.storage.am.bloomfilter.impls.BloomFilterSpecification;
import org.apache.hyracks.storage.am.btree.impls.BTree;
import org.apache.hyracks.storage.am.btree.impls.RangePredicate;
import org.apache.hyracks.storage.am.common.api.IIndexBulkLoader;
import org.apache.hyracks.storage.am.common.api.IIndexCursor;
import org.apache.hyracks.storage.am.common.api.IIndexOperationContext;
import org.apache.hyracks.storage.am.common.api.IModificationOperationCallback;
import org.apache.hyracks.storage.am.common.api.ISearchOperationCallback;
import org.apache.hyracks.storage.am.common.api.ISearchPredicate;
import org.apache.hyracks.storage.am.common.api.ITreeIndex;
import org.apache.hyracks.storage.am.common.api.ITreeIndexAccessor;
import org.apache.hyracks.storage.am.common.api.ITreeIndexCursor;
import org.apache.hyracks.storage.am.common.api.ITreeIndexFrameFactory;
import org.apache.hyracks.storage.am.common.api.IndexException;
import org.apache.hyracks.storage.am.common.api.TreeIndexException;
import org.apache.hyracks.storage.am.common.exceptions.TreeIndexDuplicateKeyException;
import org.apache.hyracks.storage.am.common.impls.NoOpOperationCallback;
import org.apache.hyracks.storage.am.common.ophelpers.IndexOperation;
import org.apache.hyracks.storage.am.common.ophelpers.MultiComparator;
import org.apache.hyracks.storage.am.common.tuples.DualTupleReference;
import org.apache.hyracks.storage.am.common.tuples.PermutingTupleReference;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponentFilterFactory;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponentFilterFrameFactory;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMDiskComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMHarness;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperation;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationCallback;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationScheduler;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexAccessor;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexFileManager;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexOperationContext;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMMemoryComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMMergePolicy;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMOperationTracker;
import org.apache.hyracks.storage.am.lsm.common.api.IVirtualBufferCache;
import org.apache.hyracks.storage.am.lsm.common.api.LSMOperationType;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMComponentFileReferences;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMComponentFilterManager;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMTreeIndexAccessor;
import org.apache.hyracks.storage.am.lsm.common.impls.TreeIndexFactory;
import org.apache.hyracks.storage.am.lsm.rtree.impls.AbstractLSMRTree;
import org.apache.hyracks.storage.am.lsm.rtree.impls.LSMRTreeDeletedKeysBTreeMergeCursor;
import org.apache.hyracks.storage.am.lsm.rtree.impls.LSMRTreeDiskComponent;
import org.apache.hyracks.storage.am.lsm.rtree.impls.LSMRTreeDiskComponentFactory;
import org.apache.hyracks.storage.am.lsm.rtree.impls.LSMRTreeFlushOperation;
import org.apache.hyracks.storage.am.lsm.rtree.impls.LSMRTreeMemoryComponent;
import org.apache.hyracks.storage.am.lsm.rtree.impls.LSMRTreeMergeOperation;
import org.apache.hyracks.storage.am.lsm.rtree.impls.LSMRTreeOpContext;
import org.apache.hyracks.storage.am.lsm.rtree.impls.LSMRTreeSearchCursor;
import org.apache.hyracks.storage.am.lsm.rtree.impls.LSMRTreeSortedCursor;
import org.apache.hyracks.storage.am.lsm.rtree.impls.TreeTupleSorter;
import org.apache.hyracks.storage.am.rtree.impls.RTree;
import org.apache.hyracks.storage.am.rtree.impls.RTreeSearchCursor;
import org.apache.hyracks.storage.am.rtree.impls.SearchPredicate;
import org.apache.hyracks.storage.common.file.IFileMapProvider;

public class LSMRTree
extends AbstractLSMRTree {
    protected int[] buddyBTreeFields;

    public LSMRTree(IIOManager ioManager, List<IVirtualBufferCache> virtualBufferCaches, ITreeIndexFrameFactory rtreeInteriorFrameFactory, ITreeIndexFrameFactory rtreeLeafFrameFactory, ITreeIndexFrameFactory btreeInteriorFrameFactory, ITreeIndexFrameFactory btreeLeafFrameFactory, ILSMIndexFileManager fileNameManager, TreeIndexFactory<RTree> diskRTreeFactory, TreeIndexFactory<BTree> diskBTreeFactory, BloomFilterFactory bloomFilterFactory, ILSMComponentFilterFactory filterFactory, ILSMComponentFilterFrameFactory filterFrameFactory, LSMComponentFilterManager filterManager, double bloomFilterFalsePositiveRate, IFileMapProvider diskFileMapProvider, int fieldCount, IBinaryComparatorFactory[] rtreeCmpFactories, IBinaryComparatorFactory[] btreeCmpFactories, ILinearizeComparatorFactory linearizer, int[] comparatorFields, IBinaryComparatorFactory[] linearizerArray, ILSMMergePolicy mergePolicy, ILSMOperationTracker opTracker, ILSMIOOperationScheduler ioScheduler, ILSMIOOperationCallback ioOpCallback, int[] rtreeFields, int[] buddyBTreeFields, int[] filterFields, boolean durable, boolean isPointMBR) throws HyracksDataException {
        super(ioManager, virtualBufferCaches, rtreeInteriorFrameFactory, rtreeLeafFrameFactory, btreeInteriorFrameFactory, btreeLeafFrameFactory, fileNameManager, new LSMRTreeDiskComponentFactory(diskRTreeFactory, diskBTreeFactory, bloomFilterFactory, filterFactory), diskFileMapProvider, fieldCount, rtreeCmpFactories, btreeCmpFactories, linearizer, comparatorFields, linearizerArray, bloomFilterFalsePositiveRate, mergePolicy, opTracker, ioScheduler, ioOpCallback, filterFactory, filterFrameFactory, filterManager, rtreeFields, filterFields, durable, isPointMBR, diskRTreeFactory.getBufferCache());
        this.buddyBTreeFields = buddyBTreeFields;
    }

    public LSMRTree(IIOManager ioManager, ITreeIndexFrameFactory rtreeInteriorFrameFactory, ITreeIndexFrameFactory rtreeLeafFrameFactory, ITreeIndexFrameFactory btreeInteriorFrameFactory, ITreeIndexFrameFactory btreeLeafFrameFactory, ILSMIndexFileManager fileNameManager, TreeIndexFactory<RTree> diskRTreeFactory, TreeIndexFactory<BTree> diskBTreeFactory, BloomFilterFactory bloomFilterFactory, double bloomFilterFalsePositiveRate, IFileMapProvider diskFileMapProvider, IBinaryComparatorFactory[] rtreeCmpFactories, IBinaryComparatorFactory[] btreeCmpFactories, ILinearizeComparatorFactory linearizer, int[] comparatorFields, IBinaryComparatorFactory[] linearizerArray, ILSMMergePolicy mergePolicy, ILSMOperationTracker opTracker, ILSMIOOperationScheduler ioScheduler, ILSMIOOperationCallback ioOpCallback, int[] buddyBTreeFields, boolean durable, boolean isPointMBR) {
        super(ioManager, rtreeInteriorFrameFactory, rtreeLeafFrameFactory, btreeInteriorFrameFactory, btreeLeafFrameFactory, fileNameManager, new LSMRTreeDiskComponentFactory(diskRTreeFactory, diskBTreeFactory, bloomFilterFactory, null), diskFileMapProvider, rtreeCmpFactories, btreeCmpFactories, linearizer, comparatorFields, linearizerArray, bloomFilterFalsePositiveRate, mergePolicy, opTracker, ioScheduler, ioOpCallback, durable, isPointMBR, diskRTreeFactory.getBufferCache());
        this.buddyBTreeFields = buddyBTreeFields;
    }

    @Override
    public synchronized void activate() throws HyracksDataException {
        List validFileReferences;
        super.activate();
        List immutableComponents = this.diskComponents;
        try {
            validFileReferences = this.fileManager.cleanupAndGetValidFiles();
        }
        catch (IndexException e) {
            throw new HyracksDataException((Throwable)e);
        }
        immutableComponents.clear();
        for (LSMComponentFileReferences lsmComonentFileReference : validFileReferences) {
            LSMRTreeDiskComponent component;
            try {
                component = this.createDiskComponent(this.componentFactory, lsmComonentFileReference.getInsertIndexFileReference(), lsmComonentFileReference.getDeleteIndexFileReference(), lsmComonentFileReference.getBloomFilterFileReference(), false);
            }
            catch (IndexException e) {
                throw new HyracksDataException((Throwable)e);
            }
            immutableComponents.add(component);
        }
        this.isActivated = true;
    }

    @Override
    public synchronized void deactivate(boolean flushOnExit) throws HyracksDataException {
        super.deactivate(flushOnExit);
        List immutableComponents = this.diskComponents;
        for (ILSMDiskComponent c : immutableComponents) {
            LSMRTreeDiskComponent component = (LSMRTreeDiskComponent)c;
            RTree rtree = component.getRTree();
            BTree btree = component.getBTree();
            BloomFilter bloomFilter = component.getBloomFilter();
            rtree.deactivateCloseHandle();
            btree.deactivateCloseHandle();
            bloomFilter.deactivate();
        }
        this.isActivated = false;
    }

    public synchronized void deactivate() throws HyracksDataException {
        this.deactivate(true);
    }

    @Override
    public synchronized void destroy() throws HyracksDataException {
        super.destroy();
        List immutableComponents = this.diskComponents;
        for (ILSMDiskComponent c : immutableComponents) {
            LSMRTreeDiskComponent component = (LSMRTreeDiskComponent)c;
            component.getBTree().destroy();
            component.getBloomFilter().destroy();
            component.getRTree().destroy();
        }
        this.fileManager.deleteDirs();
    }

    @Override
    public synchronized void clear() throws HyracksDataException {
        super.clear();
        List immutableComponents = this.diskComponents;
        for (ILSMDiskComponent c : immutableComponents) {
            LSMRTreeDiskComponent component = (LSMRTreeDiskComponent)c;
            component.getBTree().deactivate();
            component.getBloomFilter().deactivate();
            component.getRTree().deactivate();
            component.getBTree().destroy();
            component.getBloomFilter().destroy();
            component.getRTree().destroy();
        }
        immutableComponents.clear();
    }

    public void scheduleFlush(ILSMIndexOperationContext ctx, ILSMIOOperationCallback callback) throws HyracksDataException {
        ILSMComponent flushingComponent = (ILSMComponent)ctx.getComponentHolder().get(0);
        LSMComponentFileReferences componentFileRefs = this.fileManager.getRelFlushFileReference();
        LSMRTreeOpContext rctx = this.createOpContext((IModificationOperationCallback)NoOpOperationCallback.INSTANCE, (ISearchOperationCallback)NoOpOperationCallback.INSTANCE);
        rctx.setOperation(IndexOperation.FLUSH);
        rctx.getComponentHolder().addAll(ctx.getComponentHolder());
        LSMRTreeAccessor accessor = new LSMRTreeAccessor(this.lsmHarness, (ILSMIndexOperationContext)rctx);
        this.ioScheduler.scheduleOperation((ILSMIOOperation)new LSMRTreeFlushOperation((ILSMIndexAccessor)accessor, flushingComponent, componentFileRefs.getInsertIndexFileReference(), componentFileRefs.getDeleteIndexFileReference(), componentFileRefs.getBloomFilterFileReference(), callback, this.fileManager.getBaseDir()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ILSMDiskComponent flush(ILSMIOOperation operation) throws HyracksDataException, IndexException {
        LSMRTreeFlushOperation flushOp = (LSMRTreeFlushOperation)operation;
        LSMRTreeMemoryComponent flushingComponent = (LSMRTreeMemoryComponent)flushOp.getFlushingComponent();
        ITreeIndexAccessor memRTreeAccessor = flushingComponent.getRTree().createAccessor((IModificationOperationCallback)NoOpOperationCallback.INSTANCE, (ISearchOperationCallback)NoOpOperationCallback.INSTANCE);
        RTreeSearchCursor rtreeScanCursor = (RTreeSearchCursor)memRTreeAccessor.createSearchCursor(false);
        SearchPredicate rtreeNullPredicate = new SearchPredicate(null, null);
        memRTreeAccessor.search((IIndexCursor)rtreeScanCursor, (ISearchPredicate)rtreeNullPredicate);
        LSMRTreeDiskComponent component = this.createDiskComponent(this.componentFactory, flushOp.getRTreeFlushTarget(), flushOp.getBTreeFlushTarget(), flushOp.getBloomFilterFlushTarget(), true);
        RTree diskRTree = component.getRTree();
        IBinaryComparatorFactory[] linearizerArray = new IBinaryComparatorFactory[]{this.linearizer};
        TreeTupleSorter rTreeTupleSorter = new TreeTupleSorter(flushingComponent.getRTree().getFileId(), linearizerArray, this.rtreeLeafFrameFactory.createFrame(), this.rtreeLeafFrameFactory.createFrame(), flushingComponent.getRTree().getBufferCache(), this.comparatorFields);
        boolean isEmpty = true;
        try {
            while (rtreeScanCursor.hasNext()) {
                isEmpty = false;
                rtreeScanCursor.next();
                rTreeTupleSorter.insertTupleEntry(rtreeScanCursor.getPageId(), rtreeScanCursor.getTupleOffset());
            }
        }
        finally {
            rtreeScanCursor.close();
        }
        rTreeTupleSorter.sort();
        IIndexBulkLoader rTreeBulkloader = diskRTree.createBulkLoader(1.0f, false, 0L, false);
        TreeTupleSorter cursor = rTreeTupleSorter;
        if (!isEmpty) {
            try {
                while (cursor.hasNext()) {
                    cursor.next();
                    ITupleReference frameTuple = cursor.getTuple();
                    rTreeBulkloader.add(frameTuple);
                }
            }
            finally {
                cursor.close();
            }
        }
        rTreeBulkloader.end();
        ITreeIndexAccessor memBTreeAccessor = flushingComponent.getBTree().createAccessor((IModificationOperationCallback)NoOpOperationCallback.INSTANCE, (ISearchOperationCallback)NoOpOperationCallback.INSTANCE);
        RangePredicate btreeNullPredicate = new RangePredicate(null, null, true, true, null, null);
        ITreeIndexCursor btreeCountingCursor = ((BTree.BTreeAccessor)memBTreeAccessor).createCountingSearchCursor();
        memBTreeAccessor.search((IIndexCursor)btreeCountingCursor, (ISearchPredicate)btreeNullPredicate);
        long numBTreeTuples = 0L;
        try {
            while (btreeCountingCursor.hasNext()) {
                btreeCountingCursor.next();
                ITupleReference countTuple = btreeCountingCursor.getTuple();
                numBTreeTuples = IntegerPointable.getInteger((byte[])countTuple.getFieldData(0), (int)countTuple.getFieldStart(0));
            }
        }
        finally {
            btreeCountingCursor.close();
        }
        int maxBucketsPerElement = BloomCalculations.maxBucketsPerElement((long)numBTreeTuples);
        BloomFilterSpecification bloomFilterSpec = BloomCalculations.computeBloomSpec((int)maxBucketsPerElement, (double)this.bloomFilterFalsePositiveRate);
        IIndexCursor btreeScanCursor = memBTreeAccessor.createSearchCursor(false);
        memBTreeAccessor.search(btreeScanCursor, (ISearchPredicate)btreeNullPredicate);
        BTree diskBTree = component.getBTree();
        IIndexBulkLoader bTreeBulkloader = diskBTree.createBulkLoader(1.0f, false, numBTreeTuples, false);
        IIndexBulkLoader builder = component.getBloomFilter().createBuilder(numBTreeTuples, bloomFilterSpec.getNumHashes(), bloomFilterSpec.getNumBucketsPerElements());
        try {
            while (btreeScanCursor.hasNext()) {
                btreeScanCursor.next();
                ITupleReference frameTuple = btreeScanCursor.getTuple();
                bTreeBulkloader.add(frameTuple);
                builder.add(frameTuple);
            }
        }
        finally {
            btreeScanCursor.close();
            builder.end();
        }
        if (component.getLSMComponentFilter() != null) {
            ArrayList<ITupleReference> filterTuples = new ArrayList<ITupleReference>();
            filterTuples.add(flushingComponent.getLSMComponentFilter().getMinTuple());
            filterTuples.add(flushingComponent.getLSMComponentFilter().getMaxTuple());
            this.filterManager.updateFilter(component.getLSMComponentFilter(), filterTuples);
            this.filterManager.writeFilter(component.getLSMComponentFilter(), (ITreeIndex)component.getRTree());
        }
        flushingComponent.getMetadata().copy(component.getMetadata());
        bTreeBulkloader.end();
        return component;
    }

    public void scheduleMerge(ILSMIndexOperationContext ctx, ILSMIOOperationCallback callback) throws HyracksDataException, IndexException {
        LSMRTreeOpContext rctx = this.createOpContext((IModificationOperationCallback)NoOpOperationCallback.INSTANCE, (ISearchOperationCallback)NoOpOperationCallback.INSTANCE);
        rctx.setOperation(IndexOperation.MERGE);
        List mergingComponents = ctx.getComponentHolder();
        LSMRTreeSortedCursor cursor = new LSMRTreeSortedCursor((ILSMIndexOperationContext)rctx, this.linearizer, this.buddyBTreeFields);
        LSMComponentFileReferences relMergeFileRefs = this.getMergeTargetFileName(mergingComponents);
        LSMRTreeAccessor accessor = new LSMRTreeAccessor(this.lsmHarness, (ILSMIndexOperationContext)rctx);
        this.ioScheduler.scheduleOperation((ILSMIOOperation)new LSMRTreeMergeOperation((ILSMIndexAccessor)accessor, mergingComponents, cursor, relMergeFileRefs.getInsertIndexFileReference(), relMergeFileRefs.getDeleteIndexFileReference(), relMergeFileRefs.getBloomFilterFileReference(), callback, this.fileManager.getBaseDir()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ILSMDiskComponent merge(ILSMIOOperation operation) throws HyracksDataException, IndexException {
        LSMRTreeMergeOperation mergeOp = (LSMRTreeMergeOperation)operation;
        ITreeIndexCursor cursor = mergeOp.getCursor();
        SearchPredicate rtreeSearchPred = new SearchPredicate(null, null);
        ILSMIndexOperationContext opCtx = ((LSMRTreeSortedCursor)cursor).getOpCtx();
        opCtx.getComponentHolder().addAll(mergeOp.getMergingComponents());
        this.search(opCtx, (IIndexCursor)cursor, (ISearchPredicate)rtreeSearchPred);
        LSMRTreeDiskComponent mergedComponent = this.createDiskComponent(this.componentFactory, mergeOp.getRTreeMergeTarget(), mergeOp.getBTreeMergeTarget(), mergeOp.getBloomFilterMergeTarget(), true);
        BTree btree = mergedComponent.getBTree();
        IIndexBulkLoader btreeBulkLoader = btree.createBulkLoader(1.0f, true, 0L, false);
        if (mergeOp.getMergingComponents().get(mergeOp.getMergingComponents().size() - 1) != this.diskComponents.get(this.diskComponents.size() - 1)) {
            LSMRTreeDeletedKeysBTreeMergeCursor btreeCursor = new LSMRTreeDeletedKeysBTreeMergeCursor(opCtx);
            this.search(opCtx, (IIndexCursor)btreeCursor, (ISearchPredicate)rtreeSearchPred);
            long numElements = 0L;
            for (int i = 0; i < mergeOp.getMergingComponents().size(); ++i) {
                numElements += ((LSMRTreeDiskComponent)mergeOp.getMergingComponents().get(i)).getBloomFilter().getNumElements();
            }
            int maxBucketsPerElement = BloomCalculations.maxBucketsPerElement((long)numElements);
            BloomFilterSpecification bloomFilterSpec = BloomCalculations.computeBloomSpec((int)maxBucketsPerElement, (double)this.bloomFilterFalsePositiveRate);
            IIndexBulkLoader builder = mergedComponent.getBloomFilter().createBuilder(numElements, bloomFilterSpec.getNumHashes(), bloomFilterSpec.getNumBucketsPerElements());
            try {
                while (btreeCursor.hasNext()) {
                    btreeCursor.next();
                    ITupleReference tuple = btreeCursor.getTuple();
                    btreeBulkLoader.add(tuple);
                    builder.add(tuple);
                }
            }
            finally {
                btreeCursor.close();
                builder.end();
            }
        }
        if (mergedComponent.getLSMComponentFilter() != null) {
            ArrayList<ITupleReference> filterTuples = new ArrayList<ITupleReference>();
            for (int i = 0; i < mergeOp.getMergingComponents().size(); ++i) {
                filterTuples.add(mergeOp.getMergingComponents().get(i).getLSMComponentFilter().getMinTuple());
                filterTuples.add(mergeOp.getMergingComponents().get(i).getLSMComponentFilter().getMaxTuple());
            }
            this.filterManager.updateFilter(mergedComponent.getLSMComponentFilter(), filterTuples);
            this.filterManager.writeFilter(mergedComponent.getLSMComponentFilter(), (ITreeIndex)mergedComponent.getRTree());
        }
        btreeBulkLoader.end();
        IIndexBulkLoader bulkLoader = mergedComponent.getRTree().createBulkLoader(1.0f, false, 0L, false);
        try {
            while (cursor.hasNext()) {
                cursor.next();
                ITupleReference frameTuple = cursor.getTuple();
                bulkLoader.add(frameTuple);
            }
        }
        finally {
            cursor.close();
        }
        bulkLoader.end();
        return mergedComponent;
    }

    public ILSMIndexAccessor createAccessor(IModificationOperationCallback modificationCallback, ISearchOperationCallback searchCallback) {
        return new LSMRTreeAccessor(this.lsmHarness, (ILSMIndexOperationContext)this.createOpContext(modificationCallback, searchCallback));
    }

    protected ILSMDiskComponent createBulkLoadTarget() throws HyracksDataException, IndexException {
        LSMComponentFileReferences componentFileRefs = this.fileManager.getRelFlushFileReference();
        return this.createDiskComponent(this.componentFactory, componentFileRefs.getInsertIndexFileReference(), componentFileRefs.getDeleteIndexFileReference(), componentFileRefs.getBloomFilterFileReference(), true);
    }

    public IIndexBulkLoader createBulkLoader(float fillLevel, boolean verifyInput, long numElementsHint, boolean checkIfEmptyIndex) throws TreeIndexException {
        try {
            return new LSMRTreeBulkLoader(fillLevel, verifyInput, numElementsHint, checkIfEmptyIndex);
        }
        catch (HyracksDataException e) {
            throw new TreeIndexException((Exception)((Object)e));
        }
    }

    @Override
    public void modify(IIndexOperationContext ictx, ITupleReference tuple) throws HyracksDataException, IndexException {
        ITupleReference indexTuple;
        LSMRTreeOpContext ctx = (LSMRTreeOpContext)ictx;
        if (ctx.getOperation() == IndexOperation.PHYSICALDELETE) {
            throw new UnsupportedOperationException("Physical delete not supported in the LSM-RTree");
        }
        if (ctx.indexTuple != null) {
            ctx.indexTuple.reset(tuple);
            indexTuple = ctx.indexTuple;
        } else {
            indexTuple = tuple;
        }
        ctx.getModificationCallback().before(indexTuple);
        ctx.getModificationCallback().found(null, indexTuple);
        if (ctx.getOperation() == IndexOperation.INSERT) {
            ctx.currentMutableRTreeAccessor.insert(indexTuple);
        } else {
            ctx.currentMutableRTreeAccessor.delete(indexTuple);
            try {
                ctx.currentMutableBTreeAccessor.insert(((DualTupleReference)tuple).getPermutingTuple());
            }
            catch (TreeIndexDuplicateKeyException treeIndexDuplicateKeyException) {
                // empty catch block
            }
        }
        if (ctx.filterTuple != null) {
            ctx.filterTuple.reset(tuple);
            ((ILSMMemoryComponent)this.memoryComponents.get(this.currentMutableComponentId.get())).getLSMComponentFilter().update((ITupleReference)ctx.filterTuple, ctx.filterCmp);
        }
    }

    public void markAsValid(ILSMDiskComponent lsmComponent) throws HyracksDataException {
        LSMRTreeDiskComponent component = (LSMRTreeDiskComponent)lsmComponent;
        this.markAsValidInternal(component.getBTree().getBufferCache(), component.getBloomFilter());
        this.markAsValidInternal((ITreeIndex)component.getBTree());
        this.markAsValidInternal((ITreeIndex)component.getRTree());
    }

    public Set<String> getLSMComponentPhysicalFiles(ILSMComponent lsmComponent) {
        HashSet<String> files = new HashSet<String>();
        LSMRTreeDiskComponent component = (LSMRTreeDiskComponent)lsmComponent;
        files.add(component.getBTree().getFileReference().getFile().getAbsolutePath());
        files.add(component.getRTree().getFileReference().getFile().getAbsolutePath());
        files.add(component.getBloomFilter().getFileReference().getFile().getAbsolutePath());
        return files;
    }

    public class LSMRTreeBulkLoader
    implements IIndexBulkLoader {
        private final ILSMDiskComponent component;
        private final IIndexBulkLoader bulkLoader;
        private final IIndexBulkLoader buddyBTreeBulkloader;
        private boolean cleanedUpArtifacts = false;
        private boolean isEmptyComponent = true;
        public final PermutingTupleReference indexTuple;
        public final PermutingTupleReference filterTuple;
        public final MultiComparator filterCmp;

        public LSMRTreeBulkLoader(float fillFactor, boolean verifyInput, long numElementsHint, boolean checkIfEmptyIndex) throws TreeIndexException, HyracksDataException {
            if (checkIfEmptyIndex && !LSMRTree.this.isEmptyIndex()) {
                throw new TreeIndexException("Cannot load an index that is not empty");
            }
            try {
                this.component = LSMRTree.this.createBulkLoadTarget();
            }
            catch (HyracksDataException | IndexException e) {
                throw new TreeIndexException((Exception)e);
            }
            this.bulkLoader = ((LSMRTreeDiskComponent)this.component).getRTree().createBulkLoader(fillFactor, verifyInput, numElementsHint, false);
            this.buddyBTreeBulkloader = ((LSMRTreeDiskComponent)this.component).getBTree().createBulkLoader(fillFactor, verifyInput, numElementsHint, false);
            if (LSMRTree.this.filterFields != null) {
                this.indexTuple = new PermutingTupleReference(LSMRTree.this.rtreeFields);
                this.filterCmp = MultiComparator.create((IBinaryComparatorFactory[])this.component.getLSMComponentFilter().getFilterCmpFactories());
                this.filterTuple = new PermutingTupleReference(LSMRTree.this.filterFields);
            } else {
                this.indexTuple = null;
                this.filterCmp = null;
                this.filterTuple = null;
            }
        }

        public void add(ITupleReference tuple) throws HyracksDataException, IndexException {
            try {
                ITupleReference t;
                if (this.indexTuple != null) {
                    this.indexTuple.reset(tuple);
                    t = this.indexTuple;
                } else {
                    t = tuple;
                }
                this.bulkLoader.add(t);
                if (this.filterTuple != null) {
                    this.filterTuple.reset(tuple);
                    this.component.getLSMComponentFilter().update((ITupleReference)this.filterTuple, this.filterCmp);
                }
            }
            catch (RuntimeException | HyracksDataException | IndexException e) {
                this.cleanupArtifacts();
                throw e;
            }
            if (this.isEmptyComponent) {
                this.isEmptyComponent = false;
            }
        }

        public void end() throws HyracksDataException, IndexException {
            if (!this.cleanedUpArtifacts) {
                if (this.component.getLSMComponentFilter() != null) {
                    LSMRTree.this.filterManager.writeFilter(this.component.getLSMComponentFilter(), (ITreeIndex)((LSMRTreeDiskComponent)this.component).getRTree());
                }
                this.bulkLoader.end();
                this.buddyBTreeBulkloader.end();
                if (this.isEmptyComponent) {
                    this.cleanupArtifacts();
                } else {
                    LSMRTree.this.ioOpCallback.afterOperation(LSMOperationType.FLUSH, null, this.component);
                    LSMRTree.this.lsmHarness.addBulkLoadedComponent(this.component);
                }
            }
        }

        public void abort() throws HyracksDataException {
            if (this.bulkLoader != null) {
                this.bulkLoader.abort();
            }
            if (this.buddyBTreeBulkloader != null) {
                this.buddyBTreeBulkloader.abort();
            }
        }

        protected void cleanupArtifacts() throws HyracksDataException {
            if (!this.cleanedUpArtifacts) {
                this.cleanedUpArtifacts = true;
                ((LSMRTreeDiskComponent)this.component).getRTree().deactivate();
                ((LSMRTreeDiskComponent)this.component).getRTree().destroy();
                ((LSMRTreeDiskComponent)this.component).getBTree().deactivate();
                ((LSMRTreeDiskComponent)this.component).getBTree().destroy();
                ((LSMRTreeDiskComponent)this.component).getBloomFilter().deactivate();
                ((LSMRTreeDiskComponent)this.component).getBloomFilter().destroy();
            }
        }
    }

    public class LSMRTreeAccessor
    extends LSMTreeIndexAccessor {
        private final DualTupleReference dualTuple;

        public LSMRTreeAccessor(ILSMHarness lsmHarness, ILSMIndexOperationContext ctx) {
            super(lsmHarness, ctx);
            this.dualTuple = new DualTupleReference(LSMRTree.this.buddyBTreeFields);
        }

        public ITreeIndexCursor createSearchCursor(boolean exclusive) {
            return new LSMRTreeSearchCursor(this.ctx, LSMRTree.this.buddyBTreeFields);
        }

        public void delete(ITupleReference tuple) throws HyracksDataException, IndexException {
            this.ctx.setOperation(IndexOperation.DELETE);
            this.dualTuple.reset(tuple);
            this.lsmHarness.modify(this.ctx, false, (ITupleReference)this.dualTuple);
        }

        public boolean tryDelete(ITupleReference tuple) throws HyracksDataException, IndexException {
            this.ctx.setOperation(IndexOperation.DELETE);
            this.dualTuple.reset(tuple);
            return this.lsmHarness.modify(this.ctx, true, (ITupleReference)this.dualTuple);
        }

        public void forceDelete(ITupleReference tuple) throws HyracksDataException, IndexException {
            this.ctx.setOperation(IndexOperation.DELETE);
            this.dualTuple.reset(tuple);
            this.lsmHarness.forceModify(this.ctx, (ITupleReference)this.dualTuple);
        }

        public MultiComparator getMultiComparator() {
            LSMRTreeOpContext concreteCtx = (LSMRTreeOpContext)this.ctx;
            return concreteCtx.currentRTreeOpContext.cmp;
        }
    }
}

