/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.rtree.impls;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.dataflow.value.ILinearizeComparatorFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.IIOManager;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.bloomfilter.impls.BloomCalculations;
import org.apache.hyracks.storage.am.bloomfilter.impls.BloomFilter;
import org.apache.hyracks.storage.am.bloomfilter.impls.BloomFilterFactory;
import org.apache.hyracks.storage.am.bloomfilter.impls.BloomFilterSpecification;
import org.apache.hyracks.storage.am.btree.impls.BTree;
import org.apache.hyracks.storage.am.common.api.ICursorInitialState;
import org.apache.hyracks.storage.am.common.api.IIndexBulkLoader;
import org.apache.hyracks.storage.am.common.api.IIndexCursor;
import org.apache.hyracks.storage.am.common.api.IIndexOperationContext;
import org.apache.hyracks.storage.am.common.api.IModificationOperationCallback;
import org.apache.hyracks.storage.am.common.api.ISearchOperationCallback;
import org.apache.hyracks.storage.am.common.api.ISearchPredicate;
import org.apache.hyracks.storage.am.common.api.ITreeIndexCursor;
import org.apache.hyracks.storage.am.common.api.ITreeIndexFrameFactory;
import org.apache.hyracks.storage.am.common.api.ITwoPCIndexBulkLoader;
import org.apache.hyracks.storage.am.common.api.IndexException;
import org.apache.hyracks.storage.am.common.api.TreeIndexException;
import org.apache.hyracks.storage.am.common.impls.NoOpOperationCallback;
import org.apache.hyracks.storage.am.common.ophelpers.IndexOperation;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMDiskComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperation;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationCallback;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationScheduler;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexAccessor;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexFileManager;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexOperationContext;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMMergePolicy;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMOperationTracker;
import org.apache.hyracks.storage.am.lsm.common.api.ITwoPCIndex;
import org.apache.hyracks.storage.am.lsm.common.api.LSMOperationType;
import org.apache.hyracks.storage.am.lsm.common.impls.BlockingIOOperationCallbackWrapper;
import org.apache.hyracks.storage.am.lsm.common.impls.ExternalIndexHarness;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMComponentFileReferences;
import org.apache.hyracks.storage.am.lsm.common.impls.TreeIndexFactory;
import org.apache.hyracks.storage.am.lsm.rtree.impls.ExternalRTreeOpContext;
import org.apache.hyracks.storage.am.lsm.rtree.impls.LSMRTree;
import org.apache.hyracks.storage.am.lsm.rtree.impls.LSMRTreeDeletedKeysBTreeMergeCursor;
import org.apache.hyracks.storage.am.lsm.rtree.impls.LSMRTreeDiskComponent;
import org.apache.hyracks.storage.am.lsm.rtree.impls.LSMRTreeMergeOperation;
import org.apache.hyracks.storage.am.lsm.rtree.impls.LSMRTreeSortedCursor;
import org.apache.hyracks.storage.am.rtree.impls.RTree;
import org.apache.hyracks.storage.am.rtree.impls.SearchPredicate;
import org.apache.hyracks.storage.common.file.IFileMapProvider;

public class ExternalRTree
extends LSMRTree
implements ITwoPCIndex {
    private final List<ILSMDiskComponent> secondDiskComponents = new LinkedList<ILSMDiskComponent>();
    private int version = -1;
    private final int fieldCount;

    public ExternalRTree(IIOManager ioManager, ITreeIndexFrameFactory rtreeInteriorFrameFactory, ITreeIndexFrameFactory rtreeLeafFrameFactory, ITreeIndexFrameFactory btreeInteriorFrameFactory, ITreeIndexFrameFactory btreeLeafFrameFactory, ILSMIndexFileManager fileNameManager, TreeIndexFactory<RTree> diskRTreeFactory, TreeIndexFactory<BTree> diskBTreeFactory, BloomFilterFactory bloomFilterFactory, double bloomFilterFalsePositiveRate, IFileMapProvider diskFileMapProvider, int fieldCount, IBinaryComparatorFactory[] rtreeCmpFactories, IBinaryComparatorFactory[] btreeCmpFactories, ILinearizeComparatorFactory linearizer, int[] comparatorFields, IBinaryComparatorFactory[] linearizerArray, ILSMMergePolicy mergePolicy, ILSMOperationTracker opTracker, ILSMIOOperationScheduler ioScheduler, ILSMIOOperationCallback ioOpCallback, int[] buddyBTreeFields, int version, boolean durable, boolean isPointMBR) {
        super(ioManager, rtreeInteriorFrameFactory, rtreeLeafFrameFactory, btreeInteriorFrameFactory, btreeLeafFrameFactory, fileNameManager, diskRTreeFactory, diskBTreeFactory, bloomFilterFactory, bloomFilterFalsePositiveRate, diskFileMapProvider, rtreeCmpFactories, btreeCmpFactories, linearizer, comparatorFields, linearizerArray, mergePolicy, opTracker, ioScheduler, ioOpCallback, buddyBTreeFields, durable, isPointMBR);
        this.version = version;
        this.fieldCount = fieldCount;
    }

    public void subsumeMergedComponents(ILSMDiskComponent newComponent, List<ILSMComponent> mergedComponents) throws HyracksDataException {
        int swapIndex;
        List olderList;
        List<ILSMDiskComponent> newerList;
        if (this.version == 0) {
            newerList = this.diskComponents;
            olderList = this.secondDiskComponents;
        } else {
            newerList = this.secondDiskComponents;
            olderList = this.diskComponents;
        }
        if (olderList.containsAll(mergedComponents)) {
            swapIndex = olderList.indexOf(mergedComponents.get(0));
            olderList.removeAll(mergedComponents);
            olderList.add(swapIndex, newComponent);
        }
        swapIndex = newerList.indexOf(mergedComponents.get(0));
        newerList.removeAll(mergedComponents);
        newerList.add(swapIndex, newComponent);
    }

    public List<ILSMDiskComponent> getImmutableComponents() {
        if (this.version == 0) {
            return this.diskComponents;
        }
        return this.secondDiskComponents;
    }

    public void deleteTransactionComponent() throws HyracksDataException {
        this.fileManager.deleteTransactionFiles();
    }

    public void addDiskComponent(ILSMDiskComponent c) throws HyracksDataException {
        if (this.version == 0) {
            this.diskComponents.add(0, c);
        } else if (this.version == 1) {
            this.secondDiskComponents.add(0, c);
        }
    }

    public void commitTransactionDiskComponent(ILSMDiskComponent newComponent) throws HyracksDataException {
        List olderList;
        List<ILSMDiskComponent> newerList;
        if (this.version == 0) {
            newerList = this.diskComponents;
            olderList = this.secondDiskComponents;
            this.version = 1;
        } else {
            newerList = this.secondDiskComponents;
            olderList = this.diskComponents;
            this.version = 0;
        }
        olderList.clear();
        olderList.addAll(newerList);
        if (newComponent != null) {
            olderList.add(0, newComponent);
        }
    }

    @Override
    public synchronized void activate() throws HyracksDataException {
        if (this.isActivated) {
            throw new HyracksDataException("Failed to activate the index since it is already activated.");
        }
        if (this.diskComponents.size() == 0 && this.secondDiskComponents.size() == 0) {
            List validFileReferences;
            try {
                validFileReferences = this.fileManager.cleanupAndGetValidFiles();
            }
            catch (IndexException indexException) {
                throw new HyracksDataException((Throwable)indexException);
            }
            for (LSMComponentFileReferences lsmComonentFileReference : validFileReferences) {
                LSMRTreeDiskComponent component;
                try {
                    component = this.createDiskComponent(this.componentFactory, lsmComonentFileReference.getInsertIndexFileReference(), lsmComonentFileReference.getDeleteIndexFileReference(), lsmComonentFileReference.getBloomFilterFileReference(), false);
                }
                catch (IndexException e) {
                    throw new HyracksDataException((Throwable)e);
                }
                this.diskComponents.add(component);
                this.secondDiskComponents.add((ILSMDiskComponent)component);
            }
            ((ExternalIndexHarness)this.lsmHarness).indexFirstTimeActivated();
        } else {
            BloomFilter bloomFilter;
            BTree btree;
            RTree rtree;
            LSMRTreeDiskComponent component;
            for (ILSMComponent iLSMComponent : this.diskComponents) {
                component = (LSMRTreeDiskComponent)iLSMComponent;
                rtree = component.getRTree();
                btree = component.getBTree();
                bloomFilter = component.getBloomFilter();
                rtree.activate();
                btree.activate();
                bloomFilter.activate();
            }
            for (ILSMComponent iLSMComponent : this.secondDiskComponents) {
                if (this.diskComponents.contains(iLSMComponent)) continue;
                component = (LSMRTreeDiskComponent)iLSMComponent;
                rtree = component.getRTree();
                btree = component.getBTree();
                bloomFilter = component.getBloomFilter();
                rtree.activate();
                btree.activate();
                bloomFilter.activate();
            }
        }
        this.isActivated = true;
    }

    @Override
    public synchronized void create() throws HyracksDataException {
        super.create();
        this.secondDiskComponents.clear();
    }

    @Override
    public void search(ILSMIndexOperationContext ictx, IIndexCursor cursor, ISearchPredicate pred) throws HyracksDataException, IndexException {
        ExternalRTreeOpContext ctx = (ExternalRTreeOpContext)ictx;
        List operationalComponents = ictx.getComponentHolder();
        ctx.initialState.setOperationalComponents(operationalComponents);
        cursor.open((ICursorInitialState)ctx.initialState, pred);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ILSMDiskComponent merge(ILSMIOOperation operation) throws HyracksDataException, IndexException {
        LSMRTreeMergeOperation mergeOp = (LSMRTreeMergeOperation)operation;
        ITreeIndexCursor cursor = mergeOp.getCursor();
        SearchPredicate rtreeSearchPred = new SearchPredicate(null, null);
        ILSMIndexOperationContext opCtx = ((LSMRTreeSortedCursor)cursor).getOpCtx();
        opCtx.getComponentHolder().addAll(mergeOp.getMergingComponents());
        this.search(opCtx, (IIndexCursor)cursor, (ISearchPredicate)rtreeSearchPred);
        LSMRTreeDiskComponent mergedComponent = this.createDiskComponent(this.componentFactory, mergeOp.getRTreeMergeTarget(), mergeOp.getBTreeMergeTarget(), mergeOp.getBloomFilterMergeTarget(), true);
        if (mergeOp.isKeepDeletedTuples()) {
            LSMRTreeDeletedKeysBTreeMergeCursor btreeCursor = new LSMRTreeDeletedKeysBTreeMergeCursor(opCtx);
            this.search(opCtx, (IIndexCursor)btreeCursor, (ISearchPredicate)rtreeSearchPred);
            BTree btree = mergedComponent.getBTree();
            IIndexBulkLoader btreeBulkLoader = btree.createBulkLoader(1.0f, true, 0L, false);
            long numElements = 0L;
            for (int i = 0; i < mergeOp.getMergingComponents().size(); ++i) {
                numElements += ((LSMRTreeDiskComponent)mergeOp.getMergingComponents().get(i)).getBloomFilter().getNumElements();
            }
            int maxBucketsPerElement = BloomCalculations.maxBucketsPerElement((long)numElements);
            BloomFilterSpecification bloomFilterSpec = BloomCalculations.computeBloomSpec((int)maxBucketsPerElement, (double)this.bloomFilterFalsePositiveRate);
            IIndexBulkLoader builder = mergedComponent.getBloomFilter().createBuilder(numElements, bloomFilterSpec.getNumHashes(), bloomFilterSpec.getNumBucketsPerElements());
            try {
                while (btreeCursor.hasNext()) {
                    btreeCursor.next();
                    ITupleReference tuple = btreeCursor.getTuple();
                    btreeBulkLoader.add(tuple);
                    builder.add(tuple);
                }
            }
            finally {
                btreeCursor.close();
                builder.end();
            }
            btreeBulkLoader.end();
        }
        IIndexBulkLoader bulkLoader = mergedComponent.getRTree().createBulkLoader(1.0f, false, 0L, false);
        try {
            while (cursor.hasNext()) {
                cursor.next();
                ITupleReference frameTuple = cursor.getTuple();
                bulkLoader.add(frameTuple);
            }
        }
        finally {
            cursor.close();
        }
        bulkLoader.end();
        return mergedComponent;
    }

    @Override
    public void deactivate(boolean flushOnExit) throws HyracksDataException {
        BloomFilter bloomFilter;
        BTree btree;
        RTree rtree;
        LSMRTreeDiskComponent component;
        if (!this.isActivated) {
            throw new HyracksDataException("Failed to deactivate the index since it is already deactivated.");
        }
        if (flushOnExit) {
            BlockingIOOperationCallbackWrapper cb = new BlockingIOOperationCallbackWrapper(this.ioOpCallback);
            cb.afterFinalize(LSMOperationType.FLUSH, null);
        }
        for (ILSMComponent iLSMComponent : this.diskComponents) {
            component = (LSMRTreeDiskComponent)iLSMComponent;
            rtree = component.getRTree();
            btree = component.getBTree();
            bloomFilter = component.getBloomFilter();
            rtree.deactivateCloseHandle();
            btree.deactivateCloseHandle();
            bloomFilter.deactivate();
        }
        for (ILSMComponent iLSMComponent : this.secondDiskComponents) {
            if (this.diskComponents.contains(iLSMComponent)) continue;
            component = (LSMRTreeDiskComponent)iLSMComponent;
            rtree = component.getRTree();
            btree = component.getBTree();
            bloomFilter = component.getBloomFilter();
            rtree.deactivateCloseHandle();
            btree.deactivateCloseHandle();
            bloomFilter.deactivate();
        }
        this.isActivated = false;
    }

    @Override
    public void clear() throws HyracksDataException {
        LSMRTreeDiskComponent component;
        if (!this.isActivated) {
            throw new HyracksDataException("Failed to clear the index since it is not activated.");
        }
        ((ExternalIndexHarness)this.lsmHarness).indexClear();
        for (ILSMComponent iLSMComponent : this.diskComponents) {
            component = (LSMRTreeDiskComponent)iLSMComponent;
            component.getRTree().deactivate();
            component.getBloomFilter().deactivate();
            component.getBTree().deactivate();
            component.getRTree().destroy();
            component.getBloomFilter().destroy();
            component.getBTree().destroy();
            this.secondDiskComponents.remove(iLSMComponent);
        }
        for (ILSMComponent iLSMComponent : this.secondDiskComponents) {
            component = (LSMRTreeDiskComponent)iLSMComponent;
            component.getRTree().deactivate();
            component.getBloomFilter().deactivate();
            component.getBTree().deactivate();
            component.getRTree().destroy();
            component.getBloomFilter().destroy();
            component.getBTree().destroy();
        }
        this.diskComponents.clear();
        this.secondDiskComponents.clear();
        this.version = -1;
    }

    @Override
    public void destroy() throws HyracksDataException {
        LSMRTreeDiskComponent component;
        if (this.isActivated) {
            throw new HyracksDataException("Failed to destroy the index since it is activated.");
        }
        for (ILSMComponent iLSMComponent : this.diskComponents) {
            component = (LSMRTreeDiskComponent)iLSMComponent;
            component.getRTree().destroy();
            component.getBTree().destroy();
            component.getBloomFilter().destroy();
            this.secondDiskComponents.remove(iLSMComponent);
        }
        for (ILSMComponent iLSMComponent : this.secondDiskComponents) {
            component = (LSMRTreeDiskComponent)iLSMComponent;
            component.getRTree().destroy();
            component.getBTree().destroy();
            component.getBloomFilter().destroy();
        }
        this.diskComponents.clear();
        this.secondDiskComponents.clear();
        this.fileManager.deleteDirs();
        this.version = -1;
    }

    @Override
    public void modify(IIndexOperationContext ictx, ITupleReference tuple) throws HyracksDataException, IndexException {
        throw new UnsupportedOperationException("tuple modify not supported in LSM-Disk-Only-RTree");
    }

    @Override
    public void scheduleFlush(ILSMIndexOperationContext ctx, ILSMIOOperationCallback callback) throws HyracksDataException {
        throw new UnsupportedOperationException("flush not supported in LSM-Disk-Only-RTree");
    }

    @Override
    public ILSMDiskComponent flush(ILSMIOOperation operation) throws HyracksDataException, IndexException {
        throw new UnsupportedOperationException("flush not supported in LSM-Disk-Only-RTree");
    }

    @Override
    public void getOperationalComponents(ILSMIndexOperationContext ctx) {
        List operationalComponents = ctx.getComponentHolder();
        List<ILSMDiskComponent> immutableComponents = this.version == 0 ? this.diskComponents : this.secondDiskComponents;
        ExternalRTreeOpContext opCtx = (ExternalRTreeOpContext)ctx;
        operationalComponents.clear();
        switch (ctx.getOperation()) {
            case SEARCH: {
                if (opCtx.getTargetIndexVersion() == 0) {
                    operationalComponents.addAll(this.diskComponents);
                    break;
                }
                operationalComponents.addAll(this.secondDiskComponents);
                break;
            }
            case MERGE: {
                operationalComponents.addAll(ctx.getComponentsToBeMerged());
                break;
            }
            case FULL_MERGE: {
                operationalComponents.addAll(immutableComponents);
                break;
            }
            case REPLICATE: {
                operationalComponents.addAll(ctx.getComponentsToBeReplicated());
                break;
            }
            case FLUSH: {
                break;
            }
            default: {
                throw new UnsupportedOperationException("Operation " + ctx.getOperation() + " not supported.");
            }
        }
    }

    @Override
    public IIndexBulkLoader createBulkLoader(float fillLevel, boolean verifyInput, long numElementsHint, boolean checkIfEmptyIndex) throws TreeIndexException {
        try {
            return new LSMTwoPCRTreeBulkLoader(fillLevel, verifyInput, 0L, checkIfEmptyIndex, false);
        }
        catch (HyracksDataException e) {
            throw new TreeIndexException((Exception)((Object)e));
        }
    }

    public IIndexBulkLoader createTransactionBulkLoader(float fillLevel, boolean verifyInput, long numElementsHint, boolean checkIfEmptyIndex) throws TreeIndexException {
        try {
            return new LSMTwoPCRTreeBulkLoader(fillLevel, verifyInput, numElementsHint, checkIfEmptyIndex, true);
        }
        catch (HyracksDataException e) {
            throw new TreeIndexException((Exception)((Object)e));
        }
    }

    @Override
    public String toString() {
        return "LSMTwoPCRTree [" + this.fileManager.getBaseDir() + "]";
    }

    @Override
    public void scheduleMerge(ILSMIndexOperationContext ctx, ILSMIOOperationCallback callback) throws HyracksDataException, IndexException {
        ExternalRTreeOpContext rctx = this.createOpContext((ISearchOperationCallback)NoOpOperationCallback.INSTANCE, -1);
        rctx.setOperation(IndexOperation.MERGE);
        List mergingComponents = ctx.getComponentHolder();
        LSMRTreeSortedCursor cursor = new LSMRTreeSortedCursor((ILSMIndexOperationContext)rctx, this.linearizer, this.buddyBTreeFields);
        LSMComponentFileReferences relMergeFileRefs = this.getMergeTargetFileName(mergingComponents);
        LSMRTree.LSMRTreeAccessor accessor = new LSMRTree.LSMRTreeAccessor(this, this.lsmHarness, (ILSMIndexOperationContext)rctx);
        LSMRTreeMergeOperation mergeOp = new LSMRTreeMergeOperation((ILSMIndexAccessor)accessor, mergingComponents, cursor, relMergeFileRefs.getInsertIndexFileReference(), relMergeFileRefs.getDeleteIndexFileReference(), relMergeFileRefs.getBloomFilterFileReference(), callback, this.fileManager.getBaseDir());
        boolean keepDeleteTuples = false;
        keepDeleteTuples = this.version == 0 ? mergeOp.getMergingComponents().get(mergeOp.getMergingComponents().size() - 1) != this.diskComponents.get(this.diskComponents.size() - 1) : mergeOp.getMergingComponents().get(mergeOp.getMergingComponents().size() - 1) != this.secondDiskComponents.get(this.secondDiskComponents.size() - 1);
        mergeOp.setKeepDeletedTuples(keepDeleteTuples);
        this.ioScheduler.scheduleOperation((ILSMIOOperation)mergeOp);
    }

    public ILSMIndexAccessor createAccessor(ISearchOperationCallback searchCallback, int targetIndexVersion) throws HyracksDataException {
        return new LSMRTree.LSMRTreeAccessor(this, this.lsmHarness, (ILSMIndexOperationContext)this.createOpContext(searchCallback, targetIndexVersion));
    }

    public ExternalRTreeOpContext createOpContext(ISearchOperationCallback searchCallback, int targetVersion) {
        return new ExternalRTreeOpContext(this.rtreeCmpFactories, this.btreeCmpFactories, searchCallback, targetVersion, this.lsmHarness, this.comparatorFields, this.linearizerArray, this.rtreeLeafFrameFactory, this.rtreeInteriorFrameFactory, this.btreeLeafFrameFactory);
    }

    @Override
    public ILSMIndexAccessor createAccessor(IModificationOperationCallback modificationCallback, ISearchOperationCallback searchCallback) {
        return new LSMRTree.LSMRTreeAccessor(this, this.lsmHarness, (ILSMIndexOperationContext)this.createOpContext(searchCallback, this.version));
    }

    public int getCurrentVersion() {
        return this.version;
    }

    public List<ILSMDiskComponent> getFirstComponentList() {
        return this.diskComponents;
    }

    public List<ILSMDiskComponent> getSecondComponentList() {
        return this.secondDiskComponents;
    }

    public void commitTransaction() throws TreeIndexException, HyracksDataException, IndexException {
        LSMComponentFileReferences componentFileRefrences = this.fileManager.getTransactionFileReferenceForCommit();
        LSMRTreeDiskComponent component = null;
        if (componentFileRefrences != null) {
            component = this.createDiskComponent(this.componentFactory, componentFileRefrences.getInsertIndexFileReference(), componentFileRefrences.getDeleteIndexFileReference(), componentFileRefrences.getBloomFilterFileReference(), false);
        }
        ((ExternalIndexHarness)this.lsmHarness).addTransactionComponents(component);
    }

    public void abortTransaction() throws TreeIndexException {
        try {
            this.fileManager.deleteTransactionFiles();
        }
        catch (HyracksDataException e) {
            throw new TreeIndexException((Exception)((Object)e));
        }
    }

    public void recoverTransaction() throws TreeIndexException {
        try {
            this.fileManager.recoverTransaction();
        }
        catch (HyracksDataException e) {
            throw new TreeIndexException((Exception)((Object)e));
        }
    }

    public boolean hasMemoryComponents() {
        return false;
    }

    @Override
    public int getFieldCount() {
        return this.fieldCount;
    }

    public class LSMTwoPCRTreeBulkLoader
    implements IIndexBulkLoader,
    ITwoPCIndexBulkLoader {
        private final ILSMDiskComponent component;
        private final IIndexBulkLoader rtreeBulkLoader;
        private final BTree.BTreeBulkLoader btreeBulkLoader;
        private final IIndexBulkLoader builder;
        private boolean cleanedUpArtifacts = false;
        private boolean isEmptyComponent = true;
        private boolean endedBloomFilterLoad = false;
        private final boolean isTransaction;

        public LSMTwoPCRTreeBulkLoader(float fillFactor, boolean verifyInput, long numElementsHint, boolean checkIfEmptyIndex, boolean isTransaction) throws TreeIndexException, HyracksDataException {
            this.isTransaction = isTransaction;
            if (isTransaction) {
                try {
                    this.component = this.createTransactionTarget();
                }
                catch (HyracksDataException | IndexException e) {
                    throw new TreeIndexException((Exception)e);
                }
            }
            if (checkIfEmptyIndex && !ExternalRTree.this.isEmptyIndex()) {
                throw new TreeIndexException("Cannot load an index that is not empty");
            }
            try {
                this.component = ExternalRTree.this.createBulkLoadTarget();
            }
            catch (HyracksDataException | IndexException e) {
                throw new TreeIndexException((Exception)e);
            }
            this.rtreeBulkLoader = ((LSMRTreeDiskComponent)this.component).getRTree().createBulkLoader(fillFactor, verifyInput, numElementsHint, false);
            this.btreeBulkLoader = (BTree.BTreeBulkLoader)((LSMRTreeDiskComponent)this.component).getBTree().createBulkLoader(fillFactor, verifyInput, numElementsHint, false);
            int maxBucketsPerElement = BloomCalculations.maxBucketsPerElement((long)numElementsHint);
            BloomFilterSpecification bloomFilterSpec = BloomCalculations.computeBloomSpec((int)maxBucketsPerElement, (double)ExternalRTree.this.bloomFilterFalsePositiveRate);
            this.builder = ((LSMRTreeDiskComponent)this.component).getBloomFilter().createBuilder(numElementsHint, bloomFilterSpec.getNumHashes(), bloomFilterSpec.getNumBucketsPerElements());
        }

        public void add(ITupleReference tuple) throws IndexException, HyracksDataException {
            try {
                this.rtreeBulkLoader.add(tuple);
            }
            catch (RuntimeException | HyracksDataException | IndexException e) {
                this.cleanupArtifacts();
                throw e;
            }
            if (this.isEmptyComponent) {
                this.isEmptyComponent = false;
            }
        }

        public void cleanupArtifacts() throws HyracksDataException {
            if (!this.cleanedUpArtifacts) {
                this.cleanedUpArtifacts = true;
                try {
                    ((LSMRTreeDiskComponent)this.component).getRTree().deactivate();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ((LSMRTreeDiskComponent)this.component).getRTree().destroy();
                try {
                    ((LSMRTreeDiskComponent)this.component).getBTree().deactivate();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ((LSMRTreeDiskComponent)this.component).getBTree().destroy();
                try {
                    ((LSMRTreeDiskComponent)this.component).getBloomFilter().deactivate();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ((LSMRTreeDiskComponent)this.component).getBloomFilter().destroy();
            }
        }

        public void end() throws HyracksDataException, IndexException {
            if (!this.cleanedUpArtifacts) {
                if (!this.endedBloomFilterLoad) {
                    this.builder.end();
                    this.endedBloomFilterLoad = true;
                }
                this.rtreeBulkLoader.end();
                this.btreeBulkLoader.end();
                if (this.isEmptyComponent) {
                    this.cleanupArtifacts();
                } else if (this.isTransaction) {
                    ExternalRTree.this.markAsValid(this.component);
                    RTree rtree = ((LSMRTreeDiskComponent)this.component).getRTree();
                    BTree btree = ((LSMRTreeDiskComponent)this.component).getBTree();
                    BloomFilter bloomFilter = ((LSMRTreeDiskComponent)this.component).getBloomFilter();
                    rtree.deactivate();
                    btree.deactivate();
                    bloomFilter.deactivate();
                } else {
                    ExternalRTree.this.lsmHarness.addBulkLoadedComponent(this.component);
                }
            }
        }

        public void delete(ITupleReference tuple) throws IndexException, HyracksDataException {
            try {
                this.btreeBulkLoader.add(tuple);
                this.builder.add(tuple);
            }
            catch (RuntimeException | HyracksDataException | IndexException e) {
                this.cleanupArtifacts();
                throw e;
            }
            if (this.isEmptyComponent) {
                this.isEmptyComponent = false;
            }
        }

        public void abort() {
            try {
                this.cleanupArtifacts();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private ILSMDiskComponent createTransactionTarget() throws HyracksDataException, IndexException {
            LSMComponentFileReferences componentFileRefs;
            try {
                componentFileRefs = ExternalRTree.this.fileManager.getNewTransactionFileReference();
            }
            catch (IOException e) {
                throw new HyracksDataException("Failed to create transaction components", (Throwable)e);
            }
            return ExternalRTree.this.createDiskComponent(ExternalRTree.this.componentFactory, componentFileRefs.getInsertIndexFileReference(), componentFileRefs.getDeleteIndexFileReference(), componentFileRefs.getBloomFilterFileReference(), true);
        }
    }
}

