/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.rtree.impls;

import java.util.List;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.dataflow.value.ILinearizeComparatorFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.api.io.IIOManager;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.btree.impls.BTree;
import org.apache.hyracks.storage.am.common.api.ICursorInitialState;
import org.apache.hyracks.storage.am.common.api.IIndexCursor;
import org.apache.hyracks.storage.am.common.api.IIndexOperationContext;
import org.apache.hyracks.storage.am.common.api.IModificationOperationCallback;
import org.apache.hyracks.storage.am.common.api.IPageManager;
import org.apache.hyracks.storage.am.common.api.ISearchOperationCallback;
import org.apache.hyracks.storage.am.common.api.ISearchPredicate;
import org.apache.hyracks.storage.am.common.api.ITreeIndex;
import org.apache.hyracks.storage.am.common.api.ITreeIndexFrameFactory;
import org.apache.hyracks.storage.am.common.api.IndexException;
import org.apache.hyracks.storage.am.common.exceptions.TreeIndexDuplicateKeyException;
import org.apache.hyracks.storage.am.common.impls.AbstractSearchPredicate;
import org.apache.hyracks.storage.am.common.impls.NoOpOperationCallback;
import org.apache.hyracks.storage.am.common.ophelpers.IndexOperation;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponentFilterFactory;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponentFilterFrameFactory;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMDiskComponentFactory;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationCallback;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationScheduler;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexAccessor;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexFileManager;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexOperationContext;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMMemoryComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMMergePolicy;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMOperationTracker;
import org.apache.hyracks.storage.am.lsm.common.api.IVirtualBufferCache;
import org.apache.hyracks.storage.am.lsm.common.freepage.VirtualFreePageManager;
import org.apache.hyracks.storage.am.lsm.common.impls.AbstractLSMIndex;
import org.apache.hyracks.storage.am.lsm.common.impls.BlockingIOOperationCallbackWrapper;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMComponentFileReferences;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMComponentFilterManager;
import org.apache.hyracks.storage.am.lsm.rtree.impls.LSMRTreeDiskComponent;
import org.apache.hyracks.storage.am.lsm.rtree.impls.LSMRTreeMemoryComponent;
import org.apache.hyracks.storage.am.lsm.rtree.impls.LSMRTreeOpContext;
import org.apache.hyracks.storage.am.rtree.impls.RTree;
import org.apache.hyracks.storage.common.buffercache.IBufferCache;
import org.apache.hyracks.storage.common.file.IFileMapProvider;

public abstract class AbstractLSMRTree
extends AbstractLSMIndex
implements ITreeIndex {
    protected final ILinearizeComparatorFactory linearizer;
    protected final int[] comparatorFields;
    protected final IBinaryComparatorFactory[] linearizerArray;
    protected final boolean isPointMBR;
    protected final ILSMDiskComponentFactory componentFactory;
    protected IBinaryComparatorFactory[] btreeCmpFactories;
    protected IBinaryComparatorFactory[] rtreeCmpFactories;
    protected final ITreeIndexFrameFactory rtreeInteriorFrameFactory;
    protected final ITreeIndexFrameFactory btreeInteriorFrameFactory;
    protected final ITreeIndexFrameFactory rtreeLeafFrameFactory;
    protected final ITreeIndexFrameFactory btreeLeafFrameFactory;
    protected final int[] rtreeFields;

    public AbstractLSMRTree(IIOManager ioManager, List<IVirtualBufferCache> virtualBufferCaches, ITreeIndexFrameFactory rtreeInteriorFrameFactory, ITreeIndexFrameFactory rtreeLeafFrameFactory, ITreeIndexFrameFactory btreeInteriorFrameFactory, ITreeIndexFrameFactory btreeLeafFrameFactory, ILSMIndexFileManager fileManager, ILSMDiskComponentFactory componentFactory, IFileMapProvider diskFileMapProvider, int fieldCount, IBinaryComparatorFactory[] rtreeCmpFactories, IBinaryComparatorFactory[] btreeCmpFactories, ILinearizeComparatorFactory linearizer, int[] comparatorFields, IBinaryComparatorFactory[] linearizerArray, double bloomFilterFalsePositiveRate, ILSMMergePolicy mergePolicy, ILSMOperationTracker opTracker, ILSMIOOperationScheduler ioScheduler, ILSMIOOperationCallback ioOpCallback, ILSMComponentFilterFactory filterFactory, ILSMComponentFilterFrameFactory filterFrameFactory, LSMComponentFilterManager filterManager, int[] rtreeFields, int[] filterFields, boolean durable, boolean isPointMBR, IBufferCache diskBufferCache) throws HyracksDataException {
        super(ioManager, virtualBufferCaches, diskBufferCache, fileManager, diskFileMapProvider, bloomFilterFalsePositiveRate, mergePolicy, opTracker, ioScheduler, ioOpCallback, filterFrameFactory, filterManager, filterFields, durable);
        int i = 0;
        for (IVirtualBufferCache virtualBufferCache : virtualBufferCaches) {
            RTree memRTree = new RTree((IBufferCache)virtualBufferCache, (IFileMapProvider)virtualBufferCache.getFileMapProvider(), (IPageManager)new VirtualFreePageManager((IBufferCache)virtualBufferCache), rtreeInteriorFrameFactory, rtreeLeafFrameFactory, rtreeCmpFactories, fieldCount, ioManager.resolveAbsolutePath(fileManager.getBaseDir() + "_virtual_r_" + i), isPointMBR);
            BTree memBTree = new BTree((IBufferCache)virtualBufferCache, (IFileMapProvider)virtualBufferCache.getFileMapProvider(), (IPageManager)new VirtualFreePageManager((IBufferCache)virtualBufferCache), btreeInteriorFrameFactory, btreeLeafFrameFactory, btreeCmpFactories, btreeCmpFactories.length, ioManager.resolveAbsolutePath(fileManager.getBaseDir() + "_virtual_b_" + i));
            LSMRTreeMemoryComponent mutableComponent = new LSMRTreeMemoryComponent(memRTree, memBTree, virtualBufferCache, i == 0, filterFactory == null ? null : filterFactory.createFilter());
            this.memoryComponents.add(mutableComponent);
            ++i;
        }
        this.rtreeInteriorFrameFactory = rtreeInteriorFrameFactory;
        this.rtreeLeafFrameFactory = rtreeLeafFrameFactory;
        this.btreeInteriorFrameFactory = btreeInteriorFrameFactory;
        this.btreeLeafFrameFactory = btreeLeafFrameFactory;
        this.componentFactory = componentFactory;
        this.btreeCmpFactories = btreeCmpFactories;
        this.rtreeCmpFactories = rtreeCmpFactories;
        this.linearizer = linearizer;
        this.comparatorFields = comparatorFields;
        this.linearizerArray = linearizerArray;
        this.rtreeFields = rtreeFields;
        this.isPointMBR = isPointMBR;
    }

    public AbstractLSMRTree(IIOManager ioManager, ITreeIndexFrameFactory rtreeInteriorFrameFactory, ITreeIndexFrameFactory rtreeLeafFrameFactory, ITreeIndexFrameFactory btreeInteriorFrameFactory, ITreeIndexFrameFactory btreeLeafFrameFactory, ILSMIndexFileManager fileManager, ILSMDiskComponentFactory componentFactory, IFileMapProvider diskFileMapProvider, IBinaryComparatorFactory[] rtreeCmpFactories, IBinaryComparatorFactory[] btreeCmpFactories, ILinearizeComparatorFactory linearizer, int[] comparatorFields, IBinaryComparatorFactory[] linearizerArray, double bloomFilterFalsePositiveRate, ILSMMergePolicy mergePolicy, ILSMOperationTracker opTracker, ILSMIOOperationScheduler ioScheduler, ILSMIOOperationCallback ioOpCallback, boolean durable, boolean isPointMBR, IBufferCache diskBufferCache) {
        super(ioManager, diskBufferCache, fileManager, diskFileMapProvider, bloomFilterFalsePositiveRate, mergePolicy, opTracker, ioScheduler, ioOpCallback, durable);
        this.rtreeInteriorFrameFactory = rtreeInteriorFrameFactory;
        this.rtreeLeafFrameFactory = rtreeLeafFrameFactory;
        this.btreeInteriorFrameFactory = btreeInteriorFrameFactory;
        this.btreeLeafFrameFactory = btreeLeafFrameFactory;
        this.componentFactory = componentFactory;
        this.btreeCmpFactories = btreeCmpFactories;
        this.rtreeCmpFactories = rtreeCmpFactories;
        this.linearizer = linearizer;
        this.comparatorFields = comparatorFields;
        this.linearizerArray = linearizerArray;
        this.rtreeFields = null;
        this.isPointMBR = isPointMBR;
    }

    public synchronized void create() throws HyracksDataException {
        if (this.isActivated) {
            throw new HyracksDataException("Failed to create the index since it is activated.");
        }
        this.fileManager.deleteDirs();
        this.fileManager.createDirs();
        this.diskComponents.clear();
    }

    public synchronized void activate() throws HyracksDataException {
        if (this.isActivated) {
            throw new HyracksDataException("Failed to activate the index since it is already activated.");
        }
    }

    public synchronized void deactivate(boolean flushOnExit) throws HyracksDataException {
        if (!this.isActivated) {
            throw new HyracksDataException("Failed to deactivate the index since it is already deactivated.");
        }
        if (flushOnExit) {
            BlockingIOOperationCallbackWrapper cb = new BlockingIOOperationCallbackWrapper(this.ioOpCallback);
            ILSMIndexAccessor accessor = this.createAccessor((IModificationOperationCallback)NoOpOperationCallback.INSTANCE, (ISearchOperationCallback)NoOpOperationCallback.INSTANCE);
            accessor.scheduleFlush((ILSMIOOperationCallback)cb);
            try {
                cb.waitForIO();
            }
            catch (InterruptedException e) {
                throw new HyracksDataException((Throwable)e);
            }
        }
        this.deallocateMemoryComponents();
    }

    public synchronized void destroy() throws HyracksDataException {
        if (this.isActivated) {
            throw new HyracksDataException("Failed to destroy the index since it is activated.");
        }
    }

    public synchronized void clear() throws HyracksDataException {
        if (!this.isActivated) {
            throw new HyracksDataException("Failed to clear the index since it is not activated.");
        }
        this.clearMemoryComponents();
    }

    public void getOperationalComponents(ILSMIndexOperationContext ctx) throws HyracksDataException {
        List operationalComponents = ctx.getComponentHolder();
        List immutableComponents = this.diskComponents;
        int cmc = this.currentMutableComponentId.get();
        ctx.setCurrentMutableComponentId(cmc);
        operationalComponents.clear();
        switch (ctx.getOperation()) {
            case INSERT: 
            case DELETE: 
            case FLUSH: 
            case UPSERT: {
                operationalComponents.add(this.memoryComponents.get(cmc));
                break;
            }
            case SEARCH: {
                if (this.memoryComponentsAllocated) {
                    this.addOperationalMutableComponents(operationalComponents);
                }
                if (this.filterManager != null) {
                    for (ILSMComponent c : immutableComponents) {
                        if (!c.getLSMComponentFilter().satisfy(((AbstractSearchPredicate)ctx.getSearchPredicate()).getMinFilterTuple(), ((AbstractSearchPredicate)ctx.getSearchPredicate()).getMaxFilterTuple(), ((LSMRTreeOpContext)ctx).filterCmp)) continue;
                        operationalComponents.add(c);
                    }
                    break;
                }
                operationalComponents.addAll(immutableComponents);
                break;
            }
            case MERGE: {
                operationalComponents.addAll(ctx.getComponentsToBeMerged());
                break;
            }
            case FULL_MERGE: {
                operationalComponents.addAll(immutableComponents);
                break;
            }
            case REPLICATE: {
                operationalComponents.addAll(ctx.getComponentsToBeReplicated());
                break;
            }
            default: {
                throw new UnsupportedOperationException("Operation " + ctx.getOperation() + " not supported.");
            }
        }
    }

    public void search(ILSMIndexOperationContext ictx, IIndexCursor cursor, ISearchPredicate pred) throws HyracksDataException, IndexException {
        LSMRTreeOpContext ctx = (LSMRTreeOpContext)ictx;
        cursor.open((ICursorInitialState)ctx.searchInitialState, pred);
    }

    protected LSMComponentFileReferences getMergeTargetFileName(List<ILSMComponent> mergingDiskComponents) throws HyracksDataException {
        RTree firstTree = ((LSMRTreeDiskComponent)mergingDiskComponents.get(0)).getRTree();
        RTree lastTree = ((LSMRTreeDiskComponent)mergingDiskComponents.get(mergingDiskComponents.size() - 1)).getRTree();
        FileReference firstFile = firstTree.getFileReference();
        FileReference lastFile = lastTree.getFileReference();
        LSMComponentFileReferences fileRefs = this.fileManager.getRelMergeFileReference(firstFile.getFile().getName(), lastFile.getFile().getName());
        return fileRefs;
    }

    protected LSMRTreeDiskComponent createDiskComponent(ILSMDiskComponentFactory factory, FileReference insertFileRef, FileReference deleteFileRef, FileReference bloomFilterFileRef, boolean createComponent) throws HyracksDataException, IndexException {
        LSMRTreeDiskComponent component = (LSMRTreeDiskComponent)factory.createComponent(new LSMComponentFileReferences(insertFileRef, deleteFileRef, bloomFilterFileRef));
        if (createComponent) {
            component.getRTree().create();
        }
        component.getRTree().activate();
        if (component.getBTree() != null) {
            if (createComponent) {
                component.getBTree().create();
                component.getBloomFilter().create();
            }
            component.getBTree().activate();
            component.getBloomFilter().activate();
        }
        if (component.getLSMComponentFilter() != null && !createComponent) {
            this.filterManager.readFilter(component.getLSMComponentFilter(), (ITreeIndex)component.getRTree());
        }
        return component;
    }

    public ITreeIndexFrameFactory getLeafFrameFactory() {
        LSMRTreeMemoryComponent mutableComponent = (LSMRTreeMemoryComponent)((Object)this.memoryComponents.get(this.currentMutableComponentId.get()));
        return mutableComponent.getRTree().getLeafFrameFactory();
    }

    public ITreeIndexFrameFactory getInteriorFrameFactory() {
        LSMRTreeMemoryComponent mutableComponent = (LSMRTreeMemoryComponent)((Object)this.memoryComponents.get(this.currentMutableComponentId.get()));
        return mutableComponent.getRTree().getInteriorFrameFactory();
    }

    public IPageManager getPageManager() {
        LSMRTreeMemoryComponent mutableComponent = (LSMRTreeMemoryComponent)((Object)this.memoryComponents.get(this.currentMutableComponentId.get()));
        return mutableComponent.getRTree().getPageManager();
    }

    public int getFieldCount() {
        LSMRTreeMemoryComponent mutableComponent = (LSMRTreeMemoryComponent)((Object)this.memoryComponents.get(this.currentMutableComponentId.get()));
        return mutableComponent.getRTree().getFieldCount();
    }

    public int getRootPageId() {
        LSMRTreeMemoryComponent mutableComponent = (LSMRTreeMemoryComponent)((Object)this.memoryComponents.get(this.currentMutableComponentId.get()));
        return mutableComponent.getRTree().getRootPageId();
    }

    public int getFileId() {
        LSMRTreeMemoryComponent mutableComponent = (LSMRTreeMemoryComponent)((Object)this.memoryComponents.get(this.currentMutableComponentId.get()));
        return mutableComponent.getRTree().getFileId();
    }

    public void modify(IIndexOperationContext ictx, ITupleReference tuple) throws HyracksDataException, IndexException {
        ITupleReference indexTuple;
        LSMRTreeOpContext ctx = (LSMRTreeOpContext)ictx;
        if (ctx.getOperation() == IndexOperation.PHYSICALDELETE) {
            throw new UnsupportedOperationException("Physical delete not supported in the LSM-RTree");
        }
        if (ctx.indexTuple != null) {
            ctx.indexTuple.reset(tuple);
            indexTuple = ctx.indexTuple;
        } else {
            indexTuple = tuple;
        }
        ctx.getModificationCallback().before(indexTuple);
        ctx.getModificationCallback().found(null, indexTuple);
        if (ctx.getOperation() == IndexOperation.INSERT) {
            ctx.currentMutableRTreeAccessor.insert(indexTuple);
        } else {
            ctx.currentMutableRTreeAccessor.delete(indexTuple);
            try {
                ctx.currentMutableBTreeAccessor.insert(indexTuple);
            }
            catch (TreeIndexDuplicateKeyException treeIndexDuplicateKeyException) {
                // empty catch block
            }
        }
        if (ctx.filterTuple != null) {
            ctx.filterTuple.reset(tuple);
            ((ILSMMemoryComponent)this.memoryComponents.get(this.currentMutableComponentId.get())).getLSMComponentFilter().update((ITupleReference)ctx.filterTuple, ctx.filterCmp);
        }
    }

    protected LSMRTreeOpContext createOpContext(IModificationOperationCallback modCallback, ISearchOperationCallback searchCallback) {
        return new LSMRTreeOpContext(this.memoryComponents, this.rtreeLeafFrameFactory, this.rtreeInteriorFrameFactory, this.btreeLeafFrameFactory, modCallback, searchCallback, this.rtreeFields, this.filterFields, this.lsmHarness, this.comparatorFields, this.linearizerArray);
    }

    public IBinaryComparatorFactory[] getComparatorFactories() {
        return this.rtreeCmpFactories;
    }

    public void validate() throws HyracksDataException {
        throw new UnsupportedOperationException("Validation not implemented for LSM R-Trees.");
    }

    public long getMemoryAllocationSize() {
        long size = 0L;
        for (ILSMComponent c : this.memoryComponents) {
            LSMRTreeMemoryComponent mutableComponent = (LSMRTreeMemoryComponent)c;
            IBufferCache virtualBufferCache = mutableComponent.getRTree().getBufferCache();
            size += (long)(virtualBufferCache.getNumPages() * virtualBufferCache.getPageSize());
        }
        return size;
    }

    public boolean isPrimaryIndex() {
        return false;
    }

    public String toString() {
        return "LSMRTree [" + this.fileManager.getBaseDir() + "]";
    }

    public synchronized void allocateMemoryComponents() throws HyracksDataException {
        if (!this.isActivated) {
            throw new HyracksDataException("Failed to allocate memory components since the index is not active.");
        }
        if (this.memoryComponentsAllocated) {
            return;
        }
        for (ILSMComponent c : this.memoryComponents) {
            LSMRTreeMemoryComponent mutableComponent = (LSMRTreeMemoryComponent)c;
            ((IVirtualBufferCache)mutableComponent.getRTree().getBufferCache()).open();
            mutableComponent.getRTree().create();
            mutableComponent.getBTree().create();
            mutableComponent.getRTree().activate();
            mutableComponent.getBTree().activate();
        }
        this.memoryComponentsAllocated = true;
    }

    private void addOperationalMutableComponents(List<ILSMComponent> operationalComponents) {
        int cmc = this.currentMutableComponentId.get();
        int numMutableComponents = this.memoryComponents.size();
        for (int i = 0; i < numMutableComponents - 1; ++i) {
            ILSMComponent c = (ILSMComponent)this.memoryComponents.get((cmc + i + 1) % numMutableComponents);
            LSMRTreeMemoryComponent mutableComponent = (LSMRTreeMemoryComponent)c;
            if (!mutableComponent.isReadable()) continue;
            operationalComponents.add(0, (ILSMComponent)mutableComponent);
        }
        operationalComponents.add(0, (ILSMComponent)this.memoryComponents.get(cmc));
    }

    private synchronized void clearMemoryComponents() throws HyracksDataException {
        if (this.memoryComponentsAllocated) {
            for (ILSMComponent c : this.memoryComponents) {
                LSMRTreeMemoryComponent mutableComponent = (LSMRTreeMemoryComponent)c;
                mutableComponent.getRTree().clear();
                mutableComponent.getBTree().clear();
                mutableComponent.reset();
            }
        }
    }

    private synchronized void deallocateMemoryComponents() throws HyracksDataException {
        if (this.memoryComponentsAllocated) {
            for (ILSMComponent c : this.memoryComponents) {
                LSMRTreeMemoryComponent mutableComponent = (LSMRTreeMemoryComponent)c;
                mutableComponent.getRTree().deactivate();
                mutableComponent.getBTree().deactivate();
                mutableComponent.getRTree().destroy();
                mutableComponent.getBTree().destroy();
                ((IVirtualBufferCache)mutableComponent.getRTree().getBufferCache()).close();
            }
            this.memoryComponentsAllocated = false;
        }
    }
}

