/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.core.rewriter.base;

import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalPlan;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.PhysicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractOperatorWithNestedPlans;
import org.apache.hyracks.algebricks.core.algebra.prettyprint.AlgebricksAppendable;
import org.apache.hyracks.algebricks.core.algebra.prettyprint.LogicalOperatorPrettyPrintVisitor;
import org.apache.hyracks.algebricks.core.algebra.prettyprint.PlanPrettyPrinter;
import org.apache.hyracks.algebricks.core.config.AlgebricksConfig;
import org.apache.hyracks.algebricks.core.rewriter.base.AbstractRuleController;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;

public class HeuristicOptimizer {
    public static PhysicalOperatorTag[] hyracksOperators = new PhysicalOperatorTag[]{PhysicalOperatorTag.DATASOURCE_SCAN, PhysicalOperatorTag.BTREE_SEARCH, PhysicalOperatorTag.EXTERNAL_GROUP_BY, PhysicalOperatorTag.HASH_GROUP_BY, PhysicalOperatorTag.HDFS_READER, PhysicalOperatorTag.HYBRID_HASH_JOIN, PhysicalOperatorTag.IN_MEMORY_HASH_JOIN, PhysicalOperatorTag.NESTED_LOOP, PhysicalOperatorTag.PRE_SORTED_DISTINCT_BY, PhysicalOperatorTag.PRE_CLUSTERED_GROUP_BY, PhysicalOperatorTag.REPLICATE, PhysicalOperatorTag.STABLE_SORT, PhysicalOperatorTag.UNION_ALL};
    public static PhysicalOperatorTag[] hyraxOperatorsBelowWhichJobGenIsDisabled = new PhysicalOperatorTag[0];
    private final IOptimizationContext context;
    private final List<Pair<AbstractRuleController, List<IAlgebraicRewriteRule>>> logicalRewrites;
    private final List<Pair<AbstractRuleController, List<IAlgebraicRewriteRule>>> physicalRewrites;
    private final ILogicalPlan plan;

    public static boolean isHyracksOp(PhysicalOperatorTag opTag) {
        for (PhysicalOperatorTag t : hyracksOperators) {
            if (t != opTag) continue;
            return true;
        }
        return false;
    }

    public HeuristicOptimizer(ILogicalPlan plan, List<Pair<AbstractRuleController, List<IAlgebraicRewriteRule>>> logicalRewrites, List<Pair<AbstractRuleController, List<IAlgebraicRewriteRule>>> physicalRewrites, IOptimizationContext context) {
        this.plan = plan;
        this.context = context;
        this.logicalRewrites = logicalRewrites;
        this.physicalRewrites = physicalRewrites;
    }

    public void optimize() throws AlgebricksException {
        if (this.plan == null) {
            return;
        }
        AlgebricksConfig.ALGEBRICKS_LOGGER.fine("Starting logical optimizations.\n");
        this.logPlanAt("Logical Plan", Level.FINE);
        this.runOptimizationSets(this.plan, this.logicalRewrites);
        HeuristicOptimizer.computeSchemaBottomUpForPlan(this.plan);
        this.runPhysicalOptimizations(this.plan, this.physicalRewrites);
        this.logPlanAt("Optimized Plan", Level.FINE);
    }

    private void logPlanAt(String name, Level lvl) throws AlgebricksException {
        if (AlgebricksConfig.ALGEBRICKS_LOGGER.isLoggable(lvl)) {
            LogicalOperatorPrettyPrintVisitor pvisitor = this.context.getPrettyPrintVisitor();
            pvisitor.reset(new AlgebricksAppendable());
            PlanPrettyPrinter.printPlan(this.plan, pvisitor, 0);
            AlgebricksConfig.ALGEBRICKS_LOGGER.info(name + ":\n" + pvisitor.get().toString());
        }
    }

    private void runOptimizationSets(ILogicalPlan plan, List<Pair<AbstractRuleController, List<IAlgebraicRewriteRule>>> optimSet) throws AlgebricksException {
        for (Pair<AbstractRuleController, List<IAlgebraicRewriteRule>> ruleList : optimSet) {
            for (Mutable<ILogicalOperator> r : plan.getRoots()) {
                ((AbstractRuleController)ruleList.first).setContext(this.context);
                ((AbstractRuleController)ruleList.first).rewriteWithRuleCollection(r, (Collection)ruleList.second);
            }
        }
    }

    private static void computeSchemaBottomUpForPlan(ILogicalPlan p) throws AlgebricksException {
        for (Mutable<ILogicalOperator> r : p.getRoots()) {
            HeuristicOptimizer.computeSchemaBottomUpForOp((AbstractLogicalOperator)r.getValue());
        }
    }

    private static void computeSchemaBottomUpForOp(AbstractLogicalOperator op) throws AlgebricksException {
        for (Mutable<ILogicalOperator> i : op.getInputs()) {
            HeuristicOptimizer.computeSchemaBottomUpForOp((AbstractLogicalOperator)i.getValue());
        }
        if (op.hasNestedPlans()) {
            AbstractOperatorWithNestedPlans a = (AbstractOperatorWithNestedPlans)op;
            for (ILogicalPlan p : a.getNestedPlans()) {
                HeuristicOptimizer.computeSchemaBottomUpForPlan(p);
            }
        }
        op.recomputeSchema();
    }

    private void runPhysicalOptimizations(ILogicalPlan plan, List<Pair<AbstractRuleController, List<IAlgebraicRewriteRule>>> physicalRewrites) throws AlgebricksException {
        AlgebricksConfig.ALGEBRICKS_LOGGER.fine("Starting physical optimizations.\n");
        this.runOptimizationSets(plan, physicalRewrites);
    }
}

