/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.core.algebra.prettyprint;

import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalPlan;
import org.apache.hyracks.algebricks.core.algebra.base.IPhysicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractOperatorWithNestedPlans;
import org.apache.hyracks.algebricks.core.algebra.prettyprint.AlgebricksAppendable;
import org.apache.hyracks.algebricks.core.algebra.prettyprint.LogicalOperatorPrettyPrintVisitor;

public class PlanPrettyPrinter {
    public static void printPlan(ILogicalPlan plan, LogicalOperatorPrettyPrintVisitor pvisitor, int indent) throws AlgebricksException {
        for (Mutable<ILogicalOperator> root : plan.getRoots()) {
            PlanPrettyPrinter.printOperator((AbstractLogicalOperator)root.getValue(), pvisitor, indent);
        }
    }

    public static void printPhysicalOps(ILogicalPlan plan, AlgebricksAppendable out, int indent) throws AlgebricksException {
        for (Mutable<ILogicalOperator> root : plan.getRoots()) {
            PlanPrettyPrinter.printPhysicalOperator((AbstractLogicalOperator)root.getValue(), indent, out);
        }
    }

    public static void printOperator(AbstractLogicalOperator op, LogicalOperatorPrettyPrintVisitor pvisitor, int indent) throws AlgebricksException {
        AlgebricksAppendable out = pvisitor.get();
        op.accept(pvisitor, indent);
        IPhysicalOperator pOp = op.getPhysicalOperator();
        if (pOp != null) {
            out.append("\n");
            PlanPrettyPrinter.pad(out, indent);
            PlanPrettyPrinter.appendln(out, "-- " + pOp.toString() + "  |" + (Object)((Object)op.getExecutionMode()) + "|");
        } else {
            PlanPrettyPrinter.appendln(out, " -- |" + (Object)((Object)op.getExecutionMode()) + "|");
        }
        for (Mutable<ILogicalOperator> i : op.getInputs()) {
            PlanPrettyPrinter.printOperator((AbstractLogicalOperator)i.getValue(), pvisitor, indent + 2);
        }
    }

    private static void printPhysicalOperator(AbstractLogicalOperator op, int indent, AlgebricksAppendable out) throws AlgebricksException {
        IPhysicalOperator pOp = op.getPhysicalOperator();
        PlanPrettyPrinter.pad(out, indent);
        PlanPrettyPrinter.appendln(out, "-- " + pOp.toString() + "  |" + (Object)((Object)op.getExecutionMode()) + "|");
        if (op.hasNestedPlans()) {
            AbstractOperatorWithNestedPlans opNest = (AbstractOperatorWithNestedPlans)op;
            for (ILogicalPlan p : opNest.getNestedPlans()) {
                PlanPrettyPrinter.pad(out, indent + 8);
                PlanPrettyPrinter.appendln(out, "{");
                PlanPrettyPrinter.printPhysicalOps(p, out, indent + 10);
                PlanPrettyPrinter.pad(out, indent + 8);
                PlanPrettyPrinter.appendln(out, "}");
            }
        }
        for (Mutable<ILogicalOperator> i : op.getInputs()) {
            PlanPrettyPrinter.printPhysicalOperator((AbstractLogicalOperator)i.getValue(), indent + 2, out);
        }
    }

    private static void appendln(AlgebricksAppendable buf, String s) throws AlgebricksException {
        buf.append(s);
        buf.append("\n");
    }

    private static void pad(AlgebricksAppendable buf, int indent) throws AlgebricksException {
        for (int i = 0; i < indent; ++i) {
            buf.append(' ');
        }
    }
}

