/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.core.algebra.prettyprint;

import java.util.List;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.common.utils.Triple;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalPlan;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractOperatorWithNestedPlans;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractUnnestMapOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AggregateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AssignOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DataSourceScanOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DelegateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DistinctOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DistributeResultOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.EmptyTupleSourceOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ExchangeOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.GroupByOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.IndexInsertDeleteUpsertOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.InnerJoinOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.InsertDeleteUpsertOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.IntersectOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.LeftOuterJoinOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.LeftOuterUnnestMapOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.LeftOuterUnnestOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.LimitOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.MaterializeOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.NestedTupleSourceOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.OrderOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ProjectOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ReplicateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.RunningAggregateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ScriptOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SelectOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SinkOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SplitOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SubplanOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.TokenizeOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnionAllOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnnestMapOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnnestOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.WriteOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.WriteResultOperator;
import org.apache.hyracks.algebricks.core.algebra.prettyprint.AlgebricksAppendable;
import org.apache.hyracks.algebricks.core.algebra.prettyprint.LogicalExpressionPrettyPrintVisitor;
import org.apache.hyracks.algebricks.core.algebra.prettyprint.PlanPrettyPrinter;
import org.apache.hyracks.algebricks.core.algebra.visitors.ILogicalExpressionVisitor;
import org.apache.hyracks.algebricks.core.algebra.visitors.ILogicalOperatorVisitor;

public class LogicalOperatorPrettyPrintVisitor
implements ILogicalOperatorVisitor<Void, Integer> {
    ILogicalExpressionVisitor<String, Integer> exprVisitor;
    AlgebricksAppendable buffer;

    public LogicalOperatorPrettyPrintVisitor() {
        this(new AlgebricksAppendable());
    }

    public LogicalOperatorPrettyPrintVisitor(Appendable app) {
        this(new AlgebricksAppendable(app), new LogicalExpressionPrettyPrintVisitor());
    }

    public LogicalOperatorPrettyPrintVisitor(AlgebricksAppendable buffer) {
        this(buffer, new LogicalExpressionPrettyPrintVisitor());
    }

    public LogicalOperatorPrettyPrintVisitor(AlgebricksAppendable buffer, ILogicalExpressionVisitor<String, Integer> exprVisitor) {
        this.reset(buffer);
        this.exprVisitor = exprVisitor;
    }

    public AlgebricksAppendable reset(AlgebricksAppendable buffer) {
        AlgebricksAppendable old = this.buffer;
        this.buffer = buffer;
        return old;
    }

    public AlgebricksAppendable get() {
        return this.buffer;
    }

    public String toString() {
        return this.buffer.toString();
    }

    CharSequence str(Object o) {
        return String.valueOf(o);
    }

    @Override
    public Void visitAggregateOperator(AggregateOperator op, Integer indent) throws AlgebricksException {
        this.addIndent(indent).append("aggregate ").append(this.str(op.getVariables())).append(" <- ");
        this.pprintExprList(op.getExpressions(), indent);
        return null;
    }

    @Override
    public Void visitRunningAggregateOperator(RunningAggregateOperator op, Integer indent) throws AlgebricksException {
        this.addIndent(indent).append("running-aggregate ").append(this.str(op.getVariables())).append(" <- ");
        this.pprintExprList(op.getExpressions(), indent);
        return null;
    }

    @Override
    public Void visitEmptyTupleSourceOperator(EmptyTupleSourceOperator op, Integer indent) throws AlgebricksException {
        this.addIndent(indent).append("empty-tuple-source");
        return null;
    }

    @Override
    public Void visitGroupByOperator(GroupByOperator op, Integer indent) throws AlgebricksException {
        this.addIndent(indent).append("group by" + (op.isGroupAll() ? " (all)" : "") + " (");
        this.pprintVeList(op.getGroupByList(), indent);
        this.buffer.append(") decor (");
        this.pprintVeList(op.getDecorList(), indent);
        this.buffer.append(") {");
        this.printNestedPlans(op, indent);
        return null;
    }

    @Override
    public Void visitDistinctOperator(DistinctOperator op, Integer indent) throws AlgebricksException {
        this.addIndent(indent).append("distinct (");
        this.pprintExprList(op.getExpressions(), indent);
        this.buffer.append(")");
        return null;
    }

    @Override
    public Void visitInnerJoinOperator(InnerJoinOperator op, Integer indent) throws AlgebricksException {
        this.addIndent(indent).append("join (").append(((ILogicalExpression)op.getCondition().getValue()).accept(this.exprVisitor, indent)).append(")");
        return null;
    }

    @Override
    public Void visitLeftOuterJoinOperator(LeftOuterJoinOperator op, Integer indent) throws AlgebricksException {
        this.addIndent(indent).append("left outer join (").append(((ILogicalExpression)op.getCondition().getValue()).accept(this.exprVisitor, indent)).append(")");
        return null;
    }

    @Override
    public Void visitNestedTupleSourceOperator(NestedTupleSourceOperator op, Integer indent) throws AlgebricksException {
        this.addIndent(indent).append("nested tuple source");
        return null;
    }

    @Override
    public Void visitOrderOperator(OrderOperator op, Integer indent) throws AlgebricksException {
        this.addIndent(indent).append("order ");
        for (Pair<OrderOperator.IOrder, Mutable<ILogicalExpression>> p : op.getOrderExpressions()) {
            if (op.getTopK() != -1) {
                this.buffer.append("(topK: " + op.getTopK() + ") ");
            }
            String fst = this.getOrderString((OrderOperator.IOrder)p.first);
            this.buffer.append("(" + fst + ", " + ((ILogicalExpression)((Mutable)p.second).getValue()).accept(this.exprVisitor, indent) + ") ");
        }
        return null;
    }

    private String getOrderString(OrderOperator.IOrder first) {
        switch (first.getKind()) {
            case ASC: {
                return "ASC";
            }
            case DESC: {
                return "DESC";
            }
        }
        return first.getExpressionRef().toString();
    }

    @Override
    public Void visitAssignOperator(AssignOperator op, Integer indent) throws AlgebricksException {
        this.addIndent(indent).append("assign ").append(this.str(op.getVariables())).append(" <- ");
        this.pprintExprList(op.getExpressions(), indent);
        return null;
    }

    @Override
    public Void visitWriteOperator(WriteOperator op, Integer indent) throws AlgebricksException {
        this.addIndent(indent).append("write ");
        this.pprintExprList(op.getExpressions(), indent);
        return null;
    }

    @Override
    public Void visitDistributeResultOperator(DistributeResultOperator op, Integer indent) throws AlgebricksException {
        this.addIndent(indent).append("distribute result ");
        this.pprintExprList(op.getExpressions(), indent);
        return null;
    }

    @Override
    public Void visitWriteResultOperator(WriteResultOperator op, Integer indent) throws AlgebricksException {
        this.addIndent(indent).append("load ").append(this.str(op.getDataSource())).append(" from ").append(((ILogicalExpression)op.getPayloadExpression().getValue()).accept(this.exprVisitor, indent)).append(" partitioned by ");
        this.pprintExprList(op.getKeyExpressions(), indent);
        return null;
    }

    @Override
    public Void visitSelectOperator(SelectOperator op, Integer indent) throws AlgebricksException {
        this.addIndent(indent).append("select (").append(((ILogicalExpression)op.getCondition().getValue()).accept(this.exprVisitor, indent)).append(")");
        return null;
    }

    @Override
    public Void visitProjectOperator(ProjectOperator op, Integer indent) throws AlgebricksException {
        this.addIndent(indent).append("project (" + op.getVariables() + ")");
        return null;
    }

    @Override
    public Void visitSubplanOperator(SubplanOperator op, Integer indent) throws AlgebricksException {
        this.addIndent(indent).append("subplan {");
        this.printNestedPlans(op, indent);
        return null;
    }

    @Override
    public Void visitUnionOperator(UnionAllOperator op, Integer indent) throws AlgebricksException {
        this.addIndent(indent).append("union");
        for (Triple<LogicalVariable, LogicalVariable, LogicalVariable> v : op.getVariableMappings()) {
            this.buffer.append(" (" + v.first + ", " + v.second + ", " + v.third + ")");
        }
        return null;
    }

    @Override
    public Void visitIntersectOperator(IntersectOperator op, Integer indent) throws AlgebricksException {
        int i;
        this.addIndent(indent).append("intersect (");
        this.buffer.append('[');
        for (i = 0; i < op.getOutputVars().size(); ++i) {
            if (i > 0) {
                this.buffer.append(", ");
            }
            this.buffer.append(this.str(op.getOutputVars().get(i)));
        }
        this.buffer.append("] <- [");
        for (i = 0; i < op.getNumInput(); ++i) {
            if (i > 0) {
                this.buffer.append(", ");
            }
            this.buffer.append('[');
            for (int j = 0; j < op.getInputVariables(i).size(); ++j) {
                if (j > 0) {
                    this.buffer.append(", ");
                }
                this.buffer.append(this.str(op.getInputVariables(i).get(j)));
            }
            this.buffer.append(']');
        }
        this.buffer.append("])");
        return null;
    }

    @Override
    public Void visitUnnestOperator(UnnestOperator op, Integer indent) throws AlgebricksException {
        this.addIndent(indent).append("unnest " + op.getVariable());
        if (op.getPositionalVariable() != null) {
            this.buffer.append(" at " + op.getPositionalVariable());
        }
        this.buffer.append(" <- " + ((ILogicalExpression)op.getExpressionRef().getValue()).accept(this.exprVisitor, indent));
        return null;
    }

    @Override
    public Void visitLeftOuterUnnestOperator(LeftOuterUnnestOperator op, Integer indent) throws AlgebricksException {
        this.addIndent(indent).append("outer-unnest " + op.getVariable());
        if (op.getPositionalVariable() != null) {
            this.buffer.append(" at " + op.getPositionalVariable());
        }
        this.buffer.append(" <- " + ((ILogicalExpression)op.getExpressionRef().getValue()).accept(this.exprVisitor, indent));
        return null;
    }

    @Override
    public Void visitUnnestMapOperator(UnnestMapOperator op, Integer indent) throws AlgebricksException {
        return this.printAbstractUnnestMapOperator(op, indent, "unnest-map");
    }

    @Override
    public Void visitLeftOuterUnnestMapOperator(LeftOuterUnnestMapOperator op, Integer indent) throws AlgebricksException {
        return this.printAbstractUnnestMapOperator(op, indent, "left-outer-unnest-map");
    }

    private Void printAbstractUnnestMapOperator(AbstractUnnestMapOperator op, Integer indent, String opSignature) throws AlgebricksException {
        this.addIndent(indent).append(opSignature + " " + op.getVariables() + " <- " + ((ILogicalExpression)op.getExpressionRef().getValue()).accept(this.exprVisitor, indent));
        return null;
    }

    @Override
    public Void visitDataScanOperator(DataSourceScanOperator op, Integer indent) throws AlgebricksException {
        this.addIndent(indent).append("data-scan " + op.getProjectVariables() + "<-" + op.getVariables() + " <- " + op.getDataSource());
        return null;
    }

    @Override
    public Void visitLimitOperator(LimitOperator op, Integer indent) throws AlgebricksException {
        this.addIndent(indent).append("limit " + ((ILogicalExpression)op.getMaxObjects().getValue()).accept(this.exprVisitor, indent));
        ILogicalExpression offset = (ILogicalExpression)op.getOffset().getValue();
        if (offset != null) {
            this.buffer.append(", " + offset.accept(this.exprVisitor, indent));
        }
        return null;
    }

    @Override
    public Void visitExchangeOperator(ExchangeOperator op, Integer indent) throws AlgebricksException {
        this.addIndent(indent).append("exchange");
        return null;
    }

    @Override
    public Void visitScriptOperator(ScriptOperator op, Integer indent) throws AlgebricksException {
        this.addIndent(indent).append("script (in: " + op.getInputVariables() + ") (out: " + op.getOutputVariables() + ")");
        return null;
    }

    @Override
    public Void visitReplicateOperator(ReplicateOperator op, Integer indent) throws AlgebricksException {
        this.addIndent(indent).append("replicate");
        return null;
    }

    @Override
    public Void visitSplitOperator(SplitOperator op, Integer indent) throws AlgebricksException {
        Mutable<ILogicalExpression> branchingExpression = op.getBranchingExpression();
        this.addIndent(indent).append("split " + ((ILogicalExpression)branchingExpression.getValue()).accept(this.exprVisitor, indent));
        return null;
    }

    @Override
    public Void visitMaterializeOperator(MaterializeOperator op, Integer indent) throws AlgebricksException {
        this.addIndent(indent).append("materialize");
        return null;
    }

    @Override
    public Void visitInsertDeleteUpsertOperator(InsertDeleteUpsertOperator op, Integer indent) throws AlgebricksException {
        String header = this.getIndexOpString(op.getOperation());
        this.addIndent(indent).append(header).append(this.str(op.getDataSource())).append(" from record: ").append(((ILogicalExpression)op.getPayloadExpression().getValue()).accept(this.exprVisitor, indent));
        if (op.getAdditionalNonFilteringExpressions() != null) {
            this.buffer.append(", meta: ");
            this.pprintExprList(op.getAdditionalNonFilteringExpressions(), indent);
        }
        this.buffer.append(" partitioned by ");
        this.pprintExprList(op.getPrimaryKeyExpressions(), indent);
        if (op.getOperation() == InsertDeleteUpsertOperator.Kind.UPSERT) {
            this.buffer.append(" out: ([record-before-upsert:" + op.getBeforeOpRecordVar() + (op.getBeforeOpAdditionalNonFilteringVars() != null ? ", additional-before-upsert: " + op.getBeforeOpAdditionalNonFilteringVars() : "") + "]) ");
        }
        if (op.isBulkload()) {
            this.buffer.append(" [bulkload]");
        }
        return null;
    }

    @Override
    public Void visitIndexInsertDeleteUpsertOperator(IndexInsertDeleteUpsertOperator op, Integer indent) throws AlgebricksException {
        String header = this.getIndexOpString(op.getOperation());
        this.addIndent(indent).append(header).append(op.getIndexName()).append(" on ").append(this.str(op.getDataSourceIndex().getDataSource())).append(" from ");
        if (op.getOperation() == InsertDeleteUpsertOperator.Kind.UPSERT) {
            this.buffer.append(" replace:");
            this.pprintExprList(op.getPrevSecondaryKeyExprs(), indent);
            this.buffer.append(" with:");
            this.pprintExprList(op.getSecondaryKeyExpressions(), indent);
        } else {
            this.pprintExprList(op.getSecondaryKeyExpressions(), indent);
        }
        if (op.isBulkload()) {
            this.buffer.append(" [bulkload]");
        }
        return null;
    }

    public String getIndexOpString(InsertDeleteUpsertOperator.Kind opKind) {
        switch (opKind) {
            case DELETE: {
                return "delete from ";
            }
            case INSERT: {
                return "insert into ";
            }
            case UPSERT: {
                return "upsert into ";
            }
        }
        return null;
    }

    @Override
    public Void visitTokenizeOperator(TokenizeOperator op, Integer indent) throws AlgebricksException {
        this.addIndent(indent).append("tokenize ").append(this.str(op.getTokenizeVars())).append(" <- ");
        this.pprintExprList(op.getSecondaryKeyExpressions(), indent);
        return null;
    }

    @Override
    public Void visitSinkOperator(SinkOperator op, Integer indent) throws AlgebricksException {
        this.addIndent(indent).append("sink");
        return null;
    }

    @Override
    public Void visitDelegateOperator(DelegateOperator op, Integer indent) throws AlgebricksException {
        this.addIndent(indent).append(op.toString());
        return null;
    }

    protected AlgebricksAppendable addIndent(int level) throws AlgebricksException {
        for (int i = 0; i < level; ++i) {
            this.buffer.append(' ');
        }
        return this.buffer;
    }

    protected void printNestedPlans(AbstractOperatorWithNestedPlans op, Integer indent) throws AlgebricksException {
        boolean first = true;
        if (op.getNestedPlans().isEmpty()) {
            this.buffer.append("}");
        } else {
            for (ILogicalPlan p : op.getNestedPlans()) {
                this.buffer.append("\n");
                if (first) {
                    first = false;
                } else {
                    this.addIndent(indent).append("       {\n");
                }
                PlanPrettyPrinter.printPlan(p, this, indent + 10);
                this.addIndent(indent).append("       }");
            }
        }
    }

    protected void pprintExprList(List<Mutable<ILogicalExpression>> expressions, Integer indent) throws AlgebricksException {
        this.buffer.append("[");
        boolean first = true;
        for (Mutable<ILogicalExpression> exprRef : expressions) {
            if (first) {
                first = false;
            } else {
                this.buffer.append(", ");
            }
            this.buffer.append(((ILogicalExpression)exprRef.getValue()).accept(this.exprVisitor, indent));
        }
        this.buffer.append("]");
    }

    protected void pprintVeList(List<Pair<LogicalVariable, Mutable<ILogicalExpression>>> vePairList, Integer indent) throws AlgebricksException {
        this.buffer.append("[");
        boolean fst = true;
        for (Pair<LogicalVariable, Mutable<ILogicalExpression>> ve : vePairList) {
            if (fst) {
                fst = false;
            } else {
                this.buffer.append("; ");
            }
            if (ve.first != null) {
                this.buffer.append(ve.first + " := " + ve.second);
                continue;
            }
            this.buffer.append(((ILogicalExpression)((Mutable)ve.second).getValue()).accept(this.exprVisitor, indent));
        }
        this.buffer.append("]");
    }
}

