/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.core.algebra.operators.physical;

import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.exceptions.NotImplementedException;
import org.apache.hyracks.algebricks.core.algebra.base.IHyracksJobBuilder;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.PhysicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.expressions.IExpressionRuntimeProvider;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractBinaryJoinOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.IOperatorSchema;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.AbstractJoinPOperator;
import org.apache.hyracks.algebricks.core.algebra.properties.BroadcastPartitioningProperty;
import org.apache.hyracks.algebricks.core.algebra.properties.IPartitioningProperty;
import org.apache.hyracks.algebricks.core.algebra.properties.IPartitioningRequirementsCoordinator;
import org.apache.hyracks.algebricks.core.algebra.properties.IPhysicalPropertiesVector;
import org.apache.hyracks.algebricks.core.algebra.properties.PhysicalRequirements;
import org.apache.hyracks.algebricks.core.algebra.properties.RandomPartitioningProperty;
import org.apache.hyracks.algebricks.core.algebra.properties.StructuralPropertiesVector;
import org.apache.hyracks.algebricks.core.algebra.util.OperatorPropertiesUtil;
import org.apache.hyracks.algebricks.core.jobgen.impl.JobGenContext;
import org.apache.hyracks.algebricks.core.jobgen.impl.JobGenHelper;
import org.apache.hyracks.algebricks.data.IBinaryBooleanInspector;
import org.apache.hyracks.algebricks.data.IBinaryBooleanInspectorFactory;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.IOperatorDescriptor;
import org.apache.hyracks.api.dataflow.value.IMissingWriterFactory;
import org.apache.hyracks.api.dataflow.value.ITuplePairComparator;
import org.apache.hyracks.api.dataflow.value.ITuplePairComparatorFactory;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.job.IOperatorDescriptorRegistry;
import org.apache.hyracks.api.job.JobSpecification;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.dataflow.common.data.accessors.FrameTupleReference;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;
import org.apache.hyracks.dataflow.std.join.NestedLoopJoinOperatorDescriptor;

public class NestedLoopJoinPOperator
extends AbstractJoinPOperator {
    private final int memSize;

    public NestedLoopJoinPOperator(AbstractBinaryJoinOperator.JoinKind kind, AbstractJoinPOperator.JoinPartitioningType partitioningType, int memSize) {
        super(kind, partitioningType);
        this.memSize = memSize;
    }

    @Override
    public PhysicalOperatorTag getOperatorTag() {
        return PhysicalOperatorTag.NESTED_LOOP;
    }

    @Override
    public boolean isMicroOperator() {
        return false;
    }

    @Override
    public void computeDeliveredProperties(ILogicalOperator iop, IOptimizationContext context) {
        AbstractLogicalOperator op2;
        IPhysicalPropertiesVector pv1;
        if (this.partitioningType != AbstractJoinPOperator.JoinPartitioningType.BROADCAST) {
            throw new NotImplementedException((Object)((Object)this.partitioningType) + " nested loop joins are not implemented.");
        }
        AbstractLogicalOperator op = (AbstractLogicalOperator)iop;
        Object pp = op.getExecutionMode() == AbstractLogicalOperator.ExecutionMode.PARTITIONED ? ((pv1 = (op2 = (AbstractLogicalOperator)op.getInputs().get(1).getValue()).getPhysicalOperator().getDeliveredProperties()) == null ? null : pv1.getPartitioningProperty()) : IPartitioningProperty.UNPARTITIONED;
        this.deliveredProperties = new StructuralPropertiesVector((IPartitioningProperty)pp, null);
    }

    @Override
    public PhysicalRequirements getRequiredPropertiesForChildren(ILogicalOperator op, IPhysicalPropertiesVector reqdByParent, IOptimizationContext context) {
        if (this.partitioningType != AbstractJoinPOperator.JoinPartitioningType.BROADCAST) {
            throw new NotImplementedException((Object)((Object)this.partitioningType) + " nested loop joins are not implemented.");
        }
        IPhysicalPropertiesVector[] pv = new StructuralPropertiesVector[]{OperatorPropertiesUtil.checkUnpartitionedAndGetPropertiesVector(op, new StructuralPropertiesVector(new RandomPartitioningProperty(context.getComputationNodeDomain()), null)), OperatorPropertiesUtil.checkUnpartitionedAndGetPropertiesVector(op, new StructuralPropertiesVector(new BroadcastPartitioningProperty(context.getComputationNodeDomain()), null))};
        return new PhysicalRequirements(pv, IPartitioningRequirementsCoordinator.NO_COORDINATION);
    }

    @Override
    public void contributeRuntimeOperator(IHyracksJobBuilder builder, JobGenContext context, ILogicalOperator op, IOperatorSchema propagatedSchema, IOperatorSchema[] inputSchemas, IOperatorSchema outerPlanSchema) throws AlgebricksException {
        AbstractBinaryJoinOperator join = (AbstractBinaryJoinOperator)op;
        RecordDescriptor recDescriptor = JobGenHelper.mkRecordDescriptor(context.getTypeEnvironment(op), propagatedSchema, context);
        IOperatorSchema[] conditionInputSchemas = new IOperatorSchema[]{propagatedSchema};
        IExpressionRuntimeProvider expressionRuntimeProvider = context.getExpressionRuntimeProvider();
        IScalarEvaluatorFactory cond = expressionRuntimeProvider.createEvaluatorFactory((ILogicalExpression)join.getCondition().getValue(), context.getTypeEnvironment(op), conditionInputSchemas, context);
        TuplePairEvaluatorFactory comparatorFactory = new TuplePairEvaluatorFactory(cond, context.getBinaryBooleanInspectorFactory());
        JobSpecification spec = builder.getJobSpec();
        NestedLoopJoinOperatorDescriptor opDesc = null;
        switch (this.kind) {
            case INNER: {
                opDesc = new NestedLoopJoinOperatorDescriptor((IOperatorDescriptorRegistry)spec, (ITuplePairComparatorFactory)comparatorFactory, recDescriptor, this.memSize, false, null);
                break;
            }
            case LEFT_OUTER: {
                IMissingWriterFactory[] nonMatchWriterFactories = new IMissingWriterFactory[inputSchemas[1].getSize()];
                for (int j = 0; j < nonMatchWriterFactories.length; ++j) {
                    nonMatchWriterFactories[j] = context.getMissingWriterFactory();
                }
                opDesc = new NestedLoopJoinOperatorDescriptor((IOperatorDescriptorRegistry)spec, (ITuplePairComparatorFactory)comparatorFactory, recDescriptor, this.memSize, true, nonMatchWriterFactories);
                break;
            }
            default: {
                throw new NotImplementedException();
            }
        }
        this.contributeOpDesc(builder, (AbstractLogicalOperator)op, (IOperatorDescriptor)opDesc);
        ILogicalOperator src1 = (ILogicalOperator)op.getInputs().get(0).getValue();
        builder.contributeGraphEdge(src1, 0, op, 0);
        ILogicalOperator src2 = (ILogicalOperator)op.getInputs().get(1).getValue();
        builder.contributeGraphEdge(src2, 0, op, 1);
    }

    public static class CompositeFrameTupleReference
    implements IFrameTupleReference {
        private final FrameTupleReference refLeft;
        private final FrameTupleReference refRight;

        public CompositeFrameTupleReference(FrameTupleReference refLeft, FrameTupleReference refRight) {
            this.refLeft = refLeft;
            this.refRight = refRight;
        }

        public void reset(IFrameTupleAccessor outerAccessor, int outerIndex, IFrameTupleAccessor innerAccessor, int innerIndex) {
            this.refLeft.reset(outerAccessor, outerIndex);
            this.refRight.reset(innerAccessor, innerIndex);
        }

        public int getFieldCount() {
            return this.refLeft.getFieldCount() + this.refRight.getFieldCount();
        }

        public byte[] getFieldData(int fIdx) {
            int leftFieldCount = this.refLeft.getFieldCount();
            if (fIdx < leftFieldCount) {
                return this.refLeft.getFieldData(fIdx);
            }
            return this.refRight.getFieldData(fIdx - leftFieldCount);
        }

        public int getFieldStart(int fIdx) {
            int leftFieldCount = this.refLeft.getFieldCount();
            if (fIdx < leftFieldCount) {
                return this.refLeft.getFieldStart(fIdx);
            }
            return this.refRight.getFieldStart(fIdx - leftFieldCount);
        }

        public int getFieldLength(int fIdx) {
            int leftFieldCount = this.refLeft.getFieldCount();
            if (fIdx < leftFieldCount) {
                return this.refLeft.getFieldLength(fIdx);
            }
            return this.refRight.getFieldLength(fIdx - leftFieldCount);
        }

        public IFrameTupleAccessor getFrameTupleAccessor() {
            throw new NotImplementedException();
        }

        public int getTupleIndex() {
            throw new NotImplementedException();
        }
    }

    public static class TuplePairEvaluator
    implements ITuplePairComparator {
        private final IHyracksTaskContext ctx;
        private IScalarEvaluator condEvaluator;
        private final IPointable p;
        private final CompositeFrameTupleReference compositeTupleRef;
        private final FrameTupleReference leftRef;
        private final FrameTupleReference rightRef;
        private final IBinaryBooleanInspector binaryBooleanInspector;

        public TuplePairEvaluator(IHyracksTaskContext ctx, IScalarEvaluatorFactory condFactory, IBinaryBooleanInspector binaryBooleanInspector) throws HyracksDataException {
            this.ctx = ctx;
            this.condEvaluator = condFactory.createScalarEvaluator(ctx);
            this.binaryBooleanInspector = binaryBooleanInspector;
            this.leftRef = new FrameTupleReference();
            this.p = VoidPointable.FACTORY.createPointable();
            this.rightRef = new FrameTupleReference();
            this.compositeTupleRef = new CompositeFrameTupleReference(this.leftRef, this.rightRef);
        }

        public int compare(IFrameTupleAccessor outerAccessor, int outerIndex, IFrameTupleAccessor innerAccessor, int innerIndex) throws HyracksDataException {
            this.compositeTupleRef.reset(outerAccessor, outerIndex, innerAccessor, innerIndex);
            this.condEvaluator.evaluate((IFrameTupleReference)this.compositeTupleRef, this.p);
            boolean result = this.binaryBooleanInspector.getBooleanValue(this.p.getByteArray(), this.p.getStartOffset(), this.p.getLength());
            if (result) {
                return 0;
            }
            return 1;
        }
    }

    public static class TuplePairEvaluatorFactory
    implements ITuplePairComparatorFactory {
        private static final long serialVersionUID = 1L;
        private final IScalarEvaluatorFactory cond;
        private final IBinaryBooleanInspectorFactory binaryBooleanInspectorFactory;

        public TuplePairEvaluatorFactory(IScalarEvaluatorFactory cond, IBinaryBooleanInspectorFactory binaryBooleanInspectorFactory) {
            this.cond = cond;
            this.binaryBooleanInspectorFactory = binaryBooleanInspectorFactory;
        }

        public synchronized ITuplePairComparator createTuplePairComparator(IHyracksTaskContext ctx) throws HyracksDataException {
            return new TuplePairEvaluator(ctx, this.cond, this.binaryBooleanInspectorFactory.createBinaryBooleanInspector(ctx));
        }
    }
}

