/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.core.algebra.operators.physical;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.IHyracksJobBuilder;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.base.PhysicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.IOperatorSchema;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.IntersectOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.OrderOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.AbstractPhysicalOperator;
import org.apache.hyracks.algebricks.core.algebra.properties.ILocalStructuralProperty;
import org.apache.hyracks.algebricks.core.algebra.properties.IPartitioningProperty;
import org.apache.hyracks.algebricks.core.algebra.properties.IPartitioningRequirementsCoordinator;
import org.apache.hyracks.algebricks.core.algebra.properties.IPhysicalPropertiesVector;
import org.apache.hyracks.algebricks.core.algebra.properties.LocalOrderProperty;
import org.apache.hyracks.algebricks.core.algebra.properties.OrderColumn;
import org.apache.hyracks.algebricks.core.algebra.properties.PhysicalRequirements;
import org.apache.hyracks.algebricks.core.algebra.properties.StructuralPropertiesVector;
import org.apache.hyracks.algebricks.core.algebra.properties.UnorderedPartitionedProperty;
import org.apache.hyracks.algebricks.core.jobgen.impl.JobGenContext;
import org.apache.hyracks.algebricks.core.jobgen.impl.JobGenHelper;
import org.apache.hyracks.algebricks.data.INormalizedKeyComputerFactoryProvider;
import org.apache.hyracks.api.dataflow.IOperatorDescriptor;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.dataflow.value.INormalizedKeyComputerFactory;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksException;
import org.apache.hyracks.api.job.IOperatorDescriptorRegistry;
import org.apache.hyracks.api.job.JobSpecification;
import org.apache.hyracks.dataflow.std.intersect.IntersectOperatorDescriptor;

public class IntersectPOperator
extends AbstractPhysicalOperator {
    @Override
    public PhysicalOperatorTag getOperatorTag() {
        return PhysicalOperatorTag.INTERSECT;
    }

    @Override
    public PhysicalRequirements getRequiredPropertiesForChildren(ILogicalOperator iop, IPhysicalPropertiesVector reqdByParent, IOptimizationContext context) {
        IntersectOperator intersectOp = (IntersectOperator)iop;
        IPhysicalPropertiesVector[] pv = new StructuralPropertiesVector[intersectOp.getNumInput()];
        for (int i = 0; i < intersectOp.getNumInput(); ++i) {
            ArrayList<ILocalStructuralProperty> localProps = new ArrayList<ILocalStructuralProperty>();
            ArrayList<OrderColumn> orderColumns = new ArrayList<OrderColumn>();
            for (LogicalVariable column : intersectOp.getInputVariables(i)) {
                orderColumns.add(new OrderColumn(column, OrderOperator.IOrder.OrderKind.ASC));
            }
            localProps.add(new LocalOrderProperty(orderColumns));
            UnorderedPartitionedProperty pp = null;
            if (intersectOp.getExecutionMode() == AbstractLogicalOperator.ExecutionMode.PARTITIONED) {
                HashSet<LogicalVariable> partitioningVariables = new HashSet<LogicalVariable>(intersectOp.getInputVariables(i));
                pp = new UnorderedPartitionedProperty(partitioningVariables, null);
            }
            pv[i] = new StructuralPropertiesVector(pp, localProps);
        }
        return new PhysicalRequirements(pv, IPartitioningRequirementsCoordinator.NO_COORDINATION);
    }

    @Override
    public void computeDeliveredProperties(ILogicalOperator iop, IOptimizationContext context) throws AlgebricksException {
        IntersectOperator op = (IntersectOperator)iop;
        IPartitioningProperty pp = ((ILogicalOperator)op.getInputs().get(0).getValue()).getDeliveredPhysicalProperties().getPartitioningProperty();
        HashMap<LogicalVariable, LogicalVariable> varMaps = new HashMap<LogicalVariable, LogicalVariable>(op.getOutputVars().size());
        for (int i = 0; i < op.getOutputVars().size(); ++i) {
            varMaps.put(op.getInputVariables(0).get(i), op.getOutputVars().get(i));
        }
        pp.substituteColumnVars(varMaps);
        ArrayList<ILocalStructuralProperty> propsLocal = new ArrayList<ILocalStructuralProperty>();
        ArrayList<OrderColumn> orderColumns = new ArrayList<OrderColumn>();
        for (LogicalVariable var : op.getOutputVars()) {
            orderColumns.add(new OrderColumn(var, OrderOperator.IOrder.OrderKind.ASC));
        }
        propsLocal.add(new LocalOrderProperty(orderColumns));
        this.deliveredProperties = new StructuralPropertiesVector(pp, propsLocal);
    }

    @Override
    public void contributeRuntimeOperator(IHyracksJobBuilder builder, JobGenContext context, ILogicalOperator op, IOperatorSchema opSchema, IOperatorSchema[] inputSchemas, IOperatorSchema outerPlanSchema) throws AlgebricksException {
        Object type;
        IntersectOperator logicalOp = (IntersectOperator)op;
        int nInput = logicalOp.getNumInput();
        int[][] compareFields = new int[nInput][];
        IBinaryComparatorFactory[] comparatorFactories = JobGenHelper.variablesToAscBinaryComparatorFactories(logicalOp.getInputVariables(0), context.getTypeEnvironment(op), context);
        INormalizedKeyComputerFactoryProvider nkcfProvider = context.getNormalizedKeyComputerFactoryProvider();
        INormalizedKeyComputerFactory nkcf = null;
        if (nkcfProvider != null && (type = context.getTypeEnvironment(op).getVarType(logicalOp.getInputVariables(0).get(0))) != null) {
            nkcf = nkcfProvider.getNormalizedKeyComputerFactory(type, true);
        }
        for (int i = 0; i < logicalOp.getNumInput(); ++i) {
            compareFields[i] = JobGenHelper.variablesToFieldIndexes(logicalOp.getInputVariables(i), inputSchemas[i]);
        }
        JobSpecification spec = builder.getJobSpec();
        RecordDescriptor recordDescriptor = JobGenHelper.mkRecordDescriptor(context.getTypeEnvironment(op), opSchema, context);
        IntersectOperatorDescriptor opDescriptor = null;
        try {
            opDescriptor = new IntersectOperatorDescriptor((IOperatorDescriptorRegistry)spec, nInput, (int[][])compareFields, nkcf, comparatorFactories, recordDescriptor);
        }
        catch (HyracksException e) {
            throw new AlgebricksException((Throwable)e);
        }
        this.contributeOpDesc(builder, (AbstractLogicalOperator)op, (IOperatorDescriptor)opDescriptor);
        for (int i = 0; i < op.getInputs().size(); ++i) {
            builder.contributeGraphEdge((ILogicalOperator)op.getInputs().get(i).getValue(), 0, op, i);
        }
    }

    @Override
    public boolean isMicroOperator() {
        return false;
    }

    @Override
    public boolean expensiveThanMaterialization() {
        return false;
    }
}

