/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.core.algebra.operators.physical;

import java.util.ArrayList;
import java.util.List;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksPartitionConstraint;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.core.algebra.base.IHyracksJobBuilder;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.base.PhysicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;
import org.apache.hyracks.algebricks.core.algebra.metadata.IDataSource;
import org.apache.hyracks.algebricks.core.algebra.metadata.IMetadataProvider;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.IOperatorSchema;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.InsertDeleteUpsertOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.AbstractPhysicalOperator;
import org.apache.hyracks.algebricks.core.algebra.properties.IPartitioningRequirementsCoordinator;
import org.apache.hyracks.algebricks.core.algebra.properties.IPhysicalPropertiesVector;
import org.apache.hyracks.algebricks.core.algebra.properties.PhysicalRequirements;
import org.apache.hyracks.algebricks.core.jobgen.impl.JobGenContext;
import org.apache.hyracks.algebricks.core.jobgen.impl.JobGenHelper;
import org.apache.hyracks.api.dataflow.IOperatorDescriptor;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.job.JobSpecification;

public class InsertDeleteUpsertPOperator
extends AbstractPhysicalOperator {
    private final LogicalVariable payload;
    private final List<LogicalVariable> keys;
    private final IDataSource<?> dataSource;
    private final List<LogicalVariable> additionalFilteringKeys;
    private final List<LogicalVariable> additionalNonFilteringFields;
    private final InsertDeleteUpsertOperator.Kind operation;

    public InsertDeleteUpsertPOperator(LogicalVariable payload, List<LogicalVariable> keys, List<LogicalVariable> additionalFilteringKeys, IDataSource dataSource, InsertDeleteUpsertOperator.Kind operation, List<LogicalVariable> additionalNonFilteringFields) {
        this.payload = payload;
        this.keys = keys;
        this.dataSource = dataSource;
        this.additionalFilteringKeys = additionalFilteringKeys;
        this.operation = operation;
        this.additionalNonFilteringFields = additionalNonFilteringFields;
    }

    @Override
    public PhysicalOperatorTag getOperatorTag() {
        return PhysicalOperatorTag.INSERT_DELETE;
    }

    @Override
    public void computeDeliveredProperties(ILogicalOperator op, IOptimizationContext context) {
        AbstractLogicalOperator op2 = (AbstractLogicalOperator)op.getInputs().get(0).getValue();
        this.deliveredProperties = op2.getDeliveredPhysicalProperties().clone();
    }

    @Override
    public PhysicalRequirements getRequiredPropertiesForChildren(ILogicalOperator op, IPhysicalPropertiesVector reqdByParent, IOptimizationContext context) {
        ArrayList<LogicalVariable> scanVariables = new ArrayList<LogicalVariable>();
        scanVariables.addAll(this.keys);
        scanVariables.add(this.payload);
        if (this.additionalNonFilteringFields != null) {
            scanVariables.addAll(this.additionalNonFilteringFields);
        }
        IPhysicalPropertiesVector r = this.dataSource.getPropertiesProvider().computePropertiesVector(scanVariables);
        r.getLocalProperties().clear();
        IPhysicalPropertiesVector[] requirements = new IPhysicalPropertiesVector[]{r};
        return new PhysicalRequirements(requirements, IPartitioningRequirementsCoordinator.NO_COORDINATION);
    }

    @Override
    public void contributeRuntimeOperator(IHyracksJobBuilder builder, JobGenContext context, ILogicalOperator op, IOperatorSchema propagatedSchema, IOperatorSchema[] inputSchemas, IOperatorSchema outerPlanSchema) throws AlgebricksException {
        InsertDeleteUpsertOperator insertDeleteOp = (InsertDeleteUpsertOperator)op;
        IMetadataProvider<?, ?> mp = context.getMetadataProvider();
        IVariableTypeEnvironment typeEnv = context.getTypeEnvironment(op);
        JobSpecification spec = builder.getJobSpec();
        RecordDescriptor inputDesc = JobGenHelper.mkRecordDescriptor(context.getTypeEnvironment((ILogicalOperator)op.getInputs().get(0).getValue()), inputSchemas[0], context);
        Pair<IOperatorDescriptor, AlgebricksPartitionConstraint> runtimeAndConstraints = null;
        if (this.operation == InsertDeleteUpsertOperator.Kind.INSERT) {
            runtimeAndConstraints = mp.getInsertRuntime(this.dataSource, propagatedSchema, typeEnv, this.keys, this.payload, this.additionalFilteringKeys, this.additionalNonFilteringFields, inputDesc, context, spec, false);
        } else if (this.operation == InsertDeleteUpsertOperator.Kind.DELETE) {
            runtimeAndConstraints = mp.getDeleteRuntime(this.dataSource, propagatedSchema, typeEnv, this.keys, this.payload, this.additionalFilteringKeys, inputDesc, context, spec);
        } else if (this.operation == InsertDeleteUpsertOperator.Kind.UPSERT) {
            runtimeAndConstraints = mp.getUpsertRuntime(this.dataSource, inputSchemas[0], typeEnv, this.keys, this.payload, this.additionalFilteringKeys, this.additionalNonFilteringFields, inputDesc, context, spec);
        } else {
            throw new AlgebricksException("Unsupported Operation " + (Object)((Object)this.operation));
        }
        builder.contributeHyracksOperator(insertDeleteOp, (IOperatorDescriptor)runtimeAndConstraints.first);
        builder.contributeAlgebricksPartitionConstraint((IOperatorDescriptor)runtimeAndConstraints.first, (AlgebricksPartitionConstraint)runtimeAndConstraints.second);
        ILogicalOperator src = (ILogicalOperator)insertDeleteOp.getInputs().get(0).getValue();
        builder.contributeGraphEdge(src, 0, insertDeleteOp, 0);
    }

    @Override
    public boolean isMicroOperator() {
        return false;
    }

    @Override
    public boolean expensiveThanMaterialization() {
        return false;
    }
}

