/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.core.algebra.operators.physical;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksPartitionConstraint;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.core.algebra.base.IHyracksJobBuilder;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.base.PhysicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;
import org.apache.hyracks.algebricks.core.algebra.metadata.IDataSourceIndex;
import org.apache.hyracks.algebricks.core.algebra.metadata.IMetadataProvider;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.IOperatorSchema;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.IndexInsertDeleteUpsertOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.InsertDeleteUpsertOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.AbstractPhysicalOperator;
import org.apache.hyracks.algebricks.core.algebra.properties.IPartitioningRequirementsCoordinator;
import org.apache.hyracks.algebricks.core.algebra.properties.IPhysicalPropertiesVector;
import org.apache.hyracks.algebricks.core.algebra.properties.PhysicalRequirements;
import org.apache.hyracks.algebricks.core.jobgen.impl.JobGenContext;
import org.apache.hyracks.algebricks.core.jobgen.impl.JobGenHelper;
import org.apache.hyracks.api.dataflow.IOperatorDescriptor;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.job.JobSpecification;

public class IndexInsertDeleteUpsertPOperator
extends AbstractPhysicalOperator {
    private final List<LogicalVariable> primaryKeys;
    private final List<LogicalVariable> secondaryKeys;
    private final ILogicalExpression filterExpr;
    private final IDataSourceIndex<?, ?> dataSourceIndex;
    private final List<LogicalVariable> additionalFilteringKeys;
    private final List<LogicalVariable> prevSecondaryKeys;
    private final LogicalVariable prevAdditionalFilteringKey;
    private final int numOfAdditionalNonFilteringFields;

    public IndexInsertDeleteUpsertPOperator(List<LogicalVariable> primaryKeys, List<LogicalVariable> secondaryKeys, List<LogicalVariable> additionalFilteringKeys, Mutable<ILogicalExpression> filterExpr, IDataSourceIndex<?, ?> dataSourceIndex, List<LogicalVariable> prevSecondaryKeys, LogicalVariable prevAdditionalFilteringKey, int numOfAdditionalNonFilteringFields) {
        this.primaryKeys = primaryKeys;
        this.secondaryKeys = secondaryKeys;
        this.filterExpr = filterExpr != null ? (ILogicalExpression)filterExpr.getValue() : null;
        this.dataSourceIndex = dataSourceIndex;
        this.additionalFilteringKeys = additionalFilteringKeys;
        this.prevSecondaryKeys = prevSecondaryKeys;
        this.prevAdditionalFilteringKey = prevAdditionalFilteringKey;
        this.numOfAdditionalNonFilteringFields = numOfAdditionalNonFilteringFields;
    }

    @Override
    public PhysicalOperatorTag getOperatorTag() {
        return PhysicalOperatorTag.INDEX_INSERT_DELETE;
    }

    @Override
    public void computeDeliveredProperties(ILogicalOperator op, IOptimizationContext context) {
        AbstractLogicalOperator op2 = (AbstractLogicalOperator)op.getInputs().get(0).getValue();
        this.deliveredProperties = op2.getDeliveredPhysicalProperties().clone();
    }

    @Override
    public PhysicalRequirements getRequiredPropertiesForChildren(ILogicalOperator op, IPhysicalPropertiesVector reqdByParent, IOptimizationContext context) {
        ArrayList<LogicalVariable> scanVariables = new ArrayList<LogicalVariable>();
        scanVariables.addAll(this.primaryKeys);
        scanVariables.add(new LogicalVariable(-1));
        for (int i = 0; i < this.numOfAdditionalNonFilteringFields; ++i) {
            scanVariables.add(new LogicalVariable(-1));
        }
        IPhysicalPropertiesVector r = this.dataSourceIndex.getDataSource().getPropertiesProvider().computePropertiesVector(scanVariables);
        r.getLocalProperties().clear();
        IPhysicalPropertiesVector[] requirements = new IPhysicalPropertiesVector[]{r};
        return new PhysicalRequirements(requirements, IPartitioningRequirementsCoordinator.NO_COORDINATION);
    }

    @Override
    public void contributeRuntimeOperator(IHyracksJobBuilder builder, JobGenContext context, ILogicalOperator op, IOperatorSchema propagatedSchema, IOperatorSchema[] inputSchemas, IOperatorSchema outerPlanSchema) throws AlgebricksException {
        IndexInsertDeleteUpsertOperator insertDeleteUpsertOp = (IndexInsertDeleteUpsertOperator)op;
        IMetadataProvider<?, ?> mp = context.getMetadataProvider();
        JobSpecification spec = builder.getJobSpec();
        RecordDescriptor inputDesc = JobGenHelper.mkRecordDescriptor(context.getTypeEnvironment((ILogicalOperator)op.getInputs().get(0).getValue()), inputSchemas[0], context);
        Pair<IOperatorDescriptor, AlgebricksPartitionConstraint> runtimeAndConstraints = null;
        IVariableTypeEnvironment typeEnv = context.getTypeEnvironment(insertDeleteUpsertOp);
        if (insertDeleteUpsertOp.getOperation() == InsertDeleteUpsertOperator.Kind.INSERT) {
            runtimeAndConstraints = mp.getIndexInsertRuntime(this.dataSourceIndex, propagatedSchema, inputSchemas, typeEnv, this.primaryKeys, this.secondaryKeys, this.additionalFilteringKeys, this.filterExpr, inputDesc, context, spec, false);
        } else if (insertDeleteUpsertOp.getOperation() == InsertDeleteUpsertOperator.Kind.DELETE) {
            runtimeAndConstraints = mp.getIndexDeleteRuntime(this.dataSourceIndex, propagatedSchema, inputSchemas, typeEnv, this.primaryKeys, this.secondaryKeys, this.additionalFilteringKeys, this.filterExpr, inputDesc, context, spec);
        } else if (insertDeleteUpsertOp.getOperation() == InsertDeleteUpsertOperator.Kind.UPSERT) {
            runtimeAndConstraints = mp.getIndexUpsertRuntime(this.dataSourceIndex, propagatedSchema, inputSchemas, typeEnv, this.primaryKeys, this.secondaryKeys, this.additionalFilteringKeys, this.filterExpr, this.prevSecondaryKeys, this.prevAdditionalFilteringKey, inputDesc, context, spec);
        }
        builder.contributeHyracksOperator(insertDeleteUpsertOp, (IOperatorDescriptor)runtimeAndConstraints.first);
        builder.contributeAlgebricksPartitionConstraint((IOperatorDescriptor)runtimeAndConstraints.first, (AlgebricksPartitionConstraint)runtimeAndConstraints.second);
        ILogicalOperator src = (ILogicalOperator)insertDeleteUpsertOp.getInputs().get(0).getValue();
        builder.contributeGraphEdge(src, 0, insertDeleteUpsertOp, 0);
    }

    @Override
    public boolean isMicroOperator() {
        return false;
    }

    @Override
    public boolean expensiveThanMaterialization() {
        return false;
    }

    public List<LogicalVariable> getPrevSecondaryKeys() {
        return this.prevSecondaryKeys;
    }

    public LogicalVariable getPrevFilteringKeys() {
        return this.prevAdditionalFilteringKey;
    }
}

