/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.core.algebra.operators.physical;

import java.util.Iterator;
import java.util.Map;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksCountPartitionConstraint;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksPartitionConstraint;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.exceptions.NotImplementedException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.core.algebra.base.IHyracksJobBuilder;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalPlan;
import org.apache.hyracks.algebricks.core.algebra.base.IPhysicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractOperatorWithNestedPlans;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.IOperatorSchema;
import org.apache.hyracks.algebricks.core.algebra.properties.IPartitioningRequirementsCoordinator;
import org.apache.hyracks.algebricks.core.algebra.properties.IPhysicalPropertiesVector;
import org.apache.hyracks.algebricks.core.algebra.properties.PhysicalRequirements;
import org.apache.hyracks.algebricks.core.algebra.properties.StructuralPropertiesVector;
import org.apache.hyracks.algebricks.core.jobgen.impl.JobGenContext;
import org.apache.hyracks.algebricks.core.jobgen.impl.PlanCompiler;
import org.apache.hyracks.algebricks.runtime.base.AlgebricksPipeline;
import org.apache.hyracks.algebricks.runtime.operators.meta.AlgebricksMetaOperatorDescriptor;
import org.apache.hyracks.api.dataflow.IOperatorDescriptor;
import org.apache.hyracks.api.job.JobSpecification;

public abstract class AbstractPhysicalOperator
implements IPhysicalOperator {
    protected IPhysicalPropertiesVector deliveredProperties;
    private boolean disableJobGenBelow = false;
    private Object hostQueryContext;

    @Override
    public final IPhysicalPropertiesVector getDeliveredProperties() {
        return this.deliveredProperties;
    }

    public String toString() {
        return this.getOperatorTag().toString();
    }

    @Override
    public void setHostQueryContext(Object context) {
        this.hostQueryContext = context;
    }

    @Override
    public Object getHostQueryContext() {
        return this.hostQueryContext;
    }

    protected PhysicalRequirements emptyUnaryRequirements() {
        IPhysicalPropertiesVector[] req = new StructuralPropertiesVector[]{StructuralPropertiesVector.EMPTY_PROPERTIES_VECTOR};
        return new PhysicalRequirements(req, IPartitioningRequirementsCoordinator.NO_COORDINATION);
    }

    protected PhysicalRequirements emptyUnaryRequirements(int numberOfChildren) {
        IPhysicalPropertiesVector[] req = new StructuralPropertiesVector[numberOfChildren];
        for (int i = 0; i < numberOfChildren; ++i) {
            req[i] = StructuralPropertiesVector.EMPTY_PROPERTIES_VECTOR;
        }
        return new PhysicalRequirements(req, IPartitioningRequirementsCoordinator.NO_COORDINATION);
    }

    @Override
    public void disableJobGenBelowMe() {
        this.disableJobGenBelow = true;
    }

    @Override
    public boolean isJobGenDisabledBelowMe() {
        return this.disableJobGenBelow;
    }

    @Override
    public Pair<int[], int[]> getInputOutputDependencyLabels(ILogicalOperator op) {
        int[] inputDependencyLabels = new int[op.getInputs().size()];
        int[] outputDependencyLabels = new int[]{0};
        return new Pair((Object)inputDependencyLabels, (Object)outputDependencyLabels);
    }

    protected void contributeOpDesc(IHyracksJobBuilder builder, AbstractLogicalOperator op, IOperatorDescriptor opDesc) {
        if (op.getExecutionMode() == AbstractLogicalOperator.ExecutionMode.UNPARTITIONED) {
            AlgebricksCountPartitionConstraint apc = new AlgebricksCountPartitionConstraint(1);
            builder.contributeAlgebricksPartitionConstraint(opDesc, (AlgebricksPartitionConstraint)apc);
        }
        builder.contributeHyracksOperator(op, opDesc);
    }

    protected AlgebricksPipeline[] compileSubplans(IOperatorSchema outerPlanSchema, AbstractOperatorWithNestedPlans npOp, IOperatorSchema opSchema, JobGenContext context) throws AlgebricksException {
        AlgebricksPipeline[] subplans = new AlgebricksPipeline[npOp.getNestedPlans().size()];
        PlanCompiler pc = new PlanCompiler(context);
        int i = 0;
        for (ILogicalPlan p : npOp.getNestedPlans()) {
            subplans[i++] = this.buildPipelineWithProjection(p, outerPlanSchema, npOp, opSchema, pc);
        }
        return subplans;
    }

    private AlgebricksPipeline buildPipelineWithProjection(ILogicalPlan p, IOperatorSchema outerPlanSchema, AbstractOperatorWithNestedPlans npOp, IOperatorSchema opSchema, PlanCompiler pc) throws AlgebricksException {
        if (p.getRoots().size() > 1) {
            throw new NotImplementedException("Nested plans with several roots are not supported.");
        }
        JobSpecification nestedJob = pc.compilePlan(p, outerPlanSchema, null);
        ILogicalOperator topOpInSubplan = (ILogicalOperator)p.getRoots().get(0).getValue();
        JobGenContext context = pc.getContext();
        IOperatorSchema topOpInSubplanScm = context.getSchema(topOpInSubplan);
        opSchema.addAllVariables(topOpInSubplanScm);
        Map opMap = nestedJob.getOperatorMap();
        if (opMap.size() != 1) {
            throw new AlgebricksException("Attempting to construct a nested plan with " + opMap.size() + " operator descriptors. Currently, nested plans can only consist in linear pipelines of Asterix micro operators.");
        }
        Iterator iterator = opMap.entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry opEntry = iterator.next();
            IOperatorDescriptor opd = (IOperatorDescriptor)opEntry.getValue();
            if (!(opd instanceof AlgebricksMetaOperatorDescriptor)) {
                throw new AlgebricksException("Can only generate Hyracks jobs for pipelinable Asterix nested plans, not for " + opd.getClass().getName());
            }
            AlgebricksMetaOperatorDescriptor amod = (AlgebricksMetaOperatorDescriptor)opd;
            return amod.getPipeline();
        }
        throw new IllegalStateException();
    }
}

