/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.core.algebra.operators.logical;

import java.util.List;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.properties.FilteredVariablePropagationPolicy;
import org.apache.hyracks.algebricks.core.algebra.properties.VariablePropagationPolicy;
import org.apache.hyracks.algebricks.core.algebra.typing.ITypingContext;
import org.apache.hyracks.algebricks.core.algebra.typing.NonPropagatingTypeEnvironment;
import org.apache.hyracks.algebricks.core.algebra.visitors.ILogicalExpressionReferenceTransform;
import org.apache.hyracks.algebricks.core.algebra.visitors.ILogicalOperatorVisitor;
import org.apache.hyracks.algebricks.core.config.AlgebricksConfig;

public class IntersectOperator
extends AbstractLogicalOperator {
    private final List<List<LogicalVariable>> inputVars;
    private final List<LogicalVariable> outputVars;

    public IntersectOperator(List<LogicalVariable> outputVars, List<List<LogicalVariable>> inputVars) throws AlgebricksException {
        if (outputVars.size() != inputVars.get(0).size()) {
            throw new AlgebricksException("The number of output variables is different with the input variable number");
        }
        if (inputVars.stream().anyMatch(vlist -> vlist.size() != outputVars.size())) {
            throw new AlgebricksException("The schemas of input variables are not consistent");
        }
        this.outputVars = outputVars;
        this.inputVars = inputVars;
    }

    @Override
    public LogicalOperatorTag getOperatorTag() {
        return LogicalOperatorTag.INTERSECT;
    }

    @Override
    public void recomputeSchema() throws AlgebricksException {
        this.schema = this.outputVars;
    }

    @Override
    public boolean acceptExpressionTransform(ILogicalExpressionReferenceTransform transform) throws AlgebricksException {
        return false;
    }

    @Override
    public <R, T> R accept(ILogicalOperatorVisitor<R, T> visitor, T arg) throws AlgebricksException {
        return visitor.visitIntersectOperator(this, arg);
    }

    @Override
    public boolean isMap() {
        return false;
    }

    @Override
    public VariablePropagationPolicy getVariablePropagationPolicy() {
        return new FilteredVariablePropagationPolicy(this.outputVars);
    }

    @Override
    public IVariableTypeEnvironment computeOutputTypeEnvironment(ITypingContext ctx) throws AlgebricksException {
        IVariableTypeEnvironment typeEnv = ctx.getOutputTypeEnvironment((ILogicalOperator)((Mutable)this.inputs.get(0)).getValue());
        for (int i = 1; i < this.inputs.size(); ++i) {
            this.checkTypeConsistency(typeEnv, this.inputVars.get(0), ctx.getOutputTypeEnvironment((ILogicalOperator)((Mutable)this.inputs.get(i)).getValue()), this.inputVars.get(i));
        }
        NonPropagatingTypeEnvironment env = new NonPropagatingTypeEnvironment(ctx.getExpressionTypeComputer(), ctx.getMetadataProvider());
        for (int i = 0; i < this.outputVars.size(); ++i) {
            env.setVarType(this.outputVars.get(i), typeEnv.getVarType(this.inputVars.get(0).get(i)));
        }
        return typeEnv;
    }

    public List<LogicalVariable> getOutputVars() {
        return this.outputVars;
    }

    public int getNumInput() {
        return this.inputVars.size();
    }

    public List<LogicalVariable> getInputVariables(int inputIndex) {
        return this.inputVars.get(inputIndex);
    }

    private void checkTypeConsistency(IVariableTypeEnvironment expected, List<LogicalVariable> expectedVariables, IVariableTypeEnvironment actual, List<LogicalVariable> actualVariables) throws AlgebricksException {
        for (int i = 0; i < expectedVariables.size(); ++i) {
            Object actualType;
            Object expectedType = expected.getVarType(expectedVariables.get(i));
            if (expectedType.equals(actualType = actual.getVarType(actualVariables.get(i)))) continue;
            AlgebricksConfig.ALGEBRICKS_LOGGER.warning("Type of two variables are not equal." + expectedVariables.get(i) + " is of type: " + expectedType + actualVariables.get(i) + " is of type: " + actualType);
        }
    }
}

