/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.api.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ErrorMessageUtil {
    private static final Logger LOGGER = Logger.getLogger(ErrorMessageUtil.class.getName());
    public static final String NONE = "";
    private static final String COMMA = ",";

    private ErrorMessageUtil() {
    }

    public static Map<Integer, String> loadErrorMap(InputStream resourceStream) throws IOException {
        Properties prop = new Properties();
        HashMap<Integer, String> errorMessageMap = new HashMap<Integer, String>();
        prop.load(resourceStream);
        for (Map.Entry<Object, Object> entry : prop.entrySet()) {
            String key = (String)entry.getKey();
            String msg = (String)entry.getValue();
            if (key.contains(COMMA)) {
                String[] codes;
                for (String code : codes = key.split(COMMA)) {
                    errorMessageMap.put(Integer.parseInt(code), msg);
                }
                continue;
            }
            errorMessageMap.put(Integer.parseInt(key), msg);
        }
        return errorMessageMap;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String formatMessage(String component, int errorCode, String message, Serializable ... params) {
        try (Formatter fmt = new Formatter();){
            if (!NONE.equals(component)) {
                fmt.format("%1$s%2$04d: ", component, errorCode);
            }
            fmt.format(message == null ? "null" : message, params);
            String string = fmt.out().toString();
            return string;
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            return e.getMessage();
        }
    }
}

