/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.api.rewriter.runtime;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.ActivityId;
import org.apache.hyracks.api.dataflow.IActivity;
import org.apache.hyracks.api.dataflow.IConnectorDescriptor;
import org.apache.hyracks.api.dataflow.IOperatorNodePushable;
import org.apache.hyracks.api.dataflow.value.IRecordDescriptorProvider;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.rewriter.runtime.SuperActivity;

public class SuperActivityOperatorNodePushable
implements IOperatorNodePushable {
    private final Map<ActivityId, IOperatorNodePushable> operatorNodePushables = new HashMap<ActivityId, IOperatorNodePushable>();
    private final List<IOperatorNodePushable> operatorNodePushablesBFSOrder = new ArrayList<IOperatorNodePushable>();
    private final Map<ActivityId, IActivity> startActivities;
    private final SuperActivity parent;
    private final IHyracksTaskContext ctx;
    private final IRecordDescriptorProvider recordDescProvider;
    private final int partition;
    private final int nPartitions;
    private int inputArity = 0;
    private boolean[] startedInitialization;

    public SuperActivityOperatorNodePushable(SuperActivity parent, Map<ActivityId, IActivity> startActivities, IHyracksTaskContext ctx, IRecordDescriptorProvider recordDescProvider, int partition, int nPartitions) {
        this.parent = parent;
        this.startActivities = startActivities;
        this.ctx = ctx;
        this.recordDescProvider = recordDescProvider;
        this.partition = partition;
        this.nPartitions = nPartitions;
        try {
            this.init();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void initialize() throws HyracksDataException {
        this.runInParallel((op, index) -> {
            this.startedInitialization[index] = true;
            op.initialize();
        });
    }

    private void init() throws HyracksDataException {
        HashMap<ActivityId, IOperatorNodePushable> startOperatorNodePushables = new HashMap<ActivityId, IOperatorNodePushable>();
        LinkedList<Pair<Pair<IActivity, Integer>, Pair<IActivity, Integer>>> childQueue = new LinkedList<Pair<Pair<IActivity, Integer>, Pair<IActivity, Integer>>>();
        List<IConnectorDescriptor> outputConnectors = null;
        for (Map.Entry<ActivityId, IActivity> entry : this.startActivities.entrySet()) {
            IOperatorNodePushable opPushable = entry.getValue().createPushRuntime(this.ctx, this.recordDescProvider, this.partition, this.nPartitions);
            startOperatorNodePushables.put(entry.getKey(), opPushable);
            this.operatorNodePushablesBFSOrder.add(opPushable);
            this.operatorNodePushables.put(entry.getKey(), opPushable);
            this.inputArity += opPushable.getInputArity();
            outputConnectors = this.parent.getActivityOutputMap().get(entry.getKey());
            if (outputConnectors == null) continue;
            for (IConnectorDescriptor conn : outputConnectors) {
                childQueue.add(this.parent.getConnectorActivityMap().get(conn.getConnectorId()));
            }
        }
        while (childQueue.size() > 0) {
            Pair channel = (Pair)childQueue.poll();
            ActivityId sourceId = ((IActivity)((Pair)channel.getLeft()).getLeft()).getActivityId();
            int outputChannel = (Integer)((Pair)channel.getLeft()).getRight();
            ActivityId destId = ((IActivity)((Pair)channel.getRight()).getLeft()).getActivityId();
            int inputChannel = (Integer)((Pair)channel.getRight()).getRight();
            IOperatorNodePushable sourceOp = this.operatorNodePushables.get(sourceId);
            IOperatorNodePushable destOp = this.operatorNodePushables.get(destId);
            if (destOp == null) {
                destOp = ((IActivity)((Pair)channel.getRight()).getLeft()).createPushRuntime(this.ctx, this.recordDescProvider, this.partition, this.nPartitions);
                this.operatorNodePushablesBFSOrder.add(destOp);
                this.operatorNodePushables.put(destId, destOp);
            }
            sourceOp.setOutputFrameWriter(outputChannel, destOp.getInputFrameWriter(inputChannel), this.recordDescProvider.getInputRecordDescriptor(destId, inputChannel));
            outputConnectors = this.parent.getActivityOutputMap().get(destId);
            if (outputConnectors == null || outputConnectors.size() <= 0) continue;
            for (IConnectorDescriptor conn : outputConnectors) {
                if (conn == null) continue;
                childQueue.add(this.parent.getConnectorActivityMap().get(conn.getConnectorId()));
            }
        }
        this.startedInitialization = new boolean[this.operatorNodePushablesBFSOrder.size()];
        Arrays.fill(this.startedInitialization, false);
    }

    @Override
    public void deinitialize() throws HyracksDataException {
        this.runInParallel((op, index) -> {
            if (this.startedInitialization[index]) {
                op.deinitialize();
            }
        });
    }

    @Override
    public int getInputArity() {
        return this.inputArity;
    }

    @Override
    public void setOutputFrameWriter(int clusterOutputIndex, IFrameWriter writer, RecordDescriptor recordDesc) throws HyracksDataException {
        Pair<ActivityId, Integer> activityIdOutputIndex = this.parent.getActivityIdOutputIndex(clusterOutputIndex);
        IOperatorNodePushable opPushable = this.operatorNodePushables.get(activityIdOutputIndex.getLeft());
        opPushable.setOutputFrameWriter((Integer)activityIdOutputIndex.getRight(), writer, recordDesc);
    }

    @Override
    public IFrameWriter getInputFrameWriter(int index) {
        Pair<ActivityId, Integer> activityIdInputIndex = this.parent.getActivityIdInputIndex(index);
        IOperatorNodePushable operatorNodePushable = this.operatorNodePushables.get(activityIdInputIndex.getLeft());
        IFrameWriter writer = operatorNodePushable.getInputFrameWriter((Integer)activityIdInputIndex.getRight());
        return writer;
    }

    @Override
    public String getDisplayName() {
        return "Super Activity " + this.parent.getActivityMap().values().toString();
    }

    private void runInParallel(OperatorNodePushableAction opAction) throws HyracksDataException {
        ArrayList<Future<Void>> initializationTasks = new ArrayList<Future<Void>>();
        try {
            int index = 0;
            for (IOperatorNodePushable iOperatorNodePushable : this.operatorNodePushablesBFSOrder) {
                int opIndex = index++;
                initializationTasks.add(this.ctx.getExecutorService().submit(() -> {
                    opAction.runAction(op, opIndex);
                    return null;
                }));
            }
            for (Future future : initializationTasks) {
                future.get();
            }
        }
        catch (Exception e) {
            for (Future future : initializationTasks) {
                future.cancel(true);
            }
            throw new HyracksDataException(e);
        }
    }

    static interface OperatorNodePushableAction {
        public void runAction(IOperatorNodePushable var1, int var2) throws HyracksDataException;
    }
}

