/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.api.job;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.IWritable;

public final class JobId
implements IWritable,
Serializable {
    public static final JobId INVALID = new JobId(-1L);
    private static final long serialVersionUID = 1L;
    private long id;

    public static JobId create(DataInput dis) throws IOException {
        JobId jobId = new JobId();
        jobId.readFields(dis);
        return jobId;
    }

    private JobId() {
    }

    public JobId(long id) {
        this.id = id;
    }

    public long getId() {
        return this.id;
    }

    public int hashCode() {
        return (int)this.id;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JobId)) {
            return false;
        }
        return ((JobId)o).id == this.id;
    }

    public String toString() {
        return "JID:" + this.id;
    }

    public static JobId parse(String str) throws HyracksDataException {
        if (str.startsWith("JID:")) {
            str = str.substring(4);
            return new JobId(Long.parseLong(str));
        }
        throw HyracksDataException.create(20, new Serializable[]{str});
    }

    @Override
    public void writeFields(DataOutput output) throws IOException {
        output.writeLong(this.id);
    }

    @Override
    public void readFields(DataInput input) throws IOException {
        this.id = input.readLong();
    }
}

