/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.api.exceptions;

import java.io.IOException;
import java.io.Serializable;
import org.apache.hyracks.api.exceptions.ErrorCode;
import org.apache.hyracks.api.util.ErrorMessageUtil;

public class HyracksException
extends IOException {
    private static final long serialVersionUID = 1L;
    public static final int UNKNOWN = 0;
    private final String component;
    private final int errorCode;
    private final Serializable[] params;
    private final String nodeId;
    private volatile transient String msgCache;

    public static HyracksException create(Throwable cause) {
        if (cause instanceof HyracksException) {
            return (HyracksException)cause;
        }
        return new HyracksException(cause);
    }

    public static HyracksException create(int code, Serializable ... params) {
        return new HyracksException("HYR", code, ErrorCode.getErrorMessage(code), params);
    }

    public static HyracksException create(int code, Throwable cause, Serializable ... params) {
        return new HyracksException("HYR", code, ErrorCode.getErrorMessage(code), cause, params);
    }

    public HyracksException(String component, int errorCode, String message, Throwable cause, String nodeId, Serializable ... params) {
        super(message, cause);
        this.component = component;
        this.errorCode = errorCode;
        this.nodeId = nodeId;
        this.params = params;
    }

    @Deprecated
    public HyracksException(String message) {
        this("", 0, message, null, null);
    }

    @Deprecated
    public HyracksException(Throwable cause) {
        this("", 0, String.valueOf(cause), cause, null);
    }

    @Deprecated
    public HyracksException(Throwable cause, String nodeId) {
        this("", 0, String.valueOf(cause), cause, nodeId, new Serializable[0]);
    }

    @Deprecated
    public HyracksException(String message, Throwable cause, String nodeId) {
        this("", 0, message, cause, nodeId, new Serializable[0]);
    }

    @Deprecated
    public HyracksException(String message, Throwable cause) {
        this("", 0, message, cause, (String)null, new Serializable[0]);
    }

    public HyracksException(String component, int errorCode, Serializable ... params) {
        this(component, errorCode, (String)null, (Throwable)null, (String)null, params);
    }

    public HyracksException(Throwable cause, int errorCode, Serializable ... params) {
        this("", errorCode, String.valueOf(cause), cause, (String)null, params);
    }

    public HyracksException(String component, int errorCode, String message, Serializable ... params) {
        this(component, errorCode, message, (Throwable)null, (String)null, params);
    }

    public HyracksException(String component, int errorCode, Throwable cause, Serializable ... params) {
        this(component, errorCode, String.valueOf(cause), cause, (String)null, params);
    }

    public HyracksException(String component, int errorCode, String message, Throwable cause, Serializable ... params) {
        this(component, errorCode, message, cause, (String)null, params);
    }

    public String getComponent() {
        return this.component;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public Object[] getParams() {
        return this.params;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getMessage() {
        if (this.msgCache == null) {
            HyracksException hyracksException = this;
            synchronized (hyracksException) {
                this.msgCache = ErrorMessageUtil.formatMessage(this.component, this.errorCode, super.getMessage(), this.params);
            }
        }
        return this.msgCache;
    }
}

