/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.replication.recovery;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.asterix.common.api.IAppRuntimeContext;
import org.apache.asterix.common.api.IDatasetLifecycleManager;
import org.apache.asterix.common.cluster.ClusterPartition;
import org.apache.asterix.common.config.ClusterProperties;
import org.apache.asterix.common.config.ReplicationProperties;
import org.apache.asterix.common.exceptions.ACIDException;
import org.apache.asterix.common.replication.IRemoteRecoveryManager;
import org.apache.asterix.common.replication.IReplicationManager;
import org.apache.asterix.common.transactions.ILogManager;
import org.apache.asterix.common.transactions.IRecoveryManager;
import org.apache.asterix.replication.storage.ReplicaResourcesManager;
import org.apache.asterix.transaction.management.resource.PersistentLocalResourceRepository;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class RemoteRecoveryManager
implements IRemoteRecoveryManager {
    private final IReplicationManager replicationManager;
    private static final Logger LOGGER = Logger.getLogger(RemoteRecoveryManager.class.getName());
    private final IAppRuntimeContext runtimeContext;
    private final ReplicationProperties replicationProperties;
    private Map<String, Set<String>> failbackRecoveryReplicas;

    public RemoteRecoveryManager(IReplicationManager replicationManager, IAppRuntimeContext runtimeContext, ReplicationProperties replicationProperties) {
        this.replicationManager = replicationManager;
        this.runtimeContext = runtimeContext;
        this.replicationProperties = replicationProperties;
    }

    private Map<String, Set<String>> constructRemoteRecoveryPlan() {
        String localNodeId = this.runtimeContext.getTransactionSubsystem().getId();
        Set nodes = this.replicationProperties.getNodeReplicasIds(localNodeId);
        HashMap<String, Set> recoveryCandidates = new HashMap<String, Set>();
        HashMap<Object, Integer> candidatesScore = new HashMap<Object, Integer>();
        for (String node : nodes) {
            Set locations = this.replicationProperties.getNodeReplicasIds(node);
            locations.remove(localNodeId);
            Set deadReplicas = this.replicationManager.getDeadReplicasIds();
            for (String deadReplica : deadReplicas) {
                locations.remove(deadReplica);
            }
            if (locations.isEmpty()) {
                throw new IllegalStateException("Could not find any ACTIVE replica to recover " + node + " data.");
            }
            for (Object location : locations) {
                if (candidatesScore.containsKey(location)) {
                    candidatesScore.put(location, (Integer)candidatesScore.get(location) + 1);
                    continue;
                }
                candidatesScore.put(location, 1);
            }
            recoveryCandidates.put(node, locations);
        }
        HashMap<String, Set<String>> recoveryList = new HashMap<String, Set<String>>();
        for (Map.Entry entry : recoveryCandidates.entrySet()) {
            int winnerScore = -1;
            String winner = "";
            for (String node : (Set)entry.getValue()) {
                int nodeScore = (Integer)candidatesScore.get(node);
                if (nodeScore <= winnerScore) continue;
                winnerScore = nodeScore;
                winner = node;
            }
            if (recoveryList.containsKey(winner)) {
                ((Set)recoveryList.get(winner)).add(entry.getKey());
                continue;
            }
            HashSet nodesToRecover = new HashSet();
            nodesToRecover.add(entry.getKey());
            recoveryList.put(winner, nodesToRecover);
        }
        return recoveryList;
    }

    public void replayReplicaPartitionLogs(Set<Integer> partitions, boolean flush) throws HyracksDataException {
        long readableSmallestLSN;
        ILogManager logManager = this.runtimeContext.getTransactionSubsystem().getLogManager();
        long minLSN = this.runtimeContext.getReplicaResourcesManager().getPartitionsMinLSN(partitions);
        if (minLSN < (readableSmallestLSN = logManager.getReadableSmallestLSN())) {
            minLSN = readableSmallestLSN;
        }
        IRecoveryManager recoveryManager = this.runtimeContext.getTransactionSubsystem().getRecoveryManager();
        try {
            recoveryManager.replayPartitionsLogs(partitions, logManager.getLogReader(true), minLSN);
            if (flush) {
                this.runtimeContext.getDatasetLifecycleManager().flushAllDatasets();
            }
        }
        catch (IOException | ACIDException e) {
            throw new HyracksDataException(e);
        }
    }

    public void takeoverPartitons(Integer[] partitions) throws IOException, ACIDException {
        HashSet<Integer> partitionsToTakeover = new HashSet<Integer>(Arrays.asList(partitions));
        this.replayReplicaPartitionLogs(partitionsToTakeover, false);
        PersistentLocalResourceRepository resourceRepository = (PersistentLocalResourceRepository)this.runtimeContext.getLocalResourceRepository();
        for (Integer patitionId : partitions) {
            resourceRepository.addActivePartition(patitionId.intValue());
        }
    }

    public void startFailbackProcess() {
        int maxRecoveryAttempts = this.replicationProperties.getMaxRemoteRecoveryAttempts();
        PersistentLocalResourceRepository resourceRepository = (PersistentLocalResourceRepository)this.runtimeContext.getLocalResourceRepository();
        IDatasetLifecycleManager datasetLifeCycleManager = this.runtimeContext.getDatasetLifecycleManager();
        Map nodePartitions = this.runtimeContext.getMetadataProperties().getNodePartitions();
        while (true) {
            try {
                if (maxRecoveryAttempts <= 0) {
                    throw new IllegalStateException("Failed to perform remote recovery.");
                }
                this.replicationManager.initializeReplicasState();
                int activeReplicasCount = this.replicationManager.getActiveReplicasCount();
                if (activeReplicasCount == 0) {
                    throw new IllegalStateException("no ACTIVE remote replica(s) exists to perform remote recovery");
                }
                datasetLifeCycleManager.closeAllDatasets();
                resourceRepository.deleteStorageData(true);
                resourceRepository.initializeNewUniverse(ClusterProperties.INSTANCE.getStorageDirectoryName());
                this.failbackRecoveryReplicas = this.constructRemoteRecoveryPlan();
                for (Map.Entry<String, Set<String>> remoteReplica : this.failbackRecoveryReplicas.entrySet()) {
                    String replicaId = remoteReplica.getKey();
                    Set<String> ncsToRecoverFor = remoteReplica.getValue();
                    HashSet partitionsIds = new HashSet();
                    for (String node : ncsToRecoverFor) {
                        partitionsIds.addAll(Arrays.asList((Object[])nodePartitions.get(node)).stream().map(ClusterPartition::getPartitionId).collect(Collectors.toList()));
                    }
                    this.replicationManager.requestReplicaFiles(replicaId, partitionsIds, new HashSet());
                }
            }
            catch (IOException e) {
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.log(Level.WARNING, "Failed during remote recovery. Attempting again...", e);
                }
                --maxRecoveryAttempts;
                continue;
            }
            break;
        }
    }

    public void completeFailbackProcess() throws IOException, InterruptedException {
        ILogManager logManager = this.runtimeContext.getTransactionSubsystem().getLogManager();
        ReplicaResourcesManager replicaResourcesManager = (ReplicaResourcesManager)this.runtimeContext.getReplicaResourcesManager();
        Map nodePartitions = this.runtimeContext.getMetadataProperties().getNodePartitions();
        try {
            for (Map.Entry<String, Set<String>> remoteReplica : this.failbackRecoveryReplicas.entrySet()) {
                String replicaId = remoteReplica.getKey();
                Set<String> NCsDataToRecover = remoteReplica.getValue();
                HashSet<String> existingFiles = new HashSet<String>();
                HashSet<Integer> partitionsToRecover = new HashSet<Integer>();
                for (String nodeId : NCsDataToRecover) {
                    ClusterPartition[] replicaPartitions;
                    for (ClusterPartition partition : replicaPartitions = (ClusterPartition[])nodePartitions.get(nodeId)) {
                        existingFiles.addAll(replicaResourcesManager.getPartitionIndexesFiles(partition.getPartitionId(), true));
                        partitionsToRecover.add(partition.getPartitionId());
                    }
                }
                this.replicationManager.requestReplicaFiles(replicaId, partitionsToRecover, existingFiles);
            }
        }
        catch (IOException e) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, "Failed during completing failback. Restarting failback process...", e);
            }
            this.startFailbackProcess();
        }
        long maxRemoteLSN = this.replicationManager.getMaxRemoteLSN(this.failbackRecoveryReplicas.keySet());
        logManager.renewLogFilesAndStartFromLSN(maxRemoteLSN);
        this.runtimeContext.getReplicationChannel().start();
        this.runtimeContext.getReplicationManager().startReplicationThreads();
        this.failbackRecoveryReplicas = null;
    }

    public void doRemoteRecoveryPlan(Map<String, Set<Integer>> recoveryPlan) throws HyracksDataException {
        int maxRecoveryAttempts = this.replicationProperties.getMaxRemoteRecoveryAttempts();
        PersistentLocalResourceRepository resourceRepository = (PersistentLocalResourceRepository)this.runtimeContext.getLocalResourceRepository();
        IDatasetLifecycleManager datasetLifeCycleManager = this.runtimeContext.getDatasetLifecycleManager();
        ILogManager logManager = this.runtimeContext.getTransactionSubsystem().getLogManager();
        while (true) {
            try {
                if (maxRecoveryAttempts <= 0) {
                    throw new IllegalStateException("Failed to perform remote recovery.");
                }
                datasetLifeCycleManager.closeAllDatasets();
                resourceRepository.deleteStorageData(true);
                resourceRepository.initializeNewUniverse(ClusterProperties.INSTANCE.getStorageDirectoryName());
                for (Map.Entry<String, Set<Integer>> remoteReplica : recoveryPlan.entrySet()) {
                    String replicaId = remoteReplica.getKey();
                    Set<Integer> partitionsToRecover = remoteReplica.getValue();
                    this.replicationManager.requestReplicaFiles(replicaId, partitionsToRecover, new HashSet());
                }
                long maxRemoteLSN = this.replicationManager.getMaxRemoteLSN(recoveryPlan.keySet());
                logManager.renewLogFilesAndStartFromLSN(maxRemoteLSN);
            }
            catch (IOException e) {
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.log(Level.WARNING, "Failed during remote recovery. Attempting again...", e);
                }
                --maxRecoveryAttempts;
                continue;
            }
            break;
        }
    }
}

