/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.common.impls;

import java.util.ArrayList;
import java.util.List;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.common.api.IIndexBulkLoader;
import org.apache.hyracks.storage.am.common.api.IPageManager;
import org.apache.hyracks.storage.am.common.api.ITreeIndex;
import org.apache.hyracks.storage.am.common.api.ITreeIndexAccessor;
import org.apache.hyracks.storage.am.common.api.ITreeIndexFrame;
import org.apache.hyracks.storage.am.common.api.ITreeIndexFrameFactory;
import org.apache.hyracks.storage.am.common.api.ITreeIndexMetadataFrame;
import org.apache.hyracks.storage.am.common.api.ITreeIndexTupleWriter;
import org.apache.hyracks.storage.am.common.api.IndexException;
import org.apache.hyracks.storage.am.common.api.TreeIndexException;
import org.apache.hyracks.storage.am.common.impls.NoOpOperationCallback;
import org.apache.hyracks.storage.am.common.impls.NodeFrontier;
import org.apache.hyracks.storage.am.common.ophelpers.MultiComparator;
import org.apache.hyracks.storage.common.buffercache.IBufferCache;
import org.apache.hyracks.storage.common.buffercache.ICachedPage;
import org.apache.hyracks.storage.common.buffercache.IFIFOPageQueue;
import org.apache.hyracks.storage.common.file.BufferedFileHandle;
import org.apache.hyracks.storage.common.file.IFileMapProvider;

public abstract class AbstractTreeIndex
implements ITreeIndex {
    public static final int MINIMAL_TREE_PAGE_COUNT = 2;
    public static final int MINIMAL_TREE_PAGE_COUNT_WITH_FILTER = 3;
    protected int rootPage = 1;
    protected final IBufferCache bufferCache;
    protected final IFileMapProvider fileMapProvider;
    protected final IPageManager freePageManager;
    protected final ITreeIndexFrameFactory interiorFrameFactory;
    protected final ITreeIndexFrameFactory leafFrameFactory;
    protected final IBinaryComparatorFactory[] cmpFactories;
    protected final int fieldCount;
    protected FileReference file;
    protected int fileId = -1;
    protected boolean isActive = false;
    protected boolean hasEverBeenActivated = false;
    protected int bulkloadLeafStart = 0;

    public AbstractTreeIndex(IBufferCache bufferCache, IFileMapProvider fileMapProvider, IPageManager freePageManager, ITreeIndexFrameFactory interiorFrameFactory, ITreeIndexFrameFactory leafFrameFactory, IBinaryComparatorFactory[] cmpFactories, int fieldCount, FileReference file) {
        this.bufferCache = bufferCache;
        this.fileMapProvider = fileMapProvider;
        this.freePageManager = freePageManager;
        this.interiorFrameFactory = interiorFrameFactory;
        this.leafFrameFactory = leafFrameFactory;
        this.cmpFactories = cmpFactories;
        this.fieldCount = fieldCount;
        this.file = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void create() throws HyracksDataException {
        if (this.isActive) {
            throw new HyracksDataException("Failed to create the index since it is activated.");
        }
        IFileMapProvider iFileMapProvider = this.fileMapProvider;
        synchronized (iFileMapProvider) {
            boolean fileIsMapped = this.fileMapProvider.isMapped(this.file);
            if (!fileIsMapped) {
                this.bufferCache.createFile(this.file);
            }
            this.fileId = this.fileMapProvider.lookupFileId(this.file);
            try {
                this.bufferCache.openFile(this.fileId);
            }
            catch (HyracksDataException e) {
                if (!fileIsMapped) {
                    this.bufferCache.deleteFile(this.fileId, false);
                }
                throw e;
            }
        }
        this.freePageManager.open(this.fileId);
        this.freePageManager.init(this.interiorFrameFactory, this.leafFrameFactory);
        this.setRootPage();
        this.freePageManager.close();
        this.bufferCache.closeFile(this.fileId);
    }

    private void setRootPage() throws HyracksDataException {
        this.rootPage = this.freePageManager.getRootPageId();
        this.bulkloadLeafStart = this.freePageManager.getBulkLoadLeaf();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void activate() throws HyracksDataException {
        if (this.isActive) {
            throw new HyracksDataException("Failed to activate the index since it is already activated.");
        }
        boolean fileIsMapped = false;
        IFileMapProvider iFileMapProvider = this.fileMapProvider;
        synchronized (iFileMapProvider) {
            fileIsMapped = this.fileMapProvider.isMapped(this.file);
            if (!fileIsMapped) {
                this.bufferCache.createFile(this.file);
            }
            this.fileId = this.fileMapProvider.lookupFileId(this.file);
            try {
                this.bufferCache.openFile(this.fileId);
            }
            catch (HyracksDataException e) {
                if (!fileIsMapped) {
                    this.bufferCache.deleteFile(this.fileId, false);
                }
                throw e;
            }
        }
        this.freePageManager.open(this.fileId);
        this.setRootPage();
        this.isActive = true;
        this.hasEverBeenActivated = true;
    }

    @Override
    public synchronized void deactivate() throws HyracksDataException {
        if (!this.isActive && this.hasEverBeenActivated) {
            throw new HyracksDataException("Failed to deactivate the index since it is already deactivated.");
        }
        if (this.isActive) {
            this.freePageManager.close();
            this.bufferCache.closeFile(this.fileId);
        }
        this.isActive = false;
    }

    public synchronized void deactivateCloseHandle() throws HyracksDataException {
        this.deactivate();
        this.bufferCache.purgeHandle(this.fileId);
    }

    @Override
    public synchronized void destroy() throws HyracksDataException {
        if (this.isActive) {
            throw new HyracksDataException("Failed to destroy the index since it is activated.");
        }
        if (this.fileId == -1) {
            return;
        }
        this.bufferCache.deleteFile(this.fileId, false);
        this.file.delete();
        this.fileId = -1;
    }

    @Override
    public synchronized void clear() throws HyracksDataException {
        if (!this.isActive) {
            throw new HyracksDataException("Failed to clear the index since it is not activated.");
        }
        this.freePageManager.init(this.interiorFrameFactory, this.leafFrameFactory);
        this.setRootPage();
    }

    public boolean isEmptyTree(ITreeIndexFrame frame) throws HyracksDataException {
        if (this.rootPage == -1) {
            return true;
        }
        return this.freePageManager.isEmpty(frame, this.rootPage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte getTreeHeight(ITreeIndexFrame frame) throws HyracksDataException {
        ICachedPage rootNode = this.bufferCache.pin(BufferedFileHandle.getDiskPageId((int)this.fileId, (int)this.rootPage), false);
        rootNode.acquireReadLatch();
        try {
            frame.setPage(rootNode);
            byte by = frame.getLevel();
            return by;
        }
        finally {
            rootNode.releaseReadLatch();
            this.bufferCache.unpin(rootNode);
        }
    }

    @Override
    public int getFileId() {
        return this.fileId;
    }

    public FileReference getFileReference() {
        return this.file;
    }

    @Override
    public IBufferCache getBufferCache() {
        return this.bufferCache;
    }

    @Override
    public ITreeIndexFrameFactory getInteriorFrameFactory() {
        return this.interiorFrameFactory;
    }

    @Override
    public ITreeIndexFrameFactory getLeafFrameFactory() {
        return this.leafFrameFactory;
    }

    @Override
    public IBinaryComparatorFactory[] getComparatorFactories() {
        return this.cmpFactories;
    }

    @Override
    public IPageManager getPageManager() {
        return this.freePageManager;
    }

    @Override
    public int getRootPageId() {
        return this.rootPage;
    }

    @Override
    public int getFieldCount() {
        return this.fieldCount;
    }

    @Override
    public long getMemoryAllocationSize() {
        return 0L;
    }

    public IBinaryComparatorFactory[] getCmpFactories() {
        return this.cmpFactories;
    }

    @Override
    public boolean hasMemoryComponents() {
        return true;
    }

    public class TreeIndexInsertBulkLoader
    implements IIndexBulkLoader {
        ITreeIndexAccessor accessor;

        public TreeIndexInsertBulkLoader() throws HyracksDataException {
            this.accessor = (ITreeIndexAccessor)AbstractTreeIndex.this.createAccessor(NoOpOperationCallback.INSTANCE, NoOpOperationCallback.INSTANCE);
        }

        @Override
        public void add(ITupleReference tuple) throws HyracksDataException {
            try {
                this.accessor.insert(tuple);
            }
            catch (IndexException e) {
                throw new HyracksDataException((Throwable)e);
            }
        }

        @Override
        public void end() throws HyracksDataException {
        }

        @Override
        public void abort() {
        }
    }

    public abstract class AbstractTreeIndexBulkLoader
    implements IIndexBulkLoader {
        protected final MultiComparator cmp;
        protected final int slotSize;
        protected final int leafMaxBytes;
        protected final int interiorMaxBytes;
        protected final ArrayList<NodeFrontier> nodeFrontiers = new ArrayList();
        protected final ITreeIndexMetadataFrame metaFrame;
        protected final ITreeIndexTupleWriter tupleWriter;
        protected ITreeIndexFrame leafFrame;
        protected ITreeIndexFrame interiorFrame;
        protected boolean releasedLatches;
        protected final IFIFOPageQueue queue;
        protected List<ICachedPage> pagesToWrite;

        public AbstractTreeIndexBulkLoader(float fillFactor) throws TreeIndexException, HyracksDataException {
            this.leafFrame = AbstractTreeIndex.this.leafFrameFactory.createFrame();
            this.interiorFrame = AbstractTreeIndex.this.interiorFrameFactory.createFrame();
            this.metaFrame = AbstractTreeIndex.this.freePageManager.createMetadataFrame();
            this.queue = AbstractTreeIndex.this.bufferCache.createFIFOQueue();
            if (!AbstractTreeIndex.this.isEmptyTree(this.leafFrame)) {
                throw new TreeIndexException("Cannot bulk-load a non-empty tree.");
            }
            this.cmp = MultiComparator.create(AbstractTreeIndex.this.cmpFactories);
            this.leafFrame.setMultiComparator(this.cmp);
            this.interiorFrame.setMultiComparator(this.cmp);
            this.tupleWriter = this.leafFrame.getTupleWriter();
            NodeFrontier leafFrontier = new NodeFrontier(this.leafFrame.createTupleReference());
            leafFrontier.pageId = AbstractTreeIndex.this.freePageManager.takePage(this.metaFrame);
            leafFrontier.page = AbstractTreeIndex.this.bufferCache.confiscatePage(BufferedFileHandle.getDiskPageId((int)AbstractTreeIndex.this.fileId, (int)leafFrontier.pageId));
            this.interiorFrame.setPage(leafFrontier.page);
            this.interiorFrame.initBuffer((byte)0);
            this.interiorMaxBytes = (int)((float)this.interiorFrame.getBuffer().capacity() * fillFactor);
            this.leafFrame.setPage(leafFrontier.page);
            this.leafFrame.initBuffer((byte)0);
            this.leafMaxBytes = (int)((float)this.leafFrame.getBuffer().capacity() * fillFactor);
            this.slotSize = this.leafFrame.getSlotSize();
            this.nodeFrontiers.add(leafFrontier);
            this.pagesToWrite = new ArrayList<ICachedPage>();
        }

        @Override
        public abstract void add(ITupleReference var1) throws IndexException, HyracksDataException;

        protected void handleException() throws HyracksDataException {
            for (NodeFrontier nodeFrontier : this.nodeFrontiers) {
                ICachedPage frontierPage = nodeFrontier.page;
                if (!frontierPage.confiscated()) continue;
                AbstractTreeIndex.this.bufferCache.returnPage(frontierPage, false);
            }
            for (ICachedPage pageToDiscard : this.pagesToWrite) {
                AbstractTreeIndex.this.bufferCache.returnPage(pageToDiscard, false);
            }
            this.releasedLatches = true;
        }

        @Override
        public void end() throws HyracksDataException {
            AbstractTreeIndex.this.bufferCache.finishQueue();
            AbstractTreeIndex.this.freePageManager.setRootPageId(AbstractTreeIndex.this.rootPage);
        }

        protected void addLevel() throws HyracksDataException {
            NodeFrontier frontier = new NodeFrontier(this.tupleWriter.createTupleReference());
            frontier.page = AbstractTreeIndex.this.bufferCache.confiscatePage(-1L);
            frontier.pageId = -1;
            frontier.lastTuple.setFieldCount(this.cmp.getKeyFieldCount());
            this.interiorFrame.setPage(frontier.page);
            this.interiorFrame.initBuffer((byte)this.nodeFrontiers.size());
            this.nodeFrontiers.add(frontier);
        }

        public ITreeIndexFrame getLeafFrame() {
            return this.leafFrame;
        }

        public void setLeafFrame(ITreeIndexFrame leafFrame) {
            this.leafFrame = leafFrame;
        }
    }
}

