/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.common.dataflow;

import java.nio.ByteBuffer;
import org.apache.hyracks.api.comm.IFrame;
import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.comm.VSizeFrame;
import org.apache.hyracks.api.context.IHyracksFrameMgrContext;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.IOperatorNodePushable;
import org.apache.hyracks.api.dataflow.value.IRecordDescriptorProvider;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAccessor;
import org.apache.hyracks.dataflow.common.comm.util.FrameUtils;
import org.apache.hyracks.dataflow.common.data.accessors.FrameTupleReference;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.dataflow.std.base.AbstractUnaryInputUnaryOutputOperatorNodePushable;
import org.apache.hyracks.storage.am.common.api.IIndex;
import org.apache.hyracks.storage.am.common.api.IIndexAccessor;
import org.apache.hyracks.storage.am.common.api.IIndexDataflowHelper;
import org.apache.hyracks.storage.am.common.api.IModificationOperationCallback;
import org.apache.hyracks.storage.am.common.api.ITupleFilter;
import org.apache.hyracks.storage.am.common.api.ITupleFilterFactory;
import org.apache.hyracks.storage.am.common.dataflow.IIndexOperatorDescriptor;
import org.apache.hyracks.storage.am.common.exceptions.TreeIndexDuplicateKeyException;
import org.apache.hyracks.storage.am.common.exceptions.TreeIndexNonExistentKeyException;
import org.apache.hyracks.storage.am.common.impls.NoOpOperationCallback;
import org.apache.hyracks.storage.am.common.ophelpers.IndexOperation;
import org.apache.hyracks.storage.am.common.tuples.PermutingFrameTupleReference;
import org.apache.hyracks.storage.common.file.LocalResource;

public class IndexInsertUpdateDeleteOperatorNodePushable
extends AbstractUnaryInputUnaryOutputOperatorNodePushable {
    protected final IIndexOperatorDescriptor opDesc;
    protected final IHyracksTaskContext ctx;
    protected final IIndexDataflowHelper indexHelper;
    protected final IRecordDescriptorProvider recordDescProvider;
    protected final IndexOperation op;
    protected final PermutingFrameTupleReference tuple = new PermutingFrameTupleReference();
    protected FrameTupleAccessor accessor;
    protected FrameTupleReference frameTuple;
    protected IFrame writeBuffer;
    protected IIndexAccessor indexAccessor;
    protected ITupleFilter tupleFilter;
    protected IModificationOperationCallback modCallback;
    protected IIndex index;

    public IndexInsertUpdateDeleteOperatorNodePushable(IIndexOperatorDescriptor opDesc, IHyracksTaskContext ctx, int partition, int[] fieldPermutation, IRecordDescriptorProvider recordDescProvider, IndexOperation op) throws HyracksDataException {
        this.opDesc = opDesc;
        this.ctx = ctx;
        this.indexHelper = opDesc.getIndexDataflowHelperFactory().createIndexDataflowHelper(opDesc, ctx, partition);
        this.recordDescProvider = recordDescProvider;
        this.op = op;
        this.tuple.setFieldPermutation(fieldPermutation);
    }

    public void open() throws HyracksDataException {
        RecordDescriptor inputRecDesc = this.recordDescProvider.getInputRecordDescriptor(this.opDesc.getActivityId(), 0);
        this.accessor = new FrameTupleAccessor(inputRecDesc);
        this.writeBuffer = new VSizeFrame((IHyracksFrameMgrContext)this.ctx);
        this.indexHelper.open();
        this.index = this.indexHelper.getIndexInstance();
        try {
            this.writer.open();
            LocalResource resource = this.indexHelper.getResource();
            this.modCallback = this.opDesc.getModificationOpCallbackFactory().createModificationOperationCallback(resource, this.ctx, (IOperatorNodePushable)this);
            this.indexAccessor = this.index.createAccessor(this.modCallback, NoOpOperationCallback.INSTANCE);
            ITupleFilterFactory tupleFilterFactory = this.opDesc.getTupleFilterFactory();
            if (tupleFilterFactory != null) {
                this.tupleFilter = tupleFilterFactory.createTupleFilter(this.ctx);
                this.frameTuple = new FrameTupleReference();
            }
        }
        catch (Exception e) {
            throw new HyracksDataException((Throwable)e);
        }
    }

    public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
        this.accessor.reset(buffer);
        int tupleCount = this.accessor.getTupleCount();
        for (int i = 0; i < tupleCount; ++i) {
            try {
                if (this.tupleFilter != null) {
                    this.frameTuple.reset((IFrameTupleAccessor)this.accessor, i);
                    if (!this.tupleFilter.accept((IFrameTupleReference)this.frameTuple)) continue;
                }
                this.tuple.reset((IFrameTupleAccessor)this.accessor, i);
                switch (this.op) {
                    case INSERT: {
                        try {
                            this.indexAccessor.insert((ITupleReference)this.tuple);
                        }
                        catch (TreeIndexDuplicateKeyException treeIndexDuplicateKeyException) {}
                        break;
                    }
                    case UPDATE: {
                        this.indexAccessor.update((ITupleReference)this.tuple);
                        break;
                    }
                    case UPSERT: {
                        this.indexAccessor.upsert((ITupleReference)this.tuple);
                        break;
                    }
                    case DELETE: {
                        try {
                            this.indexAccessor.delete((ITupleReference)this.tuple);
                        }
                        catch (TreeIndexNonExistentKeyException treeIndexNonExistentKeyException) {}
                        break;
                    }
                    default: {
                        throw new HyracksDataException("Unsupported operation " + (Object)((Object)this.op) + " in tree index InsertUpdateDelete operator");
                    }
                }
                continue;
            }
            catch (HyracksDataException e) {
                throw e;
            }
            catch (Exception e) {
                throw new HyracksDataException((Throwable)e);
            }
        }
        this.writeBuffer.ensureFrameSize(buffer.capacity());
        FrameUtils.copyAndFlip((ByteBuffer)buffer, (ByteBuffer)this.writeBuffer.getBuffer());
        FrameUtils.flushFrame((ByteBuffer)this.writeBuffer.getBuffer(), (IFrameWriter)this.writer);
    }

    public void close() throws HyracksDataException {
        if (this.index != null) {
            try {
                this.writer.close();
            }
            finally {
                this.indexHelper.close();
            }
        }
    }

    public void fail() throws HyracksDataException {
        if (this.index != null) {
            this.writer.fail();
        }
    }

    public void flush() throws HyracksDataException {
        this.writer.flush();
    }
}

