/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.common.dataflow;

import java.io.IOException;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.api.io.FileSplit;
import org.apache.hyracks.api.io.IIOManager;
import org.apache.hyracks.storage.am.common.api.IIndex;
import org.apache.hyracks.storage.am.common.api.IIndexDataflowHelper;
import org.apache.hyracks.storage.am.common.api.IPageManagerFactory;
import org.apache.hyracks.storage.am.common.api.IResourceLifecycleManager;
import org.apache.hyracks.storage.am.common.dataflow.IIndexOperatorDescriptor;
import org.apache.hyracks.storage.common.file.ILocalResourceFactory;
import org.apache.hyracks.storage.common.file.ILocalResourceRepository;
import org.apache.hyracks.storage.common.file.IResourceIdFactory;
import org.apache.hyracks.storage.common.file.LocalResource;

public abstract class IndexDataflowHelper
implements IIndexDataflowHelper {
    protected final IHyracksTaskContext ctx;
    protected final IIOManager ioManager;
    protected final IIndexOperatorDescriptor opDesc;
    protected final IResourceLifecycleManager<IIndex> lcManager;
    protected final ILocalResourceRepository localResourceRepository;
    protected final IResourceIdFactory resourceIdFactory;
    protected final IPageManagerFactory pageManagerFactory;
    protected final boolean durable;
    protected final FileReference resourceRef;
    protected final String resourceName;
    protected final int partition;
    protected IIndex index;

    public IndexDataflowHelper(IIndexOperatorDescriptor opDesc, IHyracksTaskContext ctx, int partition, boolean durable) throws HyracksDataException {
        this.ctx = ctx;
        this.opDesc = opDesc;
        this.ioManager = ctx.getIOManager();
        this.lcManager = opDesc.getLifecycleManagerProvider().getLifecycleManager(ctx);
        this.localResourceRepository = opDesc.getStorageManager().getLocalResourceRepository(ctx);
        this.resourceIdFactory = opDesc.getStorageManager().getResourceIdFactory(ctx);
        FileSplit fileSplit = opDesc.getFileSplitProvider().getFileSplits()[partition];
        this.resourceRef = fileSplit.getFileReference(this.ioManager);
        this.resourceName = this.resourceRef.getRelativePath();
        this.pageManagerFactory = opDesc.getPageManagerFactory();
        this.durable = durable;
        this.partition = partition;
    }

    protected abstract IIndex createIndexInstance() throws HyracksDataException;

    @Override
    public IIndex getIndexInstance() {
        return this.index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void create() throws HyracksDataException {
        IResourceLifecycleManager<IIndex> iResourceLifecycleManager = this.lcManager;
        synchronized (iResourceLifecycleManager) {
            this.index = this.lcManager.get(this.resourceRef.getRelativePath());
            if (this.index != null) {
                this.lcManager.unregister(this.resourceRef.getRelativePath());
            } else {
                this.index = this.createIndexInstance();
            }
            long resourceID = this.getResourceID();
            if (resourceID != -1L) {
                this.localResourceRepository.delete(this.resourceRef.getRelativePath());
            }
            this.index.create();
            try {
                resourceID = this.resourceIdFactory.createId();
                ILocalResourceFactory localResourceFactory = this.opDesc.getLocalResourceFactoryProvider().getLocalResourceFactory();
                this.localResourceRepository.insert(localResourceFactory.createLocalResource(resourceID, this.resourceRef.getRelativePath(), 5, this.partition));
            }
            catch (IOException e) {
                throw new HyracksDataException((Throwable)e);
            }
            this.lcManager.register(this.resourceRef.getRelativePath(), this.index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() throws HyracksDataException {
        IResourceLifecycleManager<IIndex> iResourceLifecycleManager = this.lcManager;
        synchronized (iResourceLifecycleManager) {
            if (this.getResourceID() == -1L) {
                throw new HyracksDataException("Index does not have a valid resource ID. Has it been created yet?");
            }
            this.index = this.lcManager.get(this.resourceRef.getRelativePath());
            if (this.index == null) {
                this.index = this.createIndexInstance();
                this.lcManager.register(this.resourceRef.getRelativePath(), this.index);
            }
            this.lcManager.open(this.resourceRef.getRelativePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws HyracksDataException {
        IResourceLifecycleManager<IIndex> iResourceLifecycleManager = this.lcManager;
        synchronized (iResourceLifecycleManager) {
            this.lcManager.close(this.resourceRef.getRelativePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() throws HyracksDataException {
        IResourceLifecycleManager<IIndex> iResourceLifecycleManager = this.lcManager;
        synchronized (iResourceLifecycleManager) {
            this.index = this.lcManager.get(this.resourceRef.getRelativePath());
            if (this.index != null) {
                this.lcManager.unregister(this.resourceRef.getRelativePath());
            } else {
                this.index = this.createIndexInstance();
            }
            if (this.getResourceID() != -1L) {
                this.localResourceRepository.delete(this.resourceRef.getRelativePath());
            }
            this.index.destroy();
        }
    }

    private long getResourceID() throws HyracksDataException {
        LocalResource lr = this.localResourceRepository.get(this.resourceRef.getRelativePath());
        return lr == null ? -1L : lr.getId();
    }

    @Override
    public LocalResource getResource() throws HyracksDataException {
        return this.localResourceRepository.get(this.resourceRef.getRelativePath());
    }
}

