/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.utils;

import org.apache.asterix.common.config.DatasetConfig;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt16SerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AIntervalSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AOrderedListSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.ARecordSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AUnorderedListSerializerDeserializer;
import org.apache.asterix.formats.nontagged.BinaryComparatorFactoryProvider;
import org.apache.asterix.formats.nontagged.BinaryTokenizerFactoryProvider;
import org.apache.asterix.formats.nontagged.TypeTraitProvider;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AUnionType;
import org.apache.asterix.om.types.AbstractCollectionType;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.EnumDeserializer;
import org.apache.asterix.om.types.IAType;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.exceptions.NotImplementedException;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.dataflow.value.ITypeTraits;
import org.apache.hyracks.data.std.primitive.ByteArrayPointable;
import org.apache.hyracks.storage.am.lsm.invertedindex.tokenizers.IBinaryTokenizerFactory;
import org.apache.hyracks.util.string.UTF8StringUtil;

public final class NonTaggedFormatUtil {
    public static final boolean isFixedSizedCollection(IAType type) {
        switch (type.getTypeTag()) {
            case UNION: {
                if (!((AUnionType)type).isUnknownableType()) {
                    return false;
                }
                return NonTaggedFormatUtil.isFixedSizedCollection(((AUnionType)type).getActualType());
            }
        }
        return NonTaggedFormatUtil.isFixedSizedCollection(type.getTypeTag());
    }

    public static final boolean isFixedSizedCollection(ATypeTag type) {
        switch (type) {
            case STRING: 
            case BINARY: 
            case RECORD: 
            case INTERVAL: 
            case ORDEREDLIST: 
            case UNORDEREDLIST: 
            case POLYGON: 
            case ANY: {
                return false;
            }
        }
        return true;
    }

    public static final boolean hasOptionalField(ARecordType recType) {
        for (int i = 0; i < recType.getFieldTypes().length; ++i) {
            AUnionType unionType;
            IAType type = recType.getFieldTypes()[i];
            if (type == null) continue;
            ATypeTag tag = type.getTypeTag();
            if (tag == ATypeTag.NULL || tag == ATypeTag.MISSING) {
                return true;
            }
            if (tag != ATypeTag.UNION || !(unionType = (AUnionType)type).isUnknownableType()) continue;
            return true;
        }
        return false;
    }

    public static boolean isOptional(IAType type) {
        return type.getTypeTag() == ATypeTag.UNION && ((AUnionType)type).isUnknownableType();
    }

    public static int getFieldValueLength(byte[] serNonTaggedAObject, int offset, ATypeTag typeTag, boolean tagged) throws AsterixException {
        switch (typeTag) {
            case ANY: {
                ATypeTag tag = EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(serNonTaggedAObject[offset]);
                if (tag == ATypeTag.ANY) {
                    throw new AsterixException("Field value has type tag ANY, but it should have a concrete type.");
                }
                return NonTaggedFormatUtil.getFieldValueLength(serNonTaggedAObject, offset, tag, true) + 1;
            }
            case MISSING: 
            case NULL: {
                return 0;
            }
            case BOOLEAN: 
            case INT8: {
                return 1;
            }
            case INT16: {
                return 2;
            }
            case INT32: 
            case FLOAT: 
            case DATE: 
            case YEARMONTHDURATION: {
                return 4;
            }
            case TIME: {
                return 4;
            }
            case INT64: 
            case DOUBLE: 
            case DATETIME: 
            case DAYTIMEDURATION: {
                return 8;
            }
            case DURATION: {
                return 12;
            }
            case POINT: 
            case UUID: {
                return 16;
            }
            case INTERVAL: {
                if (tagged) {
                    return AIntervalSerializerDeserializer.getIntervalLength(serNonTaggedAObject, offset + 1);
                }
                return AIntervalSerializerDeserializer.getIntervalLength(serNonTaggedAObject, offset);
            }
            case POINT3D: 
            case CIRCLE: {
                return 24;
            }
            case LINE: 
            case RECTANGLE: {
                return 32;
            }
            case POLYGON: {
                if (tagged) {
                    return AInt16SerializerDeserializer.getShort(serNonTaggedAObject, offset + 1) * 16 + 2;
                }
                return AInt16SerializerDeserializer.getShort(serNonTaggedAObject, offset) * 16 + 2;
            }
            case STRING: {
                if (tagged) {
                    int len = UTF8StringUtil.getUTFLength((byte[])serNonTaggedAObject, (int)(offset + 1));
                    return len + UTF8StringUtil.getNumBytesToStoreLength((int)len);
                }
                int len = UTF8StringUtil.getUTFLength((byte[])serNonTaggedAObject, (int)offset);
                return len + UTF8StringUtil.getNumBytesToStoreLength((int)len);
            }
            case BINARY: {
                if (tagged) {
                    int len = ByteArrayPointable.getContentLength((byte[])serNonTaggedAObject, (int)(offset + 1));
                    return len + ByteArrayPointable.getNumberBytesToStoreMeta((int)len);
                }
                int len = ByteArrayPointable.getContentLength((byte[])serNonTaggedAObject, (int)offset);
                return len + ByteArrayPointable.getNumberBytesToStoreMeta((int)len);
            }
            case RECORD: {
                if (tagged) {
                    return ARecordSerializerDeserializer.getRecordLength(serNonTaggedAObject, offset + 1) - 1;
                }
                return ARecordSerializerDeserializer.getRecordLength(serNonTaggedAObject, offset) - 1;
            }
            case ORDEREDLIST: {
                if (tagged) {
                    return AOrderedListSerializerDeserializer.getOrderedListLength(serNonTaggedAObject, offset + 1) - 1;
                }
                return AOrderedListSerializerDeserializer.getOrderedListLength(serNonTaggedAObject, offset) - 1;
            }
            case UNORDEREDLIST: {
                if (tagged) {
                    return AUnorderedListSerializerDeserializer.getUnorderedListLength(serNonTaggedAObject, offset + 1) - 1;
                }
                return AUnorderedListSerializerDeserializer.getUnorderedListLength(serNonTaggedAObject, offset) - 1;
            }
        }
        throw new NotImplementedException("No getLength implemented for a value of this type " + typeTag + " .");
    }

    public static int getNumDimensions(ATypeTag typeTag) {
        switch (typeTag) {
            case POLYGON: 
            case POINT: 
            case CIRCLE: 
            case LINE: 
            case RECTANGLE: {
                return 2;
            }
            case POINT3D: {
                return 3;
            }
        }
        throw new NotImplementedException("getNumDimensions is not implemented for this type " + typeTag + " .");
    }

    public static IAType getNestedSpatialType(ATypeTag typeTag) {
        switch (typeTag) {
            case POLYGON: 
            case POINT: 
            case CIRCLE: 
            case LINE: 
            case RECTANGLE: {
                return BuiltinType.ADOUBLE;
            }
        }
        throw new NotImplementedException(typeTag + " is not a supported spatial data type.");
    }

    public static IBinaryTokenizerFactory getBinaryTokenizerFactory(ATypeTag keyType, DatasetConfig.IndexType indexType, int gramLength) throws AlgebricksException {
        switch (indexType) {
            case SINGLE_PARTITION_WORD_INVIX: 
            case LENGTH_PARTITIONED_WORD_INVIX: {
                return BinaryTokenizerFactoryProvider.INSTANCE.getWordTokenizerFactory(keyType, false, false);
            }
            case SINGLE_PARTITION_NGRAM_INVIX: 
            case LENGTH_PARTITIONED_NGRAM_INVIX: {
                return BinaryTokenizerFactoryProvider.INSTANCE.getNGramTokenizerFactory(keyType, gramLength, true, false);
            }
        }
        throw new AlgebricksException("Tokenizer not applicable to index type '" + indexType + "'.");
    }

    public static IAType getTokenType(IAType keyType) throws AlgebricksException {
        IAType type = keyType;
        ATypeTag typeTag = keyType.getTypeTag();
        if (typeTag == ATypeTag.UNORDEREDLIST || typeTag == ATypeTag.ORDEREDLIST) {
            AbstractCollectionType listType = (AbstractCollectionType)keyType;
            if (!listType.isTyped()) {
                throw new AlgebricksException("Cannot build an inverted index on untyped lists.)");
            }
            type = listType.getItemType();
        }
        return type;
    }

    public static IBinaryComparatorFactory getTokenBinaryComparatorFactory(IAType keyType) throws AlgebricksException {
        IAType type = NonTaggedFormatUtil.getTokenType(keyType);
        return BinaryComparatorFactoryProvider.INSTANCE.getBinaryComparatorFactory(type, true, true);
    }

    public static ITypeTraits getTokenTypeTrait(IAType keyType) throws AlgebricksException {
        IAType type = NonTaggedFormatUtil.getTokenType(keyType);
        return TypeTraitProvider.INSTANCE.getTypeTrait(type);
    }
}

