/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.types.hierachy;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.hierachy.ITypeConvertComputer;
import org.apache.hyracks.data.std.primitive.FloatPointable;

public class FloatToInt64TypeConvertComputer
implements ITypeConvertComputer {
    public static final FloatToInt64TypeConvertComputer INSTANCE = new FloatToInt64TypeConvertComputer();

    private FloatToInt64TypeConvertComputer() {
    }

    @Override
    public void convertType(byte[] data, int start, int length, DataOutput out) throws IOException {
        float sourceValue = FloatPointable.getFloat((byte[])data, (int)start);
        if (sourceValue > 9.223372E18f || sourceValue < -9.223372E18f) {
            throw new IOException("Cannot convert Float to INT64 - Float value " + sourceValue + " is out of range that INT64 type can hold: INT64.MAX_VALUE:" + Long.MAX_VALUE + ", INT64.MIN_VALUE: " + Long.MIN_VALUE);
        }
        long targetValue = (long)Math.floor(sourceValue);
        out.writeByte(ATypeTag.INT64.serialize());
        out.writeLong(targetValue);
    }
}

