/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.types.hierachy;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.hierachy.ITypeConvertComputer;
import org.apache.hyracks.data.std.primitive.DoublePointable;

public class DoubleToInt64TypeConvertComputer
implements ITypeConvertComputer {
    public static final DoubleToInt64TypeConvertComputer INSTANCE = new DoubleToInt64TypeConvertComputer();

    private DoubleToInt64TypeConvertComputer() {
    }

    @Override
    public void convertType(byte[] data, int start, int length, DataOutput out) throws IOException {
        double sourceValue = DoublePointable.getDouble((byte[])data, (int)start);
        if (sourceValue > 9.223372036854776E18 || sourceValue < -9.223372036854776E18) {
            throw new IOException("Cannot convert Double to INT64 - Double value " + sourceValue + " is out of range that INT64 type can hold: INT64.MAX_VALUE:" + Long.MAX_VALUE + ", INT64.MIN_VALUE: " + Long.MIN_VALUE);
        }
        long targetValue = (long)Math.floor(sourceValue);
        out.writeByte(ATypeTag.INT64.serialize());
        out.writeLong(targetValue);
    }
}

