/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.types.hierachy;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.hierachy.ITypeConvertComputer;
import org.apache.hyracks.data.std.primitive.DoublePointable;

public class DoubleToFloatTypeConvertComputer
implements ITypeConvertComputer {
    public static final DoubleToFloatTypeConvertComputer INSTANCE = new DoubleToFloatTypeConvertComputer();

    private DoubleToFloatTypeConvertComputer() {
    }

    @Override
    public void convertType(byte[] data, int start, int length, DataOutput out) throws IOException {
        double sourceValue = DoublePointable.getDouble((byte[])data, (int)start);
        if (sourceValue > 3.4028234663852886E38 || sourceValue < (double)1.4E-45f) {
            throw new IOException("Cannot convert Double to Float - Double value " + sourceValue + " is out of range that Float type can hold: Float.MAX_VALUE:" + Float.MAX_VALUE + ", Float.MIN_VALUE: " + Float.MIN_VALUE);
        }
        out.writeByte(ATypeTag.FLOAT.serialize());
        out.writeFloat((float)sourceValue);
    }
}

