/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.types;

import org.apache.asterix.om.types.AUnionType;
import org.apache.asterix.om.types.IAType;

public class TypeHelper {
    public static boolean canBeMissing(IAType t) {
        switch (t.getTypeTag()) {
            case MISSING: {
                return true;
            }
            case UNION: {
                return ((AUnionType)t).isMissableType();
            }
        }
        return false;
    }

    public static boolean canBeUnknown(IAType t) {
        switch (t.getTypeTag()) {
            case MISSING: 
            case NULL: {
                return true;
            }
            case UNION: {
                return ((AUnionType)t).isUnknownableType();
            }
        }
        return false;
    }

    public static boolean isClosed(IAType t) {
        switch (t.getTypeTag()) {
            case MISSING: 
            case ANY: {
                return false;
            }
            case UNION: {
                return TypeHelper.isClosed(((AUnionType)t).getActualType());
            }
        }
        return true;
    }
}

