/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.types;

import java.util.ArrayList;
import org.apache.asterix.om.types.IEnumSerializer;

public enum ATypeTag implements IEnumSerializer
{
    INT8(1),
    INT16(2),
    INT32(3),
    INT64(4),
    UINT8(5),
    UINT16(6),
    UINT32(7),
    UINT64(8),
    BINARY(9),
    BITARRAY(10),
    FLOAT(11),
    DOUBLE(12),
    STRING(13),
    MISSING(14),
    BOOLEAN(15),
    DATETIME(16),
    DATE(17),
    TIME(18),
    DURATION(19),
    POINT(20),
    POINT3D(21),
    ORDEREDLIST(22),
    UNORDEREDLIST(23),
    RECORD(24),
    SPARSERECORD(25),
    UNION(26),
    ENUM(27),
    TYPE(28),
    ANY(29),
    LINE(30),
    POLYGON(31),
    CIRCLE(32),
    RECTANGLE(33),
    INTERVAL(34),
    SYSTEM_NULL(35),
    YEARMONTHDURATION(36),
    DAYTIMEDURATION(37),
    UUID(38),
    SHORTWITHOUTTYPEINFO(40),
    NULL(41);

    public static final byte SERIALIZED_STRING_TYPE_TAG;
    public static final byte SERIALIZED_MISSING_TYPE_TAG;
    public static final byte SERIALIZED_NULL_TYPE_TAG;
    public static final byte SERIALIZED_DOUBLE_TYPE_TAG;
    public static final byte SERIALIZED_RECORD_TYPE_TAG;
    public static final byte SERIALIZED_INT32_TYPE_TAG;
    public static final byte SERIALIZED_ORDEREDLIST_TYPE_TAG;
    public static final byte SERIALIZED_UNORDEREDLIST_TYPE_TAG;
    public static final byte SERIALIZED_POLYGON_TYPE_TAG;
    public static final byte SERIALIZED_DATE_TYPE_TAG;
    public static final byte SERIALIZED_TIME_TYPE_TAG;
    public static final byte SERIALIZED_DATETIME_TYPE_TAG;
    public static final byte SERIALIZED_SYSTEM_NULL_TYPE_TAG;
    public static final byte SERIALIZED_DURATION_TYPE_TAG;
    public static final byte SERIALIZED_DAY_TIME_DURATION_TYPE_TAG;
    public static final byte SERIALIZED_POINT_TYPE_TAG;
    public static final byte SERIALIZED_INTERVAL_TYPE_TAG;
    public static final byte SERIALIZED_CIRCLE_TYPE_TAG;
    public static final byte SERIALIZED_YEAR_MONTH_DURATION_TYPE_TAG;
    public static final byte SERIALIZED_LINE_TYPE_TAG;
    public static final byte SERIALIZED_RECTANGLE_TYPE_TAG;
    public static final byte SERIALIZED_BOOLEAN_TYPE_TAG;
    public static final byte SERIALIZED_INT8_TYPE_TAG;
    public static final byte SERIALIZED_INT16_TYPE_TAG;
    public static final byte SERIALIZED_INT64_TYPE_TAG;
    public static final byte SERIALIZED_FLOAT_TYPE_TAG;
    public static final byte SERIALIZED_BINARY_TYPE_TAG;
    public static final byte SERIALIZED_UUID_TYPE_TAG;
    public static final int TYPE_COUNT;
    private byte value;
    public static final ATypeTag[] VALUE_TYPE_MAPPING;

    private ATypeTag(int value) {
        this.value = (byte)value;
    }

    @Override
    public byte serialize() {
        return this.value;
    }

    public boolean isDerivedType() {
        return this == RECORD || this == ORDEREDLIST || this == UNORDEREDLIST || this == UNION;
    }

    public String toString() {
        return this.name().toLowerCase();
    }

    static {
        SERIALIZED_STRING_TYPE_TAG = STRING.serialize();
        SERIALIZED_MISSING_TYPE_TAG = MISSING.serialize();
        SERIALIZED_NULL_TYPE_TAG = NULL.serialize();
        SERIALIZED_DOUBLE_TYPE_TAG = DOUBLE.serialize();
        SERIALIZED_RECORD_TYPE_TAG = RECORD.serialize();
        SERIALIZED_INT32_TYPE_TAG = INT32.serialize();
        SERIALIZED_ORDEREDLIST_TYPE_TAG = ORDEREDLIST.serialize();
        SERIALIZED_UNORDEREDLIST_TYPE_TAG = UNORDEREDLIST.serialize();
        SERIALIZED_POLYGON_TYPE_TAG = POLYGON.serialize();
        SERIALIZED_DATE_TYPE_TAG = DATE.serialize();
        SERIALIZED_TIME_TYPE_TAG = TIME.serialize();
        SERIALIZED_DATETIME_TYPE_TAG = DATETIME.serialize();
        SERIALIZED_SYSTEM_NULL_TYPE_TAG = SYSTEM_NULL.serialize();
        SERIALIZED_DURATION_TYPE_TAG = DURATION.serialize();
        SERIALIZED_DAY_TIME_DURATION_TYPE_TAG = DAYTIMEDURATION.serialize();
        SERIALIZED_POINT_TYPE_TAG = POINT.serialize();
        SERIALIZED_INTERVAL_TYPE_TAG = INTERVAL.serialize();
        SERIALIZED_CIRCLE_TYPE_TAG = CIRCLE.serialize();
        SERIALIZED_YEAR_MONTH_DURATION_TYPE_TAG = YEARMONTHDURATION.serialize();
        SERIALIZED_LINE_TYPE_TAG = LINE.serialize();
        SERIALIZED_RECTANGLE_TYPE_TAG = RECTANGLE.serialize();
        SERIALIZED_BOOLEAN_TYPE_TAG = BOOLEAN.serialize();
        SERIALIZED_INT8_TYPE_TAG = INT8.serialize();
        SERIALIZED_INT16_TYPE_TAG = INT16.serialize();
        SERIALIZED_INT64_TYPE_TAG = INT64.serialize();
        SERIALIZED_FLOAT_TYPE_TAG = FLOAT.serialize();
        SERIALIZED_BINARY_TYPE_TAG = BINARY.serialize();
        SERIALIZED_UUID_TYPE_TAG = UUID.serialize();
        TYPE_COUNT = ATypeTag.values().length;
        ArrayList<ATypeTag> typeList = new ArrayList<ATypeTag>();
        for (ATypeTag tt : ATypeTag.values()) {
            byte index = tt.value;
            while (typeList.size() <= index) {
                typeList.add(null);
            }
            typeList.set(index, tt);
        }
        VALUE_TYPE_MAPPING = typeList.toArray(new ATypeTag[typeList.size()]);
    }
}

